/*	Copyright(c) 1982 Michael Landy, Yoav Cohen, and George Sperling

	Disclaimer:  No guarantees of performance accompany this software,
	nor is any responsibility assumed on the part of the authors.  All the
	software has been tested extensively and every effort has been made to
	insure its reliability. 
 */

/*
 * pshalftone.c - display images as halftones on a Postscript device
 *
 * Michael Landy/Jeff Fookson - 1/4/87
 */

/* modified to convert from Anima format to Postscript */
/* David Robertson - December 1990 */

#include <stdio.h> 
#include <math.h> 
#include <scry_image.h>
#include <scry_anima.h>
#include <string.h>

#define PROFILEFILE "pshalftone.pro"

float ih = -1.;
float iw = -1.;
int lflag = 0;
int setflag = 0;
float sa = 45;
int packing = 0;
char line[80];

int true_height, true_width ;

void
anima_to_post(sf)

float sf;

{
    FILE *profile;
    int r, c, f;
    float sx, sy;
    FILE *psfile;
    char name_ps[80] ;
    char tmp_name[80] ;
    void decompress() ;
    
    if (S_anima_file == NULL)
    {
	fprintf (stderr,"anima file has not been input\n") ;
	return ;
    }
    strncpy(tmp_name,S_anima_filename,strlen(S_anima_filename)-4) ;
    tmp_name[strlen(S_anima_filename)-4] = '\0' ;
    sprintf(name_ps, "%s.%d.ps", tmp_name,S_avars.current);
    if ((psfile = fopen(name_ps, "w")) == NULL)
    {
	perror("opening postscript file\n") ;
	return ;
    }
    iw = 8.5;
    if (!S_do_zoom)
    {
        r = true_height = S_image_info.s_height;
        c = true_width = S_image_info.s_width;
    }
    else
    {
        r = true_height = S_image_info.s_height / 2;
        c = true_width = S_image_info.s_width / 2;
    }
    f = 1;
    if(ih < 0) {
	if(iw < 0) {
	    if(r > c) {
		ih = 5.;
		iw = ih * c / r;
	    } else {
		iw = 5.;
		ih = iw * r / c;
	    }
	} else
	    ih = iw * r / c;
    } else
	if(iw < 0)
	    iw = ih * c / r;
    
    /* copy prologue */
    
    if((profile = fopen(PROFILEFILE, "r")) == NULL)
    {
	perror("can't open profile file");
	return ;
    }
    while(fgets(line, 80, profile))
	fputs(line, psfile);
    
    sx = 4.25 - iw / 2.;
    sy = 5.5 - ih / 2.;
    
    /* save graphic state 
    fprintf(psfile, "gsave\n");
      
    /* set screen if necessary */
    if(setflag) {
	if(lflag)
	    fprintf(psfile, "%f %f setline\n", sf, sa);
	else
	    fprintf(psfile, "%f %f setcirc\n", sf, sa);
    }
    /* set up string for temporary postsscript storage of one row of image */
    
    fprintf(psfile, "%d setimstr\n", c);
    
    /* set up parameters for image array */
    
    fprintf(psfile, "%d %d setrc\n", c, r);
    fprintf(psfile, "%d setnb\n", 8);
    
    
    /* position image, scale and output single page data */
    
    fprintf(psfile, "%f %f placeim\n", sx, sy);
    fprintf(psfile, "%f %f scaleim\n", iw, ih);
    
    fprintf(psfile, "doimu\n");
    
    /* do image decompression and write here */
    decompress(psfile);
    fprintf(psfile, "showpage\n");
    
    /* restore graphics state */
    fprintf(psfile, "grestore\n");
    
    fprintf(psfile, "restorestate\n");
    fclose(psfile);

    return;
}

/* This procedure converts from an anima file to a postscript
   file.  It converts the colormap to greyscale.
 * David Robertson
 * Lawrence Berkeley Lab
 */

static void
decompress(psfile)
     FILE *psfile;
{
    void conv_to_grey() ;	/* convert to greyscale */
    unsigned char buf[2048]; 	/* byte pixel line buffer */
    int i , j;
    unsigned char *ip;		/* steps through row in image */
    unsigned char red[256], green[256], blue[256];
    unsigned int lum[256];	/* NTSC luminance */
    int xform_indices[256] ;	/* used for compatility with other utilities only */
    
    for(i = 0; i < S_mapnum; i++)
    {
        red[i] = S_map[i][S_RED];
        green[i] = S_map[i][S_GREEN];
        blue[i] = S_map[i][S_BLUE];
    }
	/* for compatibility only */
    for (i = 0 ; i < S_mapnum ; i++)
       xform_indices[i] = i ;

        /* decompress image */
    decompress_ccc(S_image_info.data, S_image_mem, true_height, true_width, xform_indices);
    
	/* build luminance map */
    for(i = 0; i < S_mapnum; i++)
    {
	lum[i] = (unsigned int) (0.3 * (double) red[i] +
				 0.59 * (double) green[i] +
				 0.11 * (double) blue[i] + 0.5);
    }
    for(j = 0; j < true_height; j++)
    {
        conv_to_grey(buf, j, lum);	/* convert to grey level */
	ip = buf;
	    /* write scan line to Postscript file */
	for(i = 0; i < true_width; i++)
            fprintf(psfile, "%02x",(unsigned char) *(ip++));
    }
}


/* convert to grey level */

static void
conv_to_grey(buf, row, lum)

unsigned char *buf;	/* byte	pixel line buffer */
int row;
unsigned int *lum;	/* greyscale map */

{
    int col;
    unsigned char *bufptr;
    
    bzero((char *)buf, (int)true_width);
    bufptr = buf;
    for(col = 0; col < true_width; col++)
	*bufptr++ = (unsigned char) lum[S_image_mem[(true_height - row - 1)*true_width + col]];
}
