/* scry_anima.h      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#define S_DELAY_INC 100000	/* increment of microseconds of delay */
#define S_FULL_SPEED 30000	/* 30 milliseconds delay per frame */
#define S_SLOWEST_SPEED 999999	/* almost 1 second */

#define S_FALSE 0
#define S_TRUE 1

#define S_FORWARD 1		/* seek through sequence in forward direction */
#define S_BACKWARD 0		/* seek through sequence in reverse direction */


#define Calloc(x,y) (y *) calloc((unsigned)(x), sizeof(y))
#define Fread(a,b,c,d) fread((char *)(a), b, (int)(c), d)
#define Cfree(a,b,c) cfree((char *)(a), (unsigned)(b), c)
#define Realloc(a,b,c) (c *) realloc((char *)(a), (unsigned)(b*sizeof(c)))
#define Bcopy(a,b,c) bcopy((char *)(a), (char *)(b), (int)(c))

   /* controls speed of playback */
extern struct itimerval S_itimevalue;

struct animavars {		/* Flags, &c */
    unsigned stop:1;		/* 1: no motion */
    unsigned advance:1;		/* 1: advance a frame */
    unsigned speed:4;		/* Speed 0-10 */
    unsigned search:1;		/* 1: search to current */
    unsigned direction:1;	/* 0: reverse 1: forward */
    unsigned quit:1;		/* 0: work 1: quit */
    unsigned start:1;		/* 1: getting things going */
    struct {
	int first;		/* Starting frame number */
	int last;		/* Ending frame number */
    } frame;
    int current;		/* Current frame number */
    int pid;			/* Makes for a unique colormap name */
    char segname[20];		/* Where we put that name */
};

extern struct animavars S_avars;	/* Anima control information */
extern int S_dont_repaint ;	/* TRUE if Anima footer just read */
extern int S_do_zoom ;		/* zoom information */
extern int S_zoom_changed ;

    /* Anima footer image sequence information */
struct footer
{
    long offset;	/* location of frame in Anima file */
    long buf_total ;	/* total bytes in compressed frame */
};

extern struct footer *S_a_index ;	/* Anima footer */

extern int iff_read_header();	/* read image header */
extern int iff_read_buf();	/* read compressed image */
extern int iff_write_header();	/* write image header */
extern int iff_write_buf() ;	/* write compressed image */

extern char S_anima_filename[80] ;	/* Anima filename */
extern FILE *S_anima_file ;		/* Anima file */
extern int S_anima_bytes ;		/* number of bytes to footer */
extern int S_anima_count ;		/* number of frames in Anima file */
