/* panason.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* init_video:  server calls this to initialize optical disk
   init_frame:  server calls this to seek to first frame
   record_frame:  server calls this to record frame and do preroll if desired
   stop_recording:  leave record mode
   shutdown_rec:  return control to human beings
   speed:  controls speed of simulated preroll
   com_send:  send string to com1
   exchange:  flush output buffer and get returning information
   first_block:  find first block of unrecorded frames big enough */


#include <stdio.h>
#include <time.h>

#define	STX '\002'	/* ascii codes used in optical recorder */
#define ETX '\003'	/* status messages */
#define	ACK '\006'
#define NAK '\025'
#define FRAMES 1	/* # frames to record per picture */
#define NORMAL 30	/* normal frames per second, watching */
#define FASTEST 2	/* 2x normal as fastest speed */
#define TIME 2		/* seconds you get to rewatch in */
#define FREQUENCY 20	/* how often to rewatch */
#define PREROLL		/* rewatch at all */
#define NEXTFRAM	(frame_to_rec+1)
#define DISTANCE	NORMAL*TIME*FASTEST

FILE *com1_in; FILE *com1_out;
int frame_zero ;	/* first frame to record on */
int recording;		/* recording or not */

void com_send(char *); int init_video(long *); void stop_recording(void);
int init_frame(long *,long); int record_frame(long, long, int *);
int speed(int);
void shutdown_rec(void); int first_block(int); char *exchange(char *);



/* server calls this to initialize optical disk */

int
init_video(optflag)

long *optflag ;

{
    recording = 1;

    if((com1_in = fopen("com1", "r")) == NULL) { perror("com1"); return(0); }
    if((com1_out = fopen ("com1","w")) == NULL) { perror("com1"); return(0); }

    com_send("ON4:");	/* Put VCR online */
    printf ("it's alive\n") ;
    /* These four are not necessary, but ensure everything will work */
    com_send("AC@");	/* Clear command buffer */
    com_send("TF");		/* Make sure the disk is ready */
    com_send("DS");	/* Turn on frame number display */
    com_send("VS");		/* Turn video on */
    *optflag = 1 ;
    return (1) ;
}




/* position videodisk at start_frame position */

int
init_frame (start_frame,total)

long *start_frame ;
long total ;

{
    int begin_frame ;
    char tmp[20];

    if (*start_frame < 0)
        if ((*start_frame = (long) first_block((int) total)) == -1)
        {
            fprintf (stderr,"not enough frames\n") ;
            return (0) ;
        }
 
    begin_frame = (int) *start_frame ;
	/* bounds check */
    if((begin_frame < 1) || (begin_frame > 24000))
	return(0);
    sprintf(tmp, "SR%d:", begin_frame);
    com_send(tmp);
    frame_zero = begin_frame;
    return(1);
}




/* record frame and optionally do simulated preroll */

int
record_frame (in_at,out_at)

long in_at, out_at ;	/* starting, ending frame numbers */

{
    int frame_to_rec ;
    char tmp[20];

    frame_to_rec = (int) in_at ;

    if(((frame_to_rec - frame_zero) % FREQUENCY) == 0)
    {
	sprintf(tmp, "RM%d:", FREQUENCY);
	com_send(tmp);
    }
    sprintf(tmp, "GS%d:", FRAMES);
    com_send(tmp);
#ifdef PREROLL
    if(((NEXTFRAM - frame_zero) % FREQUENCY) == 0)
    {
	sprintf(tmp,"SR%d:", (((NEXTFRAM - DISTANCE) > frame_zero) ? (NEXTFRAM - DISTANCE) : frame_zero));
	com_send(tmp);
	sprintf(tmp,"%s%d:%d:", (((NEXTFRAM - frame_zero) < (TIME*NORMAL)) ? "LF" : "FF"), speed(NEXTFRAM - frame_zero), frame_to_rec);
	com_send(tmp);
    }
#endif
    return(1);
}




int
speed(frames)	/* Speed to go depending on number of frames to go */

int frames;

{
    if(frames < (NORMAL*TIME))
	    return((((NORMAL * TIME) / frames) < NORMAL) ? ((NORMAL * TIME) / frames) : NORMAL);
    else if(frames < NORMAL*FASTEST*TIME)
        return((frames / (NORMAL*TIME)));
    else
	return(FASTEST);
}




void
stop_recording()	/* Leave record mode */

{
    com_send("RC");
}




void
shutdown_rec()	/* return control to human beings */

{
    if(recording)
	stop_recording();
    com_send("OF@");
    fclose(com1_out);
    fclose(com1_in);
}




/* communicate with Panasonic over com1 */

void
com_send(string)

char *string;

{
    int status;

    fprintf(com1_out, "%c%s%c\n", STX, string, ETX);
    fflush(com1_out);
    while(fgetc(com1_in) == EOF);
    while((status = fgetc(com1_in)) != EOF) if(status == ETX) return;
}




/* flush output buffer and get returning information */

char
*exchange(string)

char *string;

{
    char buf[100];

    fflush(com1_in);
    fprintf(com1_out, "%c%s%c\n", STX, string, ETX);
    fflush(com1_out);
    fgets(buf,100,com1_in);
    return(buf);
}




/* find first block of unrecorded frames big enough
   for sequence of images that will be sent */

int
first_block(frames)

int frames;

{
    int begin, end, unfound = 1;
    char buf[100], *ret;

    exchange("SR1:");
    while(unfound)
    {
        ret = exchange("RE");
        begin = atoi(ret+3);
        ret = exchange("NO");
        end = atoi(ret+3);
	    /* if enough */
        if((end - begin) >= frames)
	{
            sprintf(buf, "SR%d:", begin);
            exchange(buf);
            unfound = 0;
        }
	    /* if at end of videodisk and unsuccessful */
        if((end == 24000) && unfound)
            return(-1);
    }
    return(begin);
}
