/* hipsclient.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


 /* programmers:  David Robertson and Fritz Renema */

#include <stdio.h>
#include <math.h>
#include <hipl_format.h>
#include <scry.h>

/* main:  transmit HIPS file to PC, Xview, or Sunview server
   parse_args:  parse command-line arguments  */



char Progname[] = "hipsclient";	/* HIPS program name */

int corner_arg_made = 0 ;



main (argc, argv)

int argc;
char *argv[];

{
    struct header hd;		/* HIPS header structure*/
    char *which_server;		/* symbolic name of server */
    int	prognum;		/* RPC program number */
    int comp_option;		/* compression option	*/
    int rec_option;		/* recording option	*/
    char *savename;		/* name to save Anima file under */
        /* upper left point of image is at (corner_left, corner_top) */
    int corner_left = 0;
    int corner_top = 0;
    int	flip_vertical = 0;	/* flip vertically or not */
    unsigned char *hips_image;	/* HIPS image buffer	*/
    int depth = 1 ;		/* only able to read PF_BYTE HIPS images */
    unsigned char cmap[256][3] ;	/* Scry color map */
    int frame_index ;		/* current frame to read */
    int debug = 0;
    int i, j ;

        /* initialize options to default values */
    which_server = NULL;
    rec_option = S_PREVIEW;	/* preview mode */
    prognum = S_PCPROG;	/* default is PC server */
    comp_option = S_NONE;
    savename = NULL;

    parse_args (argc, argv, &corner_left, &corner_top, &which_server, &comp_option, 
	        &rec_option, &prognum, &flip_vertical, &savename) ;

	/* read HIPS header */
    read_header (&hd);
    if (hd.pixel_format != PFBYTE)
    {
        fprintf (stderr, "%s: input must be in byte format\n", argv[0]);
        exit (0) ;
    }

	/* if to connect to server */
    if (which_server != NULL)
    {
	if (prognum == 0)
	{
	    fprintf (stderr,"program number must be supplied\n") ;
	    exit(0) ;
	}
	    /* connect to server */
        if (!scry_connect (which_server, prognum))
            exit(0);
		/* initialize recorder */
        scry_init_record(rec_option,1) ;
    }
	/* if saving Anima file */
    if (savename != NULL)
        scry_set_filename(savename,hd.num_frame) ;
    for (i = 0 ; i < 256 ; i++)	/* set color map to grey ramp */
    {
        cmap[i][0] = i ;
        cmap[i][1] = i ;
        cmap[i][2] = i ;
    }
	/* set Scry color map */
    scry_set_map (256,cmap) ;

        /* only has effect if server maximum display size is
           less than image */
    if (corner_arg_made)
	    /* if not called, center of image will be sent if
               image bigger than display */
        scry_set_corner(corner_left,corner_top) ;

    if ((hips_image = (unsigned char *) malloc(hd.rows*hd.cols)) == NULL)
    {
        fprintf (stderr,"unable to allocate space for HIPS char image\n") ;
        exit(0) ;
    }

       /* for all frames in HIPS file */
    for (frame_index = 0 ; frame_index < hd.num_frame ; frame_index++)
    {
        if ((fread(hips_image,1,hd.rows*hd.cols,stdin)) != hd.rows*hd.cols)
        {
            fprintf (stderr,"unable to read HIPS char image\n") ;
            exit(0) ;
        }

	    /* if should flip image */
	if (flip_vertical)
	    scry_v_flip(hips_image,hd.rows,hd.cols,depth) ;

        if (which_server != NULL)
		/* transmit Anima file */
	    scry_send_image (hips_image,comp_option,hd.rows,hd.cols,depth);
	else if (savename != NULL)
		/* save Anima file */
	    scry_save_anima (hips_image,hd.rows,hd.cols,depth) ;
	else
	    fprintf (stderr,"No server or file name chosen: no action taken\n") ;
	fprintf (stderr, "Done with frame %d of %d\n",frame_index+1,hd.num_frame) ;
    }

	/* free memory previously allocated */
    free (hips_image);
	/* close client */
    scry_close();
}



parse_args (argc,argv,start_col,start_row,which_server,comp, 
	    record, prognum, flip_vertical, savename)

int argc;
char *argv[];
int *start_row, *start_col;	/* upper left hand corner */
char **which_server;		/* symbolic name of server */
int *comp;			/* compression option */
int *record;			/* recording option */
int *prognum;			/* RPC program number */
int *flip_vertical;		/* flip or not */
char **savename ;		/* name to save Anima file under */

{
    int i;
    int j;
    char	*temp_string;

    /* parse command-line arguments */
    for (i = 1; i < argc; i++)
    {
	if (*argv[i] != '-')
	{
	    fprintf (stderr, "All arguments must start with a -\n") ;
	    fprintf (stderr, "Invoke with %s -h for help\n", argv[0]) ;
	    exit (0) ;
	}
	switch(*(argv[i]+1))
	{
		/* name to save Anima file under */
	    case 'o':
		*savename = argv[++i] ;
		break ;
	    case 'v':	/* flip vertically */
		*flip_vertical = 1;
		break;
	    case 's':	/* upper left hand corner */
		*start_col = atoi (argv[++i]);
	        *start_row = atoi (argv[++i]);
		corner_arg_made = 1 ;
		break;
	    case 'r':	/* recording option */
                *record = atoi(argv[++i]);
                break;
            case 'w':	/* server name */
                *which_server = argv[++i];
                break;
            case 'p':	/* RPC program number */
                *prognum = atoi(argv[++i]);
                break;
            case 'c':	/* compression option */
                *comp = 0;
                temp_string = argv[++i];
                for(j = 0; j < strlen(temp_string); j++)
		{
                    switch(temp_string[j])
		    {
			case 'c':
			    *comp |= S_CCC; break;
			case 'q':
			    *comp |= S_QUANTIZE; break;
			case 'l':
			    *comp |= S_LEMPEL_ZIV; break;
			case 'n':
			    *comp = S_NONE; break;
                    }
                }
                break;
	    case 'h':
	    case 'H':
	    case '?':
	      puts("hipsclient:  transfers HIPS image to PC, Sunview, or X server");
	      puts("Invoke:  hipsclient -w server -p prognum [args] < input\n");
	      puts("-w hostname    connect to server hostname");
	      puts("            this argument must be supplied unless");
	      puts("            saving an Anima file locally");
	      puts("-p prognum     RPC program number");
	      puts("            default is the PC server RPC program number");
	      puts("-c compr       one of c, q, cl, ql, or n") ;
	      puts("            default is n (none)");
	      puts("-r frame_#      set record on");
	      puts("            default is preview");
	      puts("-v              flip vertically"); 
	      puts("            default is not to flip");
	      puts("-o filename	    save anima file");
	      puts("            default is not to save");
	      puts("-s x y          upper left hand corner");
	      puts("		default is (0,0)");
              puts("-h, -H, -?      this message") ;
		exit (-1) ;
	    default:
		return (-1);
		break;
	}
    }
}
