/* sunclient.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <math.h>
#include "scry.h"

/* main:  transmit Sun rasterfile to PC, Xview, or Sunview server
   parse_args:  parse command-line arguments  */


#define RED 0
#define GREEN 1
#define BLUE 2

int corner_arg_made = 0 ;

main (argc, argv)

int argc;
char *argv[];

{
    char	*which_server;
    int	prognum;			/* RPC program number */
    int 	comp_option;		/* compression option	*/
    int 	rec_option;		/* recording option	*/
    char *savename = NULL ;		/* name to save Anima file under */
	/* upper left point of image is at (corner_left, corner_top) */
    int corner_left = 0 ;
    int corner_top = 0 ;
    unsigned char	*image_mem;
    int flip_vertical = 0 ;		/* flip vertically or not */
    int height, width, depth ;
    int mapnum ;		/* number of entries in color map */
    int i ;

    which_server = NULL;	/* set default movie workstation*/
    rec_option = S_PREVIEW;		/* preview mode 		*/
    comp_option = S_NONE;
    prognum = S_PCPROG;

    parse_args (argc, argv, &corner_left, &corner_top, &which_server,
		&comp_option, &flip_vertical, &rec_option, &prognum,
		&savename) ;

#ifdef SCRY_CRAY
    fread(&height,1,sizeof(int),stdin) ;
    fread(&width,1,sizeof(int),stdin) ;
#else
    fread(&i,1,sizeof(int),stdin) ;
    fread(&height,1,sizeof(int),stdin) ;
    fread(&i,1,sizeof(int),stdin) ;
    fread(&width,1,sizeof(int),stdin) ;
#endif
    depth = 3 ;
    if ((image_mem = (unsigned char *) malloc(width*height*depth)) == NULL)
    {
        fprintf (stderr,"unable to allocate space for Sun rasterfile image\n") ;
        exit(0) ;
    }
	/* read image */
    fread(image_mem,width*height*depth,1,stdin) ;

	/* if should flip image */
    if (flip_vertical)
	scry_v_flip(image_mem,height,width,depth) ;

        /* if to connect to server */
    if (which_server != NULL)
    {
	if (prognum == 0)
	{
	    fprintf (stderr,"program number must be supplied\n") ;
	    exit(0) ;
	}
	    /* connect to server */
        if (!scry_connect (which_server, prognum))
	    exit(0);
		/* initialize recorder */
        scry_init_record (rec_option,1) ;
    }

        /* only has effect if server maximum display size is
	   less than image */
    if (corner_arg_made)
	    /* if not called, center of image will be sent
	       if the image is bigger than the server display */
        scry_set_corner(corner_left,corner_top) ;

	/* if saving Anima file */
    if (savename != NULL)
        scry_set_filename(savename) ;
    if (which_server != NULL)
	    /* transmit Anima file */
        scry_send_image(image_mem,comp_option,height,width,depth) ;
    else if (savename != NULL)
	    /* save Anima file */
	scry_save_anima(image_mem,height,width,depth) ;
    else
        fprintf (stderr,"No server or file name chosen: no action taken\n") ;
	    /* close client */
    scry_close();
    free (image_mem);
}




/* parse command-line arguments */

parse_args (argc,argv,start_col,start_row,which_server,comp,
	    flip_vertical,record,prognum,savename)

int 	argc;
char 	*argv[];
int 	*start_row, *start_col;	/* upper left hand corner */
char 	**which_server;		/* symbolic name of server */
int 	*comp;			/* compression option */
int	*flip_vertical;		/* flip vertically or not */
int 	*record;		/* recording option */
int	*prognum;		/* RPC program number */
char 	**savename ;		/* name to save Anima file under */

{
    int i;
    int j;
    char *temp_string;

    for (i = 1; i < argc; i++)
    {
	if (*argv[i] != '-')
	{
	    fprintf (stderr, "All arguments must start with a -\n") ;
	    fprintf (stderr, "Invoke with %s -h for help\n", argv[0]) ;
	    exit (0) ;
	}
	switch(*(argv[i]+1))
	{
		/* file to save Anima file under */
	    case 'o':
		*savename = argv[++i] ;
		break ;
	    case 'v':
		*flip_vertical = 1 ;
		break ;
	    case 's':	/* upper left hand corner */
		*start_col = atoi(argv[++i]);
		*start_row = atoi(argv[++i]);
		corner_arg_made = 1 ;
		break;
	    case 'r':	/* recording option */
		*record = atoi(argv[++i]);
		break;
            case 'w':	/* server name */
                *which_server = argv[++i];
                break;
            case 'p':	/* RPC program number */
                *prognum = atoi(argv[++i]);
                break;
            case 'c':	/* compression option */
                *comp = 0;
                temp_string = argv[++i];
                for(j = 0; j < strlen(temp_string); j++)
		{
                    switch(temp_string[j])
		    {
			case 'c':
			    *comp |= S_CCC; break;
			case 'q':
			    *comp |= S_QUANTIZE; break;
			case 'l':
			    *comp |= S_LEMPEL_ZIV; break;
			case 'n':
			    *comp = S_NONE; break;
                    }
                }
                break;
	    case 'h':
	    case 'H':
	    case '?':
	      puts("sunclient:  transfers Sun rasterfile to PC, Sunview, or X server");
	      puts("Invoke:  rleclient -w server -p prognum [args] < input\n");
	      puts("-w hostname    connect to server hostname");
	      puts("            this argument must be supplied unless");
	      puts("            saving an Anima file locally");
	      puts("-p prognum     RPC program number");
	      puts("            default is the PC server RPC program number");
	      puts("-c compr       one of c, q, cl, ql, or n");
	      puts("            default is n (none)");
	      puts("-r frame_#     set record on");
	      puts("            default is preview");
	      puts("-v             flip vertically") ;
	      puts("            default is not to flip");
	      puts("-o filename    save Anima file") ;
	      puts("            default is not to save");
	      puts("-s x y         upper left hand corner");
	      puts("            default is (0,0)");
              puts("-h, -H, -?      this message") ;
		exit (-1) ;
	    default:
		return (-1);
		break;
	}
    }
}
