#ifndef	_bsd_1_user_
#define	_bsd_1_user_

/* Module bsd_1 */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <bsd_types.h>

/* Routine Bsd1_execve */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_execve
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, cfname, cfarg, entry, entryCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	cfname_t cfname;
	cfname_t cfarg;
	entry_array entry;
	mach_msg_type_number_t *entryCnt;
{ return Bsd1_execve(proc_port, interrupt, fname, fnameCnt, cfname, cfarg, entry, entryCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	cfname_t cfname,
	cfname_t cfarg,
	entry_array entry,
	mach_msg_type_number_t *entryCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_fork */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_fork
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, new_state, new_stateCnt, child_pid)
	mach_port_t proc_port;
	boolean_t *interrupt;
	thread_state_t new_state;
	mach_msg_type_number_t new_stateCnt;
	int *child_pid;
{ return Bsd1_fork(proc_port, interrupt, new_state, new_stateCnt, child_pid); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	thread_state_t new_state,
	mach_msg_type_number_t new_stateCnt,
	int *child_pid
);
#else
    ();
#endif
#endif

/* Routine Bsd1_take_signal */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_take_signal
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, old_mask, old_onstack, sig, code, handler, new_sp)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int *old_mask;
	int *old_onstack;
	int *sig;
	int *code;
	int *handler;
	int *new_sp;
{ return Bsd1_take_signal(proc_port, interrupt, old_mask, old_onstack, sig, code, handler, new_sp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int *old_mask,
	int *old_onstack,
	int *sig,
	int *code,
	int *handler,
	int *new_sp
);
#else
    ();
#endif
#endif

/* Routine Bsd1_sigreturn */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_sigreturn
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, old_on_stack, old_sigmask)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int old_on_stack;
	int old_sigmask;
{ return Bsd1_sigreturn(proc_port, interrupt, old_on_stack, old_sigmask); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int old_on_stack,
	int old_sigmask
);
#else
    ();
#endif
#endif

/* Routine Bsd1_getrusage */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_getrusage
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, which, rusage)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int which;
	rusage_t *rusage;
{ return Bsd1_getrusage(proc_port, interrupt, which, rusage); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int which,
	rusage_t *rusage
);
#else
    ();
#endif
#endif

/* Routine Bsd1_chdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_chdir
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
{ return Bsd1_chdir(proc_port, interrupt, fname, fnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_chroot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_chroot
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
{ return Bsd1_chroot(proc_port, interrupt, fname, fnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_open */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_open
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, mode, crtmode, fileno)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int mode;
	int crtmode;
	int *fileno;
{ return Bsd1_open(proc_port, interrupt, fname, fnameCnt, mode, crtmode, fileno); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int mode,
	int crtmode,
	int *fileno
);
#else
    ();
#endif
#endif

/* Routine Bsd1_creat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_creat
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, fmode, fileno)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int fmode;
	int *fileno;
{ return Bsd1_creat(proc_port, interrupt, fname, fnameCnt, fmode, fileno); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int fmode,
	int *fileno
);
#else
    ();
#endif
#endif

/* Routine Bsd1_mknod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_mknod
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, fmode, dev)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int fmode;
	int dev;
{ return Bsd1_mknod(proc_port, interrupt, fname, fnameCnt, fmode, dev); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int fmode,
	int dev
);
#else
    ();
#endif
#endif

/* Routine Bsd1_link */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_link
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, target, targetCnt, linkname, linknameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t target;
	mach_msg_type_number_t targetCnt;
	path_name_t linkname;
	mach_msg_type_number_t linknameCnt;
{ return Bsd1_link(proc_port, interrupt, target, targetCnt, linkname, linknameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t target,
	mach_msg_type_number_t targetCnt,
	path_name_t linkname,
	mach_msg_type_number_t linknameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_symlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_symlink
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, target, targetCnt, linkname, linknameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t target;
	mach_msg_type_number_t targetCnt;
	path_name_t linkname;
	mach_msg_type_number_t linknameCnt;
{ return Bsd1_symlink(proc_port, interrupt, target, targetCnt, linkname, linknameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t target,
	mach_msg_type_number_t targetCnt,
	path_name_t linkname,
	mach_msg_type_number_t linknameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_unlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_unlink
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
{ return Bsd1_unlink(proc_port, interrupt, fname, fnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_access */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_access
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, fmode)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int fmode;
{ return Bsd1_access(proc_port, interrupt, fname, fnameCnt, fmode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int fmode
);
#else
    ();
#endif
#endif

/* Routine Bsd1_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_stat
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, follow, name, nameCnt, stat)
	mach_port_t proc_port;
	boolean_t *interrupt;
	boolean_t follow;
	path_name_t name;
	mach_msg_type_number_t nameCnt;
	statb_t *stat;
{ return Bsd1_stat(proc_port, interrupt, follow, name, nameCnt, stat); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	boolean_t follow,
	path_name_t name,
	mach_msg_type_number_t nameCnt,
	statb_t *stat
);
#else
    ();
#endif
#endif

/* Routine Bsd1_readlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_readlink
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, name, nameCnt, count, buf, bufCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t name;
	mach_msg_type_number_t nameCnt;
	int count;
	small_char_array buf;
	mach_msg_type_number_t *bufCnt;
{ return Bsd1_readlink(proc_port, interrupt, name, nameCnt, count, buf, bufCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t name,
	mach_msg_type_number_t nameCnt,
	int count,
	small_char_array buf,
	mach_msg_type_number_t *bufCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_chmod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_chmod
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, fmode)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int fmode;
{ return Bsd1_chmod(proc_port, interrupt, fname, fnameCnt, fmode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int fmode
);
#else
    ();
#endif
#endif

/* Routine Bsd1_chown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_chown
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, uid, gid)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int uid;
	int gid;
{ return Bsd1_chown(proc_port, interrupt, fname, fnameCnt, uid, gid); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int uid,
	int gid
);
#else
    ();
#endif
#endif

/* Routine Bsd1_utimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_utimes
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, times)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	timeval_2_t times;
{ return Bsd1_utimes(proc_port, interrupt, fname, fnameCnt, times); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	timeval_2_t times
);
#else
    ();
#endif
#endif

/* Routine Bsd1_truncate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_truncate
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, length)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	int length;
{ return Bsd1_truncate(proc_port, interrupt, fname, fnameCnt, length); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	int length
);
#else
    ();
#endif
#endif

/* Routine Bsd1_rename */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_rename
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, from_name, from_nameCnt, to_name, to_nameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t from_name;
	mach_msg_type_number_t from_nameCnt;
	path_name_t to_name;
	mach_msg_type_number_t to_nameCnt;
{ return Bsd1_rename(proc_port, interrupt, from_name, from_nameCnt, to_name, to_nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t from_name,
	mach_msg_type_number_t from_nameCnt,
	path_name_t to_name,
	mach_msg_type_number_t to_nameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_mkdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_mkdir
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, name, nameCnt, dmode)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t name;
	mach_msg_type_number_t nameCnt;
	int dmode;
{ return Bsd1_mkdir(proc_port, interrupt, name, nameCnt, dmode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t name,
	mach_msg_type_number_t nameCnt,
	int dmode
);
#else
    ();
#endif
#endif

/* Routine Bsd1_rmdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_rmdir
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, name, nameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t name;
	mach_msg_type_number_t nameCnt;
{ return Bsd1_rmdir(proc_port, interrupt, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_xutimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_xutimes
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fname, fnameCnt, times)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
	timeval_3_t times;
{ return Bsd1_xutimes(proc_port, interrupt, fname, fnameCnt, times); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt,
	timeval_3_t times
);
#else
    ();
#endif
#endif

/* Routine Bsd1_mount */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_mount
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fspec, fspecCnt, freg, fregCnt, ronly)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fspec;
	mach_msg_type_number_t fspecCnt;
	path_name_t freg;
	mach_msg_type_number_t fregCnt;
	int ronly;
{ return Bsd1_mount(proc_port, interrupt, fspec, fspecCnt, freg, fregCnt, ronly); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fspec,
	mach_msg_type_number_t fspecCnt,
	path_name_t freg,
	mach_msg_type_number_t fregCnt,
	int ronly
);
#else
    ();
#endif
#endif

/* Routine Bsd1_umount */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_umount
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fspec, fspecCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fspec;
	mach_msg_type_number_t fspecCnt;
{ return Bsd1_umount(proc_port, interrupt, fspec, fspecCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fspec,
	mach_msg_type_number_t fspecCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_acct */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_acct
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, acct_on, fname, fnameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	boolean_t acct_on;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
{ return Bsd1_acct(proc_port, interrupt, acct_on, fname, fnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	boolean_t acct_on,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_setquota */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_setquota
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fblk, fblkCnt, fname, fnameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t fblk;
	mach_msg_type_number_t fblkCnt;
	path_name_t fname;
	mach_msg_type_number_t fnameCnt;
{ return Bsd1_setquota(proc_port, interrupt, fblk, fblkCnt, fname, fnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t fblk,
	mach_msg_type_number_t fblkCnt,
	path_name_t fname,
	mach_msg_type_number_t fnameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_write_short */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_write_short
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, data, dataCnt, amount_written)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	small_char_array data;
	mach_msg_type_number_t dataCnt;
	int *amount_written;
{ return Bsd1_write_short(proc_port, interrupt, fileno, data, dataCnt, amount_written); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	small_char_array data,
	mach_msg_type_number_t dataCnt,
	int *amount_written
);
#else
    ();
#endif
#endif

/* Routine Bsd1_write_long */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_write_long
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, data, dataCnt, amount_written)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	char_array data;
	mach_msg_type_number_t dataCnt;
	int *amount_written;
{ return Bsd1_write_long(proc_port, interrupt, fileno, data, dataCnt, amount_written); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	char_array data,
	mach_msg_type_number_t dataCnt,
	int *amount_written
);
#else
    ();
#endif
#endif

/* Routine Bsd1_send_short */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_send_short
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, flags, data, dataCnt, amount_written)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int flags;
	small_char_array data;
	mach_msg_type_number_t dataCnt;
	int *amount_written;
{ return Bsd1_send_short(proc_port, interrupt, fileno, flags, data, dataCnt, amount_written); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int flags,
	small_char_array data,
	mach_msg_type_number_t dataCnt,
	int *amount_written
);
#else
    ();
#endif
#endif

/* Routine Bsd1_send_long */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_send_long
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, flags, data, dataCnt, amount_written)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int flags;
	char_array data;
	mach_msg_type_number_t dataCnt;
	int *amount_written;
{ return Bsd1_send_long(proc_port, interrupt, fileno, flags, data, dataCnt, amount_written); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int flags,
	char_array data,
	mach_msg_type_number_t dataCnt,
	int *amount_written
);
#else
    ();
#endif
#endif

/* Routine Bsd1_sendto_short */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_sendto_short
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, flags, to, toCnt, data, dataCnt, amount_written)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int flags;
	sockarg_t to;
	mach_msg_type_number_t toCnt;
	small_char_array data;
	mach_msg_type_number_t dataCnt;
	int *amount_written;
{ return Bsd1_sendto_short(proc_port, interrupt, fileno, flags, to, toCnt, data, dataCnt, amount_written); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int flags,
	sockarg_t to,
	mach_msg_type_number_t toCnt,
	small_char_array data,
	mach_msg_type_number_t dataCnt,
	int *amount_written
);
#else
    ();
#endif
#endif

/* Routine Bsd1_sendto_long */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_sendto_long
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, flags, to, toCnt, data, dataCnt, amount_written)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int flags;
	sockarg_t to;
	mach_msg_type_number_t toCnt;
	char_array data;
	mach_msg_type_number_t dataCnt;
	int *amount_written;
{ return Bsd1_sendto_long(proc_port, interrupt, fileno, flags, to, toCnt, data, dataCnt, amount_written); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int flags,
	sockarg_t to,
	mach_msg_type_number_t toCnt,
	char_array data,
	mach_msg_type_number_t dataCnt,
	int *amount_written
);
#else
    ();
#endif
#endif

/* Routine Bsd1_select */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_select
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, nd, in_set, ou_set, ex_set, in_valid, ou_valid, ex_valid, do_timeout, tv, rval)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int nd;
	fd_set *in_set;
	fd_set *ou_set;
	fd_set *ex_set;
	boolean_t in_valid;
	boolean_t ou_valid;
	boolean_t ex_valid;
	boolean_t do_timeout;
	timeval_t tv;
	int *rval;
{ return Bsd1_select(proc_port, interrupt, nd, in_set, ou_set, ex_set, in_valid, ou_valid, ex_valid, do_timeout, tv, rval); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int nd,
	fd_set *in_set,
	fd_set *ou_set,
	fd_set *ex_set,
	boolean_t in_valid,
	boolean_t ou_valid,
	boolean_t ex_valid,
	boolean_t do_timeout,
	timeval_t tv,
	int *rval
);
#else
    ();
#endif
#endif

/* Routine Bsd1_task_by_pid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_task_by_pid
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, pid, task)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int pid;
	task_t *task;
{ return Bsd1_task_by_pid(proc_port, interrupt, pid, task); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int pid,
	task_t *task
);
#else
    ();
#endif
#endif

/* Routine Bsd1_recvfrom_short */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_recvfrom_short
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, flags, len, from_addr, from_addrCnt, data, dataCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int flags;
	int len;
	sockarg_t from_addr;
	mach_msg_type_number_t *from_addrCnt;
	small_char_array data;
	mach_msg_type_number_t *dataCnt;
{ return Bsd1_recvfrom_short(proc_port, interrupt, fileno, flags, len, from_addr, from_addrCnt, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int flags,
	int len,
	sockarg_t from_addr,
	mach_msg_type_number_t *from_addrCnt,
	small_char_array data,
	mach_msg_type_number_t *dataCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_recvfrom_long */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_recvfrom_long
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, flags, len, from_addr, from_addrCnt, data, dataCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int flags;
	int len;
	sockarg_t from_addr;
	mach_msg_type_number_t *from_addrCnt;
	char_array *data;
	mach_msg_type_number_t *dataCnt;
{ return Bsd1_recvfrom_long(proc_port, interrupt, fileno, flags, len, from_addr, from_addrCnt, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int flags,
	int len,
	sockarg_t from_addr,
	mach_msg_type_number_t *from_addrCnt,
	char_array *data,
	mach_msg_type_number_t *dataCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_setgroups */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_setgroups
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, gidsetsize, gidset)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int gidsetsize;
	gidset_t gidset;
{ return Bsd1_setgroups(proc_port, interrupt, gidsetsize, gidset); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int gidsetsize,
	gidset_t gidset
);
#else
    ();
#endif
#endif

/* Routine Bsd1_setrlimit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_setrlimit
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, which, lim)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int which;
	rlimit_t lim;
{ return Bsd1_setrlimit(proc_port, interrupt, which, lim); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int which,
	rlimit_t lim
);
#else
    ();
#endif
#endif

/* Routine Bsd1_sigvec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_sigvec
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, signo, have_nsv, nsv, osv, tramp)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int signo;
	boolean_t have_nsv;
	sigvec_t nsv;
	sigvec_t *osv;
	int tramp;
{ return Bsd1_sigvec(proc_port, interrupt, signo, have_nsv, nsv, osv, tramp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int signo,
	boolean_t have_nsv,
	sigvec_t nsv,
	sigvec_t *osv,
	int tramp
);
#else
    ();
#endif
#endif

/* Routine Bsd1_sigstack */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_sigstack
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, have_nss, nss, oss)
	mach_port_t proc_port;
	boolean_t *interrupt;
	boolean_t have_nss;
	sigstack_t nss;
	sigstack_t *oss;
{ return Bsd1_sigstack(proc_port, interrupt, have_nss, nss, oss); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	boolean_t have_nss,
	sigstack_t nss,
	sigstack_t *oss
);
#else
    ();
#endif
#endif

/* Routine Bsd1_settimeofday */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_settimeofday
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, have_tv, tv, have_tz, tz)
	mach_port_t proc_port;
	boolean_t *interrupt;
	boolean_t have_tv;
	timeval_t tv;
	boolean_t have_tz;
	timezone_t tz;
{ return Bsd1_settimeofday(proc_port, interrupt, have_tv, tv, have_tz, tz); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	boolean_t have_tv,
	timeval_t tv,
	boolean_t have_tz,
	timezone_t tz
);
#else
    ();
#endif
#endif

/* Routine Bsd1_adjtime */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_adjtime
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, delta, olddelta)
	mach_port_t proc_port;
	boolean_t *interrupt;
	timeval_t delta;
	timeval_t *olddelta;
{ return Bsd1_adjtime(proc_port, interrupt, delta, olddelta); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	timeval_t delta,
	timeval_t *olddelta
);
#else
    ();
#endif
#endif

/* Routine Bsd1_setitimer */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_setitimer
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, which, have_itv, itv, oitv)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int which;
	boolean_t have_itv;
	itimerval_t itv;
	itimerval_t *oitv;
{ return Bsd1_setitimer(proc_port, interrupt, which, have_itv, itv, oitv); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int which,
	boolean_t have_itv,
	itimerval_t itv,
	itimerval_t *oitv
);
#else
    ();
#endif
#endif

/* Routine Bsd1_sethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_sethostname
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, hostname, len)
	mach_port_t proc_port;
	boolean_t *interrupt;
	hostname_t hostname;
	int len;
{ return Bsd1_sethostname(proc_port, interrupt, hostname, len); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	hostname_t hostname,
	int len
);
#else
    ();
#endif
#endif

/* Routine Bsd1_bind */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_bind
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, name, nameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	sockarg_t name;
	mach_msg_type_number_t nameCnt;
{ return Bsd1_bind(proc_port, interrupt, s, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	sockarg_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_accept */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_accept
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, name, nameCnt, new_s)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	sockarg_t name;
	mach_msg_type_number_t *nameCnt;
	int *new_s;
{ return Bsd1_accept(proc_port, interrupt, s, name, nameCnt, new_s); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	sockarg_t name,
	mach_msg_type_number_t *nameCnt,
	int *new_s
);
#else
    ();
#endif
#endif

/* Routine Bsd1_connect */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_connect
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, name, nameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	sockarg_t name;
	mach_msg_type_number_t nameCnt;
{ return Bsd1_connect(proc_port, interrupt, s, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	sockarg_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_setsockopt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_setsockopt
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, level, name, val, valCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	int level;
	int name;
	sockarg_t val;
	mach_msg_type_number_t valCnt;
{ return Bsd1_setsockopt(proc_port, interrupt, s, level, name, val, valCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	int level,
	int name,
	sockarg_t val,
	mach_msg_type_number_t valCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_getsockopt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_getsockopt
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, level, name, val, valCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	int level;
	int name;
	sockarg_t val;
	mach_msg_type_number_t *valCnt;
{ return Bsd1_getsockopt(proc_port, interrupt, s, level, name, val, valCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	int level,
	int name,
	sockarg_t val,
	mach_msg_type_number_t *valCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_getsockname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_getsockname
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, name, nameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	sockarg_t name;
	mach_msg_type_number_t *nameCnt;
{ return Bsd1_getsockname(proc_port, interrupt, s, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	sockarg_t name,
	mach_msg_type_number_t *nameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_getpeername */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_getpeername
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, s, name, nameCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int s;
	sockarg_t name;
	mach_msg_type_number_t *nameCnt;
{ return Bsd1_getpeername(proc_port, interrupt, s, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int s,
	sockarg_t name,
	mach_msg_type_number_t *nameCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_init_process */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_init_process
#if	defined(LINTLIBRARY)
    (proc_port, interrupt)
	mach_port_t proc_port;
	boolean_t *interrupt;
{ return Bsd1_init_process(proc_port, interrupt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_table_set */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_table_set
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, id, index, lel, nel, addr, addrCnt, nel_done)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int id;
	int index;
	int lel;
	int nel;
	small_char_array addr;
	mach_msg_type_number_t addrCnt;
	int *nel_done;
{ return Bsd1_table_set(proc_port, interrupt, id, index, lel, nel, addr, addrCnt, nel_done); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int id,
	int index,
	int lel,
	int nel,
	small_char_array addr,
	mach_msg_type_number_t addrCnt,
	int *nel_done
);
#else
    ();
#endif
#endif

/* Routine Bsd1_table_get */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_table_get
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, id, index, lel, nel, addr, addrCnt, nel_done)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int id;
	int index;
	int lel;
	int nel;
	char_array *addr;
	mach_msg_type_number_t *addrCnt;
	int *nel_done;
{ return Bsd1_table_get(proc_port, interrupt, id, index, lel, nel, addr, addrCnt, nel_done); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int id,
	int index,
	int lel,
	int nel,
	char_array *addr,
	mach_msg_type_number_t *addrCnt,
	int *nel_done
);
#else
    ();
#endif
#endif

/* Routine Bsd1_pioctl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_pioctl
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, path, pathCnt, com, follow, in_data, in_dataCnt, out_data_wanted, out_data, out_dataCnt)
	mach_port_t proc_port;
	boolean_t *interrupt;
	path_name_t path;
	mach_msg_type_number_t pathCnt;
	int com;
	boolean_t follow;
	small_char_array in_data;
	mach_msg_type_number_t in_dataCnt;
	int out_data_wanted;
	small_char_array out_data;
	mach_msg_type_number_t *out_dataCnt;
{ return Bsd1_pioctl(proc_port, interrupt, path, pathCnt, com, follow, in_data, in_dataCnt, out_data_wanted, out_data, out_dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	path_name_t path,
	mach_msg_type_number_t pathCnt,
	int com,
	boolean_t follow,
	small_char_array in_data,
	mach_msg_type_number_t in_dataCnt,
	int out_data_wanted,
	small_char_array out_data,
	mach_msg_type_number_t *out_dataCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_emulator_error */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_emulator_error
#if	defined(LINTLIBRARY)
    (proc_port, err_message, err_messageCnt)
	mach_port_t proc_port;
	small_char_array err_message;
	mach_msg_type_number_t err_messageCnt;
{ return Bsd1_emulator_error(proc_port, err_message, err_messageCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	small_char_array err_message,
	mach_msg_type_number_t err_messageCnt
);
#else
    ();
#endif
#endif

/* Routine Bsd1_readwrite */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_readwrite
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, which, fileno, size, amount)
	mach_port_t proc_port;
	boolean_t *interrupt;
	boolean_t which;
	int fileno;
	int size;
	int *amount;
{ return Bsd1_readwrite(proc_port, interrupt, which, fileno, size, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	boolean_t which,
	int fileno,
	int size,
	int *amount
);
#else
    ();
#endif
#endif

/* Routine Bsd1_share_wakeup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_share_wakeup
#if	defined(LINTLIBRARY)
    (proc_port, lock_offset)
	mach_port_t proc_port;
	int lock_offset;
{ return Bsd1_share_wakeup(proc_port, lock_offset); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	int lock_offset
);
#else
    ();
#endif
#endif

/* Routine Bsd1_maprw_request_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_maprw_request_it
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
{ return Bsd1_maprw_request_it(proc_port, interrupt, fileno); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno
);
#else
    ();
#endif
#endif

/* Routine Bsd1_maprw_release_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_maprw_release_it
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
{ return Bsd1_maprw_release_it(proc_port, interrupt, fileno); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno
);
#else
    ();
#endif
#endif

/* Routine Bsd1_maprw_remap */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_maprw_remap
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, fileno, offset, size)
	mach_port_t proc_port;
	boolean_t *interrupt;
	int fileno;
	int offset;
	int size;
{ return Bsd1_maprw_remap(proc_port, interrupt, fileno, offset, size); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	int fileno,
	int offset,
	int size
);
#else
    ();
#endif
#endif

/* Routine Bsd1_pid_by_task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t Bsd1_pid_by_task
#if	defined(LINTLIBRARY)
    (proc_port, interrupt, task, pid, command, commandCnt, rval)
	mach_port_t proc_port;
	boolean_t *interrupt;
	mach_port_t task;
	int *pid;
	path_name_t command;
	mach_msg_type_number_t *commandCnt;
	int *rval;
{ return Bsd1_pid_by_task(proc_port, interrupt, task, pid, command, commandCnt, rval); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t proc_port,
	boolean_t *interrupt,
	mach_port_t task,
	int *pid,
	path_name_t command,
	mach_msg_type_number_t *commandCnt,
	int *rval
);
#else
    ();
#endif
#endif

#endif	_bsd_1_user_
