/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	main.c,v $
 * Revision 2.4  90/12/04  21:55:43  rpd
 * 	Removed reaper thread.
 * 	[90/12/04            rpd]
 * 
 * Revision 2.3  90/09/27  13:55:08  rwd
 * 	Change exit to _exit to not pick up version in libmach_sa.a
 * 	Remove mach_port_allocate_name since library has been fixed.
 * 	[90/09/24            rwd]
 * 	Add setlinebuf for !STANDALONE case.
 * 	[90/09/19            rwd]
 * 	Fix signal code for i386.
 * 	[90/09/08            rwd]
 * 
 * Revision 2.2  90/09/08  00:19:12  rwd
 * 		Define mach_port_allocate_name until bug fix to libmach_sa
 * 		propogates.
 * 	[90/09/03            rwd]
 * 	Added mapped time support.
 * 	[90/08/13            rwd]
 * 
 * 	Added standard way to get ports plus standalone version.
 * 	[90/07/13            rwd]
 * 
 */
/*
 *	File:	./main.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <config.h>
#include <mach.h>
#include <mach/message.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/time.h>
#include <ux_user.h>
#include <machine/root_device.h>
#include <device/device_types.h>

extern char version[];
mach_port_t privileged_host_port;
mach_port_t host_port;
mach_port_t device_server_port;
int add_crs = 1;

get_privileged_ports()
{
	privileged_host_port = (mach_port_t)mach_privileged_host_port();
	device_server_port = (mach_port_t)mach_device_server_port();
	host_port = mach_host_self();
}

time_value_t *mtime = 0;

init_mapped_time()
{
        kern_return_t rc;
        mach_port_t device_port, pager = MACH_PORT_NULL;

        rc = device_open(device_server_port,0,"time",&device_port);
        if (rc != D_SUCCESS) panic("unable to open device time");

        rc = device_map(device_port, VM_PROT_READ,
                        0, sizeof(time_value_t), &pager, 0);
        if (rc != D_SUCCESS) panic("unable to map device time");
        if (pager == MACH_PORT_NULL) panic("unable to map device time");

        rc = vm_map(mach_task_self(), &mtime, sizeof(time_value_t), 0, TRUE,
                    pager, 0, 0, VM_PROT_READ,
                    VM_PROT_READ, VM_INHERIT_SHARE);
        if (rc != D_SUCCESS) panic("unable to vm_map device time");

        rc = mach_port_deallocate(mach_task_self(), pager);
        if (rc != KERN_SUCCESS) panic("unable to deallocate pager");
}

gettimeofday(tp, tzp)
struct timeval *tp;
struct timezone *tzp;
{
	*tp = *(struct timeval *)mtime;
/*XXX*/
	tzp->tz_minuteswest = 300;
	tzp->tz_dsttime = 1;
}

get_time(t)
long *t;
{
	long nt = mtime->seconds;
	if (t) *t = nt;
	return nt;
}

tv_sleep(sec, usec)
	int sec;
	int usec;
{
	mach_msg_header_t	m;
	mach_port_t		sleep_port;
	int			init = 0;
	int			t;

	if (!init) {
	    init = 1;
	    (void) mach_port_allocate(mach_task_self(),
				      MACH_PORT_RIGHT_RECEIVE,
				      &sleep_port);
	    (void) mach_port_insert_right(mach_task_self(),
					  sleep_port, sleep_port,
					  MACH_MSG_TYPE_MAKE_SEND);
	}
	t = usec/1000 + sec*1000;

	(void) mach_msg(&m, MACH_RCV_MSG|MACH_RCV_TIMEOUT,
			0, sizeof m, sleep_port,
			t, MACH_PORT_NULL);

}

server_shutdown_user(ut)
	struct ux_task *ut;
{
	int error;

	if (! ut->ut_dead) {
		error = task_terminate(ut->ut_task);
		printf("shutdown_user(pid=%d) : error %d\r\n",
			ut->ut_pid, error);
	}
}

char bogus_c;

server_shutdown(sig, code)
	int sig;
	int code;
{
	if (sig == SIGINT) {
		bogus_c = 'C'-'@';
		return;
	}
	if (sig == SIGTSTP) {
		bogus_c = 'Z'-'@';
		return;
	}
	if (sig != SIGQUIT && sig != SIGTERM) {
		printf("server_shutdown: sig=%d, code=0x%x\r\n", sig, code);
	}
	foreach_ux_user(server_shutdown_user);
	poe_exit(0, "Server shutdown", 0);
}

#if	!STANDALONE
#ifdef	i386
#define	sc_pc sc_eip
#endif	i386
#include <stdio.h>
got_signal(sig, code, scp)
	int sig;
	int code;
	struct sigcontext *scp;
{
	switch (sig) {
	    default:
		printf("signal(%d) code=%d  pc=x0%x\r\n", sig, code, scp->sc_pc);
	}
	panic("external signal");
}

set_signals()
{
	signal(SIGHUP, got_signal);
	signal(SIGINT, got_signal);
	signal(SIGQUIT, got_signal);
	signal(SIGILL, got_signal);
	signal(SIGTRAP, got_signal);
	signal(SIGIOT, got_signal);
	signal(SIGEMT, got_signal);
	signal(SIGBUS, got_signal);
	signal(SIGSEGV, got_signal);
	signal(SIGTERM, got_signal);
	signal(SIGSTOP, got_signal);
	signal(SIGTSTP, got_signal);
	setlinebuf(stdout);
	setlinebuf(stderr);
}

signal_thread()
{
	cthread_set_kernel_limit(cthread_kernel_limit() + 1);
	cthread_wire();
	set_signals();
	while(1)sleep(10000);
}

#endif	!STANDALONE
main(argc, argv)
	int argc;
	char **argv;
{
	char *getenv(), *PATH, *TERM;
	char pathname[1024];
	extern int silent;
	int sig, error;

	cthread_set_kernel_limit(2);

#if	!STANDALONE
	cthread_detach(cthread_fork(signal_thread, 0));
#endif	!STANDALONE

	if (argc > 1 && ! strcmp(argv[1], "-v")) {
		silent = 0;
		argv[1] = argv[0];
		argc--, argv++;
	}
	bsd_master_init();
	get_privileged_ports();
	init_console();
	init_mapped_time();

	printf("%s\n\r",version);

	server_init();

	/*
	 * filesystem stuff
	 */

	ufs_devpager_init();
	ufs_pager_init();

	error = ufs_mountroot(ROOT_DEVICE);
	if (error) {
		poe_exit(1, "ufs_mountroot", error);
	}
	error = rfs_walk();
	if (error) {
		poe_exit(1, "rfs_walk", error);
	}

	error = spawn(argc, argv);
	if (error) {
		unix_error("spawn", error);
		poe_exit(0, "unix error spawn", error);
	}

	{
	    struct mutex kill_mutex;
	    struct condition kill_condition;
	    mutex_init(&kill_mutex);
	    condition_init(&kill_condition);
	    mutex_lock(&kill_mutex);
	    condition_wait(&kill_condition, &kill_mutex);
	}
	/* NOTREACHED */
}

panic(s)
	char *s;
{
	printf("panic: %s\r\n", s);
	server_shutdown(1, 0);
}

poe_exit(i, s, e)
int	i,e;
char	*s;
{
#if	STANDALONE
	for( ;; );
	host_reboot(privileged_host_port, 0x1004);	/*XXX*/
#else
	printf("%s: error = %d\n", s, e);
	_exit(i);
#endif	STANDALONE
}
