/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	mem_fops.c,v $
 * Revision 2.3  91/06/18  13:06:44  jjc
 * 	Fixed mem_special() to get /dev/null's major device number right 
 * 	for non-MIPS machines.
 * 	[91/04/16            jjc]
 * 
 * Revision 2.2  90/09/08  00:19:23  rwd
 * 	First checkin
 * 	[90/08/31  13:44:35  rwd]
 * 
 * 	[90/08/31  13:35:41  rwd]
 * 
 *	First checkin
 *
 */
/*
 *	File:	./mem_fops.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ux_user.h>
#include <fnode.h>
#include <sys/ioctl.h>
#include <bsd_ioctl.h>
#include <subr_fops.h>

struct fops null_fops = {
	null_open,
	spec_close,
	null_read,
	null_write,
	spec_getstat,
	spec_setstat,
	null_select,
	nil_ioctl,
	nil_getpager,
	nil_lookup,
	nil_create,
	nil_link,
	nil_unlink,
};
	
struct fnfs null_fs = {
	0,		/* fs_mountpoint */
	0,		/* fs_root */
	&null_fops,	/* fs_fops */
	TRUE,		/* fs_mayseek */
	FALSE,		/* fs_maymap */
};

mem_special(fnp, fmt, dev)
	struct fnode **fnp;
	int fmt;
	dev_t dev;
{
	switch (dev) {
#if	mips
	case makedev(2, 2):	/*	 /dev/null	*/
#else	mips
	case makedev(3, 2):	/*	 /dev/null	*/
#endif	mips
		return spec_make_special(fnp, fmt, dev, &null_fs);

	default:
		return enxio_special(fnp, fmt, dev);
	}
}
