/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	minit.c,v $
 * Revision 2.2  90/09/08  00:19:31  rwd
 * 	Fix STANDALONE logic.
 * 	[90/09/04            rwd]
 * 	First Checkin
 * 	[90/09/03  17:44:29  rwd]
 * 
 */
/*
 *	File:	./minit.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <config.h>

#if STANDALONE
#define TTY "/dev/console"
#else STANDALONE
#define TTY "/dev/tty"
#endif STANDALONE
char *cshargv[] = {
	"-csh",
	0,
};
char *cshenvp[] = {
	"HOME=/mach_servers",
	"SHELL=/bin/csh",
	"TERM=unknown",
	"USER=root",
	"PATH=/usr/cs/bin:/usr/ucb:/bin:/usr/bin:/etc:/mach_servers",
	"CPATH=:/usr/cs/include:/usr/include",
	"LPATH=:/usr/cs/lib:/lib:/usr/lib",
	"MPATH=:/usr/cs/man:/usr/man",
	"EPATH=:/usr/cs/maclib",
	0,
};

main(argc, argv)
int argc;
char *argv[];
{
	int fd, nfds, error;

	chdir("/");
	nfds = getdtablesize();
	if (nfds == -1) {
		perror("getdtablesize");
		exit(1);
	}
	for (fd = 0; fd < nfds; fd++) {
		close(fd);
	}
	error = open(TTY, 2);
	if (error == -1) {
		perror("open TTY");
		exit(1);
	}
	error = dup(0);
	if (error == -1) {
		perror("dup 0");
		exit(1);
	}
	error = dup(1);
	if (error == -1) {
		perror("dup 1");
		exit(1);
	}
	if (argc > 2)
		printf("Root Device %s\n",argv[2]);
#if	STANDALONE
	if (*argv[1] != 's') {
	    system("/bin/csh -f < /mach_servers/rc");
	}
#endif	STANDALONE
	system("/etc/mount -a");
	chdir("/mach_servers");
	execve("/bin/csh", cshargv, cshenvp);
	perror("/bin/csh");
	exit(1);
}
