/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ufs_fops.h,v $
 * Revision 2.3  90/10/01  14:06:11  rwd
 * 	Added precalculated ud_nindir.
 * 	[90/09/30            rwd]
 * 
 * Revision 2.2  90/09/08  00:21:50  rwd
 * 	First checkin
 * 	[90/08/31  14:00:32  rwd]
 * 
 */
/*
 *	File:	./ufs_fops.h
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#ifndef _UFS_FOPS_H_
#define _UFS_FOPS_H_

#include <sys/types.h>
#include <ufs_param.h>
#include <ufs_fs.h>
#include <ufs_disk.h>
#include <map_info.h>
#include <fnode.h>

/*
 *  XXX General solution requires windowing (yuck)
 *  XXX or, perhaps a separate task per device
 */
struct udev {
	struct fnfs	ud_fnfs;	/* common fs info */
	struct fnode *	ud_special;	/* special device where fs lives */
	dev_t		ud_dev;		/* unix dev type thingywah */
	struct fs	ud_fs;		/* file system assoc w/ device */
	long 		ud_refcount;	/* number of fnodes using device */
	vm_size_t	ud_size;	/* (XXX how do we find this?) */
	int		ud_nindir[NIADDR+1];
	struct udev *	ud_next;	/* list of udevs */

	mach_port_t	ud_pager;
	memory_object_control_t	ud_memory_control;
	vm_offset_t	ud_mapped_addr;	/* Where device is mapped
					   into memory. */
};

#define DISK_BLOCK_ADDR( udev, blkno ) \
   ((udev)->ud_mapped_addr + ((blkno) * DEV_BSIZE ))

struct uhack {
	vm_offset_t	uh_offset;
	vm_offset_t	uh_data;
	struct uhack *	uh_next;
};

struct unode {
	struct fnode	un_fn;
	struct udev *	un_ud;		/* XXX redundant, with fnfs */
	struct uhash *	un_uh;		/* (dirty) ubuf hash table */
	int		un_pager_refs;	/* reference count for un pager */
	ino_t		un_ino;
	/* struct uhack *	un_hack; */	/* XXX should use ic format */
	struct icommon *i_ic;		/* copy of on-disk inode */
	struct unode *	un_next;	/* list of in-core unodes */
	memory_object_control_t	un_memory_control;
	
};

/* XXX does struct direct information belong here or in ufs_fs.h? --ajr */
#define DIRBLKSIZ       DEV_BSIZE
#define	MAXNAMLEN	255
#define D_RECLEN(d_namelen) \
    ((sizeof (struct direct) - (MAXNAMLEN+1)) + ((d_namelen + 4) &~ 3))


struct	direct {
	u_long	d_ino;			/* inode number of entry */
	u_short	d_reclen;		/* length of this record */
	u_short	d_namlen;		/* length of string in d_name */
	char	d_name[MAXNAMLEN + 1];	/* name must be no longer than this */
};

#define B_CLRBUF	0x1	/* request allocated buffer be cleared */
#define B_SYNC		0x2	/* do all allocations synchronously */

#ifndef IO_SYNC
#define IO_SYNC 0x04		/* do IO synchronously */
#endif /* IO_SYNC */

#ifndef min
#define min(a,b)	( (a) < (b) ? (a) : (b) )
#endif /* min */

#ifndef max
#define max(a,b)	( (a) > (b) ? (a) : (b) )
#endif /* max */


#endif /* _UFS_FOPS_H_ */
