/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ufs_param.h,v $
 * Revision 2.3  90/10/01  14:06:36  rwd
 * 	Taken from XMK26.
 * 	[90/09/28            rwd]
 * 
 * Revision 2.2  90/09/08  00:22:14  rwd
 * 	Added UFS error codes.
 * 	[88/10/10            dbg]
 * 
 * 	MACH_KERNEL version: contains only those constants that the boot
 * 	file system loader needs (they really should be in those files
 * 	instead).
 * 	[88/08/16            dbg]
 * 
 */
/*
 *	File:	./ufs_param.h
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

/*
 * Common definitions for Berkeley Fast File System.
 */
#include <sys/types.h>

#define DEV_BSIZE 512
/*
 * The file system is made out of blocks of at most MAXBSIZE units,
 * with smaller units (fragments) only in the last direct block.
 * MAXBSIZE primarily determines the size of buffers in the buffer
 * pool.  It may be made larger without any effect on existing
 * file systems; however, making it smaller may make some file
 * systems unmountable.
 *
 * Note that the disk devices are assumed to have DEV_BSIZE "sectors"
 * and that fragments must be some multiple of this size.
 */
#define	MAXBSIZE	8192
#define	MAXFRAG		8

/*
 * MAXPATHLEN defines the longest permissible path length
 * after expanding symbolic links.
 *
 * MAXSYMLINKS defines the maximum number of symbolic links
 * that may be expanded in a path name.  It should be set
 * high enough to allow all legitimate uses, but halt infinite
 * loops reasonably quickly.
 */

#define	MAXPATHLEN	1024
#define	MAXSYMLINKS	8

