#include <sys/types.h>
#include <dial.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include "modemcap.h"


static jmp_buf env;	/* long jump buffer if timeout in read */


extern int merrno;


static void timeout(void)
{
  longjmp(env, 1);
}


int mdial(telno, fd)
char *telno;
int fd;
{
  char buf[64];		/* telephone buffer if AS is false */
  char command[80];	/* dial command buffer */
  int i, j;		/* index and length of telephone number */
  char c;		/* single character for connection verification */

  /* can't dial phone anyhow */
  if (! DI) return(merrno = A_PROB);

  /* never used any other kind of modem */
  if (! AS) return(merrno = A_PROB);
    else strcpy(buf, telno);	/* normal ascii character phone numbers	*/

  sprintf(command, "%s%s%s%s%s", CS, DS, buf, DE, CE);
  if (setjmp(env) != 0) {	
	signal(SIGALRM, SIG_DFL);
	return(merrno = D_HUNG);
  }

  signal(SIGALRM, timeout);
  alarm(30);
  write(fd, command, strlen(command));

  if (CO) {	/* verify connection */
	if (setjmp(env) != 0) {	
		signal(SIGALRM, SIG_DFL);
		return(merrno = A_PROB);
	}
	signal(SIGALRM, timeout);
	if (TT) alarm(60);
	  else alarm(60 + strlen(telno) / 2);

	for (i=0; CO[i] != 0; ) {
		if (read(fd, &c, 1) != 1) continue;
			
		if (CO[i] == c) i++;
		  else i = 0;
	}
	return(0);
  }
  return(0);
}
