#include <sys/types.h>
#include <stdio.h>


extern char *__modemcap;


char *mgetstr(id, area)
register char *id;
register char **area;
{
  register char *cp = __modemcap;
  register char *str = *area;		/* start of current string */

  if (__modemcap == (char *)NULL)	/* has mgetent() been called? ... */
		return((char *)NULL);	/* ... no, can't find string */

  while (*cp != ':' && *cp != 0) cp++;	/* find first entry in cap */

  if (*cp == 0) return(NULL);	/* empty entry??? yes, bad modemcap entry */
    else cp++;			/* point to first character in next */

  /* until entry found or end of entry */
  while (*cp != 0) {
	if (cp[0] == id[0] && cp[1] == id[1]) {		/* found entry!!! */
		if (cp[2] != '=')		/* is it a string value??? */
			return(NULL);		/* no, something else */
		  else break;			/* yes, entry was found */
	} else {	/* not entry, skip this entire entry */
		/* search for end of current entry */
		while (*cp != ':' && *cp != 0) cp++;

		if (*cp != 0) cp++;	/* skip terminating character */
	}
  }

  if (*cp == 0) return(NULL);			/* end of modem cap entry */
  cp += 3;					/* point to actual string */

  /* for every character in string ... */
  while (*cp != ':' && *cp != 0) {
	if (*cp == '\\') {	/* translate escaped character */
		cp++;
		switch (*cp) {
			case 'n':	/* newline */
				**area = '\n';
				(*area)++;
				cp++;
				break;
			case 'r':	/* carriage return */
				**area = '\r';
				(*area)++;
				cp++;
				break;
			case 'b':	/* backspace */
				**area = '\b';
				(*area)++;
				cp++;
				break;
			case 'f':	/* form feed */
				**area = '\f';
				(*area)++;
				cp++;
				break;
			case 't':	/* tab */
				**area = '\t';
				(*area)++;
				cp++;
				break;
			case 'E':	/* Escape character */
				**area = 033;
				(*area)++;
				cp++;
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				**area = ((cp[0] - '0') << 6) +
					 ((cp[1] - '0') << 3) +
					  (cp[2] - '0');
				(*area)++;
				cp += 3;
				break;
			default:
				**area = *cp++;
				(*area)++;
				break;
		}
	} else if (*cp == '^') {	/* some control character */
			cp++;
			if (*cp >= '@' && *cp <= '_') {
				**area = *cp - '@';
				(*area)++;
			}
			cp++;
		} else {			/* some normal character */
			**area = *cp++;		/* put character in area */
			(*area)++;
		}
	}
  *((*area)++) = 0;		/* null terminate area and string */
  return(str);			/* return pointer to start of string */
}
