/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *		This version  has a better  user-interface, and it
 *		also "knows" about things like forwarding, replies
 *		etc. Overall, it looks like the Mail (uppercase M)
 *		on our local DYNIX(tm) (==BSD) system...
 *		The paging-code (for paging letters on the screen)
 *		was taken from "more.c", by Brandon Allbery.
 *
 *		D E F I N I T I O N S
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <setjmp.h>


#ifdef _MINIX
#	define VERSION	   "3.3/MINIX (04/28/90)"
#	define DROPNAME      "/usr/spool/mail/%s"   /* User Mailbox */
#	define LOCKNAME	"/usr/spool/mail/%s.lock"   /* lockfile for box */
#endif /* _MINIX */

#ifdef _UNIX
#	define VERSION	    "3.3/UNIX (04/28/90)"
#	define DROPNAME            "/usr/mail/%s"   /* User Mailbox */
#	define LOCKNAME	      "/usr/mail/%s.lock"   /* lockfile for box */
#endif /* _UNIX */

#define MAILTEMP		"/tmp/mailXXXXXX"   /* temp. file */
#define COPYTEMP		"/tmp/mcpyXXXXXX"   /* temp update file */
#define SHELL		      		"/bin/sh"
#define RMAIL			 "/usr/bin/rmail"   /* the Internet Mailer */
#define SAVEFILE		     	   "mbox"   /* default mailsave */
#define SIGNATURE		     ".signature"
#define DEADLETTER		    "dead.letter"
#define PROMPT				 "[%d]& "

#ifndef PATHLEN
#	define PATHLEN	128
#endif /* PATHLEN */

#ifndef TRUE
#	define FALSE	  0
#	define TRUE	  1
#endif

#define LOCKWAIT	  5		/* seconds to wait after collision */
#define LOCKTRIES	  4		/* maximum number of collisions */
#define MAXRCPT		100		/* maximum number of recipients */
#define LINELEN		512

#define UNREAD		  1		/* 'not read yet' status */
#define DELETED		  2		/* 'deleted' status */
#define READ		  3		/* 'has been read' status */


typedef struct _letter{
  struct _letter *prev;		/* linked letter list: previous letter */
  struct _letter *next;		/* linked letter list: next letter */
  off_t location;		/* location within mailbox file */
  int status;			/* letter status */
  int seqno;			/* letter number */
  char *subject;		/* subject of message */
  char *sender;			/* sender of message */
  char date[32];		/* date of message */
} LETTER;
#define NIL_LET	(LETTER *)NULL


extern char *Version;
extern int old_uid, old_gid;		/* "real" ID's of caller */
extern int remote;			/* use RMAIL to deliver (if any) */
extern int loclink;			/* LMAIL: local delivery only! */
extern int printmode;			/* print-and-exit mode */
extern int immediate;			/* send remote immediately! */
extern int quitmode;			/* take interrupts */
extern int usedrop;			/* read the maildrop (no -f given) */
extern int verbose;			/* pass "-v" flag on to mailer */
extern int needupdate;			/* need to update mailbox */
extern int sayall;			/* include line with all recipients */
extern int checkonly;			/* only chack if there is mail */
extern char sender[PATHLEN];		/* who sent the message? */
extern char forward[PATHLEN];		/* who is the message forwarded to? */
extern char addressee[PATHLEN];		/* current recipient */
extern char recipients[PATHLEN];	/* also to... users */
extern char mailbox[PATHLEN];		/* user's mailbox/maildrop */
extern char subject[PATHLEN];		/* subject of message */
extern char msg_temp[PATHLEN];		/* temporary file */
extern FILE *infp;			/* current message input file */
extern FILE *boxfp;			/* mailbox file */
extern char *progname;			/* program name */
extern jmp_buf printjump;		/* for quitting out of letters */
extern LETTER *firstlet, *lastlet;	/* message pointers for readbox() */
extern int numlet, seqno;		/* number of active letters */
extern unsigned oldmask;		/* saved umask() */ 


/*
 * Function Prototypes.
 */
#if _MSDOS
#       define  _PROTOTYPE(function, params)    function params
#       define  _VOIDSTAR       void *
#       define  _VOID           void
#       define  _CONST          const
#       define  _VOLATILE       volatile
#       define _SIZET           size_t
#else
#ifndef _ANSI_H
#       include <ansi.h>
#endif  /* _ANSI_H */
#endif  /* _MSDOS */

_PROTOTYPE( void onint, (void) );
_PROTOTYPE( char *basename, (char *name) );
_PROTOTYPE( char *basepath, (char *name) );
_PROTOTYPE( char *whoami, (void) );
_PROTOTYPE( int allowed, (char *name, int mode) );
_PROTOTYPE( void showlet, (LETTER *let) );
_PROTOTYPE( void printlet, (LETTER *let, FILE *tofp) );
_PROTOTYPE( void printall, (void) );
_PROTOTYPE( void dead_letter, (void) );
_PROTOTYPE( char *find_string, (LETTER *let, char *text) );
_PROTOTYPE( void updatebox, (void) );
_PROTOTYPE( void interact, (void) );
_PROTOTYPE( void send_remote, (char *name) );
_PROTOTYPE( FILE *edit_mail, (void) );
_PROTOTYPE( int chk_box, (void) );
_PROTOTYPE( int deliver, (int count, char *vec[]) );
_PROTOTYPE( char *xtime, (void) );

