/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *		This version  has a better  user-interface, and it
 *		also "knows" about things like forwarding, replies
 *		etc. Overall, it looks like the Mail (uppercase M)
 *		on our local DYNIX(tm) (==BSD) system...
 *		The paging-code (for paging letters on the screen)
 *		was taken from "more.c", by Brandon Allbery.
 *
 *		L O C A L    D E L I V E R Y    M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 *
 * Revisions:
 *		11/07/89 FvK	Edited a little for the new MSS.
 *				Fixed "dead.letter" pathname.
 *		11/10/89 FvK	Fixed the overall security-bug.
 *		11/23/89 RW	Fixed removing of newly received letters if
 *				the former last one is deleted.
 *				Fixed the bug which causes update() to fail
 *				if a reply was done.
 *		12/04/89 FvK	Fixed 'adressee' typo.
 *				Fixed send_remote() argument bug.
 *				Removed unneeded variables.
 *		12/16/89 FvK	Cleanup.
 *		02/17/90 FvK	Cleaned for release.
 *
 * To Do:
 *		- Aliases.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <pwd.h>
#include <unistd.h>
#include <stdio.h>
#include "wmail.h"


/*
 * Update the mail-box file.
 */
void updatebox()
{
  char cpbuff[1024];		/* copy buffer */
  char lockname[PATHLEN];	/* maildrop lock */
  char copytemp[PATHLEN];	/* temporary copy file */
  FILE *copyfp;			/* fp for tempfile */
  LETTER *let;			/* current letter */
  int locktries = 0;		/* tries when box is locked */
  int newlet;			/* true if a new letter is found */

  strcpy(copytemp, COPYTEMP);
  mktemp(copytemp);

  sprintf(lockname, LOCKNAME, sender);
  
  /* Create a new mailbox-file. */
  if ((copyfp = fopen(copytemp, "w")) == (FILE *)NULL) {
	fprintf(stderr, "%s: cannot create temp file \"%s\"\n",
						progname, copytemp);
	return;
  }
    
  /* Copy letters from old file to new file. */
  for (let = firstlet; let != NIL_LET; let = let->next) {
	if (let->status != DELETED) printlet(let, copyfp);
  }

  /* If the last letter was deleted, newly received mail will be lost ! */
  /* We try to avoid this by some additionl work ... */
  if (lastlet->status == DELETED) {
	newlet = FALSE;
	fseek(boxfp, (off_t) (lastlet->location + 1), SEEK_SET);
	while (fgets(cpbuff, sizeof(cpbuff), boxfp) != (char *)NULL) {
		if (!newlet && strncmp(cpbuff,"From ", 5) == 0)
							newlet = TRUE;
		if (newlet)
			fwrite(cpbuff, sizeof(char), strlen(cpbuff), copyfp);
	}
  }

  if ((copyfp = freopen(copytemp, "r", copyfp)) == (FILE *)NULL) {
	sprintf(cpbuff, "%s: temporary file write error", progname);
	perror(cpbuff);
	if (usedrop) unlink(copytemp); 
	return;
  }

  /* Shut off signals during the update. */
  signal(SIGINT, SIG_IGN);
  signal(SIGHUP, SIG_IGN);
  signal(SIGQUIT, SIG_IGN);

  if (usedrop) while(link(mailbox, lockname) != 0) {
	if (++locktries >= LOCKTRIES) {
		fprintf(stderr, "%s: could not lock maildrop for update\n",
								progname);
		return;
	}
	sleep(LOCKWAIT);
  }

  if ((boxfp = freopen(mailbox, "w", boxfp)) == (FILE *)NULL) {
	sprintf(cpbuff, "%s: could not reopen maildrop\n", progname);
       	fprintf(stderr, "%sMail may have been lost; look in %s\n",
							cpbuff, copytemp);
       	unlink(lockname);
       	return;
  }

  /* Copy temp. file to mailbox. */
  while (TRUE) {
	if (fgets(cpbuff, sizeof(cpbuff), copyfp) == (char *)NULL) break;
	fwrite(cpbuff, sizeof(char), strlen(cpbuff), boxfp);
  }
  fflush(copyfp); fflush(boxfp);
  fclose(boxfp); fclose(copyfp);
  unlink(copytemp); 

  if (usedrop) unlink(lockname);
}


/*
 * Send a message to a remote user.
 * Define UMAILER if your mailer knows about the "-i datafile" option.
 */
void send_remote(name)
char *name;
{
  char cmdbuff[128];

#ifdef UMAILER		/* faster than redirecting! */
  sprintf(cmdbuff, "exec %s -i%s %s %s %s >/dev/null", RMAIL, msg_temp,
#else
  sprintf(cmdbuff, "exec %s <%s %s %s %s >/dev/null", RMAIL, msg_temp,
#endif UMAILER
	immediate ? "-n" : "", verbose ? "-v" : "", name);
  system(cmdbuff);				/* call the mailer! */
}


/*
 * Deliver a message to a user.
 * First of all, check if we can use a more intelligent mailer
 * for this job. If not, deliver it !
 */
int deliver(count, vec)
int count; char *vec[];
{
  int (*sigint)(), (*sighup)(), (*sigquit)();	/* saved signal state */
  char cpbuff[1024];			/* copy buffer */
  char lockname[PATHLEN];		/* maildrop lock */
  FILE *mailfp;				/* fp for mail */
  FILE *boxfp;				/* mailbox file */
  struct stat stb;			/* for checking drop modes, owners */
  struct passwd *pw;			/* sender and recipent */
  int errs = 0;				/* count of errors */
  int dropfd;				/* file descriptor for user's drop */
  int created = FALSE;			/* true if we created the maildrop */
  int locktries;			/* tries when box is locked */
  register int i;

  if (count > MAXRCPT) {
	fprintf(stderr, "%s: too many recipients\n", progname);
	return(-1);
  }

  strcpy(recipients, "");
  if (sayall) {
	for (i=0; i<count; i++) {
		strcat(recipients, vec[i]);
		/* RFC-822: separate with comma */
		strcat(recipients, ",");
  	}
  	recipients[strlen(recipients)-1] = '\0';  /* kill last comma */
  } else strcat(recipients, vec[0]);     

  mailfp = edit_mail();	/* input the message */

  /* Shut off signals during the delivery. */
  sigint = signal(SIGINT, SIG_IGN);
  sighup = signal(SIGHUP, SIG_IGN);
  sigquit = signal(SIGQUIT, SIG_IGN);

  /*
   * We have the message, now deliver it to all recipients!
   * Do this on a per-user basis!
   */
  for (i = 0; i < count; ++i) {
	if (count > 1) rewind(mailfp);		/* rewind data-file */
	strcpy(addressee, vec[i]); 		/* get name of addressee */
	forward[0] = '\0';			/* Clear 'Forward' flag */

      	/* OK, 'addressee' is the recipient. Check if local. */
      	if (strchr(addressee, '!') || strchr(addressee, '@')) {
		remote = TRUE;			/* the guy is remote... */
        	send_remote(addressee);		/* call RMAIL for this... */
		continue;
       	}

	/* Hmm, it is a local user. Do we know him? */
      	if ((pw = getpwnam(addressee)) == (struct passwd *)NULL) {
		fprintf(stderr, "%s: user %s unknown\n", progname, addressee);
		++errs;
		continue;
       	} else {
	   	sprintf(mailbox, DROPNAME, addressee);
 	       	sprintf(lockname, LOCKNAME, addressee);
	}

	/* OK, we know him. Check if we have to forward his mail. */
      	if (chk_box() == 1) {		/* forward messages to 'forward' */
		strcpy(addressee, forward);

        	/* We now have the final addressee.
		 * Check for remote users again.
		 */
		if (strchr(addressee, '!') || strchr(addressee, '@')) {
			remote = TRUE;
           		send_remote(addressee);		/* No, call RMAIL */
  	  		continue;
         	} else {	/* Check if this guy is known. */
		       	if ((pw = getpwnam(addressee)) ==
						(struct passwd *)NULL) {
		   		fprintf(stderr,
					"%s: forward-user %s unknown\n",
							progname, addressee);
		   		++errs;
		   		continue;
	          	} else {
		         	sprintf(mailbox, DROPNAME, addressee);
	 	          	sprintf(lockname, LOCKNAME, addressee);
		        }
		}
	}

      	/*
       	 * We now have a local user 'addressee' who exists.
         * Lock the maildrop while we're messing with it. Races are possible
         * (though not very likely) when we have to create the maildrop, but
         * not otherwise. If the box is already locked, wait awhile and try
         * again.
         */
      	locktries = 0;
	created = 0;
trylock:
      	if (link(mailbox, lockname) != 0) {
		if (errno == ENOENT) {	/* user doesn't have a drop yet */
			if ((dropfd = creat(mailbox, 0600)) < 0) {
				fprintf(stderr,
				 "%s: could not create maildrop for %s\n",
		      					  progname, vec[i]);
				++errs;
				continue;
          		}
	  		++created;
	  		goto trylock;
         	} else {   /* somebody else has it locked, it seems - wait */
	  	 	if (++locktries >= LOCKTRIES) {	
				fprintf(stderr,
				  "%s: could not lock maildrop for %s\n",
		      					progname, vec[i]);
				++errs;
	      	   		continue;
	     	  	}
	   	 	sleep(LOCKWAIT);
	   	 	goto trylock;
	  	}
	}

      	if (created) {
        	chown(mailbox, pw->pw_uid, pw->pw_gid);
        	boxfp = fdopen(dropfd, "a");
       	} else boxfp = fopen(mailbox, "a");

      	if (boxfp==(FILE *)NULL || stat(mailbox, &stb) < 0) {
		fprintf(stderr, "%s: serious maildrop problems for %s\n",
							progname, vec[i]);
        	unlink(lockname);
        	++errs;
        	continue;
       	}

      	if (stb.st_uid != pw->pw_uid || (stb.st_mode & S_IFMT) != S_IFREG) {
		fprintf(stderr, "%s: mailbox for user %s is illegal\n",
							progname, vec[i]);
		unlink(lockname);
		++errs;
		continue;
       	}

	/* Copy temp. file to mailbox. */
	while (TRUE) {
		if (fgets(cpbuff, sizeof(cpbuff), mailfp) == (char *)NULL)
								      break;
		fwrite(cpbuff, sizeof(char), strlen(cpbuff), boxfp);
	}

	/* To make sure! */
	fputc('\n', boxfp);
      	if (ferror(boxfp) || fclose(boxfp) != 0) {
		fprintf(stderr, "%s: error delivering to user %s",
							progname, vec[i]);
		perror("");
		++errs;
       	}

      	unlink(lockname);
  }

  fclose(mailfp);

  /* Put signals back the way they were. */
  signal(SIGINT, sigint);
  signal(SIGHUP, sighup);
  signal(SIGQUIT, sigquit);

  return((errs == 0) ? 0 : -1);
}


/* 
 * Save the current message to file 'dead.letter'.
 *
 * If the environmental variable "DEADLETTER" is defined,
 * use its value as the file name. Otherwise, use DEADLETTER
 * in the current directory. Check if we may write to that file!
 */
void dead_letter()
{
  char cpbuff[1024];
  char fname[PATHLEN];
  register FILE *inf, *outf;
  char *sp;

  fname[0] = '\0';
  inf = fopen(msg_temp, "r");
  if ((sp = getenv("DEADLETTER")) != (char *)NULL) strcpy(fname, sp);
    else strcpy(fname, DEADLETTER);

  /* Open the message file. */
  if ((inf = fopen(msg_temp, "r")) == (FILE *)NULL) {
	fprintf(stderr, "%s: cannot open \"%s\"\n", progname, msg_temp);
	return;
  }

  /* Check if we may create/write that file. */
  if (allowed(fname, 02) == FALSE) {
	/* We may not. Say so! */
	fprintf(stderr, "%s: cannot create \"%s\"\n", progname, fname);
	fclose(inf);
	return;
  }

  /* We may create the dump-file. */
  if ((outf = fopen(fname, "w")) == (FILE *)NULL) {
	fprintf(stderr, "%s: cannot create \"%s\"\n", progname, fname);
	fclose(inf);
	return;
  }

  /* Copy temp. file to dead.letter. */
  while (TRUE) {
	if (fgets(cpbuff, sizeof(cpbuff), inf) == (char *)NULL) break;
	fwrite(cpbuff, sizeof(char), strlen(cpbuff), outf);
  }

  fclose(inf);
  fclose(outf);

  fprintf(stderr, "%s: dumped message on file \"%s\"\n", progname, fname);
}
