/* FIRST THINGS FIRST - Locations - far_future.t
/*  Copyright (c) 1996, 1997, 1999, 2000, 2001, 2002, and 2006 
* 	by J. Robinson Wheeler. All Rights Reserved. */

/*
 *					********				 *********
 *					********	THE GAME CODE	 *********
 *					********				 *********
 */

/**************************************************************************
 *					The rooms of the FAR FUTURE.			  *
 **************************************************************************/

FFclearing: room
	sdesc = "Parking lot"
	ldesc = "You are standing in the middle of a gigantic parking lot which extends as 
			far as you can see in most directions. An ugly, hot wind whips past you, 
			scorching across the miles of black pavement, drawing at you like a vacuum, 
			pulling you toward one of the ugliest skyscrapers you have ever seen.\b
			
			A monolith of black glass and steel, it rises fully 80 stories, 
			at least. "
			
	xdesc = "The fearsome structure is a short walk to the northeast, right where 
			your house used to be. "
			
	listenDesc = 'You hear the dessicating blasts of hot winds across
				black-topped pavement. '
			
	ne = monolith
	noexit =
	{
		"The heat and wind drive you back. ";
	}

	returnVisit = 0
	ffDaemonCounter = 0
	enterRoom( actor ) =
	{
		self.returnVisit++;
		if ( self.returnVisit = 2 )
		{
			notify( self, &ffDaemon, 0 );
		}
		pass enterRoom;
	}
	ffDaemon = 
	{
		if ( not Me.isIn( self ) ) return;
		
		self.ffDaemonCounter++;
		"\b";
		
		switch( self.ffDaemonCounter )
		{
			case 0: "[BUG] "; break;
			case 1: "You hear a sharp noise that dies quickly away. "; break;
			case 2: "You see something moving in the shimmering air. "; break;
			case 3: "Something is moving quickly toward you from the
						northeast. "; break;
			case 4: "Black shapes are surrounding you on all sides. "; break;
			case 5: "Everything seems to fade into the haze... ";
					unnotify( self, &ffDaemon ); break;
		}
	}
;

FFdummyClearingItem: locationDesc
	sdesc = "parking lot"
	adjective = 'parking' 'lot'
	location = FFclearing
;

skyscraper: block
	sdesc = "skyscraper"
	ldesc = "A monolith of black glass and steel, it rises fully 70 stories
			and seems by design to trample and crush the human spirit. "
	noun = 'monolith' 'skyscraper' 'building' 'steel' 'glass' 'building'
	location = FFclearing
	askArchitect = 0
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I don't know anything about that, but it sounds
				freaky as all get-out.\" ";
				return( true );
			case Laura:
				"Laura says, \"The Lothario Corp always builds big skyscrapers
				like that. I think they're kind of cool looking, actually. There's
				something majestic and, well, sexy about all that black glass and
				steel.\" ";
				return( true );
			case Architect:
				if ( not self.askedArchitectAbout )
					"He says, \"Never talk about that building to me again!\" ";
				else
				{
					"He says, \"I told you, never mention that building to me
					again! It goes against everything I -- oh, never mind. Just,
					just -- don't. Please.\" ";
					self.askedArchitectAbout := true;
				}
				return( true );
			default: 
				return( nil );
		}
	}
;

monolith: room
	sdesc = "Beneath the skyscraper"
	ldesc = "The skyscraper looms, looms, looms above you. It could be as high as 
			100 stories, but somehow the rippling heat from the blacktop is making 
			your vision distorted, and you really can't trust your eyes right now. 
			The name \"Lothario\" is displayed in striated steel letters 20 feet up 
			over the entranceway, which extends through glass doors into an expansive 
			lobby. There is not another soul in sight. "
	xdesc = "Your only means of escape is the time machine, visible through the 
			hazy heat to the southwest. You hope it isn't just a mirage. The 
			glass doors are to the west. "
	listenDesc = 'You hear the dessicating blasts of hot winds across
					black-topped pavement. '
	sw = FFclearing
	
	west = lobbyDoors
	in = lobbyDoors
	noexit =
	{
		"A blast of heat obscures your vision. You retreat, oppressed by feelings 
		of black foreboding. ";
	}
;

dummyLobby: fixedBlock
	sdesc = "lobby"
	ldesc = "A blast of heat obscures your vision. "
	noun = 'lobby'
	adjective = 'expansive'
	location = monolith 
	verDoEnter( actor ) = {}
	doEnter( actor ) = 
	{
		Me.travelTo( lobbyDoors );
	}
;

bigSkyscraper: fixedBlock
	sdesc = "skyscraper"
	ldesc = "A blast of heat obscures your vision. You see the word \"Lothario\" 
			through the shimmering air. "
	noun = 'skyscraper' 'building' 'entranceway'
			'monolith' 
	location = monolith
 	verDoSay( actor ) = 
	{
		"You hear a rumble in the distance. Something about it makes you shudder. ";
	}
;

lobbyDoors: doorway, seeThruItem
	sdesc = "lobby doors"
	ldesc = "The doors are made of burnished steel and tinted glass. "
	thrudesc = "A blast of heat obscures your vision. "
	noun = 'door'
	plural = 'doors'
	isThem = true
	adjective = 'steel' 'glass' 'entrance' 'burnished' 'tinted'
	doordest =
	{
		"The blast of dessicating heat settles into the sterile chill of air 
		conditioning as you pass through the doors... \b";
		return( lobby );
	}
	location = monolith
	otherside = interiorLobbyDoors
	noAutoOpen = nil
;

lobby: skyscraperRoom
	sdesc = "Expansive lobby"
	ldesc = 
	{
		"The floor of this oppressively architectured lobby, with proportions
		guaranteed to make the visitor feel powerless and insignificant, 
		is made of polished pink granite. Black marble walls laced with 
		stripes of brass lurch upward to a curved ceiling. An almost 
		laughable fresco has been painted in the dome, depicting Atlas
		shouldering the world as angels look on. In this rendition, Atlas
		sports a tailored, double-breasted gray suit and an advertising-age,
		beaming white smile. \b";
			
		if ( not self.longDescriptionPrintedOnce )
		{
			"You are aware of the presence of security cameras, at least four
			that you notice right away, pointed in your direction. A massive
			security desk built of granite, with an arcing black marble 
			countertop, is situated in the middle of the lobby. An array of 
			black and white monitors are visible behind it. \b";
			
			securityDesk.moveInto( self );
			self.longDescriptionPrintedOnce := true;
		}
	}
	xdesc = "The lobby doors exit to the east. To the northeast is a long hallway,
			and to the northwest you see a set of three elevators. "
	
	ne = 
	{
		"The security guard stops you. \"You don't have any business down there,\"
		she says. ";
		
		securityGuard.botherCount++;
		return( nil );
	}
	nw = 
	{
		if ( securityGuard.stoppedPlayerAtElevatorsOnce )
		{
			"The security guard stops you. \"You don't have any business down there,\"
			she says. ";
		
			securityGuard.botherCount++;
			return( nil );
		}
		else return( lobbyElevatorRoom );
	}
	out = interiorLobbyDoors
	east = interiorLobbyDoors
	
	firstseen =
	{
		notify( securityGuard, &actorDaemon, 0 );
		notify( securityDesk, &listSelf, 1 );
	}
	
	enterRoom( actor ) =
	{
		setit( securityGuard, 2 );
		pass enterRoom;
	}
;

dummyLobbyDesc: locationDesc
	sdesc = "lobby"
	noun = 'lobby'
	location = lobby
;

lobbyDecor: unimportantItem
	sdesc = "lobby decor"
	adesc = "the lobby decor"
	ldesc = "The floor is made of polished pink granite. Black marble walls laced with 
			stripes of brass lurch upward to a curved ceiling. "
	noun = 'decor' 'decoration'
	adjective = 'polished' 'pink' 'granite' 'black' 'marble' 'walls' 'wall' 'laced'
				'stripe' 'stripes' 'brass' 'curved' 
	location = lobby
;

fresco: fixedBlock
	sdesc = "<<self.laughedAtOnce ? "fresco" : "almost laughable fresco">>"
	adesc = { self.thedesc; }
	ldesc = "\^<<self.thedesc>> has been painted in the ceiling dome. It depicts Atlas
			shouldering the world as angels look on. In this rendition, Atlas
			sports a tailored, double-breasted gray suit and an advertising-age,
			beaming white smile. "
	noun = 'fresco'
	adjective = 'painting' 'ceiling' 'curved' 'laughable' 'almost' 'atlas'
			'angel' 'angels' 'world' 'tailored' 'double' 'double-breasted'
			'breasted' 'breast' 'gray' 'suit' 'pants' 'jacket' 'tie' 'shirt'
			'collar' 'advertising' 'age' 'ad' 'advertising-age' 'beaming'
			'white' 'smile' 'plaster'
	location = lobby
	
	verDoTake( actor ) = 
	{
		"It's an indelible painting in the plaster surface of the ceiling.
		You cannot take it. ";
	}
	verDoLaughAt( actor ) = 
	{
		if ( self.laughedAtOnce )
			"The humor seems to have gone out of it, for the moment. ";
	}
	doLaughAt( actor ) =
	{
		"You laugh out loud at the fresco. From the corner of your eye, you 
		think you see the security guard smile. When you make eye contact, 
		though, it appears that she is regarding you with humorless severity. ";
		
		self.laughedAtOnce := true;
	}
;

securityDesk: staticItem, surface
	isListed = nil
	sdesc = "security desk"
	ldesc = 
	{
		"The desk is built of granite with an arcing black marble 
		countertop. An array of black and white monitors are visible 
		behind it. ";
		
		pass ldesc;
	}
	noun = 'desk'
	adjective = 'massive' 'security' 'countertop' 'counter' 'top'
	location = nil
	verDoLookbehind( actor ) = {}
	doLookbehind( actor ) = 
	{
		"Behind the security desk you see the security guard and
		an array of black and white monitors. ";
	}
	listSelf =
	{
		self.isListed := true;
	}
;

arrayOfMonitors: unimportantItem
	sdesc = "array of monitors"
	adesc = "an <<self.sdesc>>"
	ldesc = 
	{
		"On the monitors you see various places in the building, with
		interchangeable people in dark suits going to and fro. ";
		
		setit( securityGuard, 2 );
		
		if ( not self.spottedLauraOnce )
		{
			if ( FFLaura.isSeen )
			{
				"As you turn your head, a familiar face catches your
				eye. It's Laura, exiting one of the elevators. You 
				scan around, trying to see where she goes, but you
				can't find her again. ";
				
				setit( FFLaura, 2 );
			}
			else
			{
				"As you turn your head, a face catches your eye. It's
				an older woman, dressed in a dark suit like everyone
				else. Something about her seemed very familiar, but 
				she exits the view of the elevator camera before you
				can place her. You scan around, trying to see where
				she goes, but you can't find her again. ";
				
				setit( self, 2 );
			}
			self.spottedLauraOnce := true;
		}
	}
	noun = 'monitor'
	plural = 'monitors'
	isThem = true
	adjective = 'array' 'array of' 'b&w' 'bw'
	location = lobby
;

dummyLobbyElevators: unimportantItem
	sdesc = "elevators"
	adesc = "the elevators"
	unimportantMsg = "The elevators are to the northwest. You'll have to
		walk over to them before you can do that. "
	noun = 'elevator' 'lift'
	plural = 'elevators' 'lifts' 'trio'
	isThem = true
	location = lobby
;

lobbyHallway: distantItem
	herring = true
	sdesc = "long hallway"
	ldesc = "The long hallway is too far away from here to examine. "
	noun = 'hall' 'hallway'
	adjective = 'long'
	location = lobby
;

interiorLobbyDoors: doorway, seeThruItem
	sdesc = "lobby doors"
	ldesc = "The doors are made of burnished steel and tinted glass. "
	thrudesc = "Through the doors you see a red sky and black asphalt. "
	noun = 'door'
	plural = 'doors' 'burnished' 'steel' 'tinted' 'glass'
	isThem = true
	adjective = 'lobby'
	doordest =
	{
		"The sterile chill of conditioned air gives way to the punishing
		blast of dessicating heat as you pass through the doors... \b";
		return( monolith );
	}
	location = lobby
	otherside = lobbyDoors
	noAutoOpen = nil
;

securityGuard: NPC
	isHer = true
	sdesc = "security guard"
	thedesc = "the security guard"
	adesc = "the security guard"
	ldesc = "She is a tall, powerful-looking woman in her late thirties. Her
			orange hair has been yanked straight back into a tight bun,
			stretching her already tense face into a taut mask of ill
			humor. She wears a uniform, a badge, a stun gun, a pistol,
			and an air of unassailable authority. "
	actorDesc = "There is a security guard here, sitting behind the desk. "
	noun = 'guard'
	adjective = 'security' 'herself'
	location = lobby
	
	knowWhereIsList = [ Laura PLaura FLaura FFLaura ]
	sayWhereIs( it ) =
	{
		"\^<<self.thedesc>> says, \"";
		switch( it )
		{
			case Laura:
			case PLaura:
			case FLaura:
			case FFLaura:
 				"I'm not authorized to give out any information.";
				break;
		}
		"\" ";
	}
	
	sayHello = 
	{
		if ( self.respectsPlayer )
			"\^<<self.thedesc>> smiles at you and says, \"Good afternoon.\" ";
		else
			"\^<<self.thedesc>> grimaces and deigns only to nod at you. ";
	}
	respectsPlayer = nil
	botherCount = 0
	botherMax = 20
	playerThrownOutCount = 0
	
	talkAboutMyself = 
	{
		"\^<<self.thedesc>> says, \"I'm not authorized to tell you anything 
		about myself.\" ";
	}
	
	disavow( it ) =
	{
		"\^<<self.thedesc>> says, \"I'm not authorized to tell you anything 
		about <<it.thatdesc>>.\" ";
		
		self.botherCount++;
	}
	
	verDoBribe( actor ) = {}
	doBribe( actor ) = { self.arrestPlayer; }
	verDoBribeWith( actor ) = {}
	doBribeWith( actor ) = { self.arrestPlayer; }
	 
	doTellAbout( actor, iobj ) =
	{
		self.wasTalkedTo := true;
		
		if ( not self.respectsPlayer )
		{
			"\^<<self.thedesc>> says, \"I have no interest in hearing 
			anything about <<iobj.thatdesc>>.\" ";
		
			self.botherCount++;
			return;
		}
		
		if ( not consultWords( iobj, self, 0 ) )	 // if it returns nil
			self.disavow( iobj );
	}
	
	doAskAbout( actor, iobj ) =
	{
		if ( not self.respectsPlayer )
		{
			self.disavow( iobj );
			return;
		}
		
		if ( not consultWords( iobj, self, 0 ) )	 // if it returns nil
			self.disavow( iobj );
		
		self.wasTalkedTo := true;
	}
	
	actorDaemon = 
	{	
		if ( self.respectsPlayer ) return;
		
		if ( self.botherCount = self.botherMax )
			self.throwPlayerOut;
	}
	throwPlayerOut =
	{
		"She stands up and comes around to face you eye to eye.\b
		
		\"You have tried my patience. Since you seem to have no business 
		being here, I'm going to have to ask you to leave.\" \b
		Rather than asking, she escorts you to the doors and puts 
		you outside. ";
		
		self.botherCount := 0;
		self.playerThrownOutCount++;
		
		switch( self.playerThrownOutCount )
		{
			case 1: self.botherMax := 12; break;
			case 2: self.botherMax := 6; break;
			case 3: self.botherMax := 3; break;
			default: self.botherMax := 1; break;
//			case 5: self.arrestPlayer; return;
		}
		
		Me.travelTo( monolith );
	}
	
	arrestPlayer =
	{
		"I don't think getting yourself arrested would be a helpful act. ";
	}
	
	stopPlayerAtElevator = 
	{
		local response;
		
		"\bThe security guard comes walking slowly towards you. \"You there,\"
		she says. \"Who are you going to see?\" \b>";
		
		response := inputline();
		
		if ( response = 'laura' || response = 'remick' || 
			response = 'laura remick' || response = 'laura remick-larson' 
			|| response = 'carl' || response = 'victor' )
		{
			"\"Oh?\"\ she asks. \"One moment.\" She goes back to her desk
			and places a quick call. When she returns, she regards you even
			more grimly than before. \b
			
			\"You don't have an appointment, and as far as anyone can tell,
			you have no legitimate business here. ";
			
			if ( response = 'laura' )
				FFLaura.playerTriedToVisit := true;
		}
		else if ( response = 'lothario' || response = 'you' )
		{
			"She regards you even more grimly than before. \"I think you've 
			proven to me that you have no legitimate business here,\" she says. \"";
		}
		else if ( response = 'se' || response = 'southeast' )
		{
			"You turn and walk away.\b
			
			\"Hey!\" the guard says, following you. \"Don't turn your
			back on me when I ask you a question.\"\b";
			
			response := execCommand( Me, seVerb );
			
			"\bThe guard sits back at her desk and types a few keystrokes 
			on her computer, her eyes on you the whole time. ";
			
			self.throwPlayerOut;
		}
		else
		{
			"She says, \"I'm not sure who that is, but you've proven to me
			that you have no legitimate business here. ";
		}
		
		"I'm going to have to ask you to leave this area.\" She escorts you 
		back to the lobby and eyes you warily from behind her desk, as if at
		any moment she expected you to start waving sticks of dynamite and
		making wild demands. ";
		
		Me.travelTo( lobby );
	}
;

guardUniform: item
	sdesc = "uniform"
	ldesc = "The security guard's uniform black and gray. "
	noun = 'uniform'
	location = securityGuard
	verDoTake( actor ) =
	{
		"The security guard is wearing the uniform. ";
	}
;

guardBadge: item
	sdesc = "badge"
	ldesc = "The security guard's badge is made of yellow metal. "
	noun = 'badge'
	location = securityGuard
	verDoTake( actor ) =
	{
		"The security guard is wearing the badge and won't let you
		anywhere near it. ";
	}
;

stunGun: item
	sdesc = "stun gun"
	ldesc = "It's a sleek metal instrument capable of disabling a subject
			instantly. "
	noun = 'zapper'
	adjective = 'stun' 'gun'
	location = securityGuard
	verDoTake( actor ) =
	{
		"The security guard is wearing the stun gun and will probably
		use it on you if you try to take it. ";
	}
;

pistol: item
	sdesc = "pistol"
	ldesc = "You can't really tell what kind of pistol it is, but it's no
			doubt in capable hands. "
	noun = 'pistol' 'gun'
	location = securityGuard
	verDoTake( actor ) =
	{
		"The security guard is wearing the pistol and will probably
		use it or the stun gun on you if you try to take it. ";
	}
;

airOfAuthority: item
	sdesc = "air of authority"
	ldesc = "It is unequivocally intimidating. "
	noun = 'authority'
	adjective = 'air' 'air of'
	location = securityGuard
	verDoTake( actor ) =
	{
		"The air of authority is inseparable from the security guard 
		as long as she is in uniform and on duty. ";
	}
;

airConditioningUnits: unimportantItem, floatingItem
	sdesc = "air conditioning"
	noun = 'unit'
	plural = 'units'
	adjective = 'powerful' 'roar' 'air' 'conditioning'
	location = 
	{
		if ( Me.location.inSkyscraper )
			return( true );
		return( nil );
	}
;

lobbyElevatorRoom: elevatorRoom
	sdesc = "Lobby elevators"
	ldesc = "This short hallway is painted a deep shade of crimson. A large
			building directory is bolted to the wall. A leafy plant sits
			in the corner, attempting to breathe some semblance of real 
			life into the sterile atmosphere. There are three closed 
			elevator doors here, and up and down call buttons. "
	xdesc = "The lobby is back to the southeast. "
	se = lobby
;

leafyPlant: unimportantItem
	sdesc = "leafy plant"
	ldesc = "Alas, it is only a semblance of real life, as the plant turns
		out to be artificial on closer inspection. "
	noun = 'plant'
	adjective = 'leafy' 'artificial' 
	location = lobbyElevatorRoom
;

directoryDisplay: bookItem, fixedBlock
	sdesc = "directory"
	ldesc = "The directory lists well over fifty companies, each occupying
			a different floor. None of them mean anything to you. The 
			Lothario Corporation's main offices are on the top floor,
			level 70. "
	readdesc = { self.ldesc; }
	noun = 'directory'
	adjective = 'large' 'building' 'direcotry' 'direcotyr' 'listing' 'listings'
	location = lobbyElevatorRoom
	
	validTopicList = [ Laura PLaura FLaura FFLaura ]
	doConsultAbout( actor, iobj ) =
	{
		switch( iobj )
		{
			case PLaura:
				"You scan the directory for her name, specifically
				looking for a Laura Remick. There is a listing 
				for an L.\ Remick-Larson, the executive vice 
				president of the Lothario Corporation, level 70. ";
				break;
			case Laura:
			case FLaura:
				"You scan the directory for her name, but no one is
				listed by their first names on the directory. ";
				break;
			case FFLaura:
				"L.\ Remick-Larson is listed as the executive vice
				president of the Lothario Corporation, level 70. ";
			default:
				"\^<<self.thedesc>> contains no information about 
				that subject. ";
				break;
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case securityGuard:
				"She says, \"I'm not authorized to tell you about 
				any of the building's offices or personnel.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

lobbyElevators: fixedBlock
	sdesc = "elevators"
	ldesc = "The elevators are all on various high-level floors. Some are static
			and some are moving in halting steps. "
	noun = 'elevator'
	plural = 'elevators' 'doors'
	isThem = true
	adjective = 'lift' 'lifts' 'door' 'moving' 'static'
	location = lobbyElevatorRoom
	
	verDoCall( actor ) = {}
	doCall( actor ) = { lobbyElevatorUpButton.doPush( actor ); }
	
	verDoBoard( actor ) = { self.verDoEnter( actor ); }
	verDoOpen( actor ) = { self.verDoEnter( actor ); }
	verDoClose( actor ) = 
	{
		"The elevator doors are already closed. ";
	}	
	verDoEnter( actor ) = 
	{
		"None of the elevators are here yet. ";
	}
	
	verDoWaitFor( actor ) = {}
	doWaitFor( actor ) =
	{
		if ( self.displayedOnce )
			"Time passes... ";
		else
		{
			"You wait for the elevators. It doesn't seem like they're
			ever going to show up. ";
			
			self.displayedOnce := true;
		}
	}
;

lobbyElevatorUpButton: fixedBlock, buttonitem
	sdesc = "up button"
	noun = 'button'
	adjective = 'up' 'u' 'call'
	plural = 'buttons'
	location = lobbyElevatorRoom
	
	doPush( actor ) = 
	{
		"You push the up button. You assume one of them will respond to 
		your call, but nothing immediately changes. ";
		
		securityGuard.stopPlayerAtElevator;
	}
;

lobbyElevatorDownButton: fixedBlock, buttonitem
	sdesc = "down button"
	noun = 'button'
	adjective = 'down' 'd' 'call'
	plural = 'buttons'
	location = lobbyElevatorRoom
	
	doPush( actor ) = 
	{
		"You push the down button. You assume one of them will respond to 
		your call, but nothing immediately changes. ";
		
		securityGuard.stopPlayerAtElevator;
	}
;

storageRoom: subBasementRoom
	inSubBasement = nil
	sdesc = "Storage room"
	ldesc = "This room is barely big enough to hold the time machine. It is 
			full of filing cabinets, old computer equipment, stacks of old
			ledgers and printouts, and other discards. Fluorescent lighting
			fixtures flicker overhead. The air is conditioned and cold, 
			almost antiseptic smelling. "
	xdesc = "A door leads east. "
	out = interiorStorageRoomDoor
	east = interiorStorageRoomDoor
	
	firstseen = 
	{
		setit( interiorStorageRoomDoor ); 
	}
;

storageRoomDiscards: unimportantItem
	sdesc = "discards"
	adesc = { self.thedesc; }
	noun = 'discard'
	plural = 'discards'
	isThem = true
	location = storageRoom
;

storageRoomFilingCabinets: fixedBlock, lockable
	sdesc = "filing cabinets"
	noun = 'cabinet'
	plural = 'cabinets'
	isThem = true
	adjective = 'filing' 'files' 'file'
	islocked = true
	location = storageRoom
;

oldComputerEquipment: unimportantItem
	sdesc = "old computer equipment"
	ldesc = "The only thing of note about the old computer equipment is that,
			upon inspection, you see that it actually dates from what you
			consider to be the present. Wherever you are now, it's considered
			obsolete junk. "
	noun = 'equipment'
	adjective = 'old' 'computer' 'obsolete' 'junk'
	location = storageRoom
;

ledgersAndPrintouts: unimportantItem
	sdesc = "stacks of ledgers and printouts"
	noun = 'printout'
	plural = 'printouts'
	isThem = true
	adjective = 'stack' 'stacks' 'stacks of' 'ledger' 'ledgers' 'old'
	location = storageRoom
;

interiorStorageRoomDoor: lockableDoorway
	sdesc = "door"
	ldesc = "I see nothing special about the door. "
	noun = 'door'
	doordest = subBasementHall
	otherside = exteriorStorageRoomDoor
	location = storageRoom
	isopen = nil
	islocked = true
	
	doUnlock( actor ) = 
	{
		if ( Fred.blockedYouOnce ) 
		{
			"Fred blocks you. ";
		}
		else pass doUnlock;
	}
	
	destination = 
	{
		if ( FFLaura.finished )
		{
			"Your business upstairs is concluded, and it's likely that
			Carl will not take kindly to your showing up again. ";
			return( nil );
		}
		else if ( Fred.deepIsIn( storageRoom ) )
		{
			if ( Fred.blockedYouOnce ) 
			{
				"Fred blocks the doorway. ";
				return( nil );
			}
			else
			{
				Fred.blockedYouOnce := true;
				self.isopen := nil;
				self.islocked := true;
				"Fred shuts the door again and locks it.\b
				Fred says, \"This place gives me the creeps. Let's
				get out of here. Spin your little doohickies and press
				the big doodad and let's go.\" \b
				You hear heavy footsteps pass by in the hall outside.\b
				Fred looks slightly freaked out. \"I'm telling you, let's 
				get out of here,\" he whispers sternly. ";
				return( nil );
			}
		}
		else pass destination;
	}
;

subBasementHall: subBasementRoom
	sdesc = "Sub-basement hallway"
	ldesc = "You find yourself in a long hallway stretching north and south.
			Faceless, identical doors line both sides. The floor and ceiling
			are white, but the walls are a muted blue. "
	xdesc = "To the north the hallway hits a T-intersection, and to the south 
			you see the hallway turn a corner to the east. Immediately to
			the west is the storage room door. "
	
	north = subBasementT_Intersection
	south = subBasementCorner
	west = exteriorStorageRoomDoor
	in = exteriorStorageRoomDoor
	
	listenDesc = 
	{
		suspiciousSuits.listenDescPrinted := true;
		return( suspiciousSuits.listenDesc );
	}
	
	firstseen =
	{
		"\bAround the corner to the south, you hear a tiny ringing noise. It
		sounds like an elevator has just arrived. ";
//		notify( suspiciousSuits, &actorDaemon, 0 );
	}
;

exteriorStorageRoomDoor: doorway
	sdesc = "storage room door"
	ldesc = "I see nothing special about <<self.thedesc>>. "
	noun = 'door'
	adjective = 'storage' 'room'
	doordest = storageRoom
	otherside = interiorStorageRoomDoor
	location = subBasementHall
	isopen = nil
	islocked = true
;

facelessDoors: fixedBlock, lockableDoorway, floatingItem
	sdesc = "faceless doors"
	ldesc = "I see nothing special about <<self.thedesc>>. "
	noun = 'door'
	plural = 'doors'
	isThem = true
	adjective = 'faceless'
	location = 
	{
		if ( Me.location.inSubBasement )
			return( Me.location );
		return( nil );
	}
	isopen = nil
	islocked = true
;

suspiciousSuits: NPC
	listenDesc = 'You hear footsteps vanish off into the distance. '
	daemonCount = 0
	actorDaemon = 
	{
		self.daemonCount++;
		switch( self.daemonCount )
		{
			case 1: break;
			case 2: 
				if ( not self.listenDescPrinted )
				{
					"\b"; say( self.listenDesc );
				}
				unnotify( self, &actorDaemon );
				restoreListenDesc( Me.location );
				break;
		}
	}
;

subBasementT_Intersection: subBasementRoom
	sdesc = "T-intersection"
	ldesc = "The halls intersect here, with the north-going hall meeting a 
			seeming-endless east-west hall. They stretch as far as you
			can see, splitting off into other intersections, and with 
			more faceless doors spaced evenly along the way. "
	xdesc = "The hallway returns south. The hallways heading east
			and west from here are endless and are not worth exploring. "
	south = subBasementHall
	west = "It isn't important to explore these endless hallways. " 
	east = "It isn't important to explore these endless hallways. " 
;

subBasementCorner: subBasementRoom
	sdesc = "Corner"
	ldesc = "The hallway turns a corner here, from north to east. "
	xdesc = "Just ahead to the east, the hallway dead-ends at a trio of elevators. "
	north = subBasementHall
	east = subBasementElevatorRoom
;

dummySubBasementElevators: distantItem
	sdesc = "elevators"
	adesc = "the elevators"
	ldesc = "I see nothing special about <<self.thedesc>>. "
	noun = 'elevator' 'lift'
	plural = 'elevators' 'lifts' 'trio'
	isThem = true
	location = subBasementCorner
;

subBasementElevatorRoom: elevatorRoom
	sdesc = "Elevator room"
	ldesc = "The hallway dead-ends here, but this is probably as far as you
			need to go. The elevators for this floor are here. One of them
			has recently arrived. "
	xdesc = "The only way back is to the west. "
	in = inTheElevator
	west = subBasementCorner
;

subBasementElevators: fixedBlock
	sdesc = "elevators"
	ldesc = "Two of the elevators are moving in halting steps between high-level 
			floors. One of them has recently arrived here. "
	noun = 'elevator'
	plural = 'elevators'
	isThem = true
	adjective = 'lift' 'lifts' 'door' 'doors' 'arrived'
	location = subBasementElevatorRoom
	
	verDoBoard( actor ) = {}
	doBoard( actor ) = { self.doEnter( actor ); }
	
	verDoEnter( actor ) = {}
	doEnter( actor ) = { Me.travelTo( inTheElevator ); }
	
	verDoOpen( actor ) = 
	{
		"The elevator is already here. ";
	}
	
	verDoClose( actor ) =
	{
		"You'll have to enter the elevator first. ";
	}
	
	verDoWaitFor( actor ) = 
	{
		"The elevator is already here. ";
	}
;

subBasementElevatorUpButton: fixedBlock, buttonitem
	sdesc = "up button"
	noun = 'button'
	adjective = 'up' 'u' 'call'
	location = subBasementElevatorRoom
	
	doPush( actor ) = 
	{
		"You push the up button. One of the elevators immediately opens, and
		you enter. ";
		
		Me.travelTo( inTheElevator );
	}
;

inTheElevator: room
	sdesc = "In the elevator"
	ldesc = "You are in a spacious, gleaming little elevator car. A brass panel
			near the doors contains a large array of possible destinations. "
	xdesc = "The only exit is out. "
	outLoc = subBasementElevatorRoom
	out = { return( self.outLoc ); }
;

elevatorButtonPanel: fixedBlock
	sdesc = "panel"
	ldesc = "The panel has a set of numbered buttons that go from 2 to 70, as 
			well as buttons labeled SB, B, and L. "
	noun = 'panel'
	adjective = 'brass'
	location = inTheElevator
;

numberedButtons: elevatorButtonItem, numberedObject
	sdesc = "numbered buttons"
	ldesc = "The numbered buttons go from 2 to 70. "
	adesc = { self.thedesc; }
	thedesc = "one of the numbered buttons"
	location = inTheElevator
	destination = nabbedByGuards
	destinationDesc = { "floor "; say( self.value ); }
	num_is_valid( num ) = 
	{
		if ( num > 1 && num < 71 )
			return( true );
		else 
		{
			"The numbered buttons only go from 2 to 70. ";
			return( nil );
		}
	}
	doPush( actor ) = 
	{
		if ( self.value = 70 )
			self.destination := floor70ElevatorRoom;
		
		if ( self.value < 2 || self.value > 70 )
		{
			"The numbered buttons only go from 2 to 70. ";
			return( nil );
		}

		"You push the button for <<self.destinationDesc>>. The elevator 
		begins to move. After a smooth ride, it arrives at <<self.destinationDesc>>. ";
		inTheElevator.outLoc := self.destination;
	}
;

subBasementButton: elevatorButtonItem
	sdesc = "SB"
	ldesc = "The SB button stands for Sub-Basement. "
	adjective = 'SB' 'sub-basement' 'subbasement' 'sub'
	destination = subBasementElevatorRoom
	destinationDesc = "the sub-basement"
;

basementButton: elevatorButtonItem
	sdesc = "B"
	adesc = { "a <<self.sdesc>> button"; }
	ldesc = "The B button probably stands for Basement. "
	adjective = 'B' 'basement'
	destination = nabbedByGuards
	destinationDesc = "the basement"
;

lobbyButton: elevatorButtonItem
	sdesc = "L"
	ldesc = "The L button probably stands for Lobby. "
	adjective = 'L' 'lobby'
	destination = lobbyElevatorRoom
	destinationDesc = "the lobby"
;

nabbedByGuards: transitionRoom
	sdesc = "Nabbed by guards"
	ldesc = "The elevator doors part to reveal a set of massive security guards,
			each itching for a reason to withdraw their weapons and take you
			down violently. \b
			
			A walkie-talkie crackles to life on someone's hip. \"We have the
			suspect,\" someone responds. Hands grab you and pin your arms back. 
			\"Don't you know that trespassing is a serious offense? You could
			do jail time for this.\" A different voice leans close to your
			ear and whispers, \"These people ain't known for their lenience,
			you know? You don't want to be messing with them. Whatever they
			tell you to do, you do it, hear?\" \b
			
			You are escorted to an empty holding room on the top floor of the
			building. The door shuts, and is locked from outside. "
	
	nextLoc = holdingRoom
;

holdingRoom: skyscraperRoom
	sdesc = "Holding room"
	ldesc = "There is nothing to see here, nowhere to sit, and nothing to do. The
			walls are painted a severe midnight blue. The ceiling, twelve feet
			high, holds a row of fluorescent lights. The door, painted the
			same color as the walls, is only barely visible. There is no knob 
			or handle on this side of the door. "
	xdesc = "There are no exits from the room, as far as you can tell. "
	
	firstseen = 
	{
		if ( length( Me.contents ) > 0 )
		{
			local l, i;
			l := Me.contents;
			for ( i := 1; i <= length(l); ++i )
			{
				l[i].moveInto( FFLaurasDesk );
			}
			FFLaura.playerHadPossessions := true;
			"\bAll of your possessions have been taken from you. ";
		}
		
		notify( self, &releasePlayer, 10 );
	}
	releasePlayer =
	{
		if ( floor70ElevatorRoom.isseen )
			"\bThe door swings open. It's <<FLaura.met ? "Carl" : "the large,
			well-dressed ape">> again. ";
		else
			"\bThe door swings open. Instead of a security guard, you see a large
			gentleman, none the less imposing in stature, but one whose bulk has been
			fitted into a tailored, double-breasted wool suit instead of a security
			uniform. ";
		self.takePlayerToLaura;
	}	
	takePlayerToLaura = 
	{
		if ( FLaura.met )
			"You recognize him as Carl, one of Laura's goons from ten years
			ago. It seems more than likely that you are about to be taken to
			meet the Laura of today. ";
		
		"\b\"Come along,\" he says. \"You've been allowed five minutes with the
		Executive Vice-President. She's a busy woman, so hop to it.\" He says 
		this in a way that suggests you should consider it a privilege. \b
		
		You follow <<FLaura.met ? "Carl" : "him">> down a series of carpeted
		hallways, with the doorways you pass becoming grander and more imposing
		the farther you go. You turn a final corner and see the largest doors
		of them all, as if you had entered a land where giants walk the earth
		and work as business executives. \b
		
		<<FLaura.met ? "Carl" : "He">> stops before the penultimate door,
		this one merely eight feet high and made of solid slabs of redwood. He
		raps it with his beefy knuckles. The door buzzes and pops open. ";
		
		Me.travelTo( outsideFFLaurasOffice );
	}
;

holdingRoomDoor: fixedBlock
	sdesc = "door"
	ldesc = "The door is locked from outside, and lacks any way to open it from
			this side. "
	noun = 'door'
	location = holdingRoom
	
	verDoOpen( actor ) = { "You can't open the door. "; }
	verDoUnlock( actor ) = { "You can't unlock the door. "; }
	verDoBreak( actor ) = { "You can't harm the door. "; }
	verDoKick( actor ) = { "Kicking the door has no effect. "; }
	verDoAttack( actor ) = { "Attackng the door has no effect. "; }
	verDoAttackWith( actor, io ) = { "Attacking the door has no effect. "; }
	verDoKnock( actor ) = {}
	doKnock( actor ) = { "There is no answer. "; }
;

holdingRoomWalls: unimportantItem
	sdesc = "walls"
	noun = 'wall'
	plural = 'walls'
	isThem = true
	adjective = 'midnight' 'blue'
	location = holdingRoom
;

holdingRoomCeiling: unimportantItem
	sdesc = "ceiling"
	noun = 'ceiling'
	adjective = 'row' 'fluorescent' 'lights'
	location = holdingRoom
;

floor70ElevatorRoom: transitionRoom
	sdesc = "Floor 70 Elevators"
	ldesc = "The elevator doors part to reveal someone massive blocking your way. Your
			first instinct is to assume it is a set of muscular security guards
			but, perhaps more frighteningly, it is just one, really imposing, man. 
			His bulk has been fitted into a tailored, double-breasted wool suit
			at great expense and to the textile industry's tremendous gain. \b
			
			\"You certainly know how to attract attention,\" he says to you. \"Don't
			you know that there are security cameras everywhere? Either you're 
			dumber than you look, or you wanted to be seen.\" \b
			
			He escorts you, with no further words, to an empty holding room on 
			the top floor of the building. \"Please wait here,\" he says politely, as 
			if you had some choice in the matter. The door shuts, and is locked from 
			outside. "
	nextLoc = holdingRoom
;

outsideFFLaurasOffice: transitionRoom
	sdesc = "Outside the Executive VP's office"
	ldesc =
	{
		"This is the office-before-the office, or one of them. In your mind's
		eye you can picture the unfolding layers of hierarchy and bureaucracy,
		doors that lead to bigger doors, executive desks that are humbled by
		ever larger executive desks. This office has two such desks, sculpted
		antiques of dark-stained wood with burnished, gleaming surfaces, and
		only tiny reminders of humanity: picture frames with families, post-it
		notes with lazy scrawls and doodles. 
		
		A cherry-haired woman behind one of the desks asks, \"Is this the
		6:45?\" \b
		
		\"You bet,\" says <<FLaura.met ? "Carl" : "your keeper">>, checking
		his gleaming, platinum watch. \b
		
		\"One moment, please.\" \b
		
		<<FLaura.met ? "Carl" : "He">> folds his arms, rocks on the balls of
		his feet and, inexplicably, flashes you a wink. He regards you for 
		a moment, then extends one of his huge hands. \"Carl,\" he says. ";
		
		if ( FLaura.met && rescue.rescuer = 2 )
			"\"Remember me?\" He does a clownlike mime of you hanging for
			dear life from the tree trunk, complete with \"Aughghh!\" noises
			to indicate struggle. Carl punches you lightly in the arm. \"Just 
			messing with you,\" he says. ";
		
		morePrompt();
		
		"\bThe woman at the desk says, \"Ms.\ Remick will take the appointment 
		now.\" \b
		
		Carl says, \"Thanks, baby.\" He leads you inside. ";
	}
	nextLoc = FFLaurasOffice
;

FFLaurasOffice: skyscraperRoom
	sdesc = "Executive VP's office"
	ldesc = "This is not so much an office as it is a rippling gravity well of
			corporate power, condensed by forces beyond imagining into an
			architectural metaphor for the excesses of human vanity, lust,
			greed, and envy. As much a papal audience chamber as a prison 
			cell fashioned from the finest materials on Earth, its proportions 
			so dwarf the human being at its center as to ridicule what it 
			purports to exalt. "
	firstseen = 
	{		
		"\nLavish pillars of marble rise from a floor constructed of concentric
		rings of polished black and red granite. The ceiling vaults up into
		a dome, from which hangs a futuristic, stainless-steel fixture, some
		sort of 21st Century reimagining of a 16th Century chandelier, with
		a layered beehive shape holding three or four dozen flashbulb-bright 
		lamps. A purely decorative fireplace, framed in a bad mixture of 
		burnished bronze and black slate, gapes open in the west wall 
		like a direct doorway to Hell, a mouth that laughs at what has been
		wrought here. There are ceramic vases on golden stands, gold trim
		slicing through the walls, trailing like the threads on an integrated
		circuit chip, leading to the apotheotic throne, the chair, at the
		far end of the room. A twenty by forty foot embroidered carpet lies
		underneath it, and in front of it, a desk that felled a forest so that
		it might exist. \b
		
		The throne chair itself is made of black leather. Its back is nearly
		six feet high. Sitting in this contrivance is a tiny woman in a pearl
		white suit, diamond jewelry flashing from every finger, each earlobe,
		and her neck. Behind her, a wall of windows reveals the purple, 
		darkening sky. \b";
		
		morePrompt;
		
		"You hear the doors shut behind you. Carl has left you alone in here. ";
		
		notify( FFLaura, &pleaseSitDown, 5 );
		setit( FFLaura, 2 );
	}
	xdesc = 
	{
		if ( self.isseen )
			"The only exit is back out the doors to the south. ";
	}
	lightDesc = "The ceiling vaults up into a dome, from which hangs a futuristic, 
			stainless-steel fixture, some sort of 21st Century reimagining of 
			a 17th Century palace chandelier, with a layered beehive shape holding 
			three or four dozen flashbulb-bright lamps. A wall of windows reveals 
			the purple, darknening sky. "
	floorDesc = "Lavish pillars of marble rise from a floor constructed of coencentric
			rings of polished black and red granite. "
	out = FFLaurasOfficeDoors
	south = FFLaurasOfficeDoors
	listenDesc = 
	{	
		if ( FFLaura.speechDaemonCount > 0 )
			return( nil );
		else pass listenDesc;
	}
;

generalRoomDesc: unimportantItem
	sdesc = "office"
	ldesc = "This is not so much an office as it is a rippling gravity well of
			corporate power, condensed by forces beyond imagining into an
			architectural metaphor for the excesses of human vanity, lust,
			greed, and envy. As much a papal audience chamber as a prison 
			cell fashioned from the finest materials on Earth, its proportions 
			so dwarf the human being at its center as to ridicule what it 
			purports to exalt. "
	noun = 'office' 'rippling' 'gravity' 'well' 'corporate' 'power' 'condensed'
			'architecture' 'architectural' 'metaphor' 'excess' 'excesses' 
			'human' 'vanity' 'lust' 'greed' 'envy' 'papal' 'audience' 
			'chamber' 'prison' 'cell' 'fashioned' 'fine' 'finest' 'material'
			'materials' 'Earth' 'proportion' 'proportions' 'dwarf'
	location = FFLaurasOffice
;

forcesBeyondImagining: fixedBlock
	sdesc = "forces beyond imagining"
	ldesc = { FFLaurasOffice.ldesc; }
	noun = 'imagining'
	adjective = 'force' 'forces' 'beyond'
	location = FFLaurasOffice
	
	verDoMake( actor ) = 
	{
		"You cannot imagine forces that are beyond imagining. ";
	}
;

futuristicLightFixture: unimportantItem
	sdesc = "futuristic light fixture"
	ldesc = "From the ceiling hangs a futuristic, stainless-steel fixture, some sort 
			of 21st Century reimagining of a 17th Century palace chandelier, with 
			a layered beehive shape holding three or four dozen flashbulb-bright 
			lamps. "
	noun = 'fixture' 
	adjective = 'futuristic' 'stainless' 'steel' 'stainless-steel' 'palace' 
			'chandelier' 'layered' 'beehive' 'bee' 'hive' 'shape'
	location = FFLaurasOffice
;

flashbulbBrightLamps: unimportantItem
	sdesc = "flashbulb-bright lamps"
	ldesc = "From the ceiling hangs a futuristic, stainless-steel fixture, some sort 
			of 21st Century reimagining of a 17th Century palace chandelier, with 
			a layered beehive shape holding three or four dozen flashbulb-bright 
			lamps. "
	noun = 'lamp'
	plural = 'lamps'
	isThem = true 
	adjective = 'flashbulb' 'bright' 'flashbulb-bright' 'lamp' 'lamps'
	location = FFLaurasOffice
;

domedCeiling: unimportantItem
	sdesc = "ceiling dome"
	ldesc = "The ceiling vaults up into a dome, from which hangs a futuristic, 
			stainless-steel fixture, some sort of 21st Century reimagining of 
			a 17th Century palace chandelier, with a layered beehive shape holding 
			three or four dozen flashbulb-bright lamps. "
	noun = 'ceiling' 
	adjective = 'dome' 'vaulted' 'vault'
	location = FFLaurasOffice
;

decorativeFireplace: unimportantItem
	sdesc = "fireplace"
	ldesc = 
	{
		"A purely decorative fireplace, framed in a bad mixture of 
		burnished bronze and black slate, gapes open in the west wall 
		like a direct doorway to Hell, a mouth that laughs at what has been
		wrought here. ";
		
		if ( FFLaura.finished )
			"Laura is standing naked in front of the curling orange flames, 
			gazing deeply into them. ";
	}
	noun = 'fireplace'
	adjective = 'purely' 'decorative' 'frame' 'framed' 'bad' 'mixture' 'burnished'
			'bronze' 'metal' 'black' 'slate' 'west' 'wall' 'direct' 'doorway'
			'hell' 'mouth'
	location = FFLaurasOffice
;

orangeFlames: unimportantItem
	sdesc = "fireplace"
	ldesc = "Laura is standing naked in front of the curling orange flames, 
			gazing deeply into them. "
	noun = 'flames'
	adjective = 'fire' 'flame' 'curling' 'orange'
	location = nil
;

ceramicVases: unimportantItem
	sdesc = "ceramic vases"
	noun = 'vase'
	plural = 'vases'
	isThem = true
	adjective = 'ceramic' 'stands' 'golden'
	location = FFLaurasOffice
;

goldTrim: unimportantItem
	sdesc = "gold trim"
	noun = 'trim'
	adjective = 'gold' 'wall' 'walls'
	location = FFLaurasOffice
;

lavishPillars: unimportantItem
	sdesc = "lavish pillars"
	ldesc = "Lavish pillars of marble rise from a floor constructed of coencentric
			rings of polished black and red granite. "
	noun = 'pillar'
	plural = 'pillars'
	isThem = true
	adjective = 'lavish' 'marble' 'coencentric' 'rings' 'polished' 'granite' 'red' 'ring'
	location = FFLaurasOffice
;			

embroideredCarpet: unimportantItem
	sdesc = "embroidered carpet"
	noun = 'carpet'
	adjective = 'twenty' 'by' 'forty' 'foot' 'embroidered' 'rug'
	location = FFLaurasOffice
;

throneChair: fixedBlock
	sdesc = "throne chair"
	ldesc = "The throne chair itself is made of black leather. Its back is nearly
			six feet high. "
	noun = 'throne'
	adjective = 'chair' 'leather' 'high' 'backed' 'high-backed' 'black' 'back'
	location = FFLaurasOffice
	verDoSiton( actor ) = { "Inconceivable. "; }
;

FFLaurasDesk: fixedBlock, surface
	sdesc = "imposing desk"
	ldesc = 
	{
		"It is a desk so massive and imposing that it must have felled a forest 
		so that it might exist. A placard on it says: 'Laura Angela Remick, 
		Executive Vice-President'. ";
		
		if ( itemcnt( self.contents ) )
		{
			"On "; self.thedesc; " %you% see%s% "; listcont( self ); ". ";
		}
	}
	noun = 'desk'
	adjective = 'massive' 'imposing' 'felled' 'forest'
	location = FFLaurasOffice
	
	verDoSiton( actor ) = { "Inconceivable. "; }
;

placard: readable
	sdesc = "placard"
	ldesc = "A placard on the desk reads: 'Laura Angela Remick, Executive 
			Vice-President.' "
	noun = 'placard'
	location = FFLaurasDesk
	
	verDoTake( actor ) = 
	{
		"You can't take the placard. ";
	}
;

wallOfWindows: unimportantWindow
	sdesc = "wall of windows"
	ldesc = { FFLaurasOffice.lightDesc; }
	noun = 'window'
	plural = 'windows'
	location = FFLaurasOffice
;

skyInLaurasOffice: unimportantItem
	sdesc = "sky"
	adesc = "the sky"
	ldesc = { FFLaurasOffice.lightDesc; }
	noun = 'sky'
	adjective = 'purple' 'darkening'
	location = FFLaurasOffice
;

tinyChair: fixedBlock, chairitem
	sdesc = "tiny chair"
	ldesc = "You didn't even notice this chair at first, since it is the only thing
			proportioned to the scale of actual people. It is a simple metal
			framed chair with white cushions. "
	listenDesc = { return( self.location.listenDesc ); }
	noun = 'chair'
	adjective = 'simple' 'metal' 'framed' 'white' 'cushions' 'cushion' 'frame'
	location = FFLaurasOffice
	
	reachable = ( self.location.contents + self )
	doSiton( actor ) = 
	{
		if ( !self.alreadySatDown ) 
		{
			self.alreadySatDown := true;
			Me.moveInto( self );
			FFLaura.toldPlayerToSit := true;
			
			"You sit down in the tiny chair. \b
			
			\"Thank you,\" Laura says, folding her fingers into a steeple 
			that she touches to the bridge of her nose.\b
			
			Laura gazes at you from across the expanse of her desk. She seems
			almost ashamed of the ridiculous luxury around her. You regard her
			as she takes a moment to gather her thoughts, and you find yourself
			suddenly expecting a confession rather than an inquisition. \b";
			
			notify( FFLaura, &speechDaemon, 0 );
		}
		pass doSiton;
	}
	doUnboard(actor) =
	{
		if ( not FFLaura.finished )
		{
			"You shouldn't get up until Laura has finished saying what
			she brought you here to tell you. ";
		}
		else
		{
			"You arise, warily, from the tiny chair. Laura nods at you. ";
			if ( FFLaura.playerHadPossessions && length( Me.contents ) = 0 )
				"\bLaura says, \"Don't leave without your things.\" She doesn't
				look around. ";
			self.leaveRoom( actor );
			actor.moveInto( self.location );
		}
	}
;

FFLaurasOfficeDoors: doorway
	sdesc = "doors"
	noun = 'door'
	plural = 'doors'
	isThem = true
	location = FFLaurasOffice
	doordest = escortPlayerOut
	destination = 
	{
		if ( FFLaura.finished )
		{
			return( self.doordest );
		}
		else
		{
			if ( not FFLaura.toldPlayerToSit )
				FFLaura.pleaseSitDown;
			else
				"Laura puts her hand up. \"When I'm finished, then you may go.\" ";
			return( nil );
		}
	}
	doOpen( actor ) =
	{
		if ( FFLaura.finished )
			pass doOpen;
		else
		{
			if ( not FFLaura.toldPlayerToSit )
				FFLaura.pleaseSitDown;
			else
				"Laura puts her hand up. \"When I'm finished, then you may go.\" ";
		}
	}
;

FFLaura: NPC
	sdesc = "Laura"
	ldesc = 
	{
		if ( not self.finished )
		{
			"Sitting in the high-backed leather throne is a tiny woman in a pearl
			white suit, diamond jewelry flashing from every finger, each earlobe,
			and her neck. ";
			
			if ( not self.lookedAtOnce )
			{
				if ( not self.toldPlayerToSit )
				{
					"\b";
					self.pleaseSitDown;
				}
				self.lookedAtOnce := true;
			}
		}
		else
			"Laura is standing naked in front of the curling orange flames, 
			gazing deeply into them. ";
	}
	actorDesc = { return; }
	isHer = true
	noun = 'woman'
	adjective = 'future' 'laura' 'human' 'being' 'purports' 'purported' 'purport' 
			'exalt' 'exalted' 'figure' 'tiny' 'executive' 'vice' 'president'
			'vp' 'vice-president' 'earlobe' 'her' 'neck' 'finger' 'fingers' 
			'diamond' 'jewelry' 'pearl' 'white' 'suit' 'ring' 'rings' 'bracelet'
			'bracelets' 'necklace' 'necklaces' 'jewels' 'remick-larson'
	playerTriedToVisit = nil
	playerHadPossessions = nil
	location = FFLaurasOffice
	listenDesc = 
	{
		if ( self.speechDaemonCount > 0 )
			return( nil );
		else pass listenDesc;
	}
	
	doAskAbout( actor, iobj ) =
	{
		if ( self.finished ) 
		{
			"She has nothing more to say. ";
		}
		else pass doAskAbout;
	}
	doTellAbout( actor, iobj ) =
	{
		if ( self.finished ) 
		{
			"There is nothing more to say. ";
		}
		else pass doTellAbout;
	}
	responseToThanks = 
	{
		"\^<<self.thedesc>> says, \"You have no reason to thank me.\" ";
	}
	
	askingAboutMe( who ) =
	{
		return( askingAboutLaura.askingAboutMe( who ) );
	}
	
	talkAboutMyself = 
	{
		"Laura says, \"That's the whole point of this. Just sit back and
		listen.\" ";
	}
	
	disavow( it ) =
	{
		"You get the feeling that this is neither the time nor the place
		for asking random questions. ";
	}
	tellAboutDisavow( it ) =
	{
		"You get the feeling that you shouldn't interrupt her with idle
		chatter. ";
	}
	notImpressedMsg = "Now is the time for listening, not show and tell. "
	
	pleaseSitDown = 
	{
		if ( not self.toldPlayerToSit )
		{
			"Laura looks at you. Though she is far away, you can feel her eyes
			cut deeply into you. \b
			
			\"Please sit,\" she says in an even, steady voice that has grown
			hushed with age. \"I have a number of things to tell you, and not
			much time.\" She points out a chair in front of her desk, so tiny
			in comparison to everything else that you didn't even notice it
			before now. \b
			
			\"When I'm finished, you may leave. Please.\" ";
			
			self.toldPlayerToSit := true;
		}
	}
	
	speechDaemonCount = 0
	speechDaemon = 
	{
		self.speechDaemonCount++;
		switch( self.speechDaemonCount )
		{
			case 1:
				self.story1;
				break;
			case 2:
				self.story2;
				break;
			case 3:
				self.story3;
				break;
			case 4:
				self.story4;
				break;
			case 5:
				self.story5;
				break;
			case 6:
				self.story6;
				break;
			case 7:
				self.story7;
				break;
			case 8:
				self.story8;
				break;
		}
	}
	story1 = 
	{
		"\"Let me tell you a story,\" she begins. \"It's my story. It's the story
		of the Devil.\" She pushes back in her chair, shaking her head as she rises.
		\"Naturally, I'm not the Devil. That's not what I mean.\" ";
		
		"\b";
		
		"She walks to the windows and gazes from horizon to horizon. \"I'm not a 
		religious woman, not any more. I don't believe in God or in Heaven. But,\"
		she says, facing you, \"I find I have to believe in the Devil and in Hell.\"
		She sweeps her arms wide as she walks forward to the corner of her desk.
		\"This ... is Hell.\" ";
		
		"\b";
		
		"A moaning sound issues from the fireplace, air flowing resonantly through
		the flue. \"And the Devil rules it. The Devil made it. The Devil ...\" She 
		leans forward, her fingers tapping the desk's surface. \"The Devil put me
		here -- because I wanted it.\" ";
		
		"\b";
		
		"She straightens her jacket, smoothing the front of it as she stands up again.
		\"You understand what a metaphor is, I hope. Otherwise, you won't understand
		any of this. You're in Hell. A metaphor for it. It was made by the Devil --
		the Devil being the name we give to another metaphor. Christ in the 
		wilderness: a metaphor meets a metaphor in a metaphorical landscape.\" She
		holds out her hand to you. \"Shall I complete the metaphor, by taking you
		to these windows behind me, where you can gaze down upon the whole Earth
		below?\" She takes back her hand. \"Or are you with me this far, and I can
		go on without laboring the point?\" ";
	}
	story2 =
	{
		"\b";
		
		"Laura cocks her head and a smile appears on her face. It's the same face
		that smiled up at you from the New Accounts desk forty years ago, but the
		smile is different. It's not the wrinkles and creases, the whitened hair,
		the change in clothes and jewelry; it's the darkness behind the smile that's
		the difference. It's something in the eyes, or something lacking that was
		once there. ";
		
		"\b";
		
		"\"Can I get you something?\"\ Laura asks, playing hostess. \"Coffee? 
		Water? Wine?\" Her smile twists another notch. \"Wealth? Fame? Power?\" ";
	}
	story3 = 
	{
		"\b";
		
		"She sobers up again. \"Fame isn't what it's cracked up to be, but I
		recommend taking the rest.\" ";
		
		"\b";
		
		"She walks around behind you, far enough that you can't turn your neck
		far enough to see her. You feel her, though, as a sensation in the hair
		on the back of your neck. \"I met the Devil the first of seven times
		when I was a teenager. This was before you and I met the first time,
		in the bank one sunny morning four decades ago.\" ";
		
		"\b";
		
		"Suddenly, her voice is right behind your ear. \"You think I don't
		remember you?\"\ she asks. \"The Devil is in the details.\" A chill
		runs the length of your spine and back again. ";
		
		"\b";
		
		"Laura walks back into view. \"The first lie, the first promise, was
		about freedom. What else does a teenaged girl want? When you scrape 
		away the superficialities, when you go to the heart of adolescent
		longing, this is the tender meat, the flesh of your young soul so
		easily primed, probed, and bruised. 'I will give you the freedom
		to do as thou wilt,' the promise goes. 'You can be on your own, make
		your own rules, earn your own money, buy what you want, date whomever
		you want. Deal?'\" ";
	}
	story4 = 
	{
		"\b";
		
		"Laura removes her suit jacket and hangs it over the back of her
		chair. The width of the chair's back makes the white sleeves stick
		out at acute angles. \"Deal,\" Laura says. She looks at you, 
		watching to see if you're keeping up. ";
		
		"\b";
		
		"\"Care to guess,\" she asks, \"what the next six lies were?\" ";
	}
	story5 = 
	{
		"\b";
		
		if ( length( FFLaurasDesk.contents ) > 1 )
		{
			"She picks up ";
			
			if ( timeManual.isIn( FFLaurasDesk ) )
				"the time machine manual, regards it for a moment, and
				drops it back onto the desk. ";
			else if ( length( FFLaurasDesk.contents ) = 2 )
				"<<FFLaurasDesk.contents[2].thedesc>>, regards
				it for a moment, and then drops it back onto the 
				desk. ";
			else
				"<<FFLaurasDesk.contents[2].thedesc>>, regards
				it for a moment, and then drops it back onto the 
				desk with the rest of your things. ";
		
			"\b";
		}
		
		"\"That's right. They were exactly the same as the first. The deal
		was the same -- I will sell you total freedom, but I'm really taking
		it away. The best part is, I'm not stealing it, you're giving it away.\" ";
		
		"\b";
		
		"Laura sits back on her black throne, the jacket-sleeve wings flaring
		to either side. \"Does this look like freedom to you?\" ";
	}
	story6 = 
	{
		"\b";
		
		"Laura leans forward across her desk, her eyes bearing down on you for
		a long moment. \"Do you believe that I'm not the Devil?\"\ she asks.
		\"I told you I wasn't, but do you believe me?\" ";
	}
	story7 = 
	{
		"\b";
		
		"\"I'm going to offer you a deal, so you had better be sure. Because
		what I'm offering you is freedom.\" You expect her to smile ironically,
		but she does not. ";
		
		"\b\"";
		
		if ( self.playerHadPossessions )
		{
			"You can take your ";
			
			if ( length( FFLaurasDesk.contents ) = 2 )
				"<<FFLaurasDesk.contents[2].sdesc>>, ";
			else
				"things, ";
		}
		else
		{
			"You can stand up, ";
		}
		
		"and you can walk out those doors, and you can go back to where you
		came from. You're free to go. I could put you under arrest for 
		trespassing, but I won't. I'm giving you your freedom. But.\" ";
		
		"\b";
		
		"At last, she does smile. \"You knew there was going to be a catch,
		didn't you?\" ";
	}
	story8 =
	{
		"\b";
		
		"\"The catch is, if I give you your freedom, you have to give me
		back mine.\" She turns a key in a latch on the other side of the 
		desk. A drawer slides open, and she removes a small, cream colored
		envelope sealed with red wax. She slides the drawer shut and locks
		it again. ";
		
		"\b";
		
		"\"I want you to go back and give this to me on that first day we
		met. I'll recognize it, don't worry. I'll recognize it, I'll read 
		it, and I'll cease to exist.\" She stands again, dropping the
		envelope onto the desk";
		
		if ( length( FFLaurasDesk.contents ) < 3 )
			". ";
		else
			" next to your possessions. ";
		
		sealedEnvelope.moveInto( FFLaurasDesk );
		
		"\"Not me then, me now. This.\" She once again indicates the whole
		room as she turns away and walks toward the gaping mouth of the
		fireplace. It was farther away and larger than you had thought.
		Laura looks like a morsel ready to be swallowed whole by it.
		\"This,\" she concludes, \"will cease to exist.\" ";
		
		"\b";

		morePrompt();
		
		"She turns to face you again. \"I'm prepared to die. I'm prepared for
		nothingness to consume me as soon as you climb on that shiny little
		machine of yours and vanish. What will the suddenness of nonexistence
		feel like? To be blotted out, not like dying, but as in never having
		ever existed in the first place? No one will remember that I had a 
		chance to live, and I chose to turn out like this.\" She regards you
		from across the room and begins to remove her jewelry. One by one, 
		she tosses each piece into the fireplace. \"You, though. You'll
		remember.\" ";
		
		"\b";
		
		"She strips completely naked, revealing a pale old woman's body,
		and tosses her clothes, too, into the fireplace. It is a ghastly
		but hypnotic sight, one that leaves you trembling slightly. \"Try
		to forget,\" she says. \"Try.\" ";
		
		"\b";
		
		"She touches a button on the wall, and orange flames belch into 
		roaring life, consuming quickly everything in the fireplace. Laura
		stands naked in front of the curling flames, gazing at them for a
		long time. ";
		
		"\b";
		
		morePrompt();
		
		"\"Go,\" she says, shouting over the noise of the fire. \"I'm finished.\" ";
		
		self.finished := true;
		self.speechDaemonCount := 0;
		unnotify( self, &speechDaemon );
		orangeFlames.moveInto( FFLaurasOffice );
	}
;

sealedEnvelope: readable
	sdesc = "sealed envelope"
	ldesc = "It is a cream colored envelope, the kind that holds small stationery.
			It has been sealed shut with red wax. "
	readdesc = "There is nothing written on the sealed envelope. "
	noun = 'envelope'
	adjective = 'sealed'
	
	verDoOpen( actor ) = 
	{
		"It is not for you to open. ";
	}
	verDoGiveTo( actor, io ) = {}
	tellingAboutMe( who ) = {
		switch( who ) {
			case FFLaura: 
				if ( FFLaura.finished ) {
					"\"Please take it and go.\" ";
					return( true );
				}
				return( nil );
			case PLaura: "Laura says, \"What is that?\"\b ";
				if ( topLocation( self ) = topLocation( Me ) )
					PLaura.ioGiveTo( actor, self );
				return( true );
			case Laura:
				if ( topLocation( self ) = topLocation( Me ) )
					Laura.ioGiveTo( actor, self );
				else 
					"Laura looks puzzled and says, \"What are you talking about?\" ";
				return( true );
			default: return( nil );
		}
	}
	askingAboutMe( who ) = {
		switch( who ) {
			case FFLaura: 
				if ( FFLaura.finished ) {
					"\"I've said all I have to say. Go.\" ";
					return( true );
				}
				return( nil );
			case PLaura: "Laura says, \"What is that?\"\b ";
				if ( topLocation( self ) = topLocation( Me ) )
					PLaura.ioGiveTo( actor, self );
				return( true );
			case Laura:
				if ( topLocation( self ) = topLocation( Me ) )
					Laura.ioGiveTo( actor, self );
				else 
					"Laura looks puzzled and says, \"What envelope?\" ";
				return( true );
			default: return( nil );
		}
	}
;

redWax: fixedBlock
	sdesc = "red wax"
	ldesc = "The red wax is sealing the envelope shut. There is a tiny imprint in
			the wax of the initials \"L.R.\" "
	noun = 'wax'
	adjective = 'red' 'seal' 'tiny' 'imprint' 'initial' 'initials'
	location = sealedEnvelope
	
	verDoBreak( actor ) = {}
	doBreak( actor ) = 
	{
		"It is not for you to open. ";
	}
	doOpen -> sealedEnvelope
	verDoTake( actor ) =
	{
		"It is not for you to open. ";
	}
;

escortPlayerOut: transitionRoom
	sdesc = ""
	ldesc = 
	{
		"Carl escorts you out of the office and into the elevator. He pushes the
		button for the sub-basement and stares straight ahead, saying nothing.
		When the elevator stops, he looks at you. \b
		
		\"I don't claim to understand this,\" he says soberly. Then he affects
		a caveman voice and says, \"Carl only pawn, in game of life.\" He laughs
		roughly as he walks you back to the storage room, gives you a final nod,
		and shuts the door behind you. ";
		
		interiorStorageRoomDoor.setIsopen( nil );
	}
	nextLoc = storageRoom
;


/*************************** END OF GAME CODE *****************************/

/* eof */
