#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// THE VR PC
// THE FIRST VR ROOM (the one accessed via the food dispenser)
// THE FIRST VR ROOM: THE VR "FILES"
// THE FIRST VR ROOM: VRROOMLISTER
// THE BEACH VR
// THE "EMPTY ROOM" VR
// THE ILLUSTRATIONS
// DEBUG STUFF

// -------------------------------------------------------------------
// THE VR PC
// -------------------------------------------------------------------

// When you're in VR, your character is deliberately generic.

virtualMe: Person
;

// -------------------------------------------------------------------
// THE FIRST VR ROOM (the one accessed via the food dispenser)
// -------------------------------------------------------------------

//class mazesM9:  Container, Immovable;

vrRoom: Room 'Place'
  "You are in a place. You can exit from here. "
  vocabWords = 'place/room'
  roomParts = [defaultFloor]
  bannerValue = vrPic
  out = goBackToCell
  roomContentsLister { return vrRoomLister; }
  hasBeenDescribed = nil
;

modify glob
  alreadyReturnedFromVR = nil
;

goBackToCell: TravelConnector
  dobjFor(TravelVia) {
    preCond = []
    verify { }
    check { }
    action {
      "In a blink, the world you are in flashes out of 
          existence. You become disoriented\ .\ .\ . ";
      nbmPause();
      setPlayer(me); // as opposed to virtualMe
      glob.font = verdana;
      cell.showTerminalPic = nil; // just in case
      nbmCls();
      nbmBanner.updateMe;
      
      // if there's no gExitLister and we need to add it:
      if (goToCell.hasExitList && !gExitLister) {
        //"<p>ExitLister retrieval attempted.<p>";
        libGlobal.exitListerObj = exitLister;
        retrieveExitSettings();
      }
      // if there's a gExitLister and we need to remove it:
      if (!goToCell.hasExitList && gExitLister) {
        //"<p>ExitLister storage attempted.<p>";
        libGlobal.exitListerObj = nil;
        storeExitSettings();
      }
      
      ".\ .\ .\ and you wake up where you were before,
          still standing in front of the food dispenser. ";
      "<p>In a flash, the articulated metal arm that was attached
          to your head rises up and rapidly disappears through the open
          panel in the ceiling. The panel closes neatly, 
          leaving little trace behind. ";
      "<p>";
      gActor = gPlayerChar;
      gPlayerChar.lookAround(verboseModeIsOn());
      if (!glob.alreadyReturnedFromVR) {
        //noClosedPanel.moveInto(nil);
        //closedPanel.moveInto(cell);
        "<.p><.q>Whoa!<./q> says Diane.
          <p><.q>I hope you<./s>re okay,<./q> says Vicki.
            <.q>That looked dangerous!<./q> ";
        glob.alreadyReturnedFromVR = true;
      }
      else {
        "<.p><.q>Another trip to Never-Never Land successfully 
            accomplished,<./q> says Diane. ";
      }
      
      // Delay doing any of Vicki and Diane's random fidgety stuff
      // for a bit after you return from the VR.
      vd1Daemon.daemonCount = 1;
      
      // If virtualMe is still carrying any .m files,
      // return them to the floor of the vrRoom.
      foreach (local cur in virtualMe.contents) {
        if (cur.isHeldBy(virtualMe))
          cur.moveInto(vrRoom);
      }
      cancelPendingCommands();
    }
  }
;

// -------------------------------------------------------------------
// THE FIRST VR ROOM: THE VR "FILES"
// -------------------------------------------------------------------

class MFile: Thing
  desc = "It<./s>s a long, irregular piece of metal and plastic, in
    the shape of alien letters, which, translated into English,
    would read something like <.q><<name>><./q>. "
  isQualifiedName = true
  isInExe = nil
;

class ExeFile: Immovable
  desc = "It<./s>s a large, cube-shaped piece of metal, engraved
    with large alien letters, which, translated into English,
    would read something like <.q><<name>><./q>. 
    You can run it. "
  isQualifiedName = true
  isListed = true
  isListedInContents = true
  isListedInInventory = true
  dobjFor(Execute) asDobjFor(Run)
  dobjFor(Play) asDobjFor(Run)
  dobjFor(Run) {
    verify { }
    action {
      //"A voice emanates from <<name>>. It asks, 
      //  <.q>Are you sure you want to run 
      //  <<runHtmlOpen>><<runDesc>>?<./q><<runHtmlClose>> ";
      executeFile;
    }
  }
  runHtmlOpen = ''
  runHtmlClose = ''
;

// I suspect I should change this to make the examineInterior()
// happen only when the box actually contains something.
mazesM9: Container, Immovable 
  'mazes.m9 mazes m9 box/container' 'mazes.m9'
  @vrRoom
  "The box is made of metal. It is engraved with large alien letters,
    which, translated into English, would read something like
    <.q>mazes.m9<./q>. "
  specialDesc {
    "A box labeled <.q>mazes.m9<./q> sits on the floor here. ";
    examineInterior();
  }
  isQualifiedName = true
  dobjFor(Compile) {
    verify { 
      logicalRank(120, 'm9 file');
    }
    action {
      //"You run m9compiler.exe. <p>";
      replaceAction(Run, m9CompilerExe);
    }
  }
;

//theMazesThemselvesM: MFile 
//  'themazesthemselves.m themazesthemselves m' 
//  'themazesthemselves.m'
//  @mazesM9
//;

mazesM: MFile 
  'mazes.m maze.m 
    mazes maze m' 
  'mazes.m'
  @mazesM9
  isInExe = true
  testDesc = 'Nothing but Mazes core module'
;

beachChairM: MFile 
  'beachchair.m beach.m chair.m 
    beachchair beach chair m'
  'beachchair.m'
  @vrRoom
  testDesc = 'beach chair module'
;

butterflyIdM: MFile 
  'butterflyidentification.m butterflyid.m butterfly.m id.m identification.m  
    butterflyidentification butterflyid butterfly id identification m' 
  'butterflyidentification.m'
  @vrRoom
  testDesc = 'butterfly identification module'
;

vr2TextM: MFile
  'vr2text.m vr2.m vr.m text.m 
    vr2text vr2 vr text m'
  'vr2text.m'
  @vrRoom
  testDesc = 'Ovan<./s>s text module for playing on a tablet device'
;

robotNavigatorM: MFile 
  'robotnavigator.m robot.m navigator.m
    robotnavigator robot navigator m' 
  'robotnavigator.m'
  @vrRoom
  testDesc = 'Robot navigator component of text module'
;

adamThorntonM: MFile
  'adamthornton.m at.m at adam thornton adamthornton m'
  'adamthornton.m'
  @vrRoom
  testDesc = 'Adam Thornton module'
;

mazesExe: ExeFile
  'mazes.exe maze.exe
    mazes maze exe'
  'mazes.exe'
  @vrRoom
  runDesc = 'Nothing but Mazes'
  runHtmlOpen = '<i>'
  runHtmlClose = '</i>'
  dobjFor(Compile) {
    verify { 
      // logicalRank == 100
      //logicalRank(120, 'm9 file');
    }
    action {
      //"You run m9compiler.exe. <p>";
      replaceAction(Run, m9CompilerExe);
    }
  }
  executeFile {
    "You try to run mazes.exe, but nothing happens. 
      Or does it&ndash;&ndash;? ";
    nbmPause();
    "<p>Suddenly, in a blink, the world you are in flashes out of 
        existence. ";
    nbmPause();
    setPlayer(me); // as opposed to virtualMe
    glob.font = verdana;
    cell.showKillYouPic = true;
    nbmCls();
    nbmBanner.updateMe;
    "You wake up where you were before,
        still standing in front of the food dispenser. ";
    "<p>In a flash, the articulated metal arm that was attached
        to your head rises up and rapidly disappears through the open
        panel in the ceiling. The panel closes neatly, 
        leaving little trace behind. 
      <p>Then, suddenly, you realize there are footsteps behind you. ";
    nbmPause();
    "<p>You turn around and are shocked to see Neton and
        Ovan standing there in the room with you, flanked by 
        the two guards.
      <p><.q>So,<./q> says Neton, <.q>the human believes
        that he can break into our computer system and 
        practice our game without being detected?<./q>
      <p><.q>What a fool!<./q> says Ovan.
      <p><.q>Yes, perhaps he is a fool,<./q> says Neton. 
        <.q>Nevertheless, just don<./s>t forget 
        whose password he used.<./q> 
      <p>Ovan glances at the floor guiltily. ";
    nbmPause();
    "<p><.q>Okay, enough talk,<./q> says Neton. Turning
        to his guards, he says, <.q>Please dispose of the 
        prisoner.<./q> ";
    "<p>The guards eagerly oblige, raising their guns
        and firing at you. 
        For a moment you are engulfed in blinding light and 
        agonizing pain. Then you collapse to the floor. 
      <p>In case it is any consolation, you should know that 
        the guards tremendously enjoyed killing you. 
        In times like this, it may be a comfort to know 
        that you have not died in vain. ";
    endGame(ftDeath);
  }
  calcStats {
    if (!mazesM.isInExe) {
      isViable = nil;
      isWinnable = nil;
    }
    else if (vr2TextM.isInExe && !robotNavigatorM.isInExe) {
      isViable = nil;
      isWinnable = nil;
    }
    else if (!vr2TextM.isInExe && robotNavigatorM.isInExe) {
      isViable = nil;
      isWinnable = nil;
    }
    else if (!vr2TextM.isInExe || !robotNavigatorM.isInExe) {
      isViable = true;
      isWinnable = nil;
      //isWinnable = vanishinglySmall;
    }
    // In all remaining cases, mazesM, vr2TextM, and robotNavigatorM
    // are all included. We're good to go.
    else {
      isViable = true;
      isWinnable = true;
    }
  }
  isViable = true
  isWinnable = nil
  //isWinnable = vanishinglySmall
  oddsOfWinningStr(ndash) {
    if (!mazesExe.isViable) {
      return '0%';
    }
    else if (!mazesExe.isWinnable) {
      return '0.01%' + ndash + '0.03%';
    }
    else { // game is viable and winnable
      return '30%' + ndash + '50%';
    }
  }
  knownOddsStr() {
    switch (pcLastSaw) {
      case zero:  return 'zero percent';
      case fifty: return '30 to 50 percent';
      default:    return 'about 0.01 percent';
    }
  }
  oddsOfWinning() {
    if (!mazesExe.isViable) {
      return zero;
    }
    else if (!mazesExe.isWinnable) {
      return one;
    }
    else { // game is viable and winnable
      return fifty;
    }
  }
  pcSawZero  = nil
  pcSawOne   = nil
  pcSawFifty = nil
  pcLastSaw  = nil
  pcKnowsCur = nil
  npcsKnowAsMuchAsPc = nil
  npcsSawZero  = nil
  npcsSawOne   = nil
  npcsSawFifty = nil
  npcsLastSaw  = nil
  npcsKnowComp = nil
  pcStatusReport {
    
    
    // Before outputting anything, update the NPCs' knowledge
    // variable as to what odds they've seen.
    if (winnabilityExe.hasBeenExecuted) {
      if (pcLastSaw == zero) {
        npcsSawZero = true;
      }
      if (pcLastSaw == one) {
        npcsSawOne = true;
      }
      if (pcLastSaw == fifty) {
        npcsSawFifty = true;
      }
      npcsLastSaw = pcLastSaw;
    }
    if (m9CompilerExe.hasBeenExecuted) {
      npcsKnowComp = true;
    }
    
    
    if (!vrRoom.hasBeenDescribed) {
      
      
//      // Before outputting anything, update the NPCs' knowledge
//      // variable as to what odds they've seen.
//      if (winnabilityExe.hasBeenExecuted) {
//        if (pcLastSaw == zero) {
//          npcsSawZero = true;
//        }
//        if (pcLastSaw == one) {
//          npcsSawOne = true;
//        }
//        if (pcLastSaw == fifty) {
//          npcsSawFifty = true;
//        }
//        npcsLastSaw = pcLastSaw;
//      }
//      if (m9CompilerExe.hasBeenExecuted) {
//        npcsKnowComp = true;
//      }
      
      
      "<.q>Well, I saw some 
          computer files lying on the ground,<./q> you say. ";
      if (!pcKnowsCur &&
          m9CompilerExe.hasBeenExecuted &&
          winnabilityExe.hasBeenExecuted) {
        "<.q>One of them told me that the odds of winning 
          the game were <<knownOddsStr>>. But after
          that I ran another file, which apparently 
          recompiled the game.<./q> ";
      }
      else if (m9CompilerExe.hasBeenExecuted) {
        "<.q>I tried running one of them, and it compiled a new
            version of mazes.exe.";
        if (winnabilityExe.hasBeenExecuted) {
          " And I also tried running another of them,
              and it told me the odds of winning 
              the maze game.<./q> 
            <p><.q>And what were the odds?<./q> asks Vicki. 
            <p><<pcOddsReport>>";
          winnabilityExe.hasBeenDescribed = true;
        }
        else {
          "<./q> ";
        }
        m9CompilerExe.hasBeenDescribed = true;
      }
      else if (winnabilityExe.hasBeenExecuted) {
        "<.q>I tried running one of them, and it told me
            the odds of winning the game.<./q>  
          <p><.q>And what were the odds?<./q> asks Vicki. 
          <p><<pcOddsReport>>";
        winnabilityExe.hasBeenDescribed = true;
      }
      else {
        "<.q>I poked around a little, and then I came 
            back.<./q> ";
      }
      vrRoom.hasBeenDescribed = true;
    }
    // vrRoom has been described, and !pcKnowsCur
    else if (!pcKnowsCur &&
             m9CompilerExe.hasBeenExecuted &&
             winnabilityExe.hasBeenExecuted) {
      "<.q>The last time I tested mazes.exe, the odds 
          of winning the game were ";
      if (pcLastSaw == fifty)
        "30 to 50 percent,<./q> you say. <.q>On the other hand, ";
      else if (pcLastSaw == zero)
        "literally nil,<./q> you admit, <.q>although ";
      else
        "next to nothing,<./q> you admit, <.q>although ";
      "I<./s>ve recompiled the game since then.<./q> ";
      m9CompilerExe.hasBeenDescribed = true;
      winnabilityExe.hasBeenDescribed = true;
    }
    // vrRoom has been described, and pcKnowsCur
    else { 
      // both m9compiler and winnability have been run
      if (m9CompilerExe.hasBeenExecuted &&
          winnabilityExe.hasBeenExecuted) {
        if (!m9CompilerExe.hasBeenDescribed)
          "<.q>I ran one of the files, and it compiled 
            a new version of mazes.exe,<./q> you say. ";
        else 
          "<.q>I recompiled mazes.exe,<./q> you say. ";
        if (!winnabilityExe.hasBeenDescribed)
          "<.q>Then I ran another file, ";
        else 
          "<.q>Then I ran that other file, ";
        "and it told me the odds of winning the maze game
          were <<knownOddsStr>>.<./q> ";
        m9CompilerExe.hasBeenDescribed = true;
        winnabilityExe.hasBeenDescribed = true;
      }
      // m9compiler's been run, but winnability hasn't been
      else if (m9CompilerExe.hasBeenExecuted) {
        if (!m9CompilerExe.hasBeenDescribed)
          "<.q>I ran one of the files,<./q> 
            you say, <.q>and it compiled 
            a new version of mazes.exe.<./q> ";
        else 
          "<.q>I recompiled mazes.exe,<./q> 
            you say. ";
        m9CompilerExe.hasBeenDescribed = true;
      }
      // winnability's been run, but m9compiler hasn't been
      else if (winnabilityExe.hasBeenExecuted) {
        if (!winnabilityExe.hasBeenDescribed)
          "<.q>I ran one of the files";
        else 
          "<.q>I ran that file";
        ",<./q> you say, <.q>and it told me 
          that the odds of winning were 
          <<knownOddsStr>>.<./q> ";
        winnabilityExe.hasBeenDescribed = true;
      }
      // neither m9compiler nor winnability has been run
      else { 
        "<.q>So far I<./s>ve basically just poked around,<./q>
          you say. ";
      }
    }
  }
  pcOddsReport {
    // If the PC has never run the winnability tester, then 
    // he simply doesn't know.
    if (pcLastSaw == nil) {
      "<.q>I don<./s>t know,<./q> you admit. ";
      return;
    }
    
    // If the PC has recompiled since the last time he ran
    // the winnability tester, then he should say what he last
    // saw, but admit his knowledge could be out of date.
    if (!pcKnowsCur) {
      "<.q>Last time I tested it the odds were ";
      if (pcLastSaw == fifty)
        "30 to 50 percent,<./q> you say. <.q>On the other hand, ";
      else if (pcLastSaw == zero)
        "literally nil,<./q> you admit, <.q>although ";
      else
        "next to nothing,<./q> you admit, <.q>although ";
      "I<./s>ve recompiled it since then.<./q> ";
      return;
    }
    
    // For all remaining cases, we can safely assume that
    // the PC's knowledge is up to date.
    if (pcLastSaw == zero) {
      if (pcSawFifty) {
        "<.q>At one point the odds were as high as 50 percent, 
          but now they<./s>re down to zero percent,<./q> you admit. ";
        return;
      }
      else {
        "<.q>Zero percent,<./q> you admit. ";
        return;
      }
    }
    if (pcLastSaw == one) {
      if (pcSawFifty) {
        "<.q>At one point the odds were as high as 50 percent, 
          but now they<./s>re down to about 0.01 percent,<./q> you admit. ";
        return;
      }
      else {
        "<.q>About 0.01 percent,<./q> you admit. ";
        return;
      }
    }
    else { // pcLastSaw = fifty
      if (!pcSawZero && !pcSawOne) {
        "<.q>About 30 to 50 percent,<./q> you say. ";
        return;
      }
      else if (!pcSawOne) {
        "<.q>At one point the odds were literally nil,
          but now they<./s>re around 30 to 50 percent,<./q> you say. ";
        return;
      }
      else {
        "<.q>At one point the odds were next to nothing,
          but now they<./s>re around 30 to 50 percent,<./q> you say. ";
        return;
      }
    }
    //// The above stuff should cover it. If not, show error message.
    //"<.q>There<./s>s been some kind of error,<./q> you admit, 
    //  <.q>because Greg Boettcher, the author of this game,
    //  has not programmed me to know the answer to that question.
    //  Please send him a bug report about it.<./q> ";
    //return;
  }
  npcRecommendation {
    // Unlike pcStatusReport, this method has to deal
    // with cases where winnabilityExe has never been run.
    if (!winnabilityExe.hasBeenExecuted) {
      if (!m9CompilerExe.hasBeenExecuted) {
        //"You said you basically just poked around a little. ";
        "Are you sure there wasn<./s>t more to do? If I were 
          you, I<./s>d go back and investigate further. 
          Who knows, maybe you can fix things to your advantage.";
        return;
      }
      else {
        //"You said you compiled a new version of mazes.exe. ";
        "That does sound promising. As for what 
          you should do now, I don<./s>t know. 
          If you think you<./s>ve done all you can, 
          you can call it a night. 
          Or, if you think there<./s>s more to do, 
          you can go back and investigate further. 
          The choice is yours.";
        return;
      }
    }
    
    // If the PC has recompiled since the last time he ran
    // the winnability tester, then he should say what he last
    // saw, but admit his knowledge could be out of date.
    if (!pcKnowsCur) {
      if (pcLastSaw == fifty) {
        "That leaves us with some uncertainty. 
          If you<./s>re going to live or die 
          as a result of this game, why not go back there 
          and test it one more time?";
        return;
      }
      else {
        "That<./s>s no good at all. If I were you, 
          I<./s>d go back in there and see if there was anything 
          I could possibly do to boost my odds of winning.";
        return;
      }
    }
    
    // For all remaining cases, we can safely assume that
    // the PC's knowledge is up to date.
    
    //if (pcLastSaw == zero) {
    //  if (pcSawFifty) {
    //    "You said the odds were zero percent. ";
    //    return;
    //  }
    //  else {
    //    "You said the odds were zero percent. ";
    //    return;
    //  }
    //}
    //if (pcLastSaw == one) {
    //  if (pcSawFifty) {
    //    "You said the odds were 0.01 percent. ";
    //    return;
    //  }
    //  else {
    //    "You said the odds were 0.01 percent. ";
    //    return;
    //  }
    //}
    //else { // pcLastSaw = fifty
    //  if (!pcSawZero && !pcSawOne) {
    //    "You said the odds were about 30 to 50 percent. ";
    //    return;
    //  }
    //  else if (!pcSawOne) {
    //    "You said the odds were about 30 to 50 percent. ";
    //    return;
    //  }
    //  else {
    //    "You said the odds were about 30 to 50 percent. ";
    //    return;
    //  }
    //}
    
    if (pcLastSaw == zero || pcLastSaw == one) {
      //"You said the odds were zero percent. ";
      "That<./s>s no good at all. If I were you, 
        I<./s>d go back in there and see if there was anything 
        I could possibly do to boost my odds of winning.";
      return;
    }
    else { // pcLastSaw = fifty
      //"You said the odds were about 30 to 50 percent. ";
      if (npcsSawZero || npcsSawOne) {
        "That<./s>s way better than before, 
          so congratulations. As for what 
          you should do now, I don<./s>t know. 
          If you think you<./s>ve raised the odds as high 
          as they can go, you can call it a night. 
          Or, if you think you can do better, 
          you can go back and try it again. 
          The choice is yours.";
        return;
      }
      else {
        "That<./s>s way better than I expected. 
          It sounds like your work has been paying off.
          As for what you should do now, I don<./s>t know. 
          If you think you<./s>ve raised the odds as high 
          as they can go, you can call it a night. 
          Or, if you think you can do better, 
          you can go back and try it again. 
          The choice is yours.";
        return;
      }
      //"That<./s>s no good at all. If I were you, 
      //  I<./s>d go back in there and see if there was anything 
      //  I could possibly do to boost my odds of winning.";
      //return;
    }
    // The above stuff should cover it. If not, show error message.
    //"There<./s>s been some kind of error,<./q> Vicki says, 
    //  <.q>because Greg Boettcher, the author of this game,
    //  has not programmed me to know the answer to that question.
    //  Please send him a bug report about it.<./q> ";
    //return;
  }
  npcStatusReport {
    // Unlike pcStatusReport, this method has to deal
    // with cases where winnabilityExe has never been run.
    if (!winnabilityExe.hasBeenExecuted) {
      if (!m9CompilerExe.hasBeenExecuted) {
        "You said you basically just poked around a little. ";
        return;
      }
      else {
        "You said you compiled a new version of mazes.exe. ";
        return;
      }
    }
    
    // If the PC has recompiled since the last time he ran
    // the winnability tester, then he should say what he last
    // saw, but admit his knowledge could be out of date.
    if (!pcKnowsCur) {
      "You said the odds of winning the game were ";
      if (pcLastSaw == fifty)
        "30 to 50 percent, ";
      else if (pcLastSaw == zero)
        "literally nil, ";
      else
        "next to nothing, ";
      "but that was before you recompiled it, so that 
        doesn<./s>t say much. ";
      return;
    }
    
    // For all remaining cases, we can safely assume that
    // the PC's knowledge is up to date.
    if (pcLastSaw == zero) {
      if (pcSawFifty) {
        "You said the odds were zero percent. ";
        return;
      }
      else {
        "You said the odds were zero percent. ";
        return;
      }
    }
    if (pcLastSaw == one) {
      if (pcSawFifty) {
        "You said the odds were 0.01 percent. ";
        return;
      }
      else {
        "You said the odds were 0.01 percent. ";
        return;
      }
    }
    else { // pcLastSaw = fifty
      if (!pcSawZero && !pcSawOne) {
        "You said the odds were about 30 to 50 percent. ";
        return;
      }
      else if (!pcSawOne) {
        "You said the odds were about 30 to 50 percent. ";
        return;
      }
      else {
        "You said the odds were about 30 to 50 percent. ";
        return;
      }
    }
    // The above stuff should cover it. If not, show error message.
    //"There<./s>s been some kind of error,<./q> Vicki says, 
    //  <.q>because Greg Boettcher, the author of this game,
    //  has not programmed me to know the answer to that question.
    //  Please send him a bug report about it.<./q> ";
    //return;
  }
;

enum zero, one, fifty;

winnabilityExe: ExeFile
  'winnability.exe winnable.exe winability.exe winable.exe win.exe 
    winnability winnable winability winable win exe'
  'winnability.exe'
  @vrRoom
  runDesc = 'the winnability tester for mazes.exe'
  executeFile {
    
    local mcount = 0;
    "A voice begins to emanate from <<name>>, saying,
        <.q>Game winnability tester activated. Testing
        mazes.exe\ .\ .\ .<./q> ";
    
    nbmPause();
    "<p><.q>";
    if (mazesM.isInExe) {
      mcount++;
      "\^<<mazesM.testDesc>> included.";
      //"<./q> ";
    }
    for(local cur=firstObj(MFile); cur != nil; 
        cur=nextObj(cur,MFile)) {
      if (cur.isInExe && cur != mazesM) {
        mcount++;
        if (mcount >= 2) {
          //"\b<.q>";
          "\n<.q>";
        }
        "\^<<cur.testDesc>> included.";
        //"<./q> ";
      }
    }
    if (mcount == 0) {
      "No modules included!";
      //"<./q> ";
    }
    "<./q> 
      <p><.q>";
    
    // Diagnosis
    if (!mazesM.isInExe) {
      "ERROR: No core module included!<./q>
        <p><.q>";
    }
    else if (vr2TextM.isInExe && !robotNavigatorM.isInExe) {
      "ERROR: vr2text.m included without required robotnavigator.m!<./q>
        <p><.q>";
    }
    else if (!vr2TextM.isInExe && robotNavigatorM.isInExe) {
      "ERROR: robotnavigator.m included without required vr2text.m!<./q>
        <p><.q>";
    }
    //else if (!vr2TextM.isInExe || !robotNavigatorM.isInExe) {
    //  "No errors detected.<./q>
    //    <p><.q>";
    //}
    //else {
    //  "No errors detected.<./q>
    //    <p><.q>";
    //}
    
    //nbmPause();
    "Diagnosis: ";
    if (mazesExe.isViable == nil)
      "Game is not viable! ";
    else
      "Game is viable. ";
    &ndash;
    "Odds of winning: 
      <<mazesExe.oddsOfWinningStr('&ndash;')>>.<./q> ";
    //if (!mazesExe.isViable) {
    //  "0%";
    //}
    //else if (!mazesExe.isWinnable) {
    //  "0.01%&ndash;0.03%";
    //}
    //else { // game is viable and winnable
    //  "30%&ndash;50%";
    //}
    ////switch (mazesExe.isWinnable) {
    ////  case true:             "30%&ndash;50%"; break;
    ////  case vanishinglySmall: "0.01%&ndash;0.03%"; break;
    ////  case nil:              "0%"; break;
    ////  default:               "0%"; break;
    ////}
    //".<./q> ";
    switch (mazesExe.oddsOfWinning) {
      case zero:  
        mazesExe.pcSawZero = true;
        mazesExe.pcLastSaw = zero;
        break;
      case one:   
        mazesExe.pcSawOne = true;
        mazesExe.pcLastSaw = one;
        break;
      case fifty: 
        mazesExe.pcSawFifty = true;
        mazesExe.pcLastSaw = fifty;
        break;
    }
    hasBeenExecuted = true;
    mazesExe.pcKnowsCur = true;
  }
  hasBeenExecuted = nil
  hasBeenDescribed = nil
;

m9CompilerExe: ExeFile
  'm9compiler.exe m9compile.exe compiler.exe compile.exe 
    m9compiler compiler m9compile compile exe'
  'm9compiler.exe'
  @vrRoom
  runDesc = 'the MIFS 9 compiler'
  executeFile {
    "A voice begins to emanate from <<name>>, saying,
        <.q>MIFS 9 compiler activated. Compiling
        mazes.m9 to mazes.exe\ .\ .\ .<./q> ";
    nbmPause();
    "<p>Suddenly a shower of sparks erupts from the 
        mazes.m9 box, so bright that you have 
        to close your eyes. 
        When you open them again, 
        you just catch sight of mazes.exe 
        quivering and rocking, increasingly fast, 
        until suddenly it shoots up like a rocket, 
        then vanishes without a trace
        into the emptiness above you. 
      <p>Then, a few seconds later, you hear the
        whistling of an object plummeting 
        down toward the earth at an ungodly speed.
        Instinctively you shield yourself,
        and then there is a tremendous crash.
      <p>When you open your eyes, you 
        see that the falling object was none other
        than a new copy of mazes.exe, which  
        landed in 
        the exact place where the other one was. 
        What<./s>s more, incredibly, its impact
        seems to have done no damage 
        to the surrounding area. In fact, the whole place
        looks exactly as it did before. ";
    for (local cur = firstObj(MFile); cur != nil; 
         cur = nextObj(cur, MFile)) {
      if (cur.isIn(mazesM9))
        cur.isInExe = true;
      else
        cur.isInExe = nil;
    }
    mazesExe.calcStats;
    hasBeenExecuted = true;
    mazesExe.pcKnowsCur = nil;
  }
  hasBeenExecuted = nil
  hasBeenDescribed = nil
;

//resetOptionM: MFile 'resetoption.m resetoption m' 'resetoption.m'
//  @vrRoom
//;
//

modify glob
  mazes     = nil
  butterfly = nil
  beach     = nil
  thornton  = nil
  robot     = nil
;

PreinitObject
  execute() {
    cmdTokenizer.insertRule(
      ['vr filename type 1',
       new RexPattern('<alphanum>{1,24}<dot>m9'),
       tokWord, nil, &acceptAbbrTok],
      'three initials', nil);
    cmdTokenizer.insertRule(
      ['vr filename type 2',
       new RexPattern('<alphanum>{1,24}<dot>m'),
       tokWord, nil, &acceptAbbrTok],
      'three initials', nil);
    cmdTokenizer.insertRule(
      ['vr filename type 3',
       new RexPattern('<alphanum>{1,24}<dot>exe'),
       tokWord, nil, &acceptAbbrTok],
      'three initials', nil);
    //cmdTokenizer.insertRule(
    //  ['vr filename type 4',
    //   new RexPattern('<alphanum>{1,24}<dot>m9m'),
    //   tokWord, nil, &acceptAbbrTok],
    //  'three initials', nil);
  }
;

// -------------------------------------------------------------------
// THE FIRST VR ROOM: VRROOMLISTER
// -------------------------------------------------------------------

// This vrRoomLister is just like the roomLister in msg_neu.t,
// except with a different showList method.

vrRoomLister: Lister
  // show the prefix/suffix in wide mode
  showListPrefixWide(itemCount, pov, parent) { "{You/he} see{s} "; }
  showListSuffixWide(itemCount, pov, parent) { " here. "; }
  // show the tall prefix
  showListPrefixTall(itemCount, pov, parent) { "{You/he} see{s}:"; }
  // Display a list of items, grouping according to the 'listWith'
  // associations of the items.  We will only list items for which
  // isListed() returns true.
  // 
  // 'pov' is the point of view of the listing, which is usually an
  // actor (and usually the player character actor).
  // 
  // 'parent' is the parent (container) of the list being shown.  This
  // should be nil if the listed objects are not all within a single
  // object.
  // 
  // 'lst' is the list of items to display.
  // 
  // 'options' gives a set of ListXxx option flags.
  // 
  // 'indent' gives the indentation level.  This is used only for
  // "tall" lists (specified by including ListTall in the options
  // flags).  An indentation level of zero indicates no indentation.
  // 
  // 'infoTab' is a lookup table of SenseInfo objects for all of the
  // objects that can be sensed from the perspective of the actor
  // performing the action that's causing the listing.  This is
  // normally the table returned from Thing.senseInfoTable() for the
  // actor from whose point of view the list is being generated.  (We
  // take this as a parameter rather than generating ourselves for two
  // reasons.  First, it's often the case that the same information
  // table will be needed for a series of listings, so we can save the
  // compute time of recalculating the same table repeatedly by having
  // the caller obtain the table and pass it to each lister.  Second,
  // in some cases the caller will want to synthesize a special sense
  // table rather than using the actual sense information; taking this
  // as a parameter allows the caller to easily customize the table.)
  // 
  // 'parentGroup' is the ListGroup object that is showing this list.
  // We will not group the objects we list into the parent group, or
  // into any group more general than the parent group.  
  // 
  // This routine is not usually overridden in lister subclasses.
  // Instead, this method calls a number of other methods that
  // determine the listing style in more detail; usually those other,
  // simpler methods are customized in subclasses.  
  showList(pov, parent, lst, options, indent, infoTab, parentGroup) {
    local groups;
    local groupTab;
    local singles;
    local origLst;
    local itemCount;
    // remember the original list
    origLst = lst;
    // filter the list to get only the items we actually will list
    lst = getFilteredList(lst, infoTab);
    // create a lookup table to keep track of the groups we've seen
    groupTab = new LookupTable();
    groups = new Vector(10);
    // set up a vector to keep track of the singles
    singles = new Vector(10);
    // figure the groupings
    itemCount = getListGrouping(groupTab, groups, singles,
                                lst, parentGroup);
    // Now that we've figured out what's in the list and how it's
    // arranged into groups, show the list.  
    
    
    //if (beachChairM.isIn(me)) {
    //  local k = 0; k = k / k;
    //}
    
    
    showArrangedList(pov, parent, lst, options, indent, infoTab,
                     itemCount, singles, groups, groupTab, origLst);
//    // If the list is recursive, mention the contents of any items
//    // that weren't listed in the main list, and of any contents
//    // that are specifically to be listed out-of-line.  Don't do
//    // this if we're already recursively showing such a listing,
//    // since if we did so we could show items at recursive depths
//    // more than once; if we're already doing a recursive listing,
//    // our caller will itself recurse through all levels of the
//    // tree, so we don't have to recurse any further ourselves.  
//    if ((options & ListRecurse) != 0
//      && indent == 0
//      && (options & ListContents) == 0) {
//      // show the contents of each object we didn't list
//      showSeparateContents(pov, origLst,
//                           options | ListContents, infoTab);
//    }
  }
;

/*
modify Thing
  lookAroundWithinContents(actor, illum, infoTab) {
    local lst;
    local lister;
    local remoteLst;
    local outer;
    // get our outermost enclosing room
    outer = getOutermostRoom();
    // mark everything visible from the room as having been seen
    setAllSeenBy(infoTab, actor);
    // if the illumination is less than 'dim' (level 2), display
    // only self-illuminating items 
    if (illum != nil && illum < 2) {
      // We're in the dark - list only those objects that the actor
      // can sense via the sight-like senses, which will be the
      // list of self-illuminating objects.  Don't include items
      // being carried by the actor, though, since those don't
      // count as part of the actor's surroundings.  (To produce
      // this list, simply make a list consisting of all of the
      // objects in the sense info table that aren't contained in
      // the actor; since the table naturally includes only objects
      // that are illuminated, the entire contents of the table
      // will give us the visible objects.)  
      lst = senseInfoTableSubset(
          infoTab, {obj, info: !obj.isIn(actor)});
      // use my dark contents lister
      lister = darkRoomContentsLister;
      // there are no remote-room lists to generate
      remoteLst = nil;
    }
    else {
      // start with my contents list
      lst = contents;
      // always remove the actor from the list
      lst -= actor;
      // use the normal (lighted) lister
      lister = roomContentsLister;
      // Generate a list of all of the *other* top-level rooms
      // with contents visible from here.  To do this, build a
      // list of all of the unique top-level rooms, other than our
      // own top-level room, that contain items in the visible
      // information table.  
      remoteLst = new Vector(5);
      infoTab.forEachAssoc(new function(obj, info) {
        // if this object isn't in our top-level room, note it
        if (obj != outer && !obj.isIn(outer)) {
          local objOuter;
          // it's not in our top-level room, so find its
          // top-level room 
          objOuter = obj.getOutermostRoom();
          // if this one isn't in our list yet, add it
          if (remoteLst.indexOf(objOuter) == nil)
            remoteLst.append(objOuter);
        }
      });
    }
    // add a paragraph before the room's contents
    "<.p>";
    // show the contents
    
    
    
    
//THE PROBLEM IS HERE:
    lister.showList(actor, self, lst, ListRecurse, 0, infoTab, nil);
    
    
    
    
    
    
    // if we can see anything in remote top-level rooms, show the
    // contents of each other room with visible contents 
    if (remoteLst != nil) {
      // show each remote room's contents
      for (local i = 1, local len = remoteLst.length() ; i <= len ; ++i) {
        local cur;
        local cont;
        // get this item
        cur = remoteLst[i];
        // start with the direct contents of this remote room
        cont = cur.contents;
        // Remove any objects that are also contents of the
        // local room or of any other room we've already listed.
        // It's possible that we have a MultiLoc that's in one
        // or more of the visible top-level locations, so we
        // need to make sure we only list each one once. 
        cont = cont.subset({x: !x.isIn(outer)});
        for (local j = 1 ; j < i ; ++j)
            cont = cont.subset({x: !x.isIn(remoteLst[j])});
        // list this remote room's contents using our remote
        // lister for this remote room 
        outer.remoteRoomContentsLister(cur).showList(
          actor, cur, cont, ListRecurse, 0, infoTab, nil);
      }
    }
  }
;
*/

// -------------------------------------------------------------------
// THE BEACH VR
// -------------------------------------------------------------------

beachRoom: OutdoorRoom
  roomName = 'Beach'
  //vocabWords = 'beach'
  desc {
    "Warm sun shines down overhead. Off to the north, 
      ocean waves wash up peacefully on the sandy shore. 
      A beach chair sits here, facing the ocean. ";
  }
  bannerValue = beachPic
  roomParts = [beachGround, defaultSky]
  roomTravelPreCond = [actorDirectlyInRoom]
  northwest = okayWalkToOcean
  north     = okayWalkToOcean
  west      = cannotLeaveAlongShore
  southwest = cannotLeaveAwayFromShore
  south     = cannotLeaveAwayFromShore
  southeast = cannotLeaveAwayFromShore
  east      = cannotLeaveAlongShore
  // This needs to be a cyclic event list, not a shuffled one,
  // because I need this atmosphere stuff not to appear in the room
  // desription the first time.
  atmosphereList: CyclicEventList { 
    [ 
       nil,nil
      ,new function {
         if (!beachButterfly.seenByRoom) {
           "<.p>An orange butterfly circles in the air nearby. ";
           if (butterflyIdM.isInExe) {
             "Looking closer, you see that it is a 
               Gulf Fritillary butterfly (<i>Agraulis vanillae</i>). ";
             beachButterfly.seenByRoom = true;
           }
         }
         else {
          "<.p>\^<<beachButterfly.theName>> flutters toward you
            from down the beach. ";
         }
       }
      ,nil
      ,'<.p>The butterfly touches down on the sand beside you,
         then flies back into the air. '
      ,nil,nil
      ,'<.p>The butterfly flutters off into the distance. '
      ,nil,nil,nil
      ,nil,nil,nil
      ,nil,nil
    ]  
  }   
;

beachGround: Floor
  'sandy coast/shore/beach/sand/ground/floor'
  'sand'
  "An ocean of sand stretches out as far as you can see, 
    both here and to the south. "
  putDestMessage = &putDestFloor
  dobjFor(Dig) {
    verify { }
    check { }
    action {
      "You try digging in the sand with your hands, but the
        sand just spills over and fills in the hole again. ";
    }
  }
  dobjFor(DigWith) asDobjFor(Dig)
;

beachSun: Distant
  'sun'
  'sun'
  @beachRoom
  "The warm sun hangs high overhead. "
;

beachOcean: Fixture
  'ocean sea water wave waves -'
  'ocean'
  @beachRoom
  desc {
    "A lovely, peaceful ocean stretches off to the north, 
      its waves lapping up against the sandy shore. ";
  }
  dobjFor(SwimIn) {
    verify { }
    action {
      if (swimCount < 10)
        swimCount++;
      switch (swimCount) {
        case 1:
          "You stride out into the ocean and dive in.
            You swim around for several minutes, and it is great fun, 
            but then it occurs to you 
            that you aren<./s>t actually accomplishing anything useful, 
            so you head back to shore. ";
          break;
        default:
          "Once more you stride off into the ocean and 
            swim around for a while. Once more you find nothing
            useful, so again you return to shore. ";
          break;
      }
    }
  }
  swimCount = 0
  dobjFor(Drink) {
    verify { }
    action {
      "Drink the salty ocean water? I think not. ";
    }
  }
;

okayWalkToOcean: FakeConnector
  travelDesc {
    //"If this had been an actual game, you would have swum for
    //  a while, then come back out of the ocean. ";
    replaceAction(SwimIn, beachOcean);
  }
;

class CannotLeaveBeach: FakeConnector
  dobjFor(TravelVia) {
    preCond() {
      return gActor.getTraveler(self).travelerPreCond(self)
        + gActor.location.roomTravelPreCond()
        //+ connectorTravelPreCond()
        ;
    }
  }
  checkTravelerDirectlyInRoom(traveler, allowImplicit) {
    return gActor.location.checkTravelerDirectlyInRoom(traveler, allowImplicit);
  }
  travelDesc {
    if (glob.beachEscapeAttempts < 10)
      glob.beachEscapeAttempts++;
    if (glob.beachEscapeAttempts == 1)
      "You start walking <<inRelationToShore>>, 
        but soon you notice that you don<./s>t seem 
        to be getting anywhere. 
        The sensation is extremely disconcerting, 
        and so you pick up your pace, to try to overcome it. 
        But the more you speed up, the more pronounced 
        the feeling becomes, until
        at last you become intensely unnerved. 
        Cutting loose all restraints, you sprint off 
        <<inRelationToShore>> as fast as you can. 
        Strangely, however, you seem to make 
        no progress whatsoever. At the end of it all, 
        panting and heaving, you turn around 
        and see that the beach chair is still 
        just a few feet behind you. All your running 
        has not budged you one inch. ";
    else
      "You start off <<inRelationToShore>>, 
        but the same thing happens as before. You can<./s>t 
        seem to make any progress, and so you give up, 
        knowing the effort is futile. ";
  }
;

cannotLeaveAlongShore: CannotLeaveBeach
  inRelationToShore = 'down the shore'
;

cannotLeaveAwayFromShore: CannotLeaveBeach
  inRelationToShore = 'away from the shore'
;

modify glob
  beachEscapeAttempts = 0
;

beachChair: Chair, Heavy
  '(beach) chair' 'beach chair'
  @beachRoom
  "The chair looks extremely comfortable. "
  actorInPrep = 'in'
;

// Gulf Fritillary butterfly (<i>Agraulis vanillae</i>)
// Okay, enough. Just remember this: When you do decide what butterfly
// to include, mention its species name in the room description 
// only the first time. Mention its species name always when in response
// to an explicit EXAMINE. And always italicize the species name,
// but not the parentheses around it.
beachButterfly: Decoration
  'orange gulf fritillary fritilary frittilary butterfly'
  name {
    if (butterflyIdM.isInExe)
      return 'Gulf Fritillary butterfly';
    else
      return 'orange butterfly';
  }
  location = beachRoom
  seenByRoom = nil
  desc {
    if (butterflyIdM.isInExe) {
      "Ah, the Gulf Fritillary, <i>Agraulis vanillae.</i>
        With its striking orange color and distinctive marks, 
        you<./s>d recognize it anywhere. It is fluttering around
        vigorously on the ocean breeze. ";
    }
    else {
      "It<./s>s a beautiful orange butterfly, fluttering around 
        on the ocean breeze. ";
    }
  }
  notImportantMsg = 
    'Meddling with the local butterfly population
      is not going to help you in your present task. '
  // I see no reason to hide this.
  hideFromAll(action) { return nil; }
  //specialDesc =
  //  "\^<<aName>> is fluttering around on the ocean breeze. "
  //specialDescOrder = 70
;

// The FlowingInContainer class is defined in 3extreme.t.
daiquiri: FlowingInContainer
  'cold ice-cold frosted glass cup 
    delicious delicious-looking creamy liquid banana daiquiri drink beverage cocktail -'
  name = 'banana daiquiri'
  containerName = 'glass'
  containerNoun = 'glass'
  contentsName = 'banana daiquiri'
  asscThing = daiquiriGlass
  location = beachRoom
  initSpecialDesc =
    "To the left of the chair, you can see an ice-cold banana daiquiri. "
  specialDescOrder = 80
  smellDesc = "The smell is mild but sweet. "
  flowingTasteDesc = "The taste is excellent. "
  flowingConsumeDesc = "The taste is excellent, and the alcohol is strong. "
  containerDesc =
    "Drops of moisture run down the frosted sides of the glass. "
  describeContents =
    "It is filled with a creamy, delicious-looking banana daiquiri. "
  hasWideOpening = true
  dobjFor(LookIn) {
    // Adding the article "a".
    action {
      "The <<containerName>> contains a <<contentsName>>. ";
    }
  }
  // Overriding the normal FlowingInContainer defaults.
  okayTakeMsg = 'Taken. '
  okayDropMsg = 'Dropped. '
  okayPutInMsg = 'Done. '
  okayPutOnMsg = 'Done. '
  okayPutUnderMsg = 'Done. '
  okayPutBehindMsg = 'Done. '
;

daiquiriGlass: RestrictedContainer
  'cold ice-cold frosted glass/cup'
  'frosted glass'
  @nil
  desc = (daiquiri.containerDesc)
  feelDesc = "The glass is wet to the touch, since there are 
    drops of moisture on the outside of it. "
  canPutIn(obj) { return nil; }
  cannotPutInRestrictedMsg =
    '{The dobj/him} {is} too big to fit into {the iobj/him}. '
;

class VrPda: Readable
  'pda (personal) computer laptop digital assistant palm (pilot) tablet device tv ipad
    buttons keyboard screen monitor game -' 
  'tablet device'
  "It<./s>s a personal digital assistant, about the size 
      of a small book. It has a screen and a few buttons. 
    <p>The tablet device is on. Looking more closely at the screen, 
      you note with annoyance that it is running the aliens<./s> 
      maze game.
      <<glob.pdaNotice>>"
  dobjFor(TurnOn) {
    verify {
      illogicalNow('The tablet device is already as on as it<./s>s ever
        going to get. ');
    }
  }
  dobjFor(TurnOff) {
    verify { }
    check {
      "Scanning the device, you are annoyed to find no obvious
        way to turn it off. ";
      exit;
    }
  }
  dobjFor(Use) {
    verify { }
    preCond = [objHeld]
    check { }
    action {
      glob.startPda;
    }
  }
  dobjFor(Feel) asDobjFor(Use)
  dobjFor(Play) asDobjFor(Use)
// Ignore the following "Play" handling. I don't need to be that anal.
//
//  // USE TABLET DEVICE could mean trying to do something else with the tablet device
//  // besides playing the game. However, PLAY TABLET or PLAY GAME
//  // specifically indicates a desire to play the game.
//  dobjFor(Play) {
//    verify { }
//    preCond = [objHeld]
//    check { }
//    action {
//      // If we make sure that glob.pdaUsageCount is greater than 0,
//      // that will avoid the message where you attempt to use the
//      // tablet device to do anything other than play the game.
//      if (glob.pdaUsageCount == 0)
//        glob.pdaUsageCount++;
//      glob.startPda;
//    }
//  }
  dobjFor(Push) asDobjFor(Use)
  dobjFor(EnterOn) asDobjFor(Use)
  dobjFor(TypeOn) asDobjFor(Use)
  dobjFor(TypeLiteralOn) asDobjFor(Use)
  dobjFor(Strike) asDobjFor(Use)
  dobjFor(Hit) asDobjFor(Use)
  dobjFor(Run) asDobjFor(Use)
;

modify glob
  pdaNotice {
    if (!hasSeenDispenserNotice)
      "<p>[If you wish to interact with the tablet device,
        you may type USE TABLET DEVICE.] ";
    hasSeenPdaNotice = true;
  }
  hasSeenPdaNotice = nil
  startPda {
    pdaUsageCount++;
    if (pdaUsageCount <= 1)
      "After pushing buttons for some time, you note, 
          to your extreme annoyance, that you can<./s>t 
          seem to do anything with the device other than 
          play the aliens<./s> maze game. In fact, there are
          no outward signs that it<./s>s <i>possible</i> 
          to do anything else with it. 
        <p>Well, you can certainly use the tablet device if you 
          want to, but that would seem to involve 
          playing the game. ";
    else if (!glob.pdaFuseIsOn) {
      "Are you absolutely certain that you want to play
        the aliens<./s> maze game? ";
      glob.pdaFuseIsOn = true;
      ncYesNo.set(
        new function { reallyStartPda; }
       ,'I can certainly see why you wouldn<./s>t want to. '
      );
    }
    else { // glob.pdaFuseIsOn
      reallyStartPda;
    }
  }
  pdaUsageCount = 0
  reallyStartPda {
    "At length you resign yourself to the fact that 
      you<./s>ll have to play the aliens<./s> maze game. 
      Steeling your resolve, you hold the tablet device 
      and give it your full attention. 
      Then, heaving a long, heavy sigh, you begin to play. ";
    nbmPause();
    nbmCls();
    goToSupermaze.execute;
    //startSupermaze();
  }
  pdaFuseIsOn = nil
;

beachPda: VrPda
  location = beachRoom
  initSpecialDesc =
    "To the right of the chair, you can see a tablet device. "
  specialDescOrder = 90
;

#ifdef __DEBUG
beachFixture: Fixture
  'beach beachbeach fixture' 'beach fixture'
  @beachRoom
  dobjFor(Pow) {
    verify {
      logicalRank(150, 'intended for powing');
    }
  }
;
#endif // __DEBUG

// -------------------------------------------------------------------
// THE "EMPTY ROOM" VR
// -------------------------------------------------------------------

emptyRoom: Room
  roomName = 'Room'
  //vocabWords = 'beach'
  desc {
    "You are in an empty room. ";
  }
  bannerValue = emptyPic
;

emptyRoomPda: VrPda
  location = emptyRoom
;

#ifdef __DEBUG
emptyRoomFixture: Fixture
  'empty (room) emptyroom fixture' 'empty room fixture'
  @emptyRoom
  dobjFor(Pow) {
    verify {
      logicalRank(150, 'intended for powing');
    }
  }
;
#endif // __DEBUG

// -------------------------------------------------------------------
// THE ILLUSTRATIONS
// -------------------------------------------------------------------

//vrPicPrint() {
//  return '<img src="misc/level9.png">';
//}

//beachPicPrint() {
//  return '<img src="misc/beach.png">';
//}

//emptyPicPrint() {
//  return '<img src="misc/empty.png">';
//}

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

//poBox: Thing 'p. o. p.o. po. p.o po.o. po.o post.o post.o. po post office box' 'PO Box' @vrRoom;
//fileM:   MFile 'file m/file.m' 'file.m' @vrRoom;
//fileM9: MFile 'file m9/file.m9' 'file.m9' @vrRoom;
//fileM9:  MFile 'file m9/file.m9' 'file.m9' @vrRoom;
//fileExe: MFile 'file exe/file.exe' 'file.exe' @vrRoom;

replace VerbRule(Quit)
    'quit'
    : QuitAction
    verbPhrase = 'quit/quitting'
;


DefineIAction(Que)
  execAction() {
    vd1Vr.reply;
  }
;

VerbRule(Que)
  'q'
  : QueAction
  verbPhrase = 'Q/Qing'
;

// ----------------

DefineIAction(Que1)
  execAction() {
    
    vd1Vr.hasBeenSelected = nil;
    vrRoom.hasBeenDescribed = nil;
    
    mazesExe.npcsKnowAsMuchAsPc = nil;
    //glob.iWantToNullify = true;
    
    vd1Vr.reply;
  }
;

VerbRule(Que1)
  'q1'
  : Que1Action
  verbPhrase = 'Q1/Q1ing'
;

// ----------------

DefineIAction(Que2)
  execAction() {
    
    vd1Vr.hasBeenSelected = true;
    vrRoom.hasBeenDescribed = true;
    
    mazesExe.npcsKnowAsMuchAsPc = true;
    //glob.iWantToMakeTrue = true;
    
    vd1Vr.reply;
  }
;

VerbRule(Que2)
  'q2'
  : Que2Action
  verbPhrase = 'Q2/Q2ing'
;

// ----------------

DefineIAction(Que3)
  execAction() {
    
    vd1Vr.hasBeenSelected = true;
    vrRoom.hasBeenDescribed = true;
    
    mazesExe.npcsKnowAsMuchAsPc = nil;
    //glob.iWantToNullify = true;
    
    //local k = 0; k = k / k;
    //"Will this even print out before running the reply? \b";
    
    vd1Vr.reply;
  }
;

VerbRule(Que3)
  'q3'
  : Que3Action
  verbPhrase = 'Q3/Q3ing'
;

// ----------------

DefineIAction(QueQue)
  execAction() {
    vd1Heard.reply;
  }
;

VerbRule(QueQue)
  'qq'
  : QueQueAction
  verbPhrase = 'QQ/QQing'
;

//modify glob
//  iWantToNullify = nil
//  iWantToMakeTrue = nil
//;


//DefineIAction(Vr)
//  execAction() {
//    "[Hack complete: NPCs now no longer assume they know 
//      as much as you do about the VR place.] ";
//    mazesExe.npcsKnowAsMuchAsPc = nil;
//  }
//;
//
//VerbRule(Vr)
//  'vr'
//  : VrAction
//  verbPhrase = 'VR/VRing'
//;

#endif // __DEBUG

