//
//  XTHtmlTagAboutBox.m
//  TadsTerp
//
//  Created by Rune Berg on 05/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagAboutBox.h"
#import "XTBaseTextHandler.h"
#import "XTHtmlLinebreakHandler2.h"


@interface XTHtmlTagAboutBox ()

@property XTHtmlLinebreakHandler2State savedLbh2State;

@end


@implementation XTHtmlTagAboutBox

+ (NSString *)name
{
	return @"aboutbox";
}

+ (BOOL)standalone
{
	return NO;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter textHandler:(XTBaseTextHandler *)textHandler
{
	[super format:formatter textHandler:textHandler];
	
	XTOutputFormatter *castFormatter = (XTOutputFormatter *)formatter;
	self.savedLbh2State = [castFormatter getLineBreakHandlerState];
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter textHandler:(XTBaseTextHandler *)textHandler
{
	XTOutputFormatter *castFormatter = (XTOutputFormatter *)formatter;
	[castFormatter setLineBreakHandlerState:self.savedLbh2State];
	
	[super formatExit:formatter textHandler:textHandler];
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.inAboutBox = YES;
	return res;
}

@end
