//
//  XTScoreStringTransformer.m
//  TadsTerp
//
//  Created by Rune Berg on 20/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTScoreStringTransformer.h"
#import "XTAllocDeallocCounter.h"


@implementation XTScoreStringTransformer

static NSString *scoreFormat = @"%ld / %ld";

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

+ (NSString *)reformat:(NSString *)scoreString
{
	NSString *res = scoreString;
	NSInteger score = 0;
	NSInteger turnCount = 0;
	NSScanner *scanner = [NSScanner scannerWithString:scoreString];
	if ([scanner scanInteger:&score]) {
		if ([scanner scanString:@"/" intoString:nil]) {
			if ([scanner scanInteger:&turnCount]) {
				if ([scanner isAtEnd]) {
					res = [NSString stringWithFormat:scoreFormat, score, turnCount];
				}
			}
		}
	}
	return res;
}

+ (NSString *)formatScore:(NSInteger)score inTurns:(NSInteger)turnCount
{
	NSString *res = [NSString stringWithFormat:scoreFormat, score, turnCount];
	return res;
}

@end
