//
//  XTBottomBarHandler.m
//  TadsTerp
//
//  Created by Rune Berg on 12/06/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTBottomBarHandler.h"
#import "XTAllocDeallocCounter.h"


@implementation XTBottomBarHandler

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

- (void)mainThread_showKeyPrompt:(NSString *)keyPrompt
{
	[self.keyPromptTextField setStringValue:keyPrompt];
}

- (void)mainThread_clearKeyPrompt
{
	[self clearKeyPrompt];
}

- (void)clearKeyPrompt
{
	[self.keyPromptTextField setStringValue:@""];
}

- (void)mainThread_setParsingModeHtml:(NSNumber *)mode
{
	BOOL htmlMode = mode.boolValue;
	[self setParsingModeHtml:htmlMode];
}

- (void)setParsingModeHtml:(BOOL)html
{
	NSString *modeStr = (html ? @"HTML" : @"Plain");
	[self.parsingModeTextField setStringValue:modeStr];
}

- (void)resetToDefaults
{
	[self clearKeyPrompt];
	[self setParsingModeHtml:NO];
}

@end
