//
//  XTPrefsItemColor.m
//  XTads
//
//  Created by Rune Berg on 14/04/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTPrefsItemColor.h"
#import "XTPrefsItem_private.h"
#import "XTColorUtils.h"


@implementation XTPrefsItemColor

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey;
{
	return [XTPrefsItemColor itemWithDefaultValue:defaultValue userDefaultsKey:userDefaultsKey valueTransformer:nil];
}

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey
					valueTransformer:(XTPrefsValueTransformer *)valueTransformer
{
	XTPrefsItemColor *item = [XTPrefsItemColor new];
	item.defaultValue = defaultValue;
	item.userDefaultsKey = userDefaultsKey;
	item.valueTransformer = valueTransformer;
	item.value = [item copyOfDefaultValue];
	item.skipResetToDefault = NO;
	return item;
}

- (void)internalPersist:(id)persistedValue
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	NSData *data = nil;
	if (self.value != nil) {
		data = [NSArchiver archivedDataWithRootObject:self.value];
	}
	[userDefaults setObject:data forKey:self.userDefaultsKey];
}

- (id)internalRestoreFromPersisted
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	NSData *data = [userDefaults dataForKey:self.userDefaultsKey];
	NSColor *res = (NSColor *)[NSUnarchiver unarchiveObjectWithData:data];
	return res;
}

- (void)resetToDefaultValue
{
	if (! self.skipResetToDefault) {
		NSColor *newValue = [self copyOfDefaultValue];
		if (! [XTColorUtils color:newValue isEqualTo:self.value]) {
			self.value = newValue;
		}
	}
}

@end
