#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

// -------------------------------------------------------------------------------------
// Preliminaries
// -------------------------------------------------------------------------------------

versionInfo: GameID
  IFID = '54abeb1d-5330-47b8-b3a6-14fc4cb3dec1'
  name = 'Padlock Demo'
  byline = 'by Greg Boettcher'
  htmlByline = 'by <a href="mailto:paradoxgreg@gmail.com">
                Greg Boettcher</a>'
  version = '1'
  authorEmail = 'Greg Boettcher <paradoxgreg@gmail.com>'
  desc = 'A padlock demo, demonstrating padlock.t.'
  htmlDesc = 'A padlock demo, demonstrating padlock.t.'
;

gameMain: GameMainDef
  initialPlayerChar = me
  showIntro() {
    "This is a demo. You can use all the usual verbs here, plus the debugging 
      verb MUNLOCK. Have fun!\b";
    padlockDaemon.startDaemon(); // remove this line later
  }
;

me: Actor
  location = lockRoom
;


// -------------------------------------------------------------------------------------
// Lock room
// -------------------------------------------------------------------------------------

lockRoom: Room
  'Lock Room' 'the lock room'
  "This is the lock room. To the east stands a door, which is 
    <<padlockMessages.briefPadlockableStatusMsg(lockDoor)>>. 
    You can also go south. "
  east = lockDoor
  south = westHallway
;

// A PadlockableContainer always has to be a complex container.
box: PadlockableContainer
  'box/container' 'box'
  @lockRoom
  desc = "It's a box. "
  subSurface: PadlockableContainerSubsurface {
    
  }
  subContainer: PadlockableContainerOpenableSubcontainer {
    
  }
;

lockDoor: PadlockableDoor
  'door' 'door'
  @lockRoom
  "It's a door. "
;

bigLock: KeyedPadlock
  'large big lock/padlock' 'big padlock'
  //@lockRoom // lying on the floor
  @lockDoor // locking the door
  //@box subLocation=&subSurface // locking the box
  desc = "It's a big padlock. "
  keyList = [goldKey]
;

smallLock: KeyedPadlock
  'small lock/padlock' 'small padlock'
  @westHallway // lying on the floor
  //@(box.subSurface) // locking the box
  "It's a small padlock. "
  keyList = [silverKey]
;

goldKey: Key
  'gold key' 'gold key'
  @lockRoom
  "It's a gold key. "
;

silverKey: Key
  'silver key' 'silver key'
  @westHallway
  "It's a silver key. "
;

// -------------------------------------------------------------------------------------
// Magnet room and magnets
// -------------------------------------------------------------------------------------

magnetRoom: Room
  'Magnet Room' 'the magnet room'
  "This is the magnet room. To the west stands a door, which 
    <<magnetDoor.isOpen ? 'is open' : 'is closed'>>. You can also go south.
    <p>There is a fridge here. "
  west = magnetDoor
  south = eastHallway
;

magnetDoor: OtherSideOfPadlockableDoor -> lockDoor
  'door' 'door'
  @magnetRoom
  "It's a door. "
;

fridge: SimpleAttachable, Fixture
  'fridge/refrigerator' 'fridge'
  @magnetRoom
  "It's a fridge. You can't open it, so don't try. "
  isMajorItemFor(obj) {
    return obj.ofKind(Magnet);
  }
;

class Magnet: SimpleAttachable, Thing
;

magnetBox: Container
  'small box' 'small box'
  @magnetRoom
  "It's a small box. "
;

redMagnet: Magnet
  'red magnet' 'red magnet'
  //@magnetRoom
  @magnetBox
  "It's a red magnet. "
;

blueMagnet: Magnet
  'blue magnet' 'blue magnet'
  //@magnetRoom
  @magnetBox
  "It's a blue magnet. "
;

// -------------------------------------------------------------------------------------
// Hallways
// -------------------------------------------------------------------------------------

westHallway: Room
  'Hallway' 'the west end of the hallway'
  "This is a hallway that continues to the east. You can also go north. "
  east = eastHallway
  north = lockRoom
  south = testDoor1
;

eastHallway: Room
  'Hallway' 'the east end of the hallway'
  "This is a hallway that continues to the west. You can also go north. "
  west = westHallway
  north = magnetRoom
  south = lockableDoor1
;

mediumLock: IndirectPadlock
  'medium lock/padlock' 'medium padlock'
  @eastHallway // lying on the floor
  //@(box.subSurface) // locking the box
  "It's a medium padlock. "
;

// -------------------------------------------------------------------------------------
// IndirectLockable Door experiment
// -------------------------------------------------------------------------------------

southwestHallway: Room
  'Hallway' 'the hallway to the south'
  north = testDoor2
;

testDoor1: IndirectLockable, Door
  'door' 'door'
  @westHallway
;

testDoor2: IndirectLockable, Door -> testDoor1
  'door' 'door'
  @southwestHallway
;

// -------------------------------------------------------------------------------------
// Lockable Door experiment
// -------------------------------------------------------------------------------------

southeastHallway: Room
  'Hallway' 'the hallway to the south'
  north =lockableDoor2
;

lockableDoor1: LockableWithKey, Door
  'door' 'door'
  @eastHallway
  keyList = [goldKey]
;

lockableDoor2: LockableWithKey, Door -> lockableDoor1
  'door' 'door'
  @eastHallway
  keyList = [goldKey]
;

// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// 
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
// DEBUGGING STUFF
// -------------------------------------------------------------------------------------

#ifdef __DEBUG

DefineTAction(Munlock);
VerbRule(Munlock)
  ('munlock' | 'mun' | 'munl' | 'munlo' | 'munloc') singleDobj
  : MunlockAction
  verbPhrase = 'magically unlock/unlocking (what)'
;
modify Thing
  dobjFor(Munlock) {
    verify() {
      illogical('{You/he} do{es}n&rsquo;t know how to magically unlock 
                {that dobj/him}. ');
    }
  }
;
modify Padlock
  dobjFor(Munlock) {
    verify() {
      if (!isLocked) {
        illogicalNow('{The dobj/he} {is} already unlocked. ');
      }
    }
    action {
      "Okay, {you/he} magically unlock{s} {the dobj/him}. ";
      makeLocked(nil);
      makeOpen(true);
    }
  }
;

padlockDaemon: Component
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      moveInto(gPlayerChar);
      daemonID = new Daemon(self, &daemon, 1);
    }
    // Otherwise, if the daemon is already running, let it continue.
  }
  daemon {
    //say('<p>lock.IsOpen == <<lock.isOpen ? 'true' : 'nil'>>. ');
    //say('<p>lock.IsLocked == <<lock.isLocked ? 'true' : 'nil'>>. ');
    //say('<.p>beginning of bigLock.examineStatus:<.p>');
    //bigLock.examineStatus();
    //say('<.p>end of bigLock.examineStatus. ');
  }    
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
  hideFromAll(action) { return true; }
  hideFromDefault(action) { return true; }
;

#endif // __DEBUG


