      SUBROUTINE FILERX(JDIM,KDIM,Q,S,XYJ,COEF2,COEF4,WORK)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK

C
      DIMENSION Q(JDIM,KDIM,4),S(JDIM,KDIM,4),XYJ(JDIM,KDIM)
      DIMENSION COEF2(JDIM,KDIM),COEF4(JDIM,KDIM)
C
      DIMENSION WORK(JDIM,KDIM,3)
C
C   FOURTH ORDER SMOOTHING, ADDED EXPLICITLY TO RHS
C   SECOND ORDER NEAR SHOCKS WITH PRESSURE GRD COEFF.
C
C  XI DIRECTION 
C
C   START DIFFERENCES EACH VARIABLE SEPARATELY
C
      DO 15 N = 1,4
C
      DO 16 J = JLOW,JUP
      JPL = JPLUS(J)
      DO 16 K = KLOW,KUP
      WORK(J,K,1) = Q(JPL,K,N)*XYJ(JPL,K) - Q(J,K,N)*XYJ(J,K)
16    CONTINUE          
C
C   C MESH BC
C
         IF(.NOT.PERIDC  )THEN
         J1 = JBEGIN
         J2 = JEND
         DO 76 K = KLOW,KUP
         WORK(J1,K,1) = Q(J1+1,K,N)*XYJ(J1+1,K) - 
     *                    Q(J1,K,N)*XYJ(J1,K)
         WORK(J2,K,1) = WORK(J2-1,K,1)
76       CONTINUE
         ENDIF
C
C   FOR FOURTH ORDER      
C
      DO 17 J = JLOW,JUP
      JPL = JPLUS(J)
      JMI = JMINU (J)
      DO 17 K = KLOW,KUP
      WORK(J,K,2) = WORK(JPL,K,1) - 2.* WORK(J,K,1) + WORK(JMI,K,1)
17    CONTINUE
C
C   C MESH BC
C
         IF(.NOT.PERIDC  )THEN
         J1 = JBEGIN
         J2 = JEND
         DO 77 K = KLOW,KUP
         WORK(J1,K,2) = Q(J1+2,K,N)*XYJ(J1+2,K) - 
     *         2.*Q(J1+1,K,N)*XYJ(J1+1,K) + Q(J1,K,N)*XYJ(J1,K)
         WORK(J2,K,2) = 0.
77       CONTINUE
         ENDIF
C
C
C   FORM DISSIPATION TERM
C
      DO 19 J = JLOW,JUP
      DO 19 K = KLOW,KUP
      WORK(J,K,3) = (COEF2(J,K)*WORK(J,K,1) - COEF4(J,K)*WORK(J,K,2))
19    CONTINUE
C
C   C MESH BC
C
         IF(.NOT.PERIDC  )THEN
         J1 = JBEGIN
         J2 = JEND
         DO 79 K = KLOW,KUP
         WORK(J1,K,3) = (COEF2(J1,K)*WORK(J1,K,1) - 
     +                   COEF4(J1,K)*WORK(J1,K,2))
         WORK(J2,K,3) = 0.
79       CONTINUE
         ENDIF
C
C  ADD IN DISSIPATION
C
C
      DTD = DT / (1. + PHIDT)
C
      DO 20 J = JLOW,JUP
      JMI = JMINU (J)
      DO 20 K = KLOW,KUP
      S(J,K,N) = S(J,K,N) + (WORK(J,K,3) - WORK(JMI,K,3))*DTD
20    CONTINUE
C
15    CONTINUE
C
      RETURN
      END
