      SUBROUTINE INPUT(JLARGE,JKLARG)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK
C
C
C         SET PARAMETER DEFAULTS
C
      MMAXJ = JLARGE
      MMAXK = JKLARG/JLARGE
      JMAX       = MMAXJ
      KMAX       = MMAXK  
C-old      JMAX       = 65
C-old      KMAX       = 21    
      NP         = 10000  
      NPCP       = 1
      IPRINT     = 1
      JTAIL1     = 0.20*JMAX
      JTAIL2     = 0.80*KMAX
      JACDT      = 1     
      THETAD     = 1.    
      PHIDT      = 0.
      PERIDC     = .FALSE.
      FSMACH     = 0.8
      ALPHA      = 0.    
      DIS2X      = 0.0
      DIS4X      = 0.64    
      DIS2Y      = 0.0
      DIS4Y      = 0.64    
      DYM        = 0.02
      XMIN       = 2.0
      XMAX       = 3.0
      YMAX       = 3.0
      THICK      = 0.1
      NSTEPS     = 100
      DT         = 1.0
C
      PRINT *,'             ',
     +   '       *         ******        ****     *****     *****  '
      PRINT *,'             ',
     +   '      * *        *     *      *        *     *    *    * '   
      PRINT *,'             ',
     +   '     *   *       *      *    *              *     *     *' 
      PRINT *,'             ',
     +   '    *******      ******      *             *      *     *'
      PRINT *,'             ',
     +   '   *       *     *     *      *          *        *    * '
      PRINT *,'             ',
     +   '  *         *    *      *      ****     ******    *****  '
      PRINT *, ' '
C
      PRINT *,'ARC2D : AN IMPLICIT FINITE DIFFERENCE CODE FOR AIRFOILS'
      PRINT *,'FOR FURTHER DETAILS SEE SELF DOCUMENTATION OR CONTACT '
      PRINT *,'THOMAS H. PULLIAM, MS 202A-1, NASA AMES RESEARCH CENTER'
      PRINT *,'MOFFETT FIELD, CA., 94035,   PHONE : 415 - 694 - 6417 '
C
C               READ IN THE DATA FOR THE RUN FROM STANDARD INPUT
C  *1*
         PRINT *, 'ENTER NSTEPS, DT DEFAULTS ARE ', NSTEPS,DT
         READ(5,*)  NSTEPS,DT
C  *2*
         PRINT *, 'ENTER JMAX, KMAX  DEFAULTS ARE ', JMAX, KMAX
         READ(5,*)  JMAX, KMAX
C  *3*
         PRINT *, 'ENTER FSMACH, ALPHA  DEFAULTS ARE ', FSMACH, ALPHA
         READ(5,*)  FSMACH, ALPHA
C  *4*
         PRINT *, 'ENTER DIS2X, DIS2X  DEFAULTS ARE ', DIS2X, DIS4X
         READ(5,*)  DIS2X, DIS4X
         PRINT *, 'ENTER DIS2Y, DIS4Y  DEFAULTS ARE ', DIS2Y, DIS4Y
         READ(5,*)  DIS2Y, DIS4Y
C  *5*
         PRINT *, 'ENTER PERIDC    DEFAULT IS ',  PERIDC  
         READ(5,*)  PERIDC  
             IF(.NOT.PERIDC  )THEN
                 PRINT *, 'ENTER JTAIL1, JTAIL2  DEFAULTS ARE ', 
     +                           JTAIL1, JTAIL2
                 READ(5,*)  JTAIL1, JTAIL2
             ELSE
                 JTAIL1 = 1
                 JTAIL2 = JMAX
             ENDIF
C  *6*
         PRINT *, 'ENTER GRID SPECIFICATIONS: '
         PRINT *,'ENTER XMIN, XMAX, YMAX  DEFAULTS ARE ',XMIN,XMAX,YMAX
         READ(5,*)  XMIN, XMAX, YMAX
         PRINT *,'ENTER DYM, THICK  DEFAULTS ARE ',DYM, THICK
         READ(5,*)  DYM, THICK
C  *7*
         PRINT *, 'ENTER PHIDT, THETAD   DEFAULTS ARE ', PHIDT, THETAD 
         READ(5,*)  PHIDT, THETAD 
C  *8*
         PRINT *, 'ENTER JACDT  DEFAULT  ', JACDT
         READ(5,*)  JACDT
C  *9*
         PRINT *, 'ENTER IPRINT  DEFAULT  ', IPRINT
         READ(5,*)  IPRINT
C  *10*
         PRINT *, 'ENTER NP, NPCP  DEFAULTS ARE ',NP,'  ',NPCP
         READ(5,*)  NP, NPCP
C  *11*
C
C
C  CHECK MESH SIZES
C
      IF ( JMAX .GT. JLARGE ) THEN
         WRITE(*, 36) JMAX, JLARGE
36       FORMAT( 1X, 'JMAX IS ', I5, 5X, 'ONLY DIMENSIONED FOR ', I5)
         STOP 'ERROR 1 IN IOALL'
      ENDIF
      IF ( JMAX*KMAX .GT. JKLARG ) THEN
         WRITE(*, 37) JMAX*KMAX, JKLARG
37       FORMAT( 1X,'JMAX*KMAX IS ',I5,5X,'ONLY DIMENSIONED FOR ',I5)
         STOP 'ERROR 1 IN IOALL'
      ENDIF
      IF ( JMAX .GT. 999 .OR. KMAX .GT. 999 ) THEN
         WRITE(*, 38) JMAX,KMAX
38       FORMAT( 1X, 'JMAX,KMAX ARE ', 2I5, 5X, 
     *    'BIGGER THAN 999 ', I5)
         STOP 'ERROR 1 IN IOALL'
      ENDIF
C
      PRINT *, ' '
C
      PRINT *,'    '
      PRINT *,'...............FLOW FIELD CONDITIONS...............'
      PRINT *,' FSMACH = ',FSMACH,' ALPHA = ',ALPHA
C
      PRINT *,'    '
      PRINT *,'...............GRID SPECIFICATIONS...............'
        PRINT *,' BICONVEX AIRFOIL GRID IS BEING INTERNALLY GENERATED'
        PRINT *,'...............................................'
        PRINT *,'  MINIMUM SPACING AT BODY'
        PRINT *,'                DYM = ',DYM
        PRINT *,' UPPER DIMENSION IN CHORDS (C=1) '
        PRINT *,'                 YMAX = ',YMAX
        PRINT *,' LEFT XMIN = ',XMIN,'  RIGHT  XMAX = ',XMAX
        PRINT *,' THICKNESS OF BICONVEX THICK = ',THICK
        PRINT *,'...............................................'

      IF(PERIDC  )THEN
        PRINT *,' THIS IS A PERIDC   GRID',
     +   ' JMAX = ',JMAX,' KMAX = ',KMAX
      ELSE
        PRINT *,' THIS IS A NONPERIDC   GRID',
     +   ' JMAX = ',JMAX,' KMAX = ',KMAX,
     +   ' JTAIL1 = ',JTAIL1,' JTAIL2 = ',JTAIL2
      ENDIF
C
C
      PRINT *,'    '
      PRINT *,'...............I/O SPECIFICATIONS...............'
      PRINT *,' NP = ',NP,'  IPRINT = ',IPRINT
      PRINT *,'...............ALGORITHM PARAMETERS...............'
      PRINT *,' THETAD  = ',THETAD ,' PHIDT = ',PHIDT
      PRINT *,' JACDT = ',JACDT
C
C
      IF(JACDT.EQ.0)PRINT *,
     *     ' <<<<<<<<<<<<  TIME ACCURATE  >>>>>>>>>>>>>>>>>>'
      IF(JACDT.EQ.1)PRINT *,
     *     ' <<<<  VARIABLE DT = 1./(1+SQRT(J)) >>>>>>>>>>>>>'
      IF(JACDT.EQ.2)PRINT *,
     *       ' <<<<  VARIABLE DT : MIN. EIGEN. >>>>>>>>>>>>>>>'
      IF(JACDT.EQ.3)PRINT *,
     *      ' <<<<  VARIABLE DT : CONST. CFL  >>>>>>>>>>>>>>>'
      PRINT *,'   ********  NUMBER OF TIME STEPS == ',NSTEPS
      PRINT *,'   ********  TIME STEP            == ',DT
C
      PRINT *,'****************************************************'
      PRINT *,'......   PENTADIAGONAL ALGORITHM         ...........'
      PRINT *,'****************************************************'
      PRINT *,' DIS2X = ',DIS2X,' DIS4X = ',DIS4X
      PRINT *,' DIS2Y = ',DIS2Y,' DIS4Y = ',DIS4Y

C
C
      RETURN
      END
