C***********************************************************************
C FILE: FEXCTR.FOR
C
C HISTORY: 18/5/90: COPIED FROM FXCGB.FOR
C                   DIRC,VOLC PUT IN
C                   SIGXC,ENXCC CHANGED
C                   OFF-DIAGONAL ELEMENTS IN STRESS TENSOR
C          3-APR-90 C0 AND CHECKING ON CHDENR(N).EQ.C0 ADDED TO PREVENT
C                   ZERO DENOMINATOR IN CALCULATING RWSRAD
C***********************************************************************
      SUBROUTINE FEXCTR(NPLWV,CHDENR,VOLC,SIGXC,XCENC,XCENER,
     &                  EXCDAT,XCFDAT,XCPDAT)
C=======================================================================
C                                                                       
C{{{{{{{{{{{{{{{{{{{{{{{{ SUBROUTINE FEXC16 }}}}}}}}}}}}}}}}}}}}}}}}}}}}
C                                                                       
C THIS SUBROUTINE CALCULATES THE EXCHANGE CORRELATION POTENTIAL FROM THE
C CHARGE DENSITY CALCULATED IN SUBROUTINE CHSP. THE CORRECTION TO THE
C TOTAL ENERGY DUE TO OVERCOUNTING THE EXCHANGE CORRELATION ENERGY ON
C SUMMING THE ELECTRONIC EIGENVALUES AND THE FORCES ON THE UNIT CELL
C DUE TO THE EXCHANGE CORRELATION ENERGY ARE ALSO CALCULATED.
C THE EXCHANGE CORRELATION ENERGY IS TAKEN FROM PERDEW AND ZUNGER'S
C PARAMETERIZATION OF CEPERLEY AND ALDER'S VALUES FOR THE CORRELATION
C ENERGY OF AN ELECTRON GAS AT LOW DENSITY AND THE GELL-MANN BRUECKNER
C EXPRESSION FOR THE CORRELATION ENERGY OF A HIGH DENSITY ELECTRON GAS
C
C                           /  
C     Sigma      =  &       |  [ e  (n(r)) - u(n(r)) ] n(r) dr
C          Ai,Aj     Ai,Aj  /     XC
C
C=======================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION CHDENR(*)
      DIMENSION SIGXC(*)
      DIMENSION EXCDAT(*),XCFDAT(*),XCPDAT(*)
      DATA PI,TPI,THIRD /3.14159265,6.283185307,0.33333333/
      DATA HALF,SIXTH /0.5,0.166666666666667/
C=======================================================================
C RSCFXF,RSCFXV,RSCCL,RSCFCF AND RSCFCV ARE PARAMETERS FROM THE PERDEW
C ZUNGER EXPRESSION FOR THE CORRELATION ENERGY
C=======================================================================
      DATA RSCFXF,RSCFXV,RSCCL / 0.9771,6.594,4.127 /
      DATA RSCFCF,RSCFCV / 0.9383,6.3348 /
      DATA C1 / (1.0,0.0) /
      DATA C0 / (0.0,0.0) /                                             
C=======================================================================
C RSCALE IS A SCALING FACTOR USED WHEN OBTAINING THE WIGNER-SEITZ RADIUS
C FROM THE ELECTRONIC CHARGE DENSITY
C=======================================================================
      RSCALE=3*VOLC/(4*PI)
C=======================================================================
C INITIALISE THE CORRECTION TO THE EXCHANGE CORRELATION ENERGY TO ZERO  
C=======================================================================
      XCF=0.0
      EXC=0.0
      DO 8100 N=1,NPLWV
C=======================================================================
C CALCULATE THE WIGNER-SEITZ RADIUS FOR THE POINT ON THE REAL SPACE GRID
C=======================================================================
      IF( CHDENR(N).EQ.C0) CHDENR(N)=CMPLX(1.E-9,0.0)
      IF( REAL(CHDENR(N)).LE.0.0) WRITE(*,1000) N,CHDENR(N)
 1000 FORMAT(/,' IN FEXCTR: CHDENR(',I5,' )=',2F13.5,' MUST GE 0!')
      RWSRAD=(RSCALE/REAL(CHDENR(N)))**THIRD
      ARG=100*RWSRAD
      IF(ARG.GT.1997.0) ARG=1997.0
      NARG=INT(ARG)
      REM=ARG-NARG
C=======================================================================
C CALC THE EXCHANGE CORRELATION ENERGY
C=======================================================================
        V1=EXCDAT(NARG-1)
        V2=EXCDAT(NARG)
        V3=EXCDAT(NARG+1)
        V4=EXCDAT(NARG+2)
        T0=V2
        T1=((6*V3)-(2*V1)-(3*V2)-V4)*SIXTH
        T2=(V1+V3-(2*V2))*HALF
        T3=(V4-V1+(3*(V2-V3)))*SIXTH
        EXC=EXC+((T0+REM*(T1+REM*(T2+REM*T3)))
     &       *REAL(CHDENR(N)))
C=======================================================================
C CALC THE EXCHANGE CORRELATION ENERGY CORRECTION WHEN SUMMING EIGENVALS
C=======================================================================
        V1=XCFDAT(NARG-1)
        V2=XCFDAT(NARG)
        V3=XCFDAT(NARG+1)
        V4=XCFDAT(NARG+2)
        T0=V2
        T1=((6*V3)-(2*V1)-(3*V2)-V4)*SIXTH
        T2=(V1+V3-(2*V2))*HALF
        T3=(V4-V1+(3*(V2-V3)))*SIXTH
        XCF=XCF+((T0+REM*(T1+REM*(T2+REM*T3)))
     &      *REAL(CHDENR(N)))
C=======================================================================
C CALC THE EXCHANGE CORRELATION POTENTIAL
C=======================================================================
        V1=XCPDAT(NARG-1)
        V2=XCPDAT(NARG)
        V3=XCPDAT(NARG+1)
        V4=XCPDAT(NARG+2)
        T0=V2
        T1=((6*V3)-(2*V1)-(3*V2)-V4)*SIXTH
        T2=(V1+V3-(2*V2))*HALF
        T3=(V4-V1+(3*(V2-V3)))*SIXTH
        CHDENR(N)=(1.0,0.0)*(T0+REM*(T1+REM*(T2+REM*T3)))
 8100 CONTINUE
C=======================================================================
C CALCULATE THE FORCE ON THE UNIT CELL DUE TO THE CHANGE IN THE EXCHANGE
C CORRELATION ENERGY ON CHANGING THE SIZE OF THE CELL                   
C=======================================================================
      SIGXC(1)=-XCF/(3*VOLC*NPLWV)
      SIGXC(2)=SIGXC(1)
      SIGXC(3)=SIGXC(1)
      SIGXC(4)=0
      SIGXC(5)=0
      SIGXC(6)=0
C=======================================================================
C SCALE THE CORRECTION TO THE TOTAL ENERGY
C=======================================================================
      XCENC=-XCF/(3*NPLWV)
      XCENER=EXC/NPLWV
      RETURN
      END
C***********************************************************************
C HISTORY: 18/5/90 TAKEN FROM FILE XCDAT.FOR
C                  EXPRESSIONS FOR XC-ENERGY WHEN SUMMING KINETIC
C                    ENERGIES NOW IN EXCDAT()
C          22/8/90 FORMULA CORRECTED ACCORDING MCP BY WENG
C***********************************************************************
      SUBROUTINE XCDAT(EXCDAT,XCFDAT,XCPDAT)
      IMPLICIT COMPLEX (C)
      DIMENSION EXCDAT(2000)
      DIMENSION XCFDAT(2000)
      DIMENSION XCPDAT(2000)
      DATA PI,TPI,THIRD /3.14159265,6.283185307,0.33333333/
C=======================================================================
C RSCFXF,RSCFXV,RSCCL,RSCFCF AND RSCFCV ARE PARAMETERS FROM THE PERDEW
C ZUNGER EXPRESSION FOR THE CORRELATION ENERGY
C=======================================================================
      DATA RSCFXF,RSCFXV,RSCCL / 0.9771,6.59747,4.127 /
      DATA RSCFCF,RSCFCV / 0.9383,6.3348 /
      DATA C1 / (1.0,0.0) /
      DATA TRTDTH,THDTRT,RTHIN /0.960768923,1.040833,0.277350098/
C=======================================================================
C RSCALE IS A SCALING FACTOR USED WHEN OBTAINING THE WIGNER-SEITZ RADIUS
C FROM THE ELECTRONIC CHARGE DENSITY
C=======================================================================
C=======================================================================
C INITIALISE THE CORRECTION TO THE EXCHANGE CORRELATION ENERGY TO ZERO
C=======================================================================
      DO 8200 N=1,2000
C=======================================================================
C CALCULATE THE WIGNER-SEITZ RADIUS FOR THE POINT ON THE REAL SPACE GRID
C=======================================================================
        RWSRAD=0.01*N
C=======================================================================
C THE FORMULA FOR THE EXCHANGE CORRELATION ENERGY IS DIFFERENT FOR THE
C WIGNER-SEITZ RADIUS GREATER OR LESS THAN THE BOHR RADIUS THE FOLLOWING
C IF STATEMENT SELECTS THE CORRECT FORMULAE FOR THE EXCHANGE CORRELATION
C POTENTIAL AND THE CORRECTION TO THE TOTAL ENERGY
C=======================================================================
        IF(RWSRAD.GT.0.529177) THEN
          F1WSR=1.0+(1.447394*SQRT(RWSRAD))+(0.630035*RWSRAD)
          F2WSR=(0.723697*SQRT(RWSRAD))+(0.630035*RWSRAD)
          EXCDAT(N)=-3.872211/F1WSR - RSCFXV/RWSRAD
          XCFDAT(N)=-(RSCFXV/RWSRAD+(3.872211*F2WSR/(F1WSR**2)))
          XCPDAT(N)=-(4*RSCFXV/(3*RWSRAD)+(3.872211/F1WSR)+
     &       (3.872211*F2WSR)/(3*(F1WSR**2)))
        ELSE
          WSRLOG=LOG(RWSRAD/0.529177)
          EXCDAT(N)=-1.306157+0.84628*WSRLOG-0.5965*RWSRAD+0.10284*
     &      RWSRAD*WSRLOG - RSCFXV/RWSRAD
          XCFDAT(N)=-(RSCFXV/RWSRAD+0.84628+(-0.493653*RWSRAD)+
     &      (0.102819*RWSRAD*WSRLOG))
          XCPDAT(N)=-(4*RSCFXV/(3*RWSRAD)-(0.84628*WSRLOG)+1.58825-
     &      (0.068567*RWSRAD*WSRLOG)+(0.431949*RWSRAD))
        ENDIF
 8200 CONTINUE
      RETURN
      END
