      FUNCTION AABACD(IOCCA1, IOCCB1, IOCCA2, IOCCB2, NMOS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'mopac.inc'
      DIMENSION IOCCA1(NMOS), IOCCB1(NMOS), IOCCA2(NMOS), IOCCB2(NMOS)
***********************************************************************
*
* AABACD EVALUATES THE C.I. MATRIX ELEMENT FOR TWO MICROSTATES DIFFERING
*       BY TWO ALPHA MOS. ONE MICROSTATE HAS ALPHA ELECTRONS IN
*       M.O.S PSI(I) AND PSI(J) FOR WHICH THE OTHER MICROSTATE HAS
*       ELECTRONS IN PSI(K) AND PSI(L)
*
***********************************************************************
      COMMON /XYIJKL/ XY(NMECI,NMECI,NMECI,NMECI)
      IJ=0
      DO 10 I=1,NMOS
   10 IF(IOCCA1(I) .LT. IOCCA2(I)) GOTO 20
   20 DO 30 J=I+1,NMOS
         IF(IOCCA1(J) .LT. IOCCA2(J)) GOTO 40
   30 IJ=IJ+IOCCA2(J)+IOCCB2(J)
   40 DO 50 K=1,NMOS
   50 IF(IOCCA1(K) .GT. IOCCA2(K)) GOTO 60
   60 DO 70 L=K+1,NMOS
         IF(IOCCA1(L) .GT. IOCCA2(L)) GOTO 80
   70 IJ=IJ+IOCCA1(L)+IOCCB1(L)
   80 IJ=IJ+IOCCB2(I)+IOCCB1(K)
      AABACD=(XY(I,K,J,L)-XY(I,L,K,J))*((-1)**(IJ-(IJ/2)*2))
      RETURN
      END
