C----------------------------------------------------------------------
C
C  I N I T 
C
C  INITIALIZE CONSTANTS, COORDINATES OF BODIES ETC
C
C----------------------------------------------------------------------
      SUBROUTINE INIT
      INTEGER  DAYNUM
C
C  CONSTANTS
C
      REAL  PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
      COMMON /CONST/    PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
C
C THE GLOBAL ENVIRONMENT FOR THE INTEGRATION SUBROUTINES
C
      INTEGER MAXOBJ, MAXDAY, MMM, ORDER
      PARAMETER (MAXOBJ=10, MAXDAY=10000, ORDER=7, MMM=3)
      REAL
     .    EPOCH,
     .    SBINC(0:ORDER,0:ORDER),
     .    DD(0:ORDER),
     .    KK(-MMM:MMM,-MMM:MMM),
     .    MASS(MAXOBJ),
     .    COORD(3,MAXOBJ),
     .    VELOC(3,MAXOBJ),
     .    XDIFF(3,MAXOBJ),      
     .    ACCEL(-MMM:MMM,3,MAXOBJ,0:1),
     .    ADIFF(maxobj,0:ORDER,3),  
     .    DISTNC(MAXOBJ,MAXOBJ)        
      INTEGER SWAP
      COMMON /INTTAB/    SBINC,DD,KK,
     .                   COORD,VELOC,MASS,
     .                   XDIFF,ACCEL,ADIFF,DISTNC,SWAP,
     .                   EPOCH
C
C  
C
      PI     = 3.141592654E+0
      PI2    = 2.0E+0*PI
      CPI    = PI/12.0E+0
      DTORAD = PI/180.0E+0
      RTODEG = 180.0E+0/PI

      GRAVIT = 0.000295912208266E+0
  
      OBLIQ = (23.452294-0.00013*(1990-1900))*DTORAD
      EPOCH = 29981.0
C
C MASSES (SUN = 1)
C
      MASS(1)=1.0E+0
      MASS(2)=3.040437823D-06
      MASS(3)=1.702707305D-07
      MASS(4)=2.483854943D-06
      MASS(5)=3.284072250D-07
      MASS(6)=9.671179884D-04
      MASS(7)=2.894356006D-04
      MASS(8)=4.438526409D-05
      MASS(9)=5.260389269D-05
      MASS(10)=0.0E+0
C
C COORDINATES AND VELOCITIES AT JD = 2445000.5
C
C SUN
       COORD(1,1)=0.0E+0
       COORD(2,1)=0.0E+0
       COORD(3,1)=0.0E+0
       VELOC(1,1)=0.0E+0
       VELOC(2,1)=0.0E+0
       VELOC(3,1)=0.0E+0
C EARTH
       COORD(1,2)=-0.6377859E+0
       COORD(2,2)= 0.6889529E+0
       COORD(3,2)= 0.2987365E+0
       VELOC(1,2)=-0.01339390E+0
       VELOC(2,2)=-0.01027350E+0
       VELOC(3,2)=-0.00445450E+0
C MERCURY
       COORD(1,3)=-0.1860543E+0
       COORD(2,3)= 0.2277965E+0
       COORD(3,3)= 0.1411025E+0
       VELOC(1,3)=-0.02869247E+0
       VELOC(2,3)=-0.01429456E+0
       VELOC(3,3)=-0.00470887E+0
C VENUS
       COORD(1,4)=-0.5175990E+0
       COORD(2,4)= 0.4412130E+0
       COORD(3,4)= 0.2315258E+0
       VELOC(1,4)=-0.01408315E+0
       VELOC(2,4)=-0.01372171E+0
       VELOC(3,4)=-0.00529464E+0
C MARS
       COORD(1,5)=-1.5956510E+0
       COORD(2,5)= 0.4120496E+0
       COORD(3,5)= 0.2319218E+0
       VELOC(1,5)=-0.00341524E+0
       VELOC(2,5)=-0.01115578E+0
       VELOC(3,5)=-0.00502920E+0
C JUPITER
       COORD(1,6)=-4.781775E+0
       COORD(2,6)=-2.434354E+0
       COORD(3,6)=-0.927398E+0
       VELOC(1,6)= 0.003518375E+0
       VELOC(2,6)=-0.005744183E+0
       VELOC(3,6)=-0.002550130E+0
C SATURN
       COORD(1,7)=-9.254252E+0
       COORD(2,7)=-2.638811E+0
       COORD(3,7)=-0.691216E+0
       VELOC(1,7)= 0.001266071E+0
       VELOC(2,7)=-0.004943432E+0
       VELOC(3,7)=-0.002099096E+0
C URANUS
       COORD(1,8)=-9.20166E+0
       COORD(2,8)=-15.12580E+0
       COORD(3,8)=-6.49732E+0
       VELOC(1,8)= 0.003405804E+0
       VELOC(2,8)=-0.001914694E+0
       VELOC(3,8)=-0.000887230E+0
C NEPTUNE
       COORD(1,9)=-2.94964E+0
       COORD(2,9)=-27.90641E+0
       COORD(3,9)=-11.35732E+0
       VELOC(1,9)= 0.003108391E+0
       VELOC(2,9)=-0.000244522E+0
       VELOC(3,9)=-0.000178528E+0
C PLUTO
       COORD(1,10)=-26.06710E+0
       COORD(2,10)=-14.44072E+0
       COORD(3,10)= 3.33565E+0
       VELOC(1,10)= 0.00163301E+0
       VELOC(2,10)=-0.002786647E+0
       VELOC(3,10)=-0.001374892E+0
C
       RETURN
       END
