C----------------------------------------------------------------------
C
C  M O O N E F
C
C  COMPUTE RIGHT ASCENSION, DECLINATION AND PARALLAX FOR THE 
C  GIVEN EPOCH
C
C----------------------------------------------------------------------
      SUBROUTINE  MOONEF(DAY,HOUR,ALFAM,DELTAM,PARA)
      INTEGER
     .    DAY,     
     .    HOUR     
      REAL
     .    ALFAM,   
     .    DELTAM,  
     .    PARA     
C
      REAL  PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
      COMMON /CONST/    PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
C 
      REAL
     .    T,T2,T3,W,F,
     .    OM,DD,DL,DF,DOM,DDL,DDS,DDN,DPA,DPL,
     .    OL,SS,SPA,DGAC,EK,DGC,A,B,CC,D,AL,
     .    SIP,UTL,UTE,E,CE,CB,SL,
     .    SE,SB,ALFA1,BPERA
C
      REAL CX1(60),CY1(60),CZ1(60),
     .     CX2(64),CY2(64),CZ2(64),
     .     CX3( 5),CY3( 5),CZ3( 5),
     .     CX4(10),CY4(10),CZ4(10),
     .     CX5(14),CY5(14),CZ5(14)
      COMMON /MOONC/ CX1,CX2,CX3,CX4,CX5,
     .               CY1,CY2,CY3,CY4,CY5,
     .               CZ1,CZ2,CZ3,CZ4,CZ5
C ---------------------------------------------------------------------
      T= FLOAT(DAY)-(0.5E+0)+HOUR/24.0E+0
      T2=  T*T
      T3= T2*T
      W=.75120601080E+0+.036601101463356E+0*T-235980D-20*T2
     .   +1077D-25*T3
      OM=.71995354167E+0-.000147094228332E+0*T+432630D-20*T2
     .   + 1266D-25 *T3
      F=.03125246914E+0+.036748195691688E+0*T-668609D-20*T2
     .  - 190D-25 * T3
      DD=.97427079475E+0+.033863192198393E+0*T-299023D-20*T2
     .  +1077D-25*T3
      W=  AMOD(W,1.0E+0)
      OM= AMOD(OM,1.0E+0)
      F=  AMOD(F,1.0E+0)
      DD= AMOD(DD,1.0E+0)
      DL=14.27*SIN((.53733431-10104982D-12*T+191D-16*T2)*PI2)
     .   + 7.261*SIN((.71995354-147094228D-12*T+43D-16*T2)*PI2)
      DOM= 95.96*SIN((.71995354-147094228D-12*T+43D-16*T2)*PI2)
     .  +15.58*SIN((.48398132-147269147D-12*T +43D-16*T2)* PI2)
     .  +1.86* SIN((.52453688-147162675D-12*T +43D-16*T2)* PI2)
      DGAC=-4.318*SIN((.71995354-147094228D-12*T +43D-16*T2)*PI2)
     .  -0.698*SIN((.48398132-147269147D-12*T +43D-16*T2)*PI2)
      DF=DL-DOM
      OM=( OM*360+ DOM/3600)* DTORAD
      F=( F*360+ DF / 3600) * DTORAD
      DD=DD* 360*DTORAD
      DDL=0.0 
      DO 100 I=1,60
        DDL=DDL+CX1(I)*SIN((CY1(I)+CZ1(I)*T)*PI2)
 100  CONTINUE
      DDS=0.0 
      DO 110 I=1,64
        DDS = DDS+CX2(I)*SIN((CY2(I)+CZ2(I)*T)*PI2)
 110  CONTINUE
      DGC=0.0 
      DO 120 I=1,5
        DGC = DGC+CX3(I)*COS((CY3(I)+CZ3(I)*T)*PI2)
 120  CONTINUE
      DDN=0.0 
      DO 130 I=1,10
        DDN = DDN+CX4(I)*SIN((CY4(I)+CZ4(I)*T)*PI2)
 130  CONTINUE
      DPA=0.0 
      DO 140 I=1,14
        DPA = DPA+CX5(I)*COS((CY5(I)+CZ5(I)*T)*PI2)
 140  CONTINUE
      DPL  = 0.0E+0
      OL   = W*360+DL/3600+DDL/3600
      OL   = AMOD(OL, 360.0E+0)
      SS   = F+DDS/3600* DTORAD
      A    = 18519.7E+0 + DGC
      B    =-336992D-9*A
      CC   = 216D-9 * A
      D    = 53996D-9 * A
      DGAC = DGAC/ 3600.0E+0/360.0E+0
      EK   = 1.0+ 2.708D-6  +139.978E+0 * DGAC
      AL   = A*SIN(SS)*EK+B*SIN(3*SS)*EK**3+CC*SIN(5*SS)*EK**5
     .       +D* DDN +DPL
      AL   = AL/3600.0E+0
      SPA  = DPA
      A    = 1.0- 4.6747D-5
      B    = A**3/6.0/206265.0E+0**2
      PARA = SPA*(A+B*SPA*SPA)/3600.0E+0
      T    = T / 36525.0E+0
      UTL  = (( -17.2327E+0 + .01737E+0 * T)*SIN(OM)
     .       + ( -1.2729E+0 -0.00013E+0 *T)* SIN(2 *OM + 2*F - 2 * DD)
     .       + (   .2088E+0 + .00002E+0 * T) * SIN( 2*OM)
     .       + (   .2037E+0 + .00002E+0 * T) * SIN(2* OM +2 * F))/ 3600
      OL   = OL+UTL
      OL   = AMOD(OL, 360.0E+0)
      UTE  = (( 9.21E+0   + .00091E+0 * T) * COS(OM)
     .       +(  .5522E+0 - .00029E+0 * T)* COS(2 *OM +2*F -2 * DD)
     .       +(  .0909E+0 + .00004E+0 * T) * COS(2* OM)
     .       +(  .0884E+0 - .00005E+0 * T) *COS(2*OM+2*F))/ 3600
      E    = 23.0E+0 + 27.0E+0/60.0E+0 +8.26E+0/3600.0E+0 
     .       -46.845E+0*T/3600.0E+0 - .0059E+0*T*T/3600.0E+0
     .       + .00181E+0 * T * T * T / 3600.0E+0
      E    = E+UTE
      SB   = SIN(AL * DTORAD)
      CB   = COS(AL * DTORAD)
      SE   = SIN( E * DTORAD)
      CE   = COS( E * DTORAD)
      SL   = SIN(OL * DTORAD)
      A    = CB * COS(OL * DTORAD)
      B    = CB * SL * CE - SB *SE
      CC   = CB * SL * SE +SB * CE
      DELTAM =ATAN2(CC,SQRT(1.-CC**2))*RTODEG
      BPERA  = B/A
      BPERA  = BPERA/SQRT(1+BPERA*BPERA)
      ALFA1  = ATAN2(BPERA,SQRT(1.E+0-BPERA**2))
      IF (A .LT. 0.0)  ALFA1=ALFA1+PI
      IF (A .GT. 0.0 .AND. B .GT. 0.0) ALFA1=ALFA1 +PI2
      ALFAM  = ALFA1*RTODEG/15.0
      IF (ALFAM .GT. 24.0) ALFAM=ALFAM-24
      IF (ALFAM .LT. 0.0 ) ALFAM=ALFAM+24
      RETURN
      END
