C----------------------------------------------------------------------
C
C  P R E C E S
C  INPUT: RECTANGULAR COORDINATES (X,Y,Z) AT T1
C  OUTPUT: PRECESSED COORDINATS  (XN,YN,ZN) AT T2
C
C----------------------------------------------------------------------
      SUBROUTINE PRECES(T1,T2,X,Y,Z,XN,YN,ZN)
      REAL
     .    T1,         
     .    T2,         
     .    X,Y,Z,      
     .    XN,YN,ZN    
C
      REAL
     .    ZETA,ZEE,THETA,
     .    XX,YX,ZX,
     .    XY,YY,ZY,
     .    XZ,YZ,ZZ,
     .    T0,T,
     .    STORAD
      PARAMETER(STORAD=4.848136811095D-06)
C
      T0=(T1-2415020.313E+0)/36524.22E+0
      T=(T2-T1)/36524.22E+0
      ZETA=STORAD*((2304.25E+0+1.396E+0*T0)*T+
     .      0.302E+0*T*T+0.018E+0*T*T*T)
      ZEE=ZETA+STORAD*(0.791E+0*T*T)
      THETA=STORAD*((2004.682E+0-0.853E+0*T0)*T-
     .      0.426E+0*T*T-0.042E+0*T*T*T)
      XX=COS(ZETA)*COS(THETA)*COS(ZEE)-SIN(ZETA)*SIN(ZEE)
      YX=-SIN(ZETA)*COS(THETA)*COS(ZEE)-COS(ZETA)*SIN(ZEE)
      ZX=-SIN(THETA)*COS(ZEE)
      XY=COS(ZETA)*COS(THETA)*SIN(ZEE)+SIN(ZETA)*COS(ZEE)
      YY=-SIN(ZETA)*COS(THETA)*SIN(ZEE)+COS(ZETA)*COS(ZEE)
      ZY=-SIN(THETA)*SIN(ZEE)
      XZ=COS(ZETA)*SIN(THETA)
      YZ=-SIN(ZETA)*SIN(THETA)
      ZZ=COS(THETA)
      XN=X*XX+Y*YX+Z*ZX
      YN=X*XY+Y*YY+Z*ZY
      ZN=X*XZ+Y*YZ+Z*ZZ
      RETURN
      END
