
      SUBROUTINE HEAD
C   ==================================================================
C   ===                                                            ===
C   ===         This subroutine generates the output header        ===
C   ===                     for benchmark run                      ===
C   ===                                                            ===
C   ==================================================================

      INCLUDE 'qcd2.inc'
      INTEGER  NSWEEP, UNIT
      DOUBLE PRECISION H,  HALFH,  MQUARK,  MSQ 
      COMMON / PARAMS / H,  HALFH,  MQUARK,  MSQ,  NSWEEP

      UNIT = 8
      OPEN(UNIT,FILE = 'result')

      CALL HEADER(UNIT)


C------ Lattice size

      WRITE(UNIT, '(//A,I2,A,I2,A//)') 
     *          '   Lattice size   = ', NT, ' * ', NX, ' ** 3'

      WRITE(UNIT, '( 3(A,A/)//)')
     *'         -------------------------------------------------------'
     *,'--------',
     *'         |                    Results and Timings               '
     *,'       |',
     *'         -------------------------------------------------------'
     *,'--------'


C------ Results heading :

      WRITE(UNIT,  '(3(A,A/))')
     *'   kinetic     potential      total      no. CG   time/CG iter',
     *'    performance',
     *'   energy      energy         energy     iters        (s)     ',
     *'     (Mflop/s) ',
     *'   -------     ---------      ------     -----    ------------',
     *'    ------------'

      END
