
/************************************************************
*
* Test program: tests speed writing float data in three ways:
*
*                  1. to HDF SDS, default conversion
*                  2. to HDF SDS, no conversion
*                  3. to raw file, no conversion
*
* Note: in DFSDsettype routine, parameter #3 (DFNTF_CRAY), should
*       be replaced when using other machines.  Currently, the 
*       only allowable replacement is 0. (July 1990)
*
* Input files:  None.  The data is generated by the program.
* Output files: Three files, named by the user on the command line.
*
************************************************************ */

#include <stdio.h>
#include <fcntl.h> 
#include "df.h"

char *malloc();

main(argc,argv)
int argc;
char *argv[];
{
    uint16 i;
    int j, rank, x, y, fd;
    int dimsizes[2];
    float *pdata,*data;
    long time(), tloc1, tloc2;

    if (argc != 4) {
        printf("Usage: %s out1 out2 out3\n", argv[0]);
        exit(1);
    }

    x = 1000; /*atoi(argv[2]); */
    y =  1000; /* atoi(argv[3]);*/
    data = (float *) malloc(x*y*sizeof(float));

    pdata = data;
    for (i=0; i< x; i++)
       for (j=0; j< y; j++)
           *pdata++ = 10.0;

    rank = 2;
    dimsizes[0]=x;
    dimsizes[1]=y;

    /* write out scientific data set -- default conversion */

    printf("\n");
    tloc1 = time((long *) 0);
    DFSDsetdims(2,dimsizes);
    DFSDputdata(argv[1], rank, dimsizes, data);
    tloc2 = time((long *) 0);
    printf("Default conversion:    %ld\n",tloc2-tloc1);

    /* write out scientific data set -- no conversion */

    printf("\n");
    tloc1 = time((long *) 0);
    DFSDsetdims(2,dimsizes);
    DFSDsettype(DFNT_FLOAT, 0, DFNTF_CRAY, DFO_C);
    DFSDputdata(argv[2], rank, dimsizes, data);
    tloc2 = time((long *) 0);
    printf("No conversion:         %ld\n",tloc2-tloc1);

    /* write out raw data to a file */

    printf("\n");
    tloc1 = time((long *) 0);
    fd = creat (argv[3], 0600);
    write(fd, data, x*y*sizeof(data[0]));
    close (fd);
    tloc2 = time((long *) 0);
    printf("Write raw binary  :    %ld\n",tloc2-tloc1);

}

