/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the mingw-w64 runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#ifndef __ATLWMIPROV_H__
#define __ATLWMIPROV_H__

#ifndef __cplusplus
#error Requires C++ compilation (use a .cpp suffix)
#endif

#include <wbemprov.h>
#include <wmiutils.h>

namespace ATL {
  class ATL_NO_VTABLE IWbemInstProviderImpl : public IWbemServices,public IWbemProviderInit {
  public:
    HRESULT WINAPI OpenNamespace(const BSTR Namespace,__LONG32 lFlags,IWbemContext *pCtx,IWbemServices **ppWorkingNamespace,IWbemCallResult **ppResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI CancelAsyncCall(IWbemObjectSink *pSink) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI QueryObjectSink(__LONG32 lFlags,IWbemObjectSink **ppResponseHandler) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI GetObject(const BSTR ObjectPath,__LONG32 lFlags,IWbemContext *pCtx,IWbemClassObject **ppObject,IWbemCallResult **ppCallResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI PutClass(IWbemClassObject *pObject,__LONG32 lFlags,IWbemContext *pCtx,IWbemCallResult **ppCallResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI PutClassAsync(IWbemClassObject *pObject,__LONG32 lFlags,IWbemContext *pCtx,IWbemObjectSink *pResponseHandler) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI DeleteClass(const BSTR Class,__LONG32 lFlags,IWbemContext *pCtx,IWbemCallResult **ppCallResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI DeleteClassAsync(const BSTR Class,__LONG32 lFlags,IWbemContext *pCtx,IWbemObjectSink *pResponseHandler) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI CreateClassEnum(const BSTR Superclass,__LONG32 lFlags,IWbemContext *pCtx,IEnumWbemClassObject **ppEnum) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI CreateClassEnumAsync(const BSTR Superclass,__LONG32 lFlags,IWbemContext *pCtx,IWbemObjectSink *pResponseHandler) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI PutInstance(IWbemClassObject *pInst,__LONG32 lFlags,IWbemContext *pCtx,IWbemCallResult **ppCallResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI DeleteInstance(const BSTR ObjectPath,__LONG32 lFlags,IWbemContext *pCtx,IWbemCallResult **ppCallResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI CreateInstanceEnum(const BSTR Class,__LONG32 lFlags,IWbemContext *pCtx,IEnumWbemClassObject **ppEnum) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI ExecQuery(const BSTR QueryLanguage,const BSTR Query,__LONG32 lFlags,IWbemContext *pCtx,IEnumWbemClassObject **ppEnum) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI ExecNotificationQuery(const BSTR QueryLanguage,const BSTR Query,__LONG32 lFlags,IWbemContext *pCtx,IEnumWbemClassObject **ppEnum) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI ExecNotificationQueryAsync(const BSTR QueryLanguage,const BSTR Query,__LONG32 lFlags,IWbemContext *pCtx,IWbemObjectSink *pResponseHandler) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI ExecMethod(const BSTR strObjectPath,const BSTR strMethodName,__LONG32 lFlags,IWbemContext *pCtx,IWbemClassObject *pInParams,IWbemClassObject **ppOutParams,IWbemCallResult **ppCallResult) {return WBEM_E_NOT_SUPPORTED;};
    HRESULT WINAPI ExecMethodAsync(const BSTR strObjectPath,const BSTR strMethodName,__LONG32 lFlags,IWbemContext *pCtx,IWbemClassObject *pInParams,IWbemObjectSink *pResponseHandler) {return WBEM_E_NOT_SUPPORTED;};
  };

  class CProviderHelper {
  private:
    CComPtr<IWbemClassObject> m_pErrorObject;
    HRESULT m_hr;
  public:
    CProviderHelper(IWbemServices *pNamespace,IWbemContext *pCtx) {
      m_hr = WBEM_E_FAILED;
      m_pErrorObject = NULL;
      if(!pNamespace) {
	m_hr = WBEM_E_INVALID_PARAMETER;
	ATLASSERT (0);
	return;
      }
      BSTR bstrString = SysAllocString(L"__ExtendedStatus");
      if(!bstrString) {
	m_hr = WBEM_E_OUT_OF_MEMORY;
	return;
      }
      m_hr = pNamespace->GetObject(bstrString,0,pCtx,&m_pErrorObject,NULL);
      SysFreeString(bstrString);
      return;
    }
    virtual ~CProviderHelpe