FUNCTION getWaterViscositySimple( Model, N, temperature ) RESULT(viscosity)

  USE DefUtils
  IMPLICIT NONE
  !------------ external variables ---------------------------
  TYPE(Model_t) :: Model
  INTEGER :: N
  REAL(KIND=dp) :: temperature, viscosity
  !------------ internal variables----------------------------
  REAL(KIND=dp), PARAMETER :: viscA=-1.704_dp, viscB=-5.306_dp,&
       viscC=7.003_dp, referenceVisc= 1.788d-03
  REAL(KIND=dp) :: Z

  IF (Temperature > 0.0_dp) THEN
     Z = 273.15/Temperature
  ELSE
     CALL FATAL("getWaterViscositySimple", "Invalid Temperature value")
  END IF
  viscosity = referenceVisc * EXP(viscA + viscb * Z + viscC * (Z**2))  
END FUNCTION getWaterViscositySimple




