#include <stdio.h>
#include <stdlib.h>

int sort_function(const void *a, const void *b)
{
  int *aa = (int *)a;
  int *bb = (int *)b;
  return ( *aa > *bb ) ? 1 : -1;
}

int main(int argc, char *argv[])
{
  int i;
  int N = atoi(argv[1]);
  int *data;

  printf("N = %d\n",N);

  /* Allocate & initialize data */
  data = (int *)malloc(N*sizeof(*data));
  for (i=0; i<N; i++) data[i] = N-i;

  printf("Data before sort:\n"); 
  for (i=0; i<N; i++)
    printf("%5d%s",data[i],(i+1)%10==0?"\n":"");
  printf("\n");

  /* Apply quicksort */
  qsort(data, N, sizeof(*data), sort_function);

  printf("Data after sort:\n"); 
  for (i=0; i<N; i++) 
    printf("%5d%s",data[i],(i+1)%10==0?"\n":"");
  printf("\n");
  
  return 0;
}
