.\"----------------------------------------------------------------------------
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.\"----------------------------------------------------------------------------
.HS Handles tcl
.ad b
.BS
'@index: Tcl_HandleAlloc Tcl_HandleFree Tcl_HandleTblInit Tcl_HandleTblRelease Tcl_HandleTblUseCount Tcl_HandleWalk Tcl_HandleXlate
.SH NAME
Tcl_HandleAlloc, Tcl_HandleFree, Tcl_HandleTblInit,
Tcl_HandleTblRelease, Tcl_HandleTblUseCount Tcl_HandleWalk, 
Tcl_HandleXlate \- Dynamic, handle addressable tables.

.SH SYNOPSIS
.nf
\fB#include <tclExtend.h>\fR
.sp
void_pt
\fBTcl_HandleTblInit\fR (\fIhandleBase, entrySize, initEntries\fR)
.sp
int
\fBTcl_HandleTblUseCount\fR (\fIheaderPtr, amount\fR)
.sp
void
\fBTcl_HandleTblRelease\fR (\fIheaderPtr\fR)
.sp
void_pt
\fBTcl_HandleAlloc\fR (\fIheaderPtr, handlePtr\fR)
.sp
void
\fBTcl_HandleFree\fR (\fIheaderPtr, entryPtr\fR)
.sp
void_pt
\fBTcl_HandleWalk\fR (\fIheaderPtr, walkKeyPtr\fR)
.sp
void
\fBTcl_WalkKeyToHandle\fR (\fIheaderPtr, walkKey, handlePtr\fR)
.sp
void_pt
\fBTcl_HandleXlate\fR (\fIinterp, headerPtr, handle\fR)
.SH ARGUMENTS
.AS Tcl_Interp *walkKeyPtr
.AP char *handleBase in
Base name for the handle, numeric entry number will be appended. 
.AP int entrySize in
Size of the table entries, in bytes.
.AP int initEntries in
Initial number of entries to allocate.
.AP int amount in
Amount to alter the use count by.
.AP void_pt headerPtr in
Pointer to the header.
.AP char *handlePtr out
The handle name is returned here.  It must be large enough to hold the handle
base name with a number appended.
.AP Tcl_Interp *interp in
Interpreter to use for error reporting.
.AP char *handle in
Name of handle to operate on.
.AP void_pt entryPtr in
Pointer to a handle table entry.
.AP int *walkKeyPtr i/o
Key used to walk the table, initialize to -1 before the first call.
.AP int walkKey in
Key returned from walking the table.
.BE

.SH DESCRIPTION
.PP
The Tcl handle facility provides a way to manage table entries that may be
referenced by a textual handle from Tcl code.  This is provided for 
applications that need to create data structures in one command, return a
reference (i.e. pointer) to that particular data structure and then access
that data structure in other commands. An example application is file handles.
.PP
A handle consists of a base name, which is some unique, meaningful name, such
as `\fBfile\fR' and a numeric value appended to the base name (e.g. `file3').
The handle facility is designed to provide a standard mechanism for building
Tcl commands that allocate and access table entries based on an entry index.
The tables are expanded when needed, consequently pointers to entries should
not be kept, as they will become invalid when the table is expanded.  If the
table entries are large or pointers must be kept to the entries, then the
the entries should be allocated separately and pointers kept in the handle 
table.  A use count is kept on the table.  This use count is intended to
determine when a table shared by multiple commands is to be release.
.PP
\fBTcl_HandleTblInit\fR creates and initialize a Tcl dynamic handle table. 
The specified initial number of entries will be allocated and added to the free
list.  The use count will be set to one.
.PP
\fBTcl_HandleTblUseCount\fR alters the use count on a table and returns the
new value.  The use count has \fIamount\fR added to it, where \fIamount\fR may
be positive, zero or negative.  A zero value retrieves the current use count.
This is normally used to increment the use count when multiple commands are
sharing the table.
.PP
\fBTcl_HandleTblRelease\fR decrements the use count on a table. If it becomes
zero (or negative), the the table will be released. Note that no clean up is
done on the table entry client supplied data.  If clean up must be done, 
then \fBTcl_HandleTblUseCount\fR can be used to decrement the use count.
When it goes to zero, the table may be walked and then released.
\fIHeaderPtr\fR is declared as \fBClientData\fR so that the procedure may
be passed as a command deletion procedure.
.PP
\fBTcl_HandleAlloc\fR allocates an entry and associates a handle with it.
The handle is returned to the buffer pointed to by \fIhandlePtr\fR can then
be used to access the entry.  The buffer must be large enough to accommodate
the base handle name with 2 to 4 digits appended along with a terminating null
byte.
A pointer is returned to the allocated entry.  If \fBTcl_HandleFree\fR
has not been called since initialization, handles will be handed out
sequentially from zero.  This behavior is useful in setting
up initial entries, such as ``\fBstdin\fR'' for a file table.
.PP
\fBTcl_HandleXlate\fR translates a handle to a pointer to the corresponding
table entry.  If the handle is not allocated (open) or is invalid, NULL is
returned and an error message is set in \fIinterp->result\fR.
.PP
\fBTcl_HandleWalk\fR walks through and finds every allocated entry in a table.
Entries may be deallocated during a walk, but should not be allocated.
\fBTcl_HandleWalk\fR
will return a pointer to the entry, or NULL if no more entries are available.
The integer pointed to by \fBwalkKeyPtr\fR should be set to `-1' before the
first call, and then the pointer passed to each subsequent call left 
unmodified.
.PP
\fBTcl_WalkKeyToHandle\fR converts a walk key, as returned from a call to
\fBTcl_HandleWalk\fR into a handle.
.PP
\fBTcl_HandleFree\fR frees a handle table entry.
.SH KEYWORDS
handle, table, allocate
