
#==============================================================================
#
# Portable makefile for TCL extended commands sources.
# This section of this Makefile is extracted from Makefile.t by Configure.
#
# @(#) Makefile.t 2.3 10/2/90
#
#------------------------------------------------------------------------------

SHELL=/bin/sh

OBJS= \
    boyermoo.o     chartype.o     chmod.o        clock.o        cmdloop.o \
    debug.o        extendUtil.o   filescan.o     fmath.o        general.o \
    handles.o      id.o           iocmds.o       list.o         math.o    \
    matherr.o      regexp.o       regexpcmds.o   signal.o  \
    string.o       unixcmds.o     tclstartup.o

BASEDIR= ../..

CFLAGS= -I../../baseline/src ${C_FLAGS} ${GLOBAL_DEFS}

all: ${BASEDIR}/tcl

${BASEDIR}/tcl:	$(BASEDIR)/tcl.a $(OBJS) main.o
	cc ${CFLAGS} main.o ${BASEDIR}/tcl.a ${LINKFLAGS} -o ${BASEDIR}/tcl
	$(STRIP) ${BASEDIR}/tcl
	$(MCS) ${BASEDIR}/tcl

main.o: patchlevel.h Makefile
	cc -c ${CFLAGS} ${DEFAULTFILE} main.c

${BASEDIR}/tcl.a: $(OBJS) 
	ar cru ${BASEDIR}/tcl.a $(OBJS)
	$(RANLIB) ${BASEDIR}/tcl.a

#
# This is just to test if it compiles.
#
tcl++:
	CC -c -I../../baseline/src tcl++.C
	-rm -f tcl++.o
clean:
	-rm -f *.o
	-rm -f ../../tcl
	-rm -f tcl++.o

realclean: clean
	-rm -f Makefile


