/* 
 * matherr.c --
 *
 *   Extended Tcl default matherr routine, may be replace by an application
 *   specified version.
 *---------------------------------------------------------------------------
 * Copyright 1991 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#include <math.h>

/*
 *----------------------------------------------------------------------
 *
 * matherr --
 *    Default matherr routine for extended Tcl.  If the error does not
 *  belong to Tcl, standard math error processing is done.  An
 *  aplication may replace this routine with their own, however it must
 *  call \fBTcl_MathError\fR to check if the error belongs to tcl.
 *
 *----------------------------------------------------------------------
 */
#ifndef TCL_386BSD
int
matherr (except)
    struct exception *except;
{
    if (Tcl_MathError (except->name, except->type))
        return 1;
    else
        return 0;
}
#else
int
matherr (except)
    void *except;
{
    return 0;
}
#endif
