/*	$NetBSD: proc.h,v 1.15 2011/07/03 02:18:20 matt Exp $	*/

/*
 * Copyright (c) 1991 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)proc.h	7.1 (Berkeley) 5/15/91
 */

#ifndef _VAX_PROC_H_
#define _VAX_PROC_H_

/*
 * Machine-dependent lwp struct for vax,
 */
struct mdlwp {
	struct trapframe *md_utf;	/* pointer to user trapframe */
};

struct trapframe;
/*
 * Machine-dependent part of the proc structure for vax.
 */
struct mdproc {
	/* Syscall handling function */
	void    (*md_syscall)(struct trapframe *);

};

/* md_flags */
#define	MDP_AST		0x0001	/* async trap pending */

/* kernel stack params */
#define	KSTACK_LOWEST_ADDR(l)	\
	((char *)(l)->l_addr + (REDZONEADDR + VAX_NBPG))
#define	KSTACK_SIZE	\
	(USPACE - (REDZONEADDR + VAX_NBPG))

#endif /* _VAX_PROC_H_ */
