#include <stdio.h>
#include <kernel-offsets.h>

#define SHOW_INT(sym) printf("#define %s %d\n", #sym, sym)
#define SHOW_STR(sym) printf("#define %s %s\n", #sym, sym)

int main(int argc, char **argv)
{
  printf("/*\n");
  printf(" * Generated by mk_constants\n");
  printf(" */\n");
  printf("\n");
  printf("#ifndef __UM_CONSTANTS_H\n");
  printf("#define __UM_CONSTANTS_H\n");
  printf("\n");

  SHOW_INT(UM_KERN_PAGE_SIZE);

  SHOW_STR(UM_KERN_EMERG);
  SHOW_STR(UM_KERN_ALERT);
  SHOW_STR(UM_KERN_CRIT);
  SHOW_STR(UM_KERN_ERR);
  SHOW_STR(UM_KERN_WARNING);
  SHOW_STR(UM_KERN_NOTICE);
  SHOW_STR(UM_KERN_INFO);
  SHOW_STR(UM_KERN_DEBUG);

  SHOW_INT(UM_NSEC_PER_SEC);
  printf("\n");
  printf("#endif\n");
  return(0);
}
