/*
 * File:         include/asm-blackfin/mach-bf549/cdefBF549.h
 * Based on:
 * Author:
 *
 * Created:
 * Description:
 *
 * Rev:
 *
 * Modified:
 *
 * Bugs:         Enter bugs at http://blackfin.uclinux.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.
 * If not, write to the Free Software Foundation,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CDEF_BF549_H
#define _CDEF_BF549_H

/* include all Core registers and bit definitions */
#include "defBF549.h"

/* include core sbfin_read_()ecific register pointer definitions */
#include <asm/mach-common/cdef_LPBlackfin.h>

/* SYSTEM & MMR ADDRESS DEFINITIONS FOR ADSP-BF549 */

/* include cdefBF54x_base.h for the set of #defines that are common to all ADSP-BF54x bfin_read_()rocessors */
#include "cdefBF54x_base.h"

/* The following are the #defines needed by ADSP-BF549 that are not in the common header */

/* Timer Registers */

#define bfin_read_TIMER8_CONFIG()		bfin_read16(TIMER8_CONFIG)
#define bfin_write_TIMER8_CONFIG(val)		bfin_write16(TIMER8_CONFIG, val)
#define bfin_read_TIMER8_COUNTER()		bfin_read32(TIMER8_COUNTER)
#define bfin_write_TIMER8_COUNTER(val)		bfin_write32(TIMER8_COUNTER, val)
#define bfin_read_TIMER8_PERIOD()		bfin_read32(TIMER8_PERIOD)
#define bfin_write_TIMER8_PERIOD(val)		bfin_write32(TIMER8_PERIOD, val)
#define bfin_read_TIMER8_WIDTH()		bfin_read32(TIMER8_WIDTH)
#define bfin_write_TIMER8_WIDTH(val)		bfin_write32(TIMER8_WIDTH, val)
#define bfin_read_TIMER9_CONFIG()		bfin_read16(TIMER9_CONFIG)
#define bfin_write_TIMER9_CONFIG(val)		bfin_write16(TIMER9_CONFIG, val)
#define bfin_read_TIMER9_COUNTER()		bfin_read32(TIMER9_COUNTER)
#define bfin_write_TIMER9_COUNTER(val)		bfin_write32(TIMER9_COUNTER, val)
#define bfin_read_TIMER9_PERIOD()		bfin_read32(TIMER9_PERIOD)
#define bfin_write_TIMER9_PERIOD(val)		bfin_write32(TIMER9_PERIOD, val)
#define bfin_read_TIMER9_WIDTH()		bfin_read32(TIMER9_WIDTH)
#define bfin_write_TIMER9_WIDTH(val)		bfin_write32(TIMER9_WIDTH, val)
#define bfin_read_TIMER10_CONFIG()		bfin_read16(TIMER10_CONFIG)
#define bfin_write_TIMER10_CONFIG(val)		bfin_write16(TIMER10_CONFIG, val)
#define bfin_read_TIMER10_COUNTER()		bfin_read32(TIMER10_COUNTER)
#define bfin_write_TIMER10_COUNTER(val)		bfin_write32(TIMER10_COUNTER, val)
#define bfin_read_TIMER10_PERIOD()		bfin_read32(TIMER10_PERIOD)
#define bfin_write_TIMER10_PERIOD(val)		bfin_write32(TIMER10_PERIOD, val)
#define bfin_read_TIMER10_WIDTH()		bfin_read32(TIMER10_WIDTH)
#define bfin_write_TIMER10_WIDTH(val)		bfin_write32(TIMER10_WIDTH, val)

/* Timer Groubfin_read_() of 3 */

#define bfin_read_TIMER_ENABLE1()		bfin_read16(TIMER_ENABLE1)
#define bfin_write_TIMER_ENABLE1(val)		bfin_write16(TIMER_ENABLE1, val)
#define bfin_read_TIMER_DISABLE1()		bfin_read16(TIMER_DISABLE1)
#define bfin_write_TIMER_DISABLE1(val)		bfin_write16(TIMER_DISABLE1, val)
#define bfin_read_TIMER_STATUS1()		bfin_read32(TIMER_STATUS1)
#define bfin_write_TIMER_STATUS1(val)		bfin_write32(TIMER_STATUS1, val)

/* SPORT0 Registers */

#define bfin_read_SPORT0_TCR1()			bfin_read16(SPORT0_TCR1)
#define bfin_write_SPORT0_TCR1(val)		bfin_write16(SPORT0_TCR1, val)
#define bfin_read_SPORT0_TCR2()			bfin_read16(SPORT0_TCR2)
#define bfin_write_SPORT0_TCR2(val)		bfin_write16(SPORT0_TCR2, val)
#define bfin_read_SPORT0_TCLKDIV()		bfin_read16(SPORT0_TCLKDIV)
#define bfin_write_SPORT0_TCLKDIV(val)		bfin_write16(SPORT0_TCLKDIV, val)
#define bfin_read_SPORT0_TFSDIV()		bfin_read16(SPORT0_TFSDIV)
#define bfin_write_SPORT0_TFSDIV(val)		bfin_write16(SPORT0_TFSDIV, val)
#define bfin_read_SPORT0_TX()			bfin_read32(SPORT0_TX)
#define bfin_write_SPORT0_TX(val)		bfin_write32(SPORT0_TX, val)
#define bfin_read_SPORT0_RX()			bfin_read32(SPORT0_RX)
#define bfin_write_SPORT0_RX(val)		bfin_write32(SPORT0_RX, val)
#define bfin_read_SPORT0_RCR1()			bfin_read16(SPORT0_RCR1)
#define bfin_write_SPORT0_RCR1(val)		bfin_write16(SPORT0_RCR1, val)
#define bfin_read_SPORT0_RCR2()			bfin_read16(SPORT0_RCR2)
#define bfin_write_SPORT0_RCR2(val)		bfin_write16(SPORT0_RCR2, val)
#define bfin_read_SPORT0_RCLKDIV()		bfin_read16(SPORT0_RCLKDIV)
#define bfin_write_SPORT0_RCLKDIV(val)		bfin_write16(SPORT0_RCLKDIV, val)
#define bfin_read_SPORT0_RFSDIV()		bfin_read16(SPORT0_RFSDIV)
#define bfin_write_SPORT0_RFSDIV(val)		bfin_write16(SPORT0_RFSDIV, val)
#define bfin_read_SPORT0_STAT()			bfin_read16(SPORT0_STAT)
#define bfin_write_SPORT0_STAT(val)		bfin_write16(SPORT0_STAT, val)
#define bfin_read_SPORT0_CHNL()			bfin_read16(SPORT0_CHNL)
#define bfin_write_SPORT0_CHNL(val)		bfin_write16(SPORT0_CHNL, val)
#define bfin_read_SPORT0_MCMC1()		bfin_read16(SPORT0_MCMC1)
#define bfin_write_SPORT0_MCMC1(val)		bfin_write16(SPORT0_MCMC1, val)
#define bfin_read_SPORT0_MCMC2()		bfin_read16(SPORT0_MCMC2)
#define bfin_write_SPORT0_MCMC2(val)		bfin_write16(SPORT0_MCMC2, val)
#define bfin_read_SPORT0_MTCS0()		bfin_read32(SPORT0_MTCS0)
#define bfin_write_SPORT0_MTCS0(val)		bfin_write32(SPORT0_MTCS0, val)
#define bfin_read_SPORT0_MTCS1()		bfin_read32(SPORT0_MTCS1)
#define bfin_write_SPORT0_MTCS1(val)		bfin_write32(SPORT0_MTCS1, val)
#define bfin_read_SPORT0_MTCS2()		bfin_read32(SPORT0_MTCS2)
#define bfin_write_SPORT0_MTCS2(val)		bfin_write32(SPORT0_MTCS2, val)
#define bfin_read_SPORT0_MTCS3()		bfin_read32(SPORT0_MTCS3)
#define bfin_write_SPORT0_MTCS3(val)		bfin_write32(SPORT0_MTCS3, val)
#define bfin_read_SPORT0_MRCS0()		bfin_read32(SPORT0_MRCS0)
#define bfin_write_SPORT0_MRCS0(val)		bfin_write32(SPORT0_MRCS0, val)
#define bfin_read_SPORT0_MRCS1()		bfin_read32(SPORT0_MRCS1)
#define bfin_write_SPORT0_MRCS1(val)		bfin_write32(SPORT0_MRCS1, val)
#define bfin_read_SPORT0_MRCS2()		bfin_read32(SPORT0_MRCS2)
#define bfin_write_SPORT0_MRCS2(val)		bfin_write32(SPORT0_MRCS2, val)
#define bfin_read_SPORT0_MRCS3()		bfin_read32(SPORT0_MRCS3)
#define bfin_write_SPORT0_MRCS3(val)		bfin_write32(SPORT0_MRCS3, val)

/* EPPI0 Registers */

#define bfin_read_EPPI0_STATUS()		bfin_read16(EPPI0_STATUS)
#define bfin_write_EPPI0_STATUS(val)		bfin_write16(EPPI0_STATUS, val)
#define bfin_read_EPPI0_HCOUNT()		bfin_read16(EPPI0_HCOUNT)
#define bfin_write_EPPI0_HCOUNT(val)		bfin_write16(EPPI0_HCOUNT, val)
#define bfin_read_EPPI0_HDELAY()		bfin_read16(EPPI0_HDELAY)
#define bfin_write_EPPI0_HDELAY(val)		bfin_write16(EPPI0_HDELAY, val)
#define bfin_read_EPPI0_VCOUNT()		bfin_read16(EPPI0_VCOUNT)
#define bfin_write_EPPI0_VCOUNT(val)		bfin_write16(EPPI0_VCOUNT, val)
#define bfin_read_EPPI0_VDELAY()		bfin_read16(EPPI0_VDELAY)
#define bfin_write_EPPI0_VDELAY(val)		bfin_write16(EPPI0_VDELAY, val)
#define bfin_read_EPPI0_FRAME()			bfin_read16(EPPI0_FRAME)
#define bfin_write_EPPI0_FRAME(val)		bfin_write16(EPPI0_FRAME, val)
#define bfin_read_EPPI0_LINE()			bfin_read16(EPPI0_LINE)
#define bfin_write_EPPI0_LINE(val)		bfin_write16(EPPI0_LINE, val)
#define bfin_read_EPPI0_CLKDIV()		bfin_read16(EPPI0_CLKDIV)
#define bfin_write_EPPI0_CLKDIV(val)		bfin_write16(EPPI0_CLKDIV, val)
#define bfin_read_EPPI0_CONTROL()		bfin_read32(EPPI0_CONTROL)
#define bfin_write_EPPI0_CONTROL(val)		bfin_write32(EPPI0_CONTROL, val)
#define bfin_read_EPPI0_FS1W_HBL()		bfin_read32(EPPI0_FS1W_HBL)
#define bfin_write_EPPI0_FS1W_HBL(val)		bfin_write32(EPPI0_FS1W_HBL, val)
#define bfin_read_EPPI0_FS1P_AVPL()		bfin_read32(EPPI0_FS1P_AVPL)
#define bfin_write_EPPI0_FS1P_AVPL(val)		bfin_write32(EPPI0_FS1P_AVPL, val)
#define bfin_read_EPPI0_FS2W_LVB()		bfin_read32(EPPI0_FS2W_LVB)
#define bfin_write_EPPI0_FS2W_LVB(val)		bfin_write32(EPPI0_FS2W_LVB, val)
#define bfin_read_EPPI0_FS2P_LAVF()		bfin_read32(EPPI0_FS2P_LAVF)
#define bfin_write_EPPI0_FS2P_LAVF(val)		bfin_write32(EPPI0_FS2P_LAVF, val)
#define bfin_read_EPPI0_CLIP()			bfin_read32(EPPI0_CLIP)
#define bfin_write_EPPI0_CLIP(val)		bfin_write32(EPPI0_CLIP, val)

/* UART2 Registers */

#define bfin_read_UART2_DLL()			bfin_read16(UART2_DLL)
#define bfin_write_UART2_DLL(val)		bfin_write16(UART2_DLL, val)
#define bfin_read_UART2_DLH()			bfin_read16(UART2_DLH)
#define bfin_write_UART2_DLH(val)		bfin_write16(UART2_DLH, val)
#define bfin_read_UART2_GCTL()			bfin_read16(UART2_GCTL)
#define bfin_write_UART2_GCTL(val)		bfin_write16(UART2_GCTL, val)
#define bfin_read_UART2_LCR()			bfin_read16(UART2_LCR)
#define bfin_write_UART2_LCR(val)		bfin_write16(UART2_LCR, val)
#define bfin_read_UART2_MCR()			bfin_read16(UART2_MCR)
#define bfin_write_UART2_MCR(val)		bfin_write16(UART2_MCR, val)
#define bfin_read_UART2_LSR()			bfin_read16(UART2_LSR)
#define bfin_write_UART2_LSR(val)		bfin_write16(UART2_LSR, val)
#define bfin_read_UART2_MSR()			bfin_read16(UART2_MSR)
#define bfin_write_UART2_MSR(val)		bfin_write16(UART2_MSR, val)
#define bfin_read_UART2_SCR()			bfin_read16(UART2_SCR)
#define bfin_write_UART2_SCR(val)		bfin_write16(UART2_SCR, val)
#define bfin_read_UART2_IER_SET()		bfin_read16(UART2_IER_SET)
#define bfin_write_UART2_IER_SET(val)		bfin_write16(UART2_IER_SET, val)
#define bfin_read_UART2_IER_CLEAR()		bfin_read16(UART2_IER_CLEAR)
#define bfin_write_UART2_IER_CLEAR(val)		bfin_write16(UART2_IER_CLEAR, val)
#define bfin_read_UART2_RBR()			bfin_read16(UART2_RBR)
#define bfin_write_UART2_RBR(val)		bfin_write16(UART2_RBR, val)

/* Two Wire Interface Registers (TWI1) */

#define bfin_read_TWI1_CLKDIV()			bfin_read16(TWI1_CLKDIV)
#define bfin_write_TWI1_CLKDIV(val)		bfin_write16(TWI1_CLKDIV, val)
#define bfin_read_TWI1_CONTROL()		bfin_read16(TWI1_CONTROL)
#define bfin_write_TWI1_CONTROL(val)		bfin_write16(TWI1_CONTROL, val)
#define bfin_read_TWI1_SLAVE_CTRL()		bfin_read16(TWI1_SLAVE_CTRL)
#define bfin_write_TWI1_SLAVE_CTRL(val)		bfin_write16(TWI1_SLAVE_CTRL, val)
#define bfin_read_TWI1_SLAVE_STAT()		bfin_read16(TWI1_SLAVE_STAT)
#define bfin_write_TWI1_SLAVE_STAT(val)		bfin_write16(TWI1_SLAVE_STAT, val)
#define bfin_read_TWI1_SLAVE_ADDR()		bfin_read16(TWI1_SLAVE_ADDR)
#define bfin_write_TWI1_SLAVE_ADDR(val)		bfin_write16(TWI1_SLAVE_ADDR, val)
#define bfin_read_TWI1_MASTER_CTRL()		bfin_read16(TWI1_MASTER_CTRL)
#define bfin_write_TWI1_MASTER_CTRL(val)	bfin_write16(TWI1_MASTER_CTRL, val)
#define bfin_read_TWI1_MASTER_STAT()		bfin_read16(TWI1_MASTER_STAT)
#define bfin_write_TWI1_MASTER_STAT(val)	bfin_write16(TWI1_MASTER_STAT, val)
#define bfin_read_TWI1_MASTER_ADDR()		bfin_read16(TWI1_MASTER_ADDR)
#define bfin_write_TWI1_MASTER_ADDR(val)	bfin_write16(TWI1_MASTER_ADDR, val)
#define bfin_read_TWI1_INT_STAT()		bfin_read16(TWI1_INT_STAT)
#define bfin_write_TWI1_INT_STAT(val)		bfin_write16(TWI1_INT_STAT, val)
#define bfin_read_TWI1_INT_MASK()		bfin_read16(TWI1_INT_MASK)
#define bfin_write_TWI1_INT_MASK(val)		bfin_write16(TWI1_INT_MASK, val)
#define bfin_read_TWI1_FIFO_CTRL()		bfin_read16(TWI1_FIFO_CTRL)
#define bfin_write_TWI1_FIFO_CTRL(val)		bfin_write16(TWI1_FIFO_CTRL, val)
#define bfin_read_TWI1_FIFO_STAT()		bfin_read16(TWI1_FIFO_STAT)
#define bfin_write_TWI1_FIFO_STAT(val)		bfin_write16(TWI1_FIFO_STAT, val)
#define bfin_read_TWI1_XMT_DATA8()		bfin_read16(TWI1_XMT_DATA8)
#define bfin_write_TWI1_XMT_DATA8(val)		bfin_write16(TWI1_XMT_DATA8, val)
#define bfin_read_TWI1_XMT_DATA16()		bfin_read16(TWI1_XMT_DATA16)
#define bfin_write_TWI1_XMT_DATA16(val)		bfin_write16(TWI1_XMT_DATA16, val)
#define bfin_read_TWI1_RCV_DATA8()		bfin_read16(TWI1_RCV_DATA8)
#define bfin_write_TWI1_RCV_DATA8(val)		bfin_write16(TWI1_RCV_DATA8, val)
#define bfin_read_TWI1_RCV_DATA16()		bfin_read16(TWI1_RCV_DATA16)
#define bfin_write_TWI1_RCV_DATA16(val)		bfin_write16(TWI1_RCV_DATA16, val)

/* SPI2 Registers */

#define bfin_read_SPI2_CTL()		bfin_read16(SPI2_CTL)
#define bfin_write_SPI2_CTL(val)	bfin_write16(SPI2_CTL, val)
#define bfin_read_SPI2_FLG()		bfin_read16(SPI2_FLG)
#define bfin_write_SPI2_FLG(val)	bfin_write16(SPI2_FLG, val)
#define bfin_read_SPI2_STAT()		bfin_read16(SPI2_STAT)
#define bfin_write_SPI2_STAT(val)	bfin_write16(SPI2_STAT, val)
#define bfin_read_SPI2_TDBR()		bfin_read16(SPI2_TDBR)
#define bfin_write_SPI2_TDBR(val)	bfin_write16(SPI2_TDBR, val)
#define bfin_read_SPI2_RDBR()		bfin_read16(SPI2_RDBR)
#define bfin_write_SPI2_RDBR(val)	bfin_write16(SPI2_RDBR, val)
#define bfin_read_SPI2_BAUD()		bfin_read16(SPI2_BAUD)
#define bfin_write_SPI2_BAUD(val)	bfin_write16(SPI2_BAUD, val)
#define bfin_read_SPI2_SHADOW()		bfin_read16(SPI2_SHADOW)
#define bfin_write_SPI2_SHADOW(val)	bfin_write16(SPI2_SHADOW, val)

/* MXVR Registers */

#define bfin_read_MXVR_CONFIG()			bfin_read16(MXVR_CONFIG)
#define bfin_write_MXVR_CONFIG(val)		bfin_write16(MXVR_CONFIG, val)
#define bfin_read_MXVR_STATE_0()		bfin_read32(MXVR_STATE_0)
#define bfin_write_MXVR_STATE_0(val)		bfin_write32(MXVR_STATE_0, val)
#define bfin_read_MXVR_STATE_1()		bfin_read32(MXVR_STATE_1)
#define bfin_write_MXVR_STATE_1(val)		bfin_write32(MXVR_STATE_1, val)
#define bfin_read_MXVR_INT_STAT_0()		bfin_read32(MXVR_INT_STAT_0)
#define bfin_write_MXVR_INT_STAT_0(val)		bfin_write32(MXVR_INT_STAT_0, val)
#define bfin_read_MXVR_INT_STAT_1()		bfin_read32(MXVR_INT_STAT_1)
#define bfin_write_MXVR_INT_STAT_1(val)		bfin_write32(MXVR_INT_STAT_1, val)
#define bfin_read_MXVR_INT_EN_0()		bfin_read32(MXVR_INT_EN_0)
#define bfin_write_MXVR_INT_EN_0(val)		bfin_write32(MXVR_INT_EN_0, val)
#define bfin_read_MXVR_INT_EN_1()		bfin_read32(MXVR_INT_EN_1)
#define bfin_write_MXVR_INT_EN_1(val)		bfin_write32(MXVR_INT_EN_1, val)
#define bfin_read_MXVR_POSITION()		bfin_read16(MXVR_POSITION)
#define bfin_write_MXVR_POSITION(val)		bfin_write16(MXVR_POSITION, val)
#define bfin_read_MXVR_MAX_POSITION()		bfin_read16(MXVR_MAX_POSITION)
#define bfin_write_MXVR_MAX_POSITION(val)	bfin_write16(MXVR_MAX_POSITION, val)
#define bfin_read_MXVR_DELAY()			bfin_read16(MXVR_DELAY)
#define bfin_write_MXVR_DELAY(val)		bfin_write16(MXVR_DELAY, val)
#define bfin_read_MXVR_MAX_DELAY()		bfin_read16(MXVR_MAX_DELAY)
#define bfin_write_MXVR_MAX_DELAY(val)		bfin_write16(MXVR_MAX_DELAY, val)
#define bfin_read_MXVR_LADDR()			bfin_read32(MXVR_LADDR)
#define bfin_write_MXVR_LADDR(val)		bfin_write32(MXVR_LADDR, val)
#define bfin_read_MXVR_GADDR()			bfin_read16(MXVR_GADDR)
#define bfin_write_MXVR_GADDR(val)		bfin_write16(MXVR_GADDR, val)
#define bfin_read_MXVR_AADDR()			bfin_read32(MXVR_AADDR)
#define bfin_write_MXVR_AADDR(val)		bfin_write32(MXVR_AADDR, val)

/* MXVR Allocation Table Registers */

#define bfin_read_MXVR_ALLOC_0()		bfin_read32(MXVR_ALLOC_0)
#define bfin_write_MXVR_ALLOC_0(val)		bfin_write32(MXVR_ALLOC_0, val)
#define bfin_read_MXVR_ALLOC_1()		bfin_read32(MXVR_ALLOC_1)
#define bfin_write_MXVR_ALLOC_1(val)		bfin_write32(MXVR_ALLOC_1, val)
#define bfin_read_MXVR_ALLOC_2()		bfin_read32(MXVR_ALLOC_2)
#define bfin_write_MXVR_ALLOC_2(val)		bfin_write32(MXVR_ALLOC_2, val)
#define bfin_read_MXVR_ALLOC_3()		bfin_read32(MXVR_ALLOC_3)
#define bfin_write_MXVR_ALLOC_3(val)		bfin_write32(MXVR_ALLOC_3, val)
#define bfin_read_MXVR_ALLOC_4()		bfin_read32(MXVR_ALLOC_4)
#define bfin_write_MXVR_ALLOC_4(val)		bfin_write32(MXVR_ALLOC_4, val)
#define bfin_read_MXVR_ALLOC_5()		bfin_read32(MXVR_ALLOC_5)
#define bfin_write_MXVR_ALLOC_5(val)		bfin_write32(MXVR_ALLOC_5, val)
#define bfin_read_MXVR_ALLOC_6()		bfin_read32(MXVR_ALLOC_6)
#define bfin_write_MXVR_ALLOC_6(val)		bfin_write32(MXVR_ALLOC_6, val)
#define bfin_read_MXVR_ALLOC_7()		bfin_read32(MXVR_ALLOC_7)
#define bfin_write_MXVR_ALLOC_7(val)		bfin_write32(MXVR_ALLOC_7, val)
#define bfin_read_MXVR_ALLOC_8()		bfin_read32(MXVR_ALLOC_8)
#define bfin_write_MXVR_ALLOC_8(val)		bfin_write32(MXVR_ALLOC_8, val)
#define bfin_read_MXVR_ALLOC_9()		bfin_read32(MXVR_ALLOC_9)
#define bfin_write_MXVR_ALLOC_9(val)		bfin_write32(MXVR_ALLOC_9, val)
#define bfin_read_MXVR_ALLOC_10()		bfin_read32(MXVR_ALLOC_10)
#define bfin_write_MXVR_ALLOC_10(val)		bfin_write32(MXVR_ALLOC_10, val)
#define bfin_read_MXVR_ALLOC_11()		bfin_read32(MXVR_ALLOC_11)
#define bfin_write_MXVR_ALLOC_11(val)		bfin_write32(MXVR_ALLOC_11, val)
#define bfin_read_MXVR_ALLOC_12()		bfin_read32(MXVR_ALLOC_12)
#define bfin_write_MXVR_ALLOC_12(val)		bfin_write32(MXVR_ALLOC_12, val)
#define bfin_read_MXVR_ALLOC_13()		bfin_read32(MXVR_ALLOC_13)
#define bfin_write_MXVR_ALLOC_13(val)		bfin_write32(MXVR_ALLOC_13, val)
#define bfin_read_MXVR_ALLOC_14()		bfin_read32(MXVR_ALLOC_14)
#define bfin_write_MXVR_ALLOC_14(val)		bfin_write32(MXVR_ALLOC_14, val)

/* MXVR Channel Assign Registers */

#define bfin_read_MXVR_SYNC_LCHAN_0()		bfin_read32(MXVR_SYNC_LCHAN_0)
#define bfin_write_MXVR_SYNC_LCHAN_0(val)	bfin_write32(MXVR_SYNC_LCHAN_0, val)
#define bfin_read_MXVR_SYNC_LCHAN_1()		bfin_read32(MXVR_SYNC_LCHAN_1)
#define bfin_write_MXVR_SYNC_LCHAN_1(val)	bfin_write32(MXVR_SYNC_LCHAN_1, val)
#define bfin_read_MXVR_SYNC_LCHAN_2()		bfin_read32(MXVR_SYNC_LCHAN_2)
#define bfin_write_MXVR_SYNC_LCHAN_2(val)	bfin_write32(MXVR_SYNC_LCHAN_2, val)
#define bfin_read_MXVR_SYNC_LCHAN_3()		bfin_read32(MXVR_SYNC_LCHAN_3)
#define bfin_write_MXVR_SYNC_LCHAN_3(val)	bfin_write32(MXVR_SYNC_LCHAN_3, val)
#define bfin_read_MXVR_SYNC_LCHAN_4()		bfin_read32(MXVR_SYNC_LCHAN_4)
#define bfin_write_MXVR_SYNC_LCHAN_4(val)	bfin_write32(MXVR_SYNC_LCHAN_4, val)
#define bfin_read_MXVR_SYNC_LCHAN_5()		bfin_read32(MXVR_SYNC_LCHAN_5)
#define bfin_write_MXVR_SYNC_LCHAN_5(val)	bfin_write32(MXVR_SYNC_LCHAN_5, val)
#define bfin_read_MXVR_SYNC_LCHAN_6()		bfin_read32(MXVR_SYNC_LCHAN_6)
#define bfin_write_MXVR_SYNC_LCHAN_6(val)	bfin_write32(MXVR_SYNC_LCHAN_6, val)
#define bfin_read_MXVR_SYNC_LCHAN_7()		bfin_read32(MXVR_SYNC_LCHAN_7)
#define bfin_write_MXVR_SYNC_LCHAN_7(val)	bfin_write32(MXVR_SYNC_LCHAN_7, val)

/* MXVR DMA0 Registers */

#define bfin_read_MXVR_DMA0_CONFIG()		bfin_read32(MXVR_DMA0_CONFIG)
#define bfin_write_MXVR_DMA0_CONFIG(val)	bfin_write32(MXVR_DMA0_CONFIG, val)
#define bfin_read_MXVR_DMA0_START_ADDR()	bfin_read32(MXVR_DMA0_START_ADDR)
#define bfin_write_MXVR_DMA0_START_ADDR(val)	bfin_write32(MXVR_DMA0_START_ADDR)
#define bfin_read_MXVR_DMA0_COUNT()		bfin_read16(MXVR_DMA0_COUNT)
#define bfin_write_MXVR_DMA0_COUNT(val)		bfin_write16(MXVR_DMA0_COUNT, val)
#define bfin_read_MXVR_DMA0_CURR_ADDR()		bfin_read32(MXVR_DMA0_CURR_ADDR)
#define bfin_write_MXVR_DMA0_CURR_ADDR(val)	bfin_write32(MXVR_DMA0_CURR_ADDR)
#define bfin_read_MXVR_DMA0_CURR_COUNT()	bfin_read16(MXVR_DMA0_CURR_COUNT)
#define bfin_write_MXVR_DMA0_CURR_COUNT(val)	bfin_write16(MXVR_DMA0_CURR_COUNT, val)

/* MXVR DMA1 Registers */

#define bfin_read_MXVR_DMA1_CONFIG()		bfin_read32(MXVR_DMA1_CONFIG)
#define bfin_write_MXVR_DMA1_CONFIG(val)	bfin_write32(MXVR_DMA1_CONFIG, val)
#define bfin_read_MXVR_DMA1_START_ADDR()	bfin_read32(MXVR_DMA1_START_ADDR)
#define bfin_write_MXVR_DMA1_START_ADDR(val)	bfin_write32(MXVR_DMA1_START_ADDR)
#define bfin_read_MXVR_DMA1_COUNT()		bfin_read16(MXVR_DMA1_COUNT)
#define bfin_write_MXVR_DMA1_COUNT(val)		bfin_write16(MXVR_DMA1_COUNT, val)
#define bfin_read_MXVR_DMA1_CURR_ADDR()		bfin_read32(MXVR_DMA1_CURR_ADDR)
#define bfin_write_MXVR_DMA1_CURR_ADDR(val)	bfin_write32(MXVR_DMA1_CURR_ADDR)
#define bfin_read_MXVR_DMA1_CURR_COUNT()	bfin_read16(MXVR_DMA1_CURR_COUNT)
#define bfin_write_MXVR_DMA1_CURR_COUNT(val)	bfin_write16(MXVR_DMA1_CURR_COUNT, val)

/* MXVR DMA2 Registers */

#define bfin_read_MXVR_DMA2_CONFIG()		bfin_read32(MXVR_DMA2_CONFIG)
#define bfin_write_MXVR_DMA2_CONFIG(val)	bfin_write32(MXVR_DMA2_CONFIG, val)
#define bfin_read_MXVR_DMA2_START_ADDR() 	bfin_read32(MXVR_DMA2_START_ADDR)
#define bfin_write_MXVR_DMA2_START_ADDR(val) 	bfin_write32(MXVR_DMA2_START_ADDR)
#define bfin_read_MXVR_DMA2_COUNT()		bfin_read16(MXVR_DMA2_COUNT)
#define bfin_write_MXVR_DMA2_COUNT(val)		bfin_write16(MXVR_DMA2_COUNT, val)
#define bfin_read_MXVR_DMA2_CURR_ADDR() 	bfin_read32(MXVR_DMA2_CURR_ADDR)
#define bfin_write_MXVR_DMA2_CURR_ADDR(val) 	bfin_write32(MXVR_DMA2_CURR_ADDR)
#define bfin_read_MXVR_DMA2_CURR_COUNT()	bfin_read16(MXVR_DMA2_CURR_COUNT)
#define bfin_write_MXVR_DMA2_CURR_COUNT(val)	bfin_write16(MXVR_DMA2_CURR_COUNT, val)

/* MXVR DMA3 Registers */

#define bfin_read_MXVR_DMA3_CONFIG()		bfin_read32(MXVR_DMA3_CONFIG)
#define bfin_write_MXVR_DMA3_CONFIG(val)	bfin_write32(MXVR_DMA3_CONFIG, val)
#define bfin_read_MXVR_DMA3_START_ADDR() 	bfin_read32(MXVR_DMA3_START_ADDR)
#define bfin_write_MXVR_DMA3_START_ADDR(val) 	bfin_write32(MXVR_DMA3_START_ADDR)
#define bfin_read_MXVR_DMA3_COUNT()		bfin_read16(MXVR_DMA3_COUNT)
#define bfin_write_MXVR_DMA3_COUNT(val)		bfin_write16(MXVR_DMA3_COUNT, val)
#define bfin_read_MXVR_DMA3_CURR_ADDR() 	bfin_read32(MXVR_DMA3_CURR_ADDR)
#define bfin_write_MXVR_DMA3_CURR_ADDR(val) 	bfin_write32(MXVR_DMA3_CURR_ADDR)
#define bfin_read_MXVR_DMA3_CURR_COUNT()	bfin_read16(MXVR_DMA3_CURR_COUNT)
#define bfin_write_MXVR_DMA3_CURR_COUNT(val)	bfin_write16(MXVR_DMA3_CURR_COUNT, val)

/* MXVR DMA4 Registers */

#define bfin_read_MXVR_DMA4_CONFIG()		bfin_read32(MXVR_DMA4_CONFIG)
#define bfin_write_MXVR_DMA4_CONFIG(val)	bfin_write32(MXVR_DMA4_CONFIG, val)
#define bfin_read_MXVR_DMA4_START_ADDR() 	bfin_read32(MXVR_DMA4_START_ADDR)
#define bfin_write_MXVR_DMA4_START_ADDR(val) 	bfin_write32(MXVR_DMA4_START_ADDR)
#define bfin_read_MXVR_DMA4_COUNT()		bfin_read16(MXVR_DMA4_COUNT)
#define bfin_write_MXVR_DMA4_COUNT(val)		bfin_write16(MXVR_DMA4_COUNT, val)
#define bfin_read_MXVR_DMA4_CURR_ADDR() 	bfin_read32(MXVR_DMA4_CURR_ADDR)
#define bfin_write_MXVR_DMA4_CURR_ADDR(val) 	bfin_write32(MXVR_DMA4_CURR_ADDR)
#define bfin_read_MXVR_DMA4_CURR_COUNT()	bfin_read16(MXVR_DMA4_CURR_COUNT)
#define bfin_write_MXVR_DMA4_CURR_COUNT(val)	bfin_write16(MXVR_DMA4_CURR_COUNT, val)

/* MXVR DMA5 Registers */

#define bfin_read_MXVR_DMA5_CONFIG()		bfin_read32(MXVR_DMA5_CONFIG)
#define bfin_write_MXVR_DMA5_CONFIG(val)	bfin_write32(MXVR_DMA5_CONFIG, val)
#define bfin_read_MXVR_DMA5_START_ADDR() 	bfin_read32(MXVR_DMA5_START_ADDR)
#define bfin_write_MXVR_DMA5_START_ADDR(val) 	bfin_write32(MXVR_DMA5_START_ADDR)
#define bfin_read_MXVR_DMA5_COUNT()		bfin_read16(MXVR_DMA5_COUNT)
#define bfin_write_MXVR_DMA5_COUNT(val)		bfin_write16(MXVR_DMA5_COUNT, val)
#define bfin_read_MXVR_DMA5_CURR_ADDR() 	bfin_read32(MXVR_DMA5_CURR_ADDR)
#define bfin_write_MXVR_DMA5_CURR_ADDR(val) 	bfin_write32(MXVR_DMA5_CURR_ADDR)
#define bfin_read_MXVR_DMA5_CURR_COUNT()	bfin_read16(MXVR_DMA5_CURR_COUNT)
#define bfin_write_MXVR_DMA5_CURR_COUNT(val)	bfin_write16(MXVR_DMA5_CURR_COUNT, val)

/* MXVR DMA6 Registers */

#define bfin_read_MXVR_DMA6_CONFIG()		bfin_read32(MXVR_DMA6_CONFIG)
#define bfin_write_MXVR_DMA6_CONFIG(val)	bfin_write32(MXVR_DMA6_CONFIG, val)
#define bfin_read_MXVR_DMA6_START_ADDR() 	bfin_read32(MXVR_DMA6_START_ADDR)
#define bfin_write_MXVR_DMA6_START_ADDR(val) 	bfin_write32(MXVR_DMA6_START_ADDR)
#define bfin_read_MXVR_DMA6_COUNT()		bfin_read16(MXVR_DMA6_COUNT)
#define bfin_write_MXVR_DMA6_COUNT(val)		bfin_write16(MXVR_DMA6_COUNT, val)
#define bfin_read_MXVR_DMA6_CURR_ADDR() 	bfin_read32(MXVR_DMA6_CURR_ADDR)
#define bfin_write_MXVR_DMA6_CURR_ADDR(val) 	bfin_write32(MXVR_DMA6_CURR_ADDR)
#define bfin_read_MXVR_DMA6_CURR_COUNT()	bfin_read16(MXVR_DMA6_CURR_COUNT)
#define bfin_write_MXVR_DMA6_CURR_COUNT(val)	bfin_write16(MXVR_DMA6_CURR_COUNT, val)

/* MXVR DMA7 Registers */

#define bfin_read_MXVR_DMA7_CONFIG()		bfin_read32(MXVR_DMA7_CONFIG)
#define bfin_write_MXVR_DMA7_CONFIG(val)	bfin_write32(MXVR_DMA7_CONFIG, val)
#define bfin_read_MXVR_DMA7_START_ADDR() 	bfin_read32(MXVR_DMA7_START_ADDR)
#define bfin_write_MXVR_DMA7_START_ADDR(val) 	bfin_write32(MXVR_DMA7_START_ADDR)
#define bfin_read_MXVR_DMA7_COUNT()		bfin_read16(MXVR_DMA7_COUNT)
#define bfin_write_MXVR_DMA7_COUNT(val)		bfin_write16(MXVR_DMA7_COUNT, val)
#define bfin_read_MXVR_DMA7_CURR_ADDR() 	bfin_read32(MXVR_DMA7_CURR_ADDR)
#define bfin_write_MXVR_DMA7_CURR_ADDR(val) 	bfin_write32(MXVR_DMA7_CURR_ADDR)
#define bfin_read_MXVR_DMA7_CURR_COUNT()	bfin_read16(MXVR_DMA7_CURR_COUNT)
#define bfin_write_MXVR_DMA7_CURR_COUNT(val)	bfin_write16(MXVR_DMA7_CURR_COUNT, val)

/* MXVR Asynch Packet Registers */

#define bfin_read_MXVR_AP_CTL()			bfin_read16(MXVR_AP_CTL)
#define bfin_write_MXVR_AP_CTL(val)		bfin_write16(MXVR_AP_CTL, val)
#define bfin_read_MXVR_APRB_START_ADDR() 	bfin_read32(MXVR_APRB_START_ADDR)
#define bfin_write_MXVR_APRB_START_ADDR(val) 	bfin_write32(MXVR_APRB_START_ADDR)
#define bfin_read_MXVR_APRB_CURR_ADDR() 	bfin_read32(MXVR_APRB_CURR_ADDR)
#define bfin_write_MXVR_APRB_CURR_ADDR(val) 	bfin_write32(MXVR_APRB_CURR_ADDR)
#define bfin_read_MXVR_APTB_START_ADDR() 	bfin_read32(MXVR_APTB_START_ADDR)
#define bfin_write_MXVR_APTB_START_ADDR(val) 	bfin_write32(MXVR_APTB_START_ADDR)
#define bfin_read_MXVR_APTB_CURR_ADDR() 	bfin_read32(MXVR_APTB_CURR_ADDR)
#define bfin_write_MXVR_APTB_CURR_ADDR(val) 	bfin_write32(MXVR_APTB_CURR_ADDR)

/* MXVR Control Message Registers */

#define bfin_read_MXVR_CM_CTL()			bfin_read32(MXVR_CM_CTL)
#define bfin_write_MXVR_CM_CTL(val)		bfin_write32(MXVR_CM_CTL, val)
#define bfin_read_MXVR_CMRB_START_ADDR() 	bfin_read32(MXVR_CMRB_START_ADDR)
#define bfin_write_MXVR_CMRB_START_ADDR(val) 	bfin_write32(MXVR_CMRB_START_ADDR)
#define bfin_read_MXVR_CMRB_CURR_ADDR() 	bfin_read32(MXVR_CMRB_CURR_ADDR)
#define bfin_write_MXVR_CMRB_CURR_ADDR(val) 	bfin_write32(MXVR_CMRB_CURR_ADDR)
#define bfin_read_MXVR_CMTB_START_ADDR() 	bfin_read32(MXVR_CMTB_START_ADDR)
#define bfin_write_MXVR_CMTB_START_ADDR(val) 	bfin_write32(MXVR_CMTB_START_ADDR)
#define bfin_read_MXVR_CMTB_CURR_ADDR() 	bfin_read32(MXVR_CMTB_CURR_ADDR)
#define bfin_write_MXVR_CMTB_CURR_ADDR(val) 	bfin_write32(MXVR_CMTB_CURR_ADDR)

/* MXVR Remote Read Registers */

#define bfin_read_MXVR_RRDB_START_ADDR() 	bfin_read32(MXVR_RRDB_START_ADDR)
#define bfin_write_MXVR_RRDB_START_ADDR(val) 	bfin_write32(MXVR_RRDB_START_ADDR)
#define bfin_read_MXVR_RRDB_CURR_ADDR() 	bfin_read32(MXVR_RRDB_CURR_ADDR)
#define bfin_write_MXVR_RRDB_CURR_ADDR(val) 	bfin_write32(MXVR_RRDB_CURR_ADDR)

/* MXVR Pattern Data Registers */

#define bfin_read_MXVR_PAT_DATA_0()		bfin_read32(MXVR_PAT_DATA_0)
#define bfin_write_MXVR_PAT_DATA_0(val)		bfin_write32(MXVR_PAT_DATA_0, val)
#define bfin_read_MXVR_PAT_EN_0()		bfin_read32(MXVR_PAT_EN_0)
#define bfin_write_MXVR_PAT_EN_0(val)		bfin_write32(MXVR_PAT_EN_0, val)
#define bfin_read_MXVR_PAT_DATA_1()		bfin_read32(MXVR_PAT_DATA_1)
#define bfin_write_MXVR_PAT_DATA_1(val)		bfin_write32(MXVR_PAT_DATA_1, val)
#define bfin_read_MXVR_PAT_EN_1()		bfin_read32(MXVR_PAT_EN_1)
#define bfin_write_MXVR_PAT_EN_1(val)		bfin_write32(MXVR_PAT_EN_1, val)

/* MXVR Frame Counter Registers */

#define bfin_read_MXVR_FRAME_CNT_0()		bfin_read16(MXVR_FRAME_CNT_0)
#define bfin_write_MXVR_FRAME_CNT_0(val)	bfin_write16(MXVR_FRAME_CNT_0, val)
#define bfin_read_MXVR_FRAME_CNT_1()		bfin_read16(MXVR_FRAME_CNT_1)
#define bfin_write_MXVR_FRAME_CNT_1(val)	bfin_write16(MXVR_FRAME_CNT_1, val)

/* MXVR Routing Table Registers */

#define bfin_read_MXVR_ROUTING_0()		bfin_read32(MXVR_ROUTING_0)
#define bfin_write_MXVR_ROUTING_0(val)		bfin_write32(MXVR_ROUTING_0, val)
#define bfin_read_MXVR_ROUTING_1()		bfin_read32(MXVR_ROUTING_1)
#define bfin_write_MXVR_ROUTING_1(val)		bfin_write32(MXVR_ROUTING_1, val)
#define bfin_read_MXVR_ROUTING_2()		bfin_read32(MXVR_ROUTING_2)
#define bfin_write_MXVR_ROUTING_2(val)		bfin_write32(MXVR_ROUTING_2, val)
#define bfin_read_MXVR_ROUTING_3()		bfin_read32(MXVR_ROUTING_3)
#define bfin_write_MXVR_ROUTING_3(val)		bfin_write32(MXVR_ROUTING_3, val)
#define bfin_read_MXVR_ROUTING_4()		bfin_read32(MXVR_ROUTING_4)
#define bfin_write_MXVR_ROUTING_4(val)		bfin_write32(MXVR_ROUTING_4, val)
#define bfin_read_MXVR_ROUTING_5()		bfin_read32(MXVR_ROUTING_5)
#define bfin_write_MXVR_ROUTING_5(val)		bfin_write32(MXVR_ROUTING_5, val)
#define bfin_read_MXVR_ROUTING_6()		bfin_read32(MXVR_ROUTING_6)
#define bfin_write_MXVR_ROUTING_6(val)		bfin_write32(MXVR_ROUTING_6, val)
#define bfin_read_MXVR_ROUTING_7()		bfin_read32(MXVR_ROUTING_7)
#define bfin_write_MXVR_ROUTING_7(val)		bfin_write32(MXVR_ROUTING_7, val)
#define bfin_read_MXVR_ROUTING_8()		bfin_read32(MXVR_ROUTING_8)
#define bfin_write_MXVR_ROUTING_8(val)		bfin_write32(MXVR_ROUTING_8, val)
#define bfin_read_MXVR_ROUTING_9()		bfin_read32(MXVR_ROUTING_9)
#define bfin_write_MXVR_ROUTING_9(val)		bfin_write32(MXVR_ROUTING_9, val)
#define bfin_read_MXVR_ROUTING_10()		bfin_read32(MXVR_ROUTING_10)
#define bfin_write_MXVR_ROUTING_10(val)		bfin_write32(MXVR_ROUTING_10, val)
#define bfin_read_MXVR_ROUTING_11()		bfin_read32(MXVR_ROUTING_11)
#define bfin_write_MXVR_ROUTING_11(val)		bfin_write32(MXVR_ROUTING_11, val)
#define bfin_read_MXVR_ROUTING_12()		bfin_read32(MXVR_ROUTING_12)
#define bfin_write_MXVR_ROUTING_12(val)		bfin_write32(MXVR_ROUTING_12, val)
#define bfin_read_MXVR_ROUTING_13()		bfin_read32(MXVR_ROUTING_13)
#define bfin_write_MXVR_ROUTING_13(val)		bfin_write32(MXVR_ROUTING_13, val)
#define bfin_read_MXVR_ROUTING_14()		bfin_read32(MXVR_ROUTING_14)
#define bfin_write_MXVR_ROUTING_14(val)		bfin_write32(MXVR_ROUTING_14, val)

/* MXVR Counter-Clock-Control Registers */

#define bfin_read_MXVR_BLOCK_CNT()		bfin_read16(MXVR_BLOCK_CNT)
#define bfin_write_MXVR_BLOCK_CNT(val)		bfin_write16(MXVR_BLOCK_CNT, val)
#define bfin_read_MXVR_CLK_CTL()		bfin_read32(MXVR_CLK_CTL)
#define bfin_write_MXVR_CLK_CTL(val)		bfin_write32(MXVR_CLK_CTL, val)
#define bfin_read_MXVR_CDRPLL_CTL()		bfin_read32(MXVR_CDRPLL_CTL)
#define bfin_write_MXVR_CDRPLL_CTL(val)		bfin_write32(MXVR_CDRPLL_CTL, val)
#define bfin_read_MXVR_FMPLL_CTL()		bfin_read32(MXVR_FMPLL_CTL)
#define bfin_write_MXVR_FMPLL_CTL(val)		bfin_write32(MXVR_FMPLL_CTL, val)
#define bfin_read_MXVR_PIN_CTL()		bfin_read16(MXVR_PIN_CTL)
#define bfin_write_MXVR_PIN_CTL(val)		bfin_write16(MXVR_PIN_CTL, val)
#define bfin_read_MXVR_SCLK_CNT()		bfin_read16(MXVR_SCLK_CNT)
#define bfin_write_MXVR_SCLK_CNT(val)		bfin_write16(MXVR_SCLK_CNT, val)

/* CAN Controller 1 Config 1 Registers */

#define bfin_read_CAN1_MC1()		bfin_read16(CAN1_MC1)
#define bfin_write_CAN1_MC1(val)	bfin_write16(CAN1_MC1, val)
#define bfin_read_CAN1_MD1()		bfin_read16(CAN1_MD1)
#define bfin_write_CAN1_MD1(val)	bfin_write16(CAN1_MD1, val)
#define bfin_read_CAN1_TRS1()		bfin_read16(CAN1_TRS1)
#define bfin_write_CAN1_TRS1(val)	bfin_write16(CAN1_TRS1, val)
#define bfin_read_CAN1_TRR1()		bfin_read16(CAN1_TRR1)
#define bfin_write_CAN1_TRR1(val)	bfin_write16(CAN1_TRR1, val)
#define bfin_read_CAN1_TA1()		bfin_read16(CAN1_TA1)
#define bfin_write_CAN1_TA1(val)	bfin_write16(CAN1_TA1, val)
#define bfin_read_CAN1_AA1()		bfin_read16(CAN1_AA1)
#define bfin_write_CAN1_AA1(val)	bfin_write16(CAN1_AA1, val)
#define bfin_read_CAN1_RMP1()		bfin_read16(CAN1_RMP1)
#define bfin_write_CAN1_RMP1(val)	bfin_write16(CAN1_RMP1, val)
#define bfin_read_CAN1_RML1()		bfin_read16(CAN1_RML1)
#define bfin_write_CAN1_RML1(val)	bfin_write16(CAN1_RML1, val)
#define bfin_read_CAN1_MBTIF1()		bfin_read16(CAN1_MBTIF1)
#define bfin_write_CAN1_MBTIF1(val)	bfin_write16(CAN1_MBTIF1, val)
#define bfin_read_CAN1_MBRIF1()		bfin_read16(CAN1_MBRIF1)
#define bfin_write_CAN1_MBRIF1(val)	bfin_write16(CAN1_MBRIF1, val)
#define bfin_read_CAN1_MBIM1()		bfin_read16(CAN1_MBIM1)
#define bfin_write_CAN1_MBIM1(val)	bfin_write16(CAN1_MBIM1, val)
#define bfin_read_CAN1_RFH1()		bfin_read16(CAN1_RFH1)
#define bfin_write_CAN1_RFH1(val)	bfin_write16(CAN1_RFH1, val)
#define bfin_read_CAN1_OPSS1()		bfin_read16(CAN1_OPSS1)
#define bfin_write_CAN1_OPSS1(val)	bfin_write16(CAN1_OPSS1, val)

/* CAN Controller 1 Config 2 Registers */

#define bfin_read_CAN1_MC2()		bfin_read16(CAN1_MC2)
#define bfin_write_CAN1_MC2(val)	bfin_write16(CAN1_MC2, val)
#define bfin_read_CAN1_MD2()		bfin_read16(CAN1_MD2)
#define bfin_write_CAN1_MD2(val)	bfin_write16(CAN1_MD2, val)
#define bfin_read_CAN1_TRS2()		bfin_read16(CAN1_TRS2)
#define bfin_write_CAN1_TRS2(val)	bfin_write16(CAN1_TRS2, val)
#define bfin_read_CAN1_TRR2()		bfin_read16(CAN1_TRR2)
#define bfin_write_CAN1_TRR2(val)	bfin_write16(CAN1_TRR2, val)
#define bfin_read_CAN1_TA2()		bfin_read16(CAN1_TA2)
#define bfin_write_CAN1_TA2(val)	bfin_write16(CAN1_TA2, val)
#define bfin_read_CAN1_AA2()		bfin_read16(CAN1_AA2)
#define bfin_write_CAN1_AA2(val)	bfin_write16(CAN1_AA2, val)
#define bfin_read_CAN1_RMP2()		bfin_read16(CAN1_RMP2)
#define bfin_write_CAN1_RMP2(val)	bfin_write16(CAN1_RMP2, val)
#define bfin_read_CAN1_RML2()		bfin_read16(CAN1_RML2)
#define bfin_write_CAN1_RML2(val)	bfin_write16(CAN1_RML2, val)
#define bfin_read_CAN1_MBTIF2()		bfin_read16(CAN1_MBTIF2)
#define bfin_write_CAN1_MBTIF2(val)	bfin_write16(CAN1_MBTIF2, val)
#define bfin_read_CAN1_MBRIF2()		bfin_read16(CAN1_MBRIF2)
#define bfin_write_CAN1_MBRIF2(val)	bfin_write16(CAN1_MBRIF2, val)
#define bfin_read_CAN1_MBIM2()		bfin_read16(CAN1_MBIM2)
#define bfin_write_CAN1_MBIM2(val)	bfin_write16(CAN1_MBIM2, val)
#define bfin_read_CAN1_RFH2()		bfin_read16(CAN1_RFH2)
#define bfin_write_CAN1_RFH2(val)	bfin_write16(CAN1_RFH2, val)
#define bfin_read_CAN1_OPSS2()		bfin_read16(CAN1_OPSS2)
#define bfin_write_CAN1_OPSS2(val)	bfin_write16(CAN1_OPSS2, val)

/* CAN Controller 1 Clock/Interrubfin_read_()t/Counter Registers */

#define bfin_read_CAN1_CLOCK()		bfin_read16(CAN1_CLOCK)
#define bfin_write_CAN1_CLOCK(val)	bfin_write16(CAN1_CLOCK, val)
#define bfin_read_CAN1_TIMING()		bfin_read16(CAN1_TIMING)
#define bfin_write_CAN1_TIMING(val)	bfin_write16(CAN1_TIMING, val)
#define bfin_read_CAN1_DEBUG()		bfin_read16(CAN1_DEBUG)
#define bfin_write_CAN1_DEBUG(val)	bfin_write16(CAN1_DEBUG, val)
#define bfin_read_CAN1_STATUS()		bfin_read16(CAN1_STATUS)
#define bfin_write_CAN1_STATUS(val)	bfin_write16(CAN1_STATUS, val)
#define bfin_read_CAN1_CEC()		bfin_read16(CAN1_CEC)
#define bfin_write_CAN1_CEC(val)	bfin_write16(CAN1_CEC, val)
#define bfin_read_CAN1_GIS()		bfin_read16(CAN1_GIS)
#define bfin_write_CAN1_GIS(val)	bfin_write16(CAN1_GIS, val)
#define bfin_read_CAN1_GIM()		bfin_read16(CAN1_GIM)
#define bfin_write_CAN1_GIM(val)	bfin_write16(CAN1_GIM, val)
#define bfin_read_CAN1_GIF()		bfin_read16(CAN1_GIF)
#define bfin_write_CAN1_GIF(val)	bfin_write16(CAN1_GIF, val)
#define bfin_read_CAN1_CONTROL()	bfin_read16(CAN1_CONTROL)
#define bfin_write_CAN1_CONTROL(val)	bfin_write16(CAN1_CONTROL, val)
#define bfin_read_CAN1_INTR()		bfin_read16(CAN1_INTR)
#define bfin_write_CAN1_INTR(val)	bfin_write16(CAN1_INTR, val)
#define bfin_read_CAN1_MBTD()		bfin_read16(CAN1_MBTD)
#define bfin_write_CAN1_MBTD(val)	bfin_write16(CAN1_MBTD, val)
#define bfin_read_CAN1_EWR()		bfin_read16(CAN1_EWR)
#define bfin_write_CAN1_EWR(val)	bfin_write16(CAN1_EWR, val)
#define bfin_read_CAN1_ESR()		bfin_read16(CAN1_ESR)
#define bfin_write_CAN1_ESR(val)	bfin_write16(CAN1_ESR, val)
#define bfin_read_CAN1_UCCNT()		bfin_read16(CAN1_UCCNT)
#define bfin_write_CAN1_UCCNT(val)	bfin_write16(CAN1_UCCNT, val)
#define bfin_read_CAN1_UCRC()		bfin_read16(CAN1_UCRC)
#define bfin_write_CAN1_UCRC(val)	bfin_write16(CAN1_UCRC, val)
#define bfin_read_CAN1_UCCNF()		bfin_read16(CAN1_UCCNF)
#define bfin_write_CAN1_UCCNF(val)	bfin_write16(CAN1_UCCNF, val)

/* CAN Controller 1 Mailbox Accebfin_read_()tance Registers */

#define bfin_read_CAN1_AM00L()		bfin_read16(CAN1_AM00L)
#define bfin_write_CAN1_AM00L(val)	bfin_write16(CAN1_AM00L, val)
#define bfin_read_CAN1_AM00H()		bfin_read16(CAN1_AM00H)
#define bfin_write_CAN1_AM00H(val)	bfin_write16(CAN1_AM00H, val)
#define bfin_read_CAN1_AM01L()		bfin_read16(CAN1_AM01L)
#define bfin_write_CAN1_AM01L(val)	bfin_write16(CAN1_AM01L, val)
#define bfin_read_CAN1_AM01H()		bfin_read16(CAN1_AM01H)
#define bfin_write_CAN1_AM01H(val)	bfin_write16(CAN1_AM01H, val)
#define bfin_read_CAN1_AM02L()		bfin_read16(CAN1_AM02L)
#define bfin_write_CAN1_AM02L(val)	bfin_write16(CAN1_AM02L, val)
#define bfin_read_CAN1_AM02H()		bfin_read16(CAN1_AM02H)
#define bfin_write_CAN1_AM02H(val)	bfin_write16(CAN1_AM02H, val)
#define bfin_read_CAN1_AM03L()		bfin_read16(CAN1_AM03L)
#define bfin_write_CAN1_AM03L(val)	bfin_write16(CAN1_AM03L, val)
#define bfin_read_CAN1_AM03H()		bfin_read16(CAN1_AM03H)
#define bfin_write_CAN1_AM03H(val)	bfin_write16(CAN1_AM03H, val)
#define bfin_read_CAN1_AM04L()		bfin_read16(CAN1_AM04L)
#define bfin_write_CAN1_AM04L(val)	bfin_write16(CAN1_AM04L, val)
#define bfin_read_CAN1_AM04H()		bfin_read16(CAN1_AM04H)
#define bfin_write_CAN1_AM04H(val)	bfin_write16(CAN1_AM04H, val)
#define bfin_read_CAN1_AM05L()		bfin_read16(CAN1_AM05L)
#define bfin_write_CAN1_AM05L(val)	bfin_write16(CAN1_AM05L, val)
#define bfin_read_CAN1_AM05H()		bfin_read16(CAN1_AM05H)
#define bfin_write_CAN1_AM05H(val)	bfin_write16(CAN1_AM05H, val)
#define bfin_read_CAN1_AM06L()		bfin_read16(CAN1_AM06L)
#define bfin_write_CAN1_AM06L(val)	bfin_write16(CAN1_AM06L, val)
#define bfin_read_CAN1_AM06H()		bfin_read16(CAN1_AM06H)
#define bfin_write_CAN1_AM06H(val)	bfin_write16(CAN1_AM06H, val)
#define bfin_read_CAN1_AM07L()		bfin_read16(CAN1_AM07L)
#define bfin_write_CAN1_AM07L(val)	bfin_write16(CAN1_AM07L, val)
#define bfin_read_CAN1_AM07H()		bfin_read16(CAN1_AM07H)
#define bfin_write_CAN1_AM07H(val)	bfin_write16(CAN1_AM07H, val)
#define bfin_read_CAN1_AM08L()		bfin_read16(CAN1_AM08L)
#define bfin_write_CAN1_AM08L(val)	bfin_write16(CAN1_AM08L, val)
#define bfin_read_CAN1_AM08H()		bfin_read16(CAN1_AM08H)
#define bfin_write_CAN1_AM08H(val)	bfin_write16(CAN1_AM08H, val)
#define bfin_read_CAN1_AM09L()		bfin_read16(CAN1_AM09L)
#define bfin_write_CAN1_AM09L(val)	bfin_write16(CAN1_AM09L, val)
#define bfin_read_CAN1_AM09H()		bfin_read16(CAN1_AM09H)
#define bfin_write_CAN1_AM09H(val)	bfin_write16(CAN1_AM09H, val)
#define bfin_read_CAN1_AM10L()		bfin_read16(CAN1_AM10L)
#define bfin_write_CAN1_AM10L(val)	bfin_write16(CAN1_AM10L, val)
#define bfin_read_CAN1_AM10H()		bfin_read16(CAN1_AM10H)
#define bfin_write_CAN1_AM10H(val)	bfin_write16(CAN1_AM10H, val)
#define bfin_read_CAN1_AM11L()		bfin_read16(CAN1_AM11L)
#define bfin_write_CAN1_AM11L(val)	bfin_write16(CAN1_AM11L, val)
#define bfin_read_CAN1_AM11H()		bfin_read16(CAN1_AM11H)
#define bfin_write_CAN1_AM11H(val)	bfin_write16(CAN1_AM11H, val)
#define bfin_read_CAN1_AM12L()		bfin_read16(CAN1_AM12L)
#define bfin_write_CAN1_AM12L(val)	bfin_write16(CAN1_AM12L, val)
#define bfin_read_CAN1_AM12H()		bfin_read16(CAN1_AM12H)
#define bfin_write_CAN1_AM12H(val)	bfin_write16(CAN1_AM12H, val)
#define bfin_read_CAN1_AM13L()		bfin_read16(CAN1_AM13L)
#define bfin_write_CAN1_AM13L(val)	bfin_write16(CAN1_AM13L, val)
#define bfin_read_CAN1_AM13H()		bfin_read16(CAN1_AM13H)
#define bfin_write_CAN1_AM13H(val)	bfin_write16(CAN1_AM13H, val)
#define bfin_read_CAN1_AM14L()		bfin_read16(CAN1_AM14L)
#define bfin_write_CAN1_AM14L(val)	bfin_write16(CAN1_AM14L, val)
#define bfin_read_CAN1_AM14H()		bfin_read16(CAN1_AM14H)
#define bfin_write_CAN1_AM14H(val)	bfin_write16(CAN1_AM14H, val)
#define bfin_read_CAN1_AM15L()		bfin_read16(CAN1_AM15L)
#define bfin_write_CAN1_AM15L(val)	bfin_write16(CAN1_AM15L, val)
#define bfin_read_CAN1_AM15H()		bfin_read16(CAN1_AM15H)
#define bfin_write_CAN1_AM15H(val)	bfin_write16(CAN1_AM15H, val)

/* CAN Controller 1 Mailbox Accebfin_read_()tance Registers */

#define bfin_read_CAN1_AM16L()		bfin_read16(CAN1_AM16L)
#define bfin_write_CAN1_AM16L(val)	bfin_write16(CAN1_AM16L, val)
#define bfin_read_CAN1_AM16H()		bfin_read16(CAN1_AM16H)
#define bfin_write_CAN1_AM16H(val)	bfin_write16(CAN1_AM16H, val)
#define bfin_read_CAN1_AM17L()		bfin_read16(CAN1_AM17L)
#define bfin_write_CAN1_AM17L(val)	bfin_write16(CAN1_AM17L, val)
#define bfin_read_CAN1_AM17H()		bfin_read16(CAN1_AM17H)
#define bfin_write_CAN1_AM17H(val)	bfin_write16(CAN1_AM17H, val)
#define bfin_read_CAN1_AM18L()		bfin_read16(CAN1_AM18L)
#define bfin_write_CAN1_AM18L(val)	bfin_write16(CAN1_AM18L, val)
#define bfin_read_CAN1_AM18H()		bfin_read16(CAN1_AM18H)
#define bfin_write_CAN1_AM18H(val)	bfin_write16(CAN1_AM18H, val)
#define bfin_read_CAN1_AM19L()		bfin_read16(CAN1_AM19L)
#define bfin_write_CAN1_AM19L(val)	bfin_write16(CAN1_AM19L, val)
#define bfin_read_CAN1_AM19H()		bfin_read16(CAN1_AM19H)
#define bfin_write_CAN1_AM19H(val)	bfin_write16(CAN1_AM19H, val)
#define bfin_read_CAN1_AM20L()		bfin_read16(CAN1_AM20L)
#define bfin_write_CAN1_AM20L(val)	bfin_write16(CAN1_AM20L, val)
#define bfin_read_CAN1_AM20H()		bfin_read16(CAN1_AM20H)
#define bfin_write_CAN1_AM20H(val)	bfin_write16(CAN1_AM20H, val)
#define bfin_read_CAN1_AM21L()		bfin_read16(CAN1_AM21L)
#define bfin_write_CAN1_AM21L(val)	bfin_write16(CAN1_AM21L, val)
#define bfin_read_CAN1_AM21H()		bfin_read16(CAN1_AM21H)
#define bfin_write_CAN1_AM21H(val)	bfin_write16(CAN1_AM21H, val)
#define bfin_read_CAN1_AM22L()		bfin_read16(CAN1_AM22L)
#define bfin_write_CAN1_AM22L(val)	bfin_write16(CAN1_AM22L, val)
#define bfin_read_CAN1_AM22H()		bfin_read16(CAN1_AM22H)
#define bfin_write_CAN1_AM22H(val)	bfin_write16(CAN1_AM22H, val)
#define bfin_read_CAN1_AM23L()		bfin_read16(CAN1_AM23L)
#define bfin_write_CAN1_AM23L(val)	bfin_write16(CAN1_AM23L, val)
#define bfin_read_CAN1_AM23H()		bfin_read16(CAN1_AM23H)
#define bfin_write_CAN1_AM23H(val)	bfin_write16(CAN1_AM23H, val)
#define bfin_read_CAN1_AM24L()		bfin_read16(CAN1_AM24L)
#define bfin_write_CAN1_AM24L(val)	bfin_write16(CAN1_AM24L, val)
#define bfin_read_CAN1_AM24H()		bfin_read16(CAN1_AM24H)
#define bfin_write_CAN1_AM24H(val)	bfin_write16(CAN1_AM24H, val)
#define bfin_read_CAN1_AM25L()		bfin_read16(CAN1_AM25L)
#define bfin_write_CAN1_AM25L(val)	bfin_write16(CAN1_AM25L, val)
#define bfin_read_CAN1_AM25H()		bfin_read16(CAN1_AM25H)
#define bfin_write_CAN1_AM25H(val)	bfin_write16(CAN1_AM25H, val)
#define bfin_read_CAN1_AM26L()		bfin_read16(CAN1_AM26L)
#define bfin_write_CAN1_AM26L(val)	bfin_write16(CAN1_AM26L, val)
#define bfin_read_CAN1_AM26H()		bfin_read16(CAN1_AM26H)
#define bfin_write_CAN1_AM26H(val)	bfin_write16(CAN1_AM26H, val)
#define bfin_read_CAN1_AM27L()		bfin_read16(CAN1_AM27L)
#define bfin_write_CAN1_AM27L(val)	bfin_write16(CAN1_AM27L, val)
#define bfin_read_CAN1_AM27H()		bfin_read16(CAN1_AM27H)
#define bfin_write_CAN1_AM27H(val)	bfin_write16(CAN1_AM27H, val)
#define bfin_read_CAN1_AM28L()		bfin_read16(CAN1_AM28L)
#define bfin_write_CAN1_AM28L(val)	bfin_write16(CAN1_AM28L, val)
#define bfin_read_CAN1_AM28H()		bfin_read16(CAN1_AM28H)
#define bfin_write_CAN1_AM28H(val)	bfin_write16(CAN1_AM28H, val)
#define bfin_read_CAN1_AM29L()		bfin_read16(CAN1_AM29L)
#define bfin_write_CAN1_AM29L(val)	bfin_write16(CAN1_AM29L, val)
#define bfin_read_CAN1_AM29H()		bfin_read16(CAN1_AM29H)
#define bfin_write_CAN1_AM29H(val)	bfin_write16(CAN1_AM29H, val)
#define bfin_read_CAN1_AM30L()		bfin_read16(CAN1_AM30L)
#define bfin_write_CAN1_AM30L(val)	bfin_write16(CAN1_AM30L, val)
#define bfin_read_CAN1_AM30H()		bfin_read16(CAN1_AM30H)
#define bfin_write_CAN1_AM30H(val)	bfin_write16(CAN1_AM30H, val)
#define bfin_read_CAN1_AM31L()		bfin_read16(CAN1_AM31L)
#define bfin_write_CAN1_AM31L(val)	bfin_write16(CAN1_AM31L, val)
#define bfin_read_CAN1_AM31H()		bfin_read16(CAN1_AM31H)
#define bfin_write_CAN1_AM31H(val)	bfin_write16(CAN1_AM31H, val)

/* CAN Controller 1 Mailbox Data Registers */

#define bfin_read_CAN1_MB00_DATA0()		bfin_read16(CAN1_MB00_DATA0)
#define bfin_write_CAN1_MB00_DATA0(val)		bfin_write16(CAN1_MB00_DATA0, val)
#define bfin_read_CAN1_MB00_DATA1()		bfin_read16(CAN1_MB00_DATA1)
#define bfin_write_CAN1_MB00_DATA1(val)		bfin_write16(CAN1_MB00_DATA1, val)
#define bfin_read_CAN1_MB00_DATA2()		bfin_read16(CAN1_MB00_DATA2)
#define bfin_write_CAN1_MB00_DATA2(val)		bfin_write16(CAN1_MB00_DATA2, val)
#define bfin_read_CAN1_MB00_DATA3()		bfin_read16(CAN1_MB00_DATA3)
#define bfin_write_CAN1_MB00_DATA3(val)		bfin_write16(CAN1_MB00_DATA3, val)
#define bfin_read_CAN1_MB00_LENGTH()		bfin_read16(CAN1_MB00_LENGTH)
#define bfin_write_CAN1_MB00_LENGTH(val)	bfin_write16(CAN1_MB00_LENGTH, val)
#define bfin_read_CAN1_MB00_TIMESTAMP()		bfin_read16(CAN1_MB00_TIMESTAMP)
#define bfin_write_CAN1_MB00_TIMESTAMP(val)	bfin_write16(CAN1_MB00_TIMESTAMP, val)
#define bfin_read_CAN1_MB00_ID0()		bfin_read16(CAN1_MB00_ID0)
#define bfin_write_CAN1_MB00_ID0(val)		bfin_write16(CAN1_MB00_ID0, val)
#define bfin_read_CAN1_MB00_ID1()		bfin_read16(CAN1_MB00_ID1)
#define bfin_write_CAN1_MB00_ID1(val)		bfin_write16(CAN1_MB00_ID1, val)
#define bfin_read_CAN1_MB01_DATA0()		bfin_read16(CAN1_MB01_DATA0)
#define bfin_write_CAN1_MB01_DATA0(val)		bfin_write16(CAN1_MB01_DATA0, val)
#define bfin_read_CAN1_MB01_DATA1()		bfin_read16(CAN1_MB01_DATA1)
#define bfin_write_CAN1_MB01_DATA1(val)		bfin_write16(CAN1_MB01_DATA1, val)
#define bfin_read_CAN1_MB01_DATA2()		bfin_read16(CAN1_MB01_DATA2)
#define bfin_write_CAN1_MB01_DATA2(val)		bfin_write16(CAN1_MB01_DATA2, val)
#define bfin_read_CAN1_MB01_DATA3()		bfin_read16(CAN1_MB01_DATA3)
#define bfin_write_CAN1_MB01_DATA3(val)		bfin_write16(CAN1_MB01_DATA3, val)
#define bfin_read_CAN1_MB01_LENGTH()		bfin_read16(CAN1_MB01_LENGTH)
#define bfin_write_CAN1_MB01_LENGTH(val)	bfin_write16(CAN1_MB01_LENGTH, val)
#define bfin_read_CAN1_MB01_TIMESTAMP()		bfin_read16(CAN1_MB01_TIMESTAMP)
#define bfin_write_CAN1_MB01_TIMESTAMP(val)	bfin_write16(CAN1_MB01_TIMESTAMP, val)
#define bfin_read_CAN1_MB01_ID0()		bfin_read16(CAN1_MB01_ID0)
#define bfin_write_CAN1_MB01_ID0(val)		bfin_write16(CAN1_MB01_ID0, val)
#define bfin_read_CAN1_MB01_ID1()		bfin_read16(CAN1_MB01_ID1)
#define bfin_write_CAN1_MB01_ID1(val)		bfin_write16(CAN1_MB01_ID1, val)
#define bfin_read_CAN1_MB02_DATA0()		bfin_read16(CAN1_MB02_DATA0)
#define bfin_write_CAN1_MB02_DATA0(val)		bfin_write16(CAN1_MB02_DATA0, val)
#define bfin_read_CAN1_MB02_DATA1()		bfin_read16(CAN1_MB02_DATA1)
#define bfin_write_CAN1_MB02_DATA1(val)		bfin_write16(CAN1_MB02_DATA1, val)
#define bfin_read_CAN1_MB02_DATA2()		bfin_read16(CAN1_MB02_DATA2)
#define bfin_write_CAN1_MB02_DATA2(val)		bfin_write16(CAN1_MB02_DATA2, val)
#define bfin_read_CAN1_MB02_DATA3()		bfin_read16(CAN1_MB02_DATA3)
#define bfin_write_CAN1_MB02_DATA3(val)		bfin_write16(CAN1_MB02_DATA3, val)
#define bfin_read_CAN1_MB02_LENGTH()		bfin_read16(CAN1_MB02_LENGTH)
#define bfin_write_CAN1_MB02_LENGTH(val)	bfin_write16(CAN1_MB02_LENGTH, val)
#define bfin_read_CAN1_MB02_TIMESTAMP()		bfin_read16(CAN1_MB02_TIMESTAMP)
#define bfin_write_CAN1_MB02_TIMESTAMP(val)	bfin_write16(CAN1_MB02_TIMESTAMP, val)
#define bfin_read_CAN1_MB02_ID0()		bfin_read16(CAN1_MB02_ID0)
#define bfin_write_CAN1_MB02_ID0(val)		bfin_write16(CAN1_MB02_ID0, val)
#define bfin_read_CAN1_MB02_ID1()		bfin_read16(CAN1_MB02_ID1)
#define bfin_write_CAN1_MB02_ID1(val)		bfin_write16(CAN1_MB02_ID1, val)
#define bfin_read_CAN1_MB03_DATA0()		bfin_read16(CAN1_MB03_DATA0)
#define bfin_write_CAN1_MB03_DATA0(val)		bfin_write16(CAN1_MB03_DATA0, val)
#define bfin_read_CAN1_MB03_DATA1()		bfin_read16(CAN1_MB03_DATA1)
#define bfin_write_CAN1_MB03_DATA1(val)		bfin_write16(CAN1_MB03_DATA1, val)
#define bfin_read_CAN1_MB03_DATA2()		bfin_read16(CAN1_MB03_DATA2)
#define bfin_write_CAN1_MB03_DATA2(val)		bfin_write16(CAN1_MB03_DATA2, val)
#define bfin_read_CAN1_MB03_DATA3()		bfin_read16(CAN1_MB03_DATA3)
#define bfin_write_CAN1_MB03_DATA3(val)		bfin_write16(CAN1_MB03_DATA3, val)
#define bfin_read_CAN1_MB03_LENGTH()		bfin_read16(CAN1_MB03_LENGTH)
#define bfin_write_CAN1_MB03_LENGTH(val)	bfin_write16(CAN1_MB03_LENGTH, val)
#define bfin_read_CAN1_MB03_TIMESTAMP()		bfin_read16(CAN1_MB03_TIMESTAMP)
#define bfin_write_CAN1_MB03_TIMESTAMP(val)	bfin_write16(CAN1_MB03_TIMESTAMP, val)
#define bfin_read_CAN1_MB03_ID0()		bfin_read16(CAN1_MB03_ID0)
#define bfin_write_CAN1_MB03_ID0(val)		bfin_write16(CAN1_MB03_ID0, val)
#define bfin_read_CAN1_MB03_ID1()		bfin_read16(CAN1_MB03_ID1)
#define bfin_write_CAN1_MB03_ID1(val)		bfin_write16(CAN1_MB03_ID1, val)
#define bfin_read_CAN1_MB04_DATA0()		bfin_read16(CAN1_MB04_DATA0)
#define bfin_write_CAN1_MB04_DATA0(val)		bfin_write16(CAN1_MB04_DATA0, val)
#define bfin_read_CAN1_MB04_DATA1()		bfin_read16(CAN1_MB04_DATA1)
#define bfin_write_CAN1_MB04_DATA1(val)		bfin_write16(CAN1_MB04_DATA1, val)
#define bfin_read_CAN1_MB04_DATA2()		bfin_read16(CAN1_MB04_DATA2)
#define bfin_write_CAN1_MB04_DATA2(val)		bfin_write16(CAN1_MB04_DATA2, val)
#define bfin_read_CAN1_MB04_DATA3()		bfin_read16(CAN1_MB04_DATA3)
#define bfin_write_CAN1_MB04_DATA3(val)		bfin_write16(CAN1_MB04_DATA3, val)
#define bfin_read_CAN1_MB04_LENGTH()		bfin_read16(CAN1_MB04_LENGTH)
#define bfin_write_CAN1_MB04_LENGTH(val)	bfin_write16(CAN1_MB04_LENGTH, val)
#define bfin_read_CAN1_MB04_TIMESTAMP()		bfin_read16(CAN1_MB04_TIMESTAMP)
#define bfin_write_CAN1_MB04_TIMESTAMP(val)	bfin_write16(CAN1_MB04_TIMESTAMP, val)
#define bfin_read_CAN1_MB04_ID0()		bfin_read16(CAN1_MB04_ID0)
#define bfin_write_CAN1_MB04_ID0(val)		bfin_write16(CAN1_MB04_ID0, val)
#define bfin_read_CAN1_MB04_ID1()		bfin_read16(CAN1_MB04_ID1)
#define bfin_write_CAN1_MB04_ID1(val)		bfin_write16(CAN1_MB04_ID1, val)
#define bfin_read_CAN1_MB05_DATA0()		bfin_read16(CAN1_MB05_DATA0)
#define bfin_write_CAN1_MB05_DATA0(val)		bfin_write16(CAN1_MB05_DATA0, val)
#define bfin_read_CAN1_MB05_DATA1()		bfin_read16(CAN1_MB05_DATA1)
#define bfin_write_CAN1_MB05_DATA1(val)		bfin_write16(CAN1_MB05_DATA1, val)
#define bfin_read_CAN1_MB05_DATA2()		bfin_read16(CAN1_MB05_DATA2)
#define bfin_write_CAN1_MB05_DATA2(val)		bfin_write16(CAN1_MB05_DATA2, val)
#define bfin_read_CAN1_MB05_DATA3()		bfin_read16(CAN1_MB05_DATA3)
#define bfin_write_CAN1_MB05_DATA3(val)		bfin_write16(CAN1_MB05_DATA3, val)
#define bfin_read_CAN1_MB05_LENGTH()		bfin_read16(CAN1_MB05_LENGTH)
#define bfin_write_CAN1_MB05_LENGTH(val)	bfin_write16(CAN1_MB05_LENGTH, val)
#define bfin_read_CAN1_MB05_TIMESTAMP()		bfin_read16(CAN1_MB05_TIMESTAMP)
#define bfin_write_CAN1_MB05_TIMESTAMP(val)	bfin_write16(CAN1_MB05_TIMESTAMP, val)
#define bfin_read_CAN1_MB05_ID0()		bfin_read16(CAN1_MB05_ID0)
#define bfin_write_CAN1_MB05_ID0(val)		bfin_write16(CAN1_MB05_ID0, val)
#define bfin_read_CAN1_MB05_ID1()		bfin_read16(CAN1_MB05_ID1)
#define bfin_write_CAN1_MB05_ID1(val)		bfin_write16(CAN1_MB05_ID1, val)
#define bfin_read_CAN1_MB06_DATA0()		bfin_read16(CAN1_MB06_DATA0)
#define bfin_write_CAN1_MB06_DATA0(val)		bfin_write16(CAN1_MB06_DATA0, val)
#define bfin_read_CAN1_MB06_DATA1()		bfin_read16(CAN1_MB06_DATA1)
#define bfin_write_CAN1_MB06_DATA1(val)		bfin_write16(CAN1_MB06_DATA1, val)
#define bfin_read_CAN1_MB06_DATA2()		bfin_read16(CAN1_MB06_DATA2)
#define bfin_write_CAN1_MB06_DATA2(val)		bfin_write16(CAN1_MB06_DATA2, val)
#define bfin_read_CAN1_MB06_DATA3()		bfin_read16(CAN1_MB06_DATA3)
#define bfin_write_CAN1_MB06_DATA3(val)		bfin_write16(CAN1_MB06_DATA3, val)
#define bfin_read_CAN1_MB06_LENGTH()		bfin_read16(CAN1_MB06_LENGTH)
#define bfin_write_CAN1_MB06_LENGTH(val)	bfin_write16(CAN1_MB06_LENGTH, val)
#define bfin_read_CAN1_MB06_TIMESTAMP()		bfin_read16(CAN1_MB06_TIMESTAMP)
#define bfin_write_CAN1_MB06_TIMESTAMP(val)	bfin_write16(CAN1_MB06_TIMESTAMP, val)
#define bfin_read_CAN1_MB06_ID0()		bfin_read16(CAN1_MB06_ID0)
#define bfin_write_CAN1_MB06_ID0(val)		bfin_write16(CAN1_MB06_ID0, val)
#define bfin_read_CAN1_MB06_ID1()		bfin_read16(CAN1_MB06_ID1)
#define bfin_write_CAN1_MB06_ID1(val)		bfin_write16(CAN1_MB06_ID1, val)
#define bfin_read_CAN1_MB07_DATA0()		bfin_read16(CAN1_MB07_DATA0)
#define bfin_write_CAN1_MB07_DATA0(val)		bfin_write16(CAN1_MB07_DATA0, val)
#define bfin_read_CAN1_MB07_DATA1()		bfin_read16(CAN1_MB07_DATA1)
#define bfin_write_CAN1_MB07_DATA1(val)		bfin_write16(CAN1_MB07_DATA1, val)
#define bfin_read_CAN1_MB07_DATA2()		bfin_read16(CAN1_MB07_DATA2)
#define bfin_write_CAN1_MB07_DATA2(val)		bfin_write16(CAN1_MB07_DATA2, val)
#define bfin_read_CAN1_MB07_DATA3()		bfin_read16(CAN1_MB07_DATA3)
#define bfin_write_CAN1_MB07_DATA3(val)		bfin_write16(CAN1_MB07_DATA3, val)
#define bfin_read_CAN1_MB07_LENGTH()		bfin_read16(CAN1_MB07_LENGTH)
#define bfin_write_CAN1_MB07_LENGTH(val)	bfin_write16(CAN1_MB07_LENGTH, val)
#define bfin_read_CAN1_MB07_TIMESTAMP()		bfin_read16(CAN1_MB07_TIMESTAMP)
#define bfin_write_CAN1_MB07_TIMESTAMP(val)	bfin_write16(CAN1_MB07_TIMESTAMP, val)
#define bfin_read_CAN1_MB07_ID0()		bfin_read16(CAN1_MB07_ID0)
#define bfin_write_CAN1_MB07_ID0(val)		bfin_write16(CAN1_MB07_ID0, val)
#define bfin_read_CAN1_MB07_ID1()		bfin_read16(CAN1_MB07_ID1)
#define bfin_write_CAN1_MB07_ID1(val)		bfin_write16(CAN1_MB07_ID1, val)
#define bfin_read_CAN1_MB08_DATA0()		bfin_read16(CAN1_MB08_DATA0)
#define bfin_write_CAN1_MB08_DATA0(val)		bfin_write16(CAN1_MB08_DATA0, val)
#define bfin_read_CAN1_MB08_DATA1()		bfin_read16(CAN1_MB08_DATA1)
#define bfin_write_CAN1_MB08_DATA1(val)		bfin_write16(CAN1_MB08_DATA1, val)
#define bfin_read_CAN1_MB08_DATA2()		bfin_read16(CAN1_MB08_DATA2)
#define bfin_write_CAN1_MB08_DATA2(val)		bfin_write16(CAN1_MB08_DATA2, val)
#define bfin_read_CAN1_MB08_DATA3()		bfin_read16(CAN1_MB08_DATA3)
#define bfin_write_CAN1_MB08_DATA3(val)		bfin_write16(CAN1_MB08_DATA3, val)
#define bfin_read_CAN1_MB08_LENGTH()		bfin_read16(CAN1_MB08_LENGTH)
#define bfin_write_CAN1_MB08_LENGTH(val)	bfin_write16(CAN1_MB08_LENGTH, val)
#define bfin_read_CAN1_MB08_TIMESTAMP()		bfin_read16(CAN1_MB08_TIMESTAMP)
#define bfin_write_CAN1_MB08_TIMESTAMP(val)	bfin_write16(CAN1_MB08_TIMESTAMP, val)
#define bfin_read_CAN1_MB08_ID0()		bfin_read16(CAN1_MB08_ID0)
#define bfin_write_CAN1_MB08_ID0(val)		bfin_write16(CAN1_MB08_ID0, val)
#define bfin_read_CAN1_MB08_ID1()		bfin_read16(CAN1_MB08_ID1)
#define bfin_write_CAN1_MB08_ID1(val)		bfin_write16(CAN1_MB08_ID1, val)
#define bfin_read_CAN1_MB09_DATA0()		bfin_read16(CAN1_MB09_DATA0)
#define bfin_write_CAN1_MB09_DATA0(val)		bfin_write16(CAN1_MB09_DATA0, val)
#define bfin_read_CAN1_MB09_DATA1()		bfin_read16(CAN1_MB09_DATA1)
#define bfin_write_CAN1_MB09_DATA1(val)		bfin_write16(CAN1_MB09_DATA1, val)
#define bfin_read_CAN1_MB09_DATA2()		bfin_read16(CAN1_MB09_DATA2)
#define bfin_write_CAN1_MB09_DATA2(val)		bfin_write16(CAN1_MB09_DATA2, val)
#define bfin_read_CAN1_MB09_DATA3()		bfin_read16(CAN1_MB09_DATA3)
#define bfin_write_CAN1_MB09_DATA3(val)		bfin_write16(CAN1_MB09_DATA3, val)
#define bfin_read_CAN1_MB09_LENGTH()		bfin_read16(CAN1_MB09_LENGTH)
#define bfin_write_CAN1_MB09_LENGTH(val)	bfin_write16(CAN1_MB09_LENGTH, val)
#define bfin_read_CAN1_MB09_TIMESTAMP()		bfin_read16(CAN1_MB09_TIMESTAMP)
#define bfin_write_CAN1_MB09_TIMESTAMP(val)	bfin_write16(CAN1_MB09_TIMESTAMP, val)
#define bfin_read_CAN1_MB09_ID0()		bfin_read16(CAN1_MB09_ID0)
#define bfin_write_CAN1_MB09_ID0(val)		bfin_write16(CAN1_MB09_ID0, val)
#define bfin_read_CAN1_MB09_ID1()		bfin_read16(CAN1_MB09_ID1)
#define bfin_write_CAN1_MB09_ID1(val)		bfin_write16(CAN1_MB09_ID1, val)
#define bfin_read_CAN1_MB10_DATA0()		bfin_read16(CAN1_MB10_DATA0)
#define bfin_write_CAN1_MB10_DATA0(val)		bfin_write16(CAN1_MB10_DATA0, val)
#define bfin_read_CAN1_MB10_DATA1()		bfin_read16(CAN1_MB10_DATA1)
#define bfin_write_CAN1_MB10_DATA1(val)		bfin_write16(CAN1_MB10_DATA1, val)
#define bfin_read_CAN1_MB10_DATA2()		bfin_read16(CAN1_MB10_DATA2)
#define bfin_write_CAN1_MB10_DATA2(val)		bfin_write16(CAN1_MB10_DATA2, val)
#define bfin_read_CAN1_MB10_DATA3()		bfin_read16(CAN1_MB10_DATA3)
#define bfin_write_CAN1_MB10_DATA3(val)		bfin_write16(CAN1_MB10_DATA3, val)
#define bfin_read_CAN1_MB10_LENGTH()		bfin_read16(CAN1_MB10_LENGTH)
#define bfin_write_CAN1_MB10_LENGTH(val)	bfin_write16(CAN1_MB10_LENGTH, val)
#define bfin_read_CAN1_MB10_TIMESTAMP()		bfin_read16(CAN1_MB10_TIMESTAMP)
#define bfin_write_CAN1_MB10_TIMESTAMP(val)	bfin_write16(CAN1_MB10_TIMESTAMP, val)
#define bfin_read_CAN1_MB10_ID0()		bfin_read16(CAN1_MB10_ID0)
#define bfin_write_CAN1_MB10_ID0(val)		bfin_write16(CAN1_MB10_ID0, val)
#define bfin_read_CAN1_MB10_ID1()		bfin_read16(CAN1_MB10_ID1)
#define bfin_write_CAN1_MB10_ID1(val)		bfin_write16(CAN1_MB10_ID1, val)
#define bfin_read_CAN1_MB11_DATA0()		bfin_read16(CAN1_MB11_DATA0)
#define bfin_write_CAN1_MB11_DATA0(val)		bfin_write16(CAN1_MB11_DATA0, val)
#define bfin_read_CAN1_MB11_DATA1()		bfin_read16(CAN1_MB11_DATA1)
#define bfin_write_CAN1_MB11_DATA1(val)		bfin_write16(CAN1_MB11_DATA1, val)
#define bfin_read_CAN1_MB11_DATA2()		bfin_read16(CAN1_MB11_DATA2)
#define bfin_write_CAN1_MB11_DATA2(val)		bfin_write16(CAN1_MB11_DATA2, val)
#define bfin_read_CAN1_MB11_DATA3()		bfin_read16(CAN1_MB11_DATA3)
#define bfin_write_CAN1_MB11_DATA3(val)		bfin_write16(CAN1_MB11_DATA3, val)
#define bfin_read_CAN1_MB11_LENGTH()		bfin_read16(CAN1_MB11_LENGTH)
#define bfin_write_CAN1_MB11_LENGTH(val)	bfin_write16(CAN1_MB11_LENGTH, val)
#define bfin_read_CAN1_MB11_TIMESTAMP()		bfin_read16(CAN1_MB11_TIMESTAMP)
#define bfin_write_CAN1_MB11_TIMESTAMP(val)	bfin_write16(CAN1_MB11_TIMESTAMP, val)
#define bfin_read_CAN1_MB11_ID0()		bfin_read16(CAN1_MB11_ID0)
#define bfin_write_CAN1_MB11_ID0(val)		bfin_write16(CAN1_MB11_ID0, val)
#define bfin_read_CAN1_MB11_ID1()		bfin_read16(CAN1_MB11_ID1)
#define bfin_write_CAN1_MB11_ID1(val)		bfin_write16(CAN1_MB11_ID1, val)
#define bfin_read_CAN1_MB12_DATA0()		bfin_read16(CAN1_MB12_DATA0)
#define bfin_write_CAN1_MB12_DATA0(val)		bfin_write16(CAN1_MB12_DATA0, val)
#define bfin_read_CAN1_MB12_DATA1()		bfin_read16(CAN1_MB12_DATA1)
#define bfin_write_CAN1_MB12_DATA1(val)		bfin_write16(CAN1_MB12_DATA1, val)
#define bfin_read_CAN1_MB12_DATA2()		bfin_read16(CAN1_MB12_DATA2)
#define bfin_write_CAN1_MB12_DATA2(val)		bfin_write16(CAN1_MB12_DATA2, val)
#define bfin_read_CAN1_MB12_DATA3()		bfin_read16(CAN1_MB12_DATA3)
#define bfin_write_CAN1_MB12_DATA3(val)		bfin_write16(CAN1_MB12_DATA3, val)
#define bfin_read_CAN1_MB12_LENGTH()		bfin_read16(CAN1_MB12_LENGTH)
#define bfin_write_CAN1_MB12_LENGTH(val)	bfin_write16(CAN1_MB12_LENGTH, val)
#define bfin_read_CAN1_MB12_TIMESTAMP()		bfin_read16(CAN1_MB12_TIMESTAMP)
#define bfin_write_CAN1_MB12_TIMESTAMP(val)	bfin_write16(CAN1_MB12_TIMESTAMP, val)
#define bfin_read_CAN1_MB12_ID0()		bfin_read16(CAN1_MB12_ID0)
#define bfin_write_CAN1_MB12_ID0(val)		bfin_write16(CAN1_MB12_ID0, val)
#define bfin_read_CAN1_MB12_ID1()		bfin_read16(CAN1_MB12_ID1)
#define bfin_write_CAN1_MB12_ID1(val)		bfin_write16(CAN1_MB12_ID1, val)
#define bfin_read_CAN1_MB13_DATA0()		bfin_read16(CAN1_MB13_DATA0)
#define bfin_write_CAN1_MB13_DATA0(val)		bfin_write16(CAN1_MB13_DATA0, val)
#define bfin_read_CAN1_MB13_DATA1()		bfin_read16(CAN1_MB13_DATA1)
#define bfin_write_CAN1_MB13_DATA1(val)		bfin_write16(CAN1_MB13_DATA1, val)
#define bfin_read_CAN1_MB13_DATA2()		bfin_read16(CAN1_MB13_DATA2)
#define bfin_write_CAN1_MB13_DATA2(val)		bfin_write16(CAN1_MB13_DATA2, val)
#define bfin_read_CAN1_MB13_DATA3()		bfin_read16(CAN1_MB13_DATA3)
#define bfin_write_CAN1_MB13_DATA3(val)		bfin_write16(CAN1_MB13_DATA3, val)
#define bfin_read_CAN1_MB13_LENGTH()		bfin_read16(CAN1_MB13_LENGTH)
#define bfin_write_CAN1_MB13_LENGTH(val)	bfin_write16(CAN1_MB13_LENGTH, val)
#define bfin_read_CAN1_MB13_TIMESTAMP()		bfin_read16(CAN1_MB13_TIMESTAMP)
#define bfin_write_CAN1_MB13_TIMESTAMP(val)	bfin_write16(CAN1_MB13_TIMESTAMP, val)
#define bfin_read_CAN1_MB13_ID0()		bfin_read16(CAN1_MB13_ID0)
#define bfin_write_CAN1_MB13_ID0(val)		bfin_write16(CAN1_MB13_ID0, val)
#define bfin_read_CAN1_MB13_ID1()		bfin_read16(CAN1_MB13_ID1)
#define bfin_write_CAN1_MB13_ID1(val)		bfin_write16(CAN1_MB13_ID1, val)
#define bfin_read_CAN1_MB14_DATA0()		bfin_read16(CAN1_MB14_DATA0)
#define bfin_write_CAN1_MB14_DATA0(val)		bfin_write16(CAN1_MB14_DATA0, val)
#define bfin_read_CAN1_MB14_DATA1()		bfin_read16(CAN1_MB14_DATA1)
#define bfin_write_CAN1_MB14_DATA1(val)		bfin_write16(CAN1_MB14_DATA1, val)
#define bfin_read_CAN1_MB14_DATA2()		bfin_read16(CAN1_MB14_DATA2)
#define bfin_write_CAN1_MB14_DATA2(val)		bfin_write16(CAN1_MB14_DATA2, val)
#define bfin_read_CAN1_MB14_DATA3()		bfin_read16(CAN1_MB14_DATA3)
#define bfin_write_CAN1_MB14_DATA3(val)		bfin_write16(CAN1_MB14_DATA3, val)
#define bfin_read_CAN1_MB14_LENGTH()		bfin_read16(CAN1_MB14_LENGTH)
#define bfin_write_CAN1_MB14_LENGTH(val)	bfin_write16(CAN1_MB14_LENGTH, val)
#define bfin_read_CAN1_MB14_TIMESTAMP()		bfin_read16(CAN1_MB14_TIMESTAMP)
#define bfin_write_CAN1_MB14_TIMESTAMP(val)	bfin_write16(CAN1_MB14_TIMESTAMP, val)
#define bfin_read_CAN1_MB14_ID0()		bfin_read16(CAN1_MB14_ID0)
#define bfin_write_CAN1_MB14_ID0(val)		bfin_write16(CAN1_MB14_ID0, val)
#define bfin_read_CAN1_MB14_ID1()		bfin_read16(CAN1_MB14_ID1)
#define bfin_write_CAN1_MB14_ID1(val)		bfin_write16(CAN1_MB14_ID1, val)
#define bfin_read_CAN1_MB15_DATA0()		bfin_read16(CAN1_MB15_DATA0)
#define bfin_write_CAN1_MB15_DATA0(val)		bfin_write16(CAN1_MB15_DATA0, val)
#define bfin_read_CAN1_MB15_DATA1()		bfin_read16(CAN1_MB15_DATA1)
#define bfin_write_CAN1_MB15_DATA1(val)		bfin_write16(CAN1_MB15_DATA1, val)
#define bfin_read_CAN1_MB15_DATA2()		bfin_read16(CAN1_MB15_DATA2)
#define bfin_write_CAN1_MB15_DATA2(val)		bfin_write16(CAN1_MB15_DATA2, val)
#define bfin_read_CAN1_MB15_DATA3()		bfin_read16(CAN1_MB15_DATA3)
#define bfin_write_CAN1_MB15_DATA3(val)		bfin_write16(CAN1_MB15_DATA3, val)
#define bfin_read_CAN1_MB15_LENGTH()		bfin_read16(CAN1_MB15_LENGTH)
#define bfin_write_CAN1_MB15_LENGTH(val)	bfin_write16(CAN1_MB15_LENGTH, val)
#define bfin_read_CAN1_MB15_TIMESTAMP()		bfin_read16(CAN1_MB15_TIMESTAMP)
#define bfin_write_CAN1_MB15_TIMESTAMP(val)	bfin_write16(CAN1_MB15_TIMESTAMP, val)
#define bfin_read_CAN1_MB15_ID0()		bfin_read16(CAN1_MB15_ID0)
#define bfin_write_CAN1_MB15_ID0(val)		bfin_write16(CAN1_MB15_ID0, val)
#define bfin_read_CAN1_MB15_ID1()		bfin_read16(CAN1_MB15_ID1)
#define bfin_write_CAN1_MB15_ID1(val)		bfin_write16(CAN1_MB15_ID1, val)

/* CAN Controller 1 Mailbox Data Registers */

#define bfin_read_CAN1_MB16_DATA0()		bfin_read16(CAN1_MB16_DATA0)
#define bfin_write_CAN1_MB16_DATA0(val)		bfin_write16(CAN1_MB16_DATA0, val)
#define bfin_read_CAN1_MB16_DATA1()		bfin_read16(CAN1_MB16_DATA1)
#define bfin_write_CAN1_MB16_DATA1(val)		bfin_write16(CAN1_MB16_DATA1, val)
#define bfin_read_CAN1_MB16_DATA2()		bfin_read16(CAN1_MB16_DATA2)
#define bfin_write_CAN1_MB16_DATA2(val)		bfin_write16(CAN1_MB16_DATA2, val)
#define bfin_read_CAN1_MB16_DATA3()		bfin_read16(CAN1_MB16_DATA3)
#define bfin_write_CAN1_MB16_DATA3(val)		bfin_write16(CAN1_MB16_DATA3, val)
#define bfin_read_CAN1_MB16_LENGTH()		bfin_read16(CAN1_MB16_LENGTH)
#define bfin_write_CAN1_MB16_LENGTH(val)	bfin_write16(CAN1_MB16_LENGTH, val)
#define bfin_read_CAN1_MB16_TIMESTAMP()		bfin_read16(CAN1_MB16_TIMESTAMP)
#define bfin_write_CAN1_MB16_TIMESTAMP(val)	bfin_write16(CAN1_MB16_TIMESTAMP, val)
#define bfin_read_CAN1_MB16_ID0()		bfin_read16(CAN1_MB16_ID0)
#define bfin_write_CAN1_MB16_ID0(val)		bfin_write16(CAN1_MB16_ID0, val)
#define bfin_read_CAN1_MB16_ID1()		bfin_read16(CAN1_MB16_ID1)
#define bfin_write_CAN1_MB16_ID1(val)		bfin_write16(CAN1_MB16_ID1, val)
#define bfin_read_CAN1_MB17_DATA0()		bfin_read16(CAN1_MB17_DATA0)
#define bfin_write_CAN1_MB17_DATA0(val)		bfin_write16(CAN1_MB17_DATA0, val)
#define bfin_read_CAN1_MB17_DATA1()		bfin_read16(CAN1_MB17_DATA1)
#define bfin_write_CAN1_MB17_DATA1(val)		bfin_write16(CAN1_MB17_DATA1, val)
#define bfin_read_CAN1_MB17_DATA2()		bfin_read16(CAN1_MB17_DATA2)
#define bfin_write_CAN1_MB17_DATA2(val)		bfin_write16(CAN1_MB17_DATA2, val)
#define bfin_read_CAN1_MB17_DATA3()		bfin_read16(CAN1_MB17_DATA3)
#define bfin_write_CAN1_MB17_DATA3(val)		bfin_write16(CAN1_MB17_DATA3, val)
#define bfin_read_CAN1_MB17_LENGTH()		bfin_read16(CAN1_MB17_LENGTH)
#define bfin_write_CAN1_MB17_LENGTH(val)	bfin_write16(CAN1_MB17_LENGTH, val)
#define bfin_read_CAN1_MB17_TIMESTAMP()		bfin_read16(CAN1_MB17_TIMESTAMP)
#define bfin_write_CAN1_MB17_TIMESTAMP(val)	bfin_write16(CAN1_MB17_TIMESTAMP, val)
#define bfin_read_CAN1_MB17_ID0()		bfin_read16(CAN1_MB17_ID0)
#define bfin_write_CAN1_MB17_ID0(val)		bfin_write16(CAN1_MB17_ID0, val)
#define bfin_read_CAN1_MB17_ID1()		bfin_read16(CAN1_MB17_ID1)
#define bfin_write_CAN1_MB17_ID1(val)		bfin_write16(CAN1_MB17_ID1, val)
#define bfin_read_CAN1_MB18_DATA0()		bfin_read16(CAN1_MB18_DATA0)
#define bfin_write_CAN1_MB18_DATA0(val)		bfin_write16(CAN1_MB18_DATA0, val)
#define bfin_read_CAN1_MB18_DATA1()		bfin_read16(CAN1_MB18_DATA1)
#define bfin_write_CAN1_MB18_DATA1(val)		bfin_write16(CAN1_MB18_DATA1, val)
#define bfin_read_CAN1_MB18_DATA2()		bfin_read16(CAN1_MB18_DATA2)
#define bfin_write_CAN1_MB18_DATA2(val)		bfin_write16(CAN1_MB18_DATA2, val)
#define bfin_read_CAN1_MB18_DATA3()		bfin_read16(CAN1_MB18_DATA3)
#define bfin_write_CAN1_MB18_DATA3(val)		bfin_write16(CAN1_MB18_DATA3, val)
#define bfin_read_CAN1_MB18_LENGTH()		bfin_read16(CAN1_MB18_LENGTH)
#define bfin_write_CAN1_MB18_LENGTH(val)	bfin_write16(CAN1_MB18_LENGTH, val)
#define bfin_read_CAN1_MB18_TIMESTAMP()		bfin_read16(CAN1_MB18_TIMESTAMP)
#define bfin_write_CAN1_MB18_TIMESTAMP(val)	bfin_write16(CAN1_MB18_TIMESTAMP, val)
#define bfin_read_CAN1_MB18_ID0()		bfin_read16(CAN1_MB18_ID0)
#define bfin_write_CAN1_MB18_ID0(val)		bfin_write16(CAN1_MB18_ID0, val)
#define bfin_read_CAN1_MB18_ID1()		bfin_read16(CAN1_MB18_ID1)
#define bfin_write_CAN1_MB18_ID1(val)		bfin_write16(CAN1_MB18_ID1, val)
#define bfin_read_CAN1_MB19_DATA0()		bfin_read16(CAN1_MB19_DATA0)
#define bfin_write_CAN1_MB19_DATA0(val)		bfin_write16(CAN1_MB19_DATA0, val)
#define bfin_read_CAN1_MB19_DATA1()		bfin_read16(CAN1_MB19_DATA1)
#define bfin_write_CAN1_MB19_DATA1(val)		bfin_write16(CAN1_MB19_DATA1, val)
#define bfin_read_CAN1_MB19_DATA2()		bfin_read16(CAN1_MB19_DATA2)
#define bfin_write_CAN1_MB19_DATA2(val)		bfin_write16(CAN1_MB19_DATA2, val)
#define bfin_read_CAN1_MB19_DATA3()		bfin_read16(CAN1_MB19_DATA3)
#define bfin_write_CAN1_MB19_DATA3(val)		bfin_write16(CAN1_MB19_DATA3, val)
#define bfin_read_CAN1_MB19_LENGTH()		bfin_read16(CAN1_MB19_LENGTH)
#define bfin_write_CAN1_MB19_LENGTH(val)	bfin_write16(CAN1_MB19_LENGTH, val)
#define bfin_read_CAN1_MB19_TIMESTAMP()		bfin_read16(CAN1_MB19_TIMESTAMP)
#define bfin_write_CAN1_MB19_TIMESTAMP(val)	bfin_write16(CAN1_MB19_TIMESTAMP, val)
#define bfin_read_CAN1_MB19_ID0()		bfin_read16(CAN1_MB19_ID0)
#define bfin_write_CAN1_MB19_ID0(val)		bfin_write16(CAN1_MB19_ID0, val)
#define bfin_read_CAN1_MB19_ID1()		bfin_read16(CAN1_MB19_ID1)
#define bfin_write_CAN1_MB19_ID1(val)		bfin_write16(CAN1_MB19_ID1, val)
#define bfin_read_CAN1_MB20_DATA0()		bfin_read16(CAN1_MB20_DATA0)
#define bfin_write_CAN1_MB20_DATA0(val)		bfin_write16(CAN1_MB20_DATA0, val)
#define bfin_read_CAN1_MB20_DATA1()		bfin_read16(CAN1_MB20_DATA1)
#define bfin_write_CAN1_MB20_DATA1(val)		bfin_write16(CAN1_MB20_DATA1, val)
#define bfin_read_CAN1_MB20_DATA2()		bfin_read16(CAN1_MB20_DATA2)
#define bfin_write_CAN1_MB20_DATA2(val)		bfin_write16(CAN1_MB20_DATA2, val)
#define bfin_read_CAN1_MB20_DATA3()		bfin_read16(CAN1_MB20_DATA3)
#define bfin_write_CAN1_MB20_DATA3(val)		bfin_write16(CAN1_MB20_DATA3, val)
#define bfin_read_CAN1_MB20_LENGTH()		bfin_read16(CAN1_MB20_LENGTH)
#define bfin_write_CAN1_MB20_LENGTH(val)	bfin_write16(CAN1_MB20_LENGTH, val)
#define bfin_read_CAN1_MB20_TIMESTAMP()		bfin_read16(CAN1_MB20_TIMESTAMP)
#define bfin_write_CAN1_MB20_TIMESTAMP(val)	bfin_write16(CAN1_MB20_TIMESTAMP, val)
#define bfin_read_CAN1_MB20_ID0()		bfin_read16(CAN1_MB20_ID0)
#define bfin_write_CAN1_MB20_ID0(val)		bfin_write16(CAN1_MB20_ID0, val)
#define bfin_read_CAN1_MB20_ID1()		bfin_read16(CAN1_MB20_ID1)
#define bfin_write_CAN1_MB20_ID1(val)		bfin_write16(CAN1_MB20_ID1, val)
#define bfin_read_CAN1_MB21_DATA0()		bfin_read16(CAN1_MB21_DATA0)
#define bfin_write_CAN1_MB21_DATA0(val)		bfin_write16(CAN1_MB21_DATA0, val)
#define bfin_read_CAN1_MB21_DATA1()		bfin_read16(CAN1_MB21_DATA1)
#define bfin_write_CAN1_MB21_DATA1(val)		bfin_write16(CAN1_MB21_DATA1, val)
#define bfin_read_CAN1_MB21_DATA2()		bfin_read16(CAN1_MB21_DATA2)
#define bfin_write_CAN1_MB21_DATA2(val)		bfin_write16(CAN1_MB21_DATA2, val)
#define bfin_read_CAN1_MB21_DATA3()		bfin_read16(CAN1_MB21_DATA3)
#define bfin_write_CAN1_MB21_DATA3(val)		bfin_write16(CAN1_MB21_DATA3, val)
#define bfin_read_CAN1_MB21_LENGTH()		bfin_read16(CAN1_MB21_LENGTH)
#define bfin_write_CAN1_MB21_LENGTH(val)	bfin_write16(CAN1_MB21_LENGTH, val)
#define bfin_read_CAN1_MB21_TIMESTAMP()		bfin_read16(CAN1_MB21_TIMESTAMP)
#define bfin_write_CAN1_MB21_TIMESTAMP(val)	bfin_write16(CAN1_MB21_TIMESTAMP, val)
#define bfin_read_CAN1_MB21_ID0()		bfin_read16(CAN1_MB21_ID0)
#define bfin_write_CAN1_MB21_ID0(val)		bfin_write16(CAN1_MB21_ID0, val)
#define bfin_read_CAN1_MB21_ID1()		bfin_read16(CAN1_MB21_ID1)
#define bfin_write_CAN1_MB21_ID1(val)		bfin_write16(CAN1_MB21_ID1, val)
#define bfin_read_CAN1_MB22_DATA0()		bfin_read16(CAN1_MB22_DATA0)
#define bfin_write_CAN1_MB22_DATA0(val)		bfin_write16(CAN1_MB22_DATA0, val)
#define bfin_read_CAN1_MB22_DATA1()		bfin_read16(CAN1_MB22_DATA1)
#define bfin_write_CAN1_MB22_DATA1(val)		bfin_write16(CAN1_MB22_DATA1, val)
#define bfin_read_CAN1_MB22_DATA2()		bfin_read16(CAN1_MB22_DATA2)
#define bfin_write_CAN1_MB22_DATA2(val)		bfin_write16(CAN1_MB22_DATA2, val)
#define bfin_read_CAN1_MB22_DATA3()		bfin_read16(CAN1_MB22_DATA3)
#define bfin_write_CAN1_MB22_DATA3(val)		bfin_write16(CAN1_MB22_DATA3, val)
#define bfin_read_CAN1_MB22_LENGTH()		bfin_read16(CAN1_MB22_LENGTH)
#define bfin_write_CAN1_MB22_LENGTH(val)	bfin_write16(CAN1_MB22_LENGTH, val)
#define bfin_read_CAN1_MB22_TIMESTAMP()		bfin_read16(CAN1_MB22_TIMESTAMP)
#define bfin_write_CAN1_MB22_TIMESTAMP(val)	bfin_write16(CAN1_MB22_TIMESTAMP, val)
#define bfin_read_CAN1_MB22_ID0()		bfin_read16(CAN1_MB22_ID0)
#define bfin_write_CAN1_MB22_ID0(val)		bfin_write16(CAN1_MB22_ID0, val)
#define bfin_read_CAN1_MB22_ID1()		bfin_read16(CAN1_MB22_ID1)
#define bfin_write_CAN1_MB22_ID1(val)		bfin_write16(CAN1_MB22_ID1, val)
#define bfin_read_CAN1_MB23_DATA0()		bfin_read16(CAN1_MB23_DATA0)
#define bfin_write_CAN1_MB23_DATA0(val)		bfin_write16(CAN1_MB23_DATA0, val)
#define bfin_read_CAN1_MB23_DATA1()		bfin_read16(CAN1_MB23_DATA1)
#define bfin_write_CAN1_MB23_DATA1(val)		bfin_write16(CAN1_MB23_DATA1, val)
#define bfin_read_CAN1_MB23_DATA2()		bfin_read16(CAN1_MB23_DATA2)
#define bfin_write_CAN1_MB23_DATA2(val)		bfin_write16(CAN1_MB23_DATA2, val)
#define bfin_read_CAN1_MB23_DATA3()		bfin_read16(CAN1_MB23_DATA3)
#define bfin_write_CAN1_MB23_DATA3(val)		bfin_write16(CAN1_MB23_DATA3, val)
#define bfin_read_CAN1_MB23_LENGTH()		bfin_read16(CAN1_MB23_LENGTH)
#define bfin_write_CAN1_MB23_LENGTH(val)	bfin_write16(CAN1_MB23_LENGTH, val)
#define bfin_read_CAN1_MB23_TIMESTAMP()		bfin_read16(CAN1_MB23_TIMESTAMP)
#define bfin_write_CAN1_MB23_TIMESTAMP(val)	bfin_write16(CAN1_MB23_TIMESTAMP, val)
#define bfin_read_CAN1_MB23_ID0()		bfin_read16(CAN1_MB23_ID0)
#define bfin_write_CAN1_MB23_ID0(val)		bfin_write16(CAN1_MB23_ID0, val)
#define bfin_read_CAN1_MB23_ID1()		bfin_read16(CAN1_MB23_ID1)
#define bfin_write_CAN1_MB23_ID1(val)		bfin_write16(CAN1_MB23_ID1, val)
#define bfin_read_CAN1_MB24_DATA0()		bfin_read16(CAN1_MB24_DATA0)
#define bfin_write_CAN1_MB24_DATA0(val)		bfin_write16(CAN1_MB24_DATA0, val)
#define bfin_read_CAN1_MB24_DATA1()		bfin_read16(CAN1_MB24_DATA1)
#define bfin_write_CAN1_MB24_DATA1(val)		bfin_write16(CAN1_MB24_DATA1, val)
#define bfin_read_CAN1_MB24_DATA2()		bfin_read16(CAN1_MB24_DATA2)
#define bfin_write_CAN1_MB24_DATA2(val)		bfin_write16(CAN1_MB24_DATA2, val)
#define bfin_read_CAN1_MB24_DATA3()		bfin_read16(CAN1_MB24_DATA3)
#define bfin_write_CAN1_MB24_DATA3(val)		bfin_write16(CAN1_MB24_DATA3, val)
#define bfin_read_CAN1_MB24_LENGTH()		bfin_read16(CAN1_MB24_LENGTH)
#define bfin_write_CAN1_MB24_LENGTH(val)	bfin_write16(CAN1_MB24_LENGTH, val)
#define bfin_read_CAN1_MB24_TIMESTAMP()		bfin_read16(CAN1_MB24_TIMESTAMP)
#define bfin_write_CAN1_MB24_TIMESTAMP(val)	bfin_write16(CAN1_MB24_TIMESTAMP, val)
#define bfin_read_CAN1_MB24_ID0()		bfin_read16(CAN1_MB24_ID0)
#define bfin_write_CAN1_MB24_ID0(val)		bfin_write16(CAN1_MB24_ID0, val)
#define bfin_read_CAN1_MB24_ID1()		bfin_read16(CAN1_MB24_ID1)
#define bfin_write_CAN1_MB24_ID1(val)		bfin_write16(CAN1_MB24_ID1, val)
#define bfin_read_CAN1_MB25_DATA0()		bfin_read16(CAN1_MB25_DATA0)
#define bfin_write_CAN1_MB25_DATA0(val)		bfin_write16(CAN1_MB25_DATA0, val)
#define bfin_read_CAN1_MB25_DATA1()		bfin_read16(CAN1_MB25_DATA1)
#define bfin_write_CAN1_MB25_DATA1(val)		bfin_write16(CAN1_MB25_DATA1, val)
#define bfin_read_CAN1_MB25_DATA2()		bfin_read16(CAN1_MB25_DATA2)
#define bfin_write_CAN1_MB25_DATA2(val)		bfin_write16(CAN1_MB25_DATA2, val)
#define bfin_read_CAN1_MB25_DATA3()		bfin_read16(CAN1_MB25_DATA3)
#define bfin_write_CAN1_MB25_DATA3(val)		bfin_write16(CAN1_MB25_DATA3, val)
#define bfin_read_CAN1_MB25_LENGTH()		bfin_read16(CAN1_MB25_LENGTH)
#define bfin_write_CAN1_MB25_LENGTH(val)	bfin_write16(CAN1_MB25_LENGTH, val)
#define bfin_read_CAN1_MB25_TIMESTAMP()		bfin_read16(CAN1_MB25_TIMESTAMP)
#define bfin_write_CAN1_MB25_TIMESTAMP(val)	bfin_write16(CAN1_MB25_TIMESTAMP, val)
#define bfin_read_CAN1_MB25_ID0()		bfin_read16(CAN1_MB25_ID0)
#define bfin_write_CAN1_MB25_ID0(val)		bfin_write16(CAN1_MB25_ID0, val)
#define bfin_read_CAN1_MB25_ID1()		bfin_read16(CAN1_MB25_ID1)
#define bfin_write_CAN1_MB25_ID1(val)		bfin_write16(CAN1_MB25_ID1, val)
#define bfin_read_CAN1_MB26_DATA0()		bfin_read16(CAN1_MB26_DATA0)
#define bfin_write_CAN1_MB26_DATA0(val)		bfin_write16(CAN1_MB26_DATA0, val)
#define bfin_read_CAN1_MB26_DATA1()		bfin_read16(CAN1_MB26_DATA1)
#define bfin_write_CAN1_MB26_DATA1(val)		bfin_write16(CAN1_MB26_DATA1, val)
#define bfin_read_CAN1_MB26_DATA2()		bfin_read16(CAN1_MB26_DATA2)
#define bfin_write_CAN1_MB26_DATA2(val)		bfin_write16(CAN1_MB26_DATA2, val)
#define bfin_read_CAN1_MB26_DATA3()		bfin_read16(CAN1_MB26_DATA3)
#define bfin_write_CAN1_MB26_DATA3(val)		bfin_write16(CAN1_MB26_DATA3, val)
#define bfin_read_CAN1_MB26_LENGTH()		bfin_read16(CAN1_MB26_LENGTH)
#define bfin_write_CAN1_MB26_LENGTH(val)	bfin_write16(CAN1_MB26_LENGTH, val)
#define bfin_read_CAN1_MB26_TIMESTAMP()		bfin_read16(CAN1_MB26_TIMESTAMP)
#define bfin_write_CAN1_MB26_TIMESTAMP(val)	bfin_write16(CAN1_MB26_TIMESTAMP, val)
#define bfin_read_CAN1_MB26_ID0()		bfin_read16(CAN1_MB26_ID0)
#define bfin_write_CAN1_MB26_ID0(val)		bfin_write16(CAN1_MB26_ID0, val)
#define bfin_read_CAN1_MB26_ID1()		bfin_read16(CAN1_MB26_ID1)
#define bfin_write_CAN1_MB26_ID1(val)		bfin_write16(CAN1_MB26_ID1, val)
#define bfin_read_CAN1_MB27_DATA0()		bfin_read16(CAN1_MB27_DATA0)
#define bfin_write_CAN1_MB27_DATA0(val)		bfin_write16(CAN1_MB27_DATA0, val)
#define bfin_read_CAN1_MB27_DATA1()		bfin_read16(CAN1_MB27_DATA1)
#define bfin_write_CAN1_MB27_DATA1(val)		bfin_write16(CAN1_MB27_DATA1, val)
#define bfin_read_CAN1_MB27_DATA2()		bfin_read16(CAN1_MB27_DATA2)
#define bfin_write_CAN1_MB27_DATA2(val)		bfin_write16(CAN1_MB27_DATA2, val)
#define bfin_read_CAN1_MB27_DATA3()		bfin_read16(CAN1_MB27_DATA3)
#define bfin_write_CAN1_MB27_DATA3(val)		bfin_write16(CAN1_MB27_DATA3, val)
#define bfin_read_CAN1_MB27_LENGTH()		bfin_read16(CAN1_MB27_LENGTH)
#define bfin_write_CAN1_MB27_LENGTH(val)	bfin_write16(CAN1_MB27_LENGTH, val)
#define bfin_read_CAN1_MB27_TIMESTAMP()		bfin_read16(CAN1_MB27_TIMESTAMP)
#define bfin_write_CAN1_MB27_TIMESTAMP(val)	bfin_write16(CAN1_MB27_TIMESTAMP, val)
#define bfin_read_CAN1_MB27_ID0()		bfin_read16(CAN1_MB27_ID0)
#define bfin_write_CAN1_MB27_ID0(val)		bfin_write16(CAN1_MB27_ID0, val)
#define bfin_read_CAN1_MB27_ID1()		bfin_read16(CAN1_MB27_ID1)
#define bfin_write_CAN1_MB27_ID1(val)		bfin_write16(CAN1_MB27_ID1, val)
#define bfin_read_CAN1_MB28_DATA0()		bfin_read16(CAN1_MB28_DATA0)
#define bfin_write_CAN1_MB28_DATA0(val)		bfin_write16(CAN1_MB28_DATA0, val)
#define bfin_read_CAN1_MB28_DATA1()		bfin_read16(CAN1_MB28_DATA1)
#define bfin_write_CAN1_MB28_DATA1(val)		bfin_write16(CAN1_MB28_DATA1, val)
#define bfin_read_CAN1_MB28_DATA2()		bfin_read16(CAN1_MB28_DATA2)
#define bfin_write_CAN1_MB28_DATA2(val)		bfin_write16(CAN1_MB28_DATA2, val)
#define bfin_read_CAN1_MB28_DATA3()		bfin_read16(CAN1_MB28_DATA3)
#define bfin_write_CAN1_MB28_DATA3(val)		bfin_write16(CAN1_MB28_DATA3, val)
#define bfin_read_CAN1_MB28_LENGTH()		bfin_read16(CAN1_MB28_LENGTH)
#define bfin_write_CAN1_MB28_LENGTH(val)	bfin_write16(CAN1_MB28_LENGTH, val)
#define bfin_read_CAN1_MB28_TIMESTAMP()		bfin_read16(CAN1_MB28_TIMESTAMP)
#define bfin_write_CAN1_MB28_TIMESTAMP(val)	bfin_write16(CAN1_MB28_TIMESTAMP, val)
#define bfin_read_CAN1_MB28_ID0()		bfin_read16(CAN1_MB28_ID0)
#define bfin_write_CAN1_MB28_ID0(val)		bfin_write16(CAN1_MB28_ID0, val)
#define bfin_read_CAN1_MB28_ID1()		bfin_read16(CAN1_MB28_ID1)
#define bfin_write_CAN1_MB28_ID1(val)		bfin_write16(CAN1_MB28_ID1, val)
#define bfin_read_CAN1_MB29_DATA0()		bfin_read16(CAN1_MB29_DATA0)
#define bfin_write_CAN1_MB29_DATA0(val)		bfin_write16(CAN1_MB29_DATA0, val)
#define bfin_read_CAN1_MB29_DATA1()		bfin_read16(CAN1_MB29_DATA1)
#define bfin_write_CAN1_MB29_DATA1(val)		bfin_write16(CAN1_MB29_DATA1, val)
#define bfin_read_CAN1_MB29_DATA2()		bfin_read16(CAN1_MB29_DATA2)
#define bfin_write_CAN1_MB29_DATA2(val)		bfin_write16(CAN1_MB29_DATA2, val)
#define bfin_read_CAN1_MB29_DATA3()		bfin_read16(CAN1_MB29_DATA3)
#define bfin_write_CAN1_MB29_DATA3(val)		bfin_write16(CAN1_MB29_DATA3, val)
#define bfin_read_CAN1_MB29_LENGTH()		bfin_read16(CAN1_MB29_LENGTH)
#define bfin_write_CAN1_MB29_LENGTH(val)	bfin_write16(CAN1_MB29_LENGTH, val)
#define bfin_read_CAN1_MB29_TIMESTAMP()		bfin_read16(CAN1_MB29_TIMESTAMP)
#define bfin_write_CAN1_MB29_TIMESTAMP(val)	bfin_write16(CAN1_MB29_TIMESTAMP, val)
#define bfin_read_CAN1_MB29_ID0()		bfin_read16(CAN1_MB29_ID0)
#define bfin_write_CAN1_MB29_ID0(val)		bfin_write16(CAN1_MB29_ID0, val)
#define bfin_read_CAN1_MB29_ID1()		bfin_read16(CAN1_MB29_ID1)
#define bfin_write_CAN1_MB29_ID1(val)		bfin_write16(CAN1_MB29_ID1, val)
#define bfin_read_CAN1_MB30_DATA0()		bfin_read16(CAN1_MB30_DATA0)
#define bfin_write_CAN1_MB30_DATA0(val)		bfin_write16(CAN1_MB30_DATA0, val)
#define bfin_read_CAN1_MB30_DATA1()		bfin_read16(CAN1_MB30_DATA1)
#define bfin_write_CAN1_MB30_DATA1(val)		bfin_write16(CAN1_MB30_DATA1, val)
#define bfin_read_CAN1_MB30_DATA2()		bfin_read16(CAN1_MB30_DATA2)
#define bfin_write_CAN1_MB30_DATA2(val)		bfin_write16(CAN1_MB30_DATA2, val)
#define bfin_read_CAN1_MB30_DATA3()		bfin_read16(CAN1_MB30_DATA3)
#define bfin_write_CAN1_MB30_DATA3(val)		bfin_write16(CAN1_MB30_DATA3, val)
#define bfin_read_CAN1_MB30_LENGTH()		bfin_read16(CAN1_MB30_LENGTH)
#define bfin_write_CAN1_MB30_LENGTH(val)	bfin_write16(CAN1_MB30_LENGTH, val)
#define bfin_read_CAN1_MB30_TIMESTAMP()		bfin_read16(CAN1_MB30_TIMESTAMP)
#define bfin_write_CAN1_MB30_TIMESTAMP(val)	bfin_write16(CAN1_MB30_TIMESTAMP, val)
#define bfin_read_CAN1_MB30_ID0()		bfin_read16(CAN1_MB30_ID0)
#define bfin_write_CAN1_MB30_ID0(val)		bfin_write16(CAN1_MB30_ID0, val)
#define bfin_read_CAN1_MB30_ID1()		bfin_read16(CAN1_MB30_ID1)
#define bfin_write_CAN1_MB30_ID1(val)		bfin_write16(CAN1_MB30_ID1, val)
#define bfin_read_CAN1_MB31_DATA0()		bfin_read16(CAN1_MB31_DATA0)
#define bfin_write_CAN1_MB31_DATA0(val)		bfin_write16(CAN1_MB31_DATA0, val)
#define bfin_read_CAN1_MB31_DATA1()		bfin_read16(CAN1_MB31_DATA1)
#define bfin_write_CAN1_MB31_DATA1(val)		bfin_write16(CAN1_MB31_DATA1, val)
#define bfin_read_CAN1_MB31_DATA2()		bfin_read16(CAN1_MB31_DATA2)
#define bfin_write_CAN1_MB31_DATA2(val)		bfin_write16(CAN1_MB31_DATA2, val)
#define bfin_read_CAN1_MB31_DATA3()		bfin_read16(CAN1_MB31_DATA3)
#define bfin_write_CAN1_MB31_DATA3(val)		bfin_write16(CAN1_MB31_DATA3, val)
#define bfin_read_CAN1_MB31_LENGTH()		bfin_read16(CAN1_MB31_LENGTH)
#define bfin_write_CAN1_MB31_LENGTH(val)	bfin_write16(CAN1_MB31_LENGTH, val)
#define bfin_read_CAN1_MB31_TIMESTAMP()		bfin_read16(CAN1_MB31_TIMESTAMP)
#define bfin_write_CAN1_MB31_TIMESTAMP(val)	bfin_write16(CAN1_MB31_TIMESTAMP, val)
#define bfin_read_CAN1_MB31_ID0()		bfin_read16(CAN1_MB31_ID0)
#define bfin_write_CAN1_MB31_ID0(val)		bfin_write16(CAN1_MB31_ID0, val)
#define bfin_read_CAN1_MB31_ID1()		bfin_read16(CAN1_MB31_ID1)
#define bfin_write_CAN1_MB31_ID1(val)		bfin_write16(CAN1_MB31_ID1, val)

/* ATAPI Registers */

#define bfin_read_ATAPI_CONTROL()		bfin_read16(ATAPI_CONTROL)
#define bfin_write_ATAPI_CONTROL(val)		bfin_write16(ATAPI_CONTROL, val)
#define bfin_read_ATAPI_STATUS()		bfin_read16(ATAPI_STATUS)
#define bfin_write_ATAPI_STATUS(val)		bfin_write16(ATAPI_STATUS, val)
#define bfin_read_ATAPI_DEV_ADDR()		bfin_read16(ATAPI_DEV_ADDR)
#define bfin_write_ATAPI_DEV_ADDR(val)		bfin_write16(ATAPI_DEV_ADDR, val)
#define bfin_read_ATAPI_DEV_TXBUF()		bfin_read16(ATAPI_DEV_TXBUF)
#define bfin_write_ATAPI_DEV_TXBUF(val)		bfin_write16(ATAPI_DEV_TXBUF, val)
#define bfin_read_ATAPI_DEV_RXBUF()		bfin_read16(ATAPI_DEV_RXBUF)
#define bfin_write_ATAPI_DEV_RXBUF(val)		bfin_write16(ATAPI_DEV_RXBUF, val)
#define bfin_read_ATAPI_INT_MASK()		bfin_read16(ATAPI_INT_MASK)
#define bfin_write_ATAPI_INT_MASK(val)		bfin_write16(ATAPI_INT_MASK, val)
#define bfin_read_ATAPI_INT_STATUS()		bfin_read16(ATAPI_INT_STATUS)
#define bfin_write_ATAPI_INT_STATUS(val)	bfin_write16(ATAPI_INT_STATUS, val)
#define bfin_read_ATAPI_XFER_LEN()		bfin_read16(ATAPI_XFER_LEN)
#define bfin_write_ATAPI_XFER_LEN(val)		bfin_write16(ATAPI_XFER_LEN, val)
#define bfin_read_ATAPI_LINE_STATUS()		bfin_read16(ATAPI_LINE_STATUS)
#define bfin_write_ATAPI_LINE_STATUS(val)	bfin_write16(ATAPI_LINE_STATUS, val)
#define bfin_read_ATAPI_SM_STATE()		bfin_read16(ATAPI_SM_STATE)
#define bfin_write_ATAPI_SM_STATE(val)		bfin_write16(ATAPI_SM_STATE, val)
#define bfin_read_ATAPI_TERMINATE()		bfin_read16(ATAPI_TERMINATE)
#define bfin_write_ATAPI_TERMINATE(val)		bfin_write16(ATAPI_TERMINATE, val)
#define bfin_read_ATAPI_PIO_TFRCNT()		bfin_read16(ATAPI_PIO_TFRCNT)
#define bfin_write_ATAPI_PIO_TFRCNT(val)	bfin_write16(ATAPI_PIO_TFRCNT, val)
#define bfin_read_ATAPI_DMA_TFRCNT()		bfin_read16(ATAPI_DMA_TFRCNT)
#define bfin_write_ATAPI_DMA_TFRCNT(val)	bfin_write16(ATAPI_DMA_TFRCNT, val)
#define bfin_read_ATAPI_UMAIN_TFRCNT()		bfin_read16(ATAPI_UMAIN_TFRCNT)
#define bfin_write_ATAPI_UMAIN_TFRCNT(val)	bfin_write16(ATAPI_UMAIN_TFRCNT, val)
#define bfin_read_ATAPI_UDMAOUT_TFRCNT()	bfin_read16(ATAPI_UDMAOUT_TFRCNT)
#define bfin_write_ATAPI_UDMAOUT_TFRCNT(val)	bfin_write16(ATAPI_UDMAOUT_TFRCNT, val)
#define bfin_read_ATAPI_REG_TIM_0()		bfin_read16(ATAPI_REG_TIM_0)
#define bfin_write_ATAPI_REG_TIM_0(val)		bfin_write16(ATAPI_REG_TIM_0, val)
#define bfin_read_ATAPI_PIO_TIM_0()		bfin_read16(ATAPI_PIO_TIM_0)
#define bfin_write_ATAPI_PIO_TIM_0(val)		bfin_write16(ATAPI_PIO_TIM_0, val)
#define bfin_read_ATAPI_PIO_TIM_1()		bfin_read16(ATAPI_PIO_TIM_1)
#define bfin_write_ATAPI_PIO_TIM_1(val)		bfin_write16(ATAPI_PIO_TIM_1, val)
#define bfin_read_ATAPI_MULTI_TIM_0()		bfin_read16(ATAPI_MULTI_TIM_0)
#define bfin_write_ATAPI_MULTI_TIM_0(val)	bfin_write16(ATAPI_MULTI_TIM_0, val)
#define bfin_read_ATAPI_MULTI_TIM_1()		bfin_read16(ATAPI_MULTI_TIM_1)
#define bfin_write_ATAPI_MULTI_TIM_1(val)	bfin_write16(ATAPI_MULTI_TIM_1, val)
#define bfin_read_ATAPI_MULTI_TIM_2()		bfin_read16(ATAPI_MULTI_TIM_2)
#define bfin_write_ATAPI_MULTI_TIM_2(val)	bfin_write16(ATAPI_MULTI_TIM_2, val)
#define bfin_read_ATAPI_ULTRA_TIM_0()		bfin_read16(ATAPI_ULTRA_TIM_0)
#define bfin_write_ATAPI_ULTRA_TIM_0(val)	bfin_write16(ATAPI_ULTRA_TIM_0, val)
#define bfin_read_ATAPI_ULTRA_TIM_1()		bfin_read16(ATAPI_ULTRA_TIM_1)
#define bfin_write_ATAPI_ULTRA_TIM_1(val)	bfin_write16(ATAPI_ULTRA_TIM_1, val)
#define bfin_read_ATAPI_ULTRA_TIM_2()		bfin_read16(ATAPI_ULTRA_TIM_2)
#define bfin_write_ATAPI_ULTRA_TIM_2(val)	bfin_write16(ATAPI_ULTRA_TIM_2, val)
#define bfin_read_ATAPI_ULTRA_TIM_3()		bfin_read16(ATAPI_ULTRA_TIM_3)
#define bfin_write_ATAPI_ULTRA_TIM_3(val)	bfin_write16(ATAPI_ULTRA_TIM_3, val)

/* SDH Registers */

#define bfin_read_SDH_PWR_CTL()		bfin_read16(SDH_PWR_CTL)
#define bfin_write_SDH_PWR_CTL(val)	bfin_write16(SDH_PWR_CTL, val)
#define bfin_read_SDH_CLK_CTL()		bfin_read16(SDH_CLK_CTL)
#define bfin_write_SDH_CLK_CTL(val)	bfin_write16(SDH_CLK_CTL, val)
#define bfin_read_SDH_ARGUMENT()	bfin_read32(SDH_ARGUMENT)
#define bfin_write_SDH_ARGUMENT(val)	bfin_write32(SDH_ARGUMENT, val)
#define bfin_read_SDH_COMMAND()		bfin_read16(SDH_COMMAND)
#define bfin_write_SDH_COMMAND(val)	bfin_write16(SDH_COMMAND, val)
#define bfin_read_SDH_RESP_CMD()	bfin_read16(SDH_RESP_CMD)
#define bfin_write_SDH_RESP_CMD(val)	bfin_write16(SDH_RESP_CMD, val)
#define bfin_read_SDH_RESPONSE0()	bfin_read32(SDH_RESPONSE0)
#define bfin_write_SDH_RESPONSE0(val)	bfin_write32(SDH_RESPONSE0, val)
#define bfin_read_SDH_RESPONSE1()	bfin_read32(SDH_RESPONSE1)
#define bfin_write_SDH_RESPONSE1(val)	bfin_write32(SDH_RESPONSE1, val)
#define bfin_read_SDH_RESPONSE2()	bfin_read32(SDH_RESPONSE2)
#define bfin_write_SDH_RESPONSE2(val)	bfin_write32(SDH_RESPONSE2, val)
#define bfin_read_SDH_RESPONSE3()	bfin_read32(SDH_RESPONSE3)
#define bfin_write_SDH_RESPONSE3(val)	bfin_write32(SDH_RESPONSE3, val)
#define bfin_read_SDH_DATA_TIMER()	bfin_read32(SDH_DATA_TIMER)
#define bfin_write_SDH_DATA_TIMER(val)	bfin_write32(SDH_DATA_TIMER, val)
#define bfin_read_SDH_DATA_LGTH()	bfin_read16(SDH_DATA_LGTH)
#define bfin_write_SDH_DATA_LGTH(val)	bfin_write16(SDH_DATA_LGTH, val)
#define bfin_read_SDH_DATA_CTL()	bfin_read16(SDH_DATA_CTL)
#define bfin_write_SDH_DATA_CTL(val)	bfin_write16(SDH_DATA_CTL, val)
#define bfin_read_SDH_DATA_CNT()	bfin_read16(SDH_DATA_CNT)
#define bfin_write_SDH_DATA_CNT(val)	bfin_write16(SDH_DATA_CNT, val)
#define bfin_read_SDH_STATUS()		bfin_read32(SDH_STATUS)
#define bfin_write_SDH_STATUS(val)	bfin_write32(SDH_STATUS, val)
#define bfin_read_SDH_STATUS_CLR()	bfin_read16(SDH_STATUS_CLR)
#define bfin_write_SDH_STATUS_CLR(val)	bfin_write16(SDH_STATUS_CLR, val)
#define bfin_read_SDH_MASK0()		bfin_read32(SDH_MASK0)
#define bfin_write_SDH_MASK0(val)	bfin_write32(SDH_MASK0, val)
#define bfin_read_SDH_MASK1()		bfin_read32(SDH_MASK1)
#define bfin_write_SDH_MASK1(val)	bfin_write32(SDH_MASK1, val)
#define bfin_read_SDH_FIFO_CNT()	bfin_read16(SDH_FIFO_CNT)
#define bfin_write_SDH_FIFO_CNT(val)	bfin_write16(SDH_FIFO_CNT, val)
#define bfin_read_SDH_FIFO()		bfin_read32(SDH_FIFO)
#define bfin_write_SDH_FIFO(val)	bfin_write32(SDH_FIFO, val)
#define bfin_read_SDH_E_STATUS()	bfin_read16(SDH_E_STATUS)
#define bfin_write_SDH_E_STATUS(val)	bfin_write16(SDH_E_STATUS, val)
#define bfin_read_SDH_E_MASK()		bfin_read16(SDH_E_MASK)
#define bfin_write_SDH_E_MASK(val)	bfin_write16(SDH_E_MASK, val)
#define bfin_read_SDH_CFG()		bfin_read16(SDH_CFG)
#define bfin_write_SDH_CFG(val)		bfin_write16(SDH_CFG, val)
#define bfin_read_SDH_RD_WAIT_EN()	bfin_read16(SDH_RD_WAIT_EN)
#define bfin_write_SDH_RD_WAIT_EN(val)	bfin_write16(SDH_RD_WAIT_EN, val)
#define bfin_read_SDH_PID0()		bfin_read16(SDH_PID0)
#define bfin_write_SDH_PID0(val)	bfin_write16(SDH_PID0, val)
#define bfin_read_SDH_PID1()		bfin_read16(SDH_PID1)
#define bfin_write_SDH_PID1(val)	bfin_write16(SDH_PID1, val)
#define bfin_read_SDH_PID2()		bfin_read16(SDH_PID2)
#define bfin_write_SDH_PID2(val)	bfin_write16(SDH_PID2, val)
#define bfin_read_SDH_PID3()		bfin_read16(SDH_PID3)
#define bfin_write_SDH_PID3(val)	bfin_write16(SDH_PID3, val)
#define bfin_read_SDH_PID4()		bfin_read16(SDH_PID4)
#define bfin_write_SDH_PID4(val)	bfin_write16(SDH_PID4, val)
#define bfin_read_SDH_PID5()		bfin_read16(SDH_PID5)
#define bfin_write_SDH_PID5(val)	bfin_write16(SDH_PID5, val)
#define bfin_read_SDH_PID6()		bfin_read16(SDH_PID6)
#define bfin_write_SDH_PID6(val)	bfin_write16(SDH_PID6, val)
#define bfin_read_SDH_PID7()		bfin_read16(SDH_PID7)
#define bfin_write_SDH_PID7(val)	bfin_write16(SDH_PID7, val)

/* HOST Port Registers */

#define bfin_read_HOST_CONTROL()	bfin_read16(HOST_CONTROL)
#define bfin_write_HOST_CONTROL(val)	bfin_write16(HOST_CONTROL, val)
#define bfin_read_HOST_STATUS()		bfin_read16(HOST_STATUS)
#define bfin_write_HOST_STATUS(val)	bfin_write16(HOST_STATUS, val)
#define bfin_read_HOST_TIMEOUT()	bfin_read16(HOST_TIMEOUT)
#define bfin_write_HOST_TIMEOUT(val)	bfin_write16(HOST_TIMEOUT, val)

/* USB Control Registers */

#define bfin_read_USB_FADDR()		bfin_read16(USB_FADDR)
#define bfin_write_USB_FADDR(val)	bfin_write16(USB_FADDR, val)
#define bfin_read_USB_POWER()		bfin_read16(USB_POWER)
#define bfin_write_USB_POWER(val)	bfin_write16(USB_POWER, val)
#define bfin_read_USB_INTRTX()		bfin_read16(USB_INTRTX)
#define bfin_write_USB_INTRTX(val)	bfin_write16(USB_INTRTX, val)
#define bfin_read_USB_INTRRX()		bfin_read16(USB_INTRRX)
#define bfin_write_USB_INTRRX(val)	bfin_write16(USB_INTRRX, val)
#define bfin_read_USB_INTRTXE()		bfin_read16(USB_INTRTXE)
#define bfin_write_USB_INTRTXE(val)	bfin_write16(USB_INTRTXE, val)
#define bfin_read_USB_INTRRXE()		bfin_read16(USB_INTRRXE)
#define bfin_write_USB_INTRRXE(val)	bfin_write16(USB_INTRRXE, val)
#define bfin_read_USB_INTRUSB()		bfin_read16(USB_INTRUSB)
#define bfin_write_USB_INTRUSB(val)	bfin_write16(USB_INTRUSB, val)
#define bfin_read_USB_INTRUSBE()	bfin_read16(USB_INTRUSBE)
#define bfin_write_USB_INTRUSBE(val)	bfin_write16(USB_INTRUSBE, val)
#define bfin_read_USB_FRAME()		bfin_read16(USB_FRAME)
#define bfin_write_USB_FRAME(val)	bfin_write16(USB_FRAME, val)
#define bfin_read_USB_INDEX()		bfin_read16(USB_INDEX)
#define bfin_write_USB_INDEX(val)	bfin_write16(USB_INDEX, val)
#define bfin_read_USB_TESTMODE()	bfin_read16(USB_TESTMODE)
#define bfin_write_USB_TESTMODE(val)	bfin_write16(USB_TESTMODE, val)
#define bfin_read_USB_GLOBINTR()	bfin_read16(USB_GLOBINTR)
#define bfin_write_USB_GLOBINTR(val)	bfin_write16(USB_GLOBINTR, val)
#define bfin_read_USB_GLOBAL_CTL()	bfin_read16(USB_GLOBAL_CTL)
#define bfin_write_USB_GLOBAL_CTL(val)	bfin_write16(USB_GLOBAL_CTL, val)

/* USB Packet Control Registers */

#define bfin_read_USB_TX_MAX_PACKET()		bfin_read16(USB_TX_MAX_PACKET)
#define bfin_write_USB_TX_MAX_PACKET(val)	bfin_write16(USB_TX_MAX_PACKET, val)
#define bfin_read_USB_CSR0()			bfin_read16(USB_CSR0)
#define bfin_write_USB_CSR0(val)		bfin_write16(USB_CSR0, val)
#define bfin_read_USB_TXCSR()			bfin_read16(USB_TXCSR)
#define bfin_write_USB_TXCSR(val)		bfin_write16(USB_TXCSR, val)
#define bfin_read_USB_RX_MAX_PACKET()		bfin_read16(USB_RX_MAX_PACKET)
#define bfin_write_USB_RX_MAX_PACKET(val)	bfin_write16(USB_RX_MAX_PACKET, val)
#define bfin_read_USB_RXCSR()			bfin_read16(USB_RXCSR)
#define bfin_write_USB_RXCSR(val)		bfin_write16(USB_RXCSR, val)
#define bfin_read_USB_COUNT0()			bfin_read16(USB_COUNT0)
#define bfin_write_USB_COUNT0(val)		bfin_write16(USB_COUNT0, val)
#define bfin_read_USB_RXCOUNT()			bfin_read16(USB_RXCOUNT)
#define bfin_write_USB_RXCOUNT(val)		bfin_write16(USB_RXCOUNT, val)
#define bfin_read_USB_TXTYPE()			bfin_read16(USB_TXTYPE)
#define bfin_write_USB_TXTYPE(val)		bfin_write16(USB_TXTYPE, val)
#define bfin_read_USB_NAKLIMIT0()		bfin_read16(USB_NAKLIMIT0)
#define bfin_write_USB_NAKLIMIT0(val)		bfin_write16(USB_NAKLIMIT0, val)
#define bfin_read_USB_TXINTERVAL()		bfin_read16(USB_TXINTERVAL)
#define bfin_write_USB_TXINTERVAL(val)		bfin_write16(USB_TXINTERVAL, val)
#define bfin_read_USB_RXTYPE()			bfin_read16(USB_RXTYPE)
#define bfin_write_USB_RXTYPE(val)		bfin_write16(USB_RXTYPE, val)
#define bfin_read_USB_RXINTERVAL()		bfin_read16(USB_RXINTERVAL)
#define bfin_write_USB_RXINTERVAL(val)		bfin_write16(USB_RXINTERVAL, val)
#define bfin_read_USB_TXCOUNT()			bfin_read16(USB_TXCOUNT)
#define bfin_write_USB_TXCOUNT(val)		bfin_write16(USB_TXCOUNT, val)

/* USB Endbfin_read_()oint FIFO Registers */

#define bfin_read_USB_EP0_FIFO()		bfin_read16(USB_EP0_FIFO)
#define bfin_write_USB_EP0_FIFO(val)		bfin_write16(USB_EP0_FIFO, val)
#define bfin_read_USB_EP1_FIFO()		bfin_read16(USB_EP1_FIFO)
#define bfin_write_USB_EP1_FIFO(val)		bfin_write16(USB_EP1_FIFO, val)
#define bfin_read_USB_EP2_FIFO()		bfin_read16(USB_EP2_FIFO)
#define bfin_write_USB_EP2_FIFO(val)		bfin_write16(USB_EP2_FIFO, val)
#define bfin_read_USB_EP3_FIFO()		bfin_read16(USB_EP3_FIFO)
#define bfin_write_USB_EP3_FIFO(val)		bfin_write16(USB_EP3_FIFO, val)
#define bfin_read_USB_EP4_FIFO()		bfin_read16(USB_EP4_FIFO)
#define bfin_write_USB_EP4_FIFO(val)		bfin_write16(USB_EP4_FIFO, val)
#define bfin_read_USB_EP5_FIFO()		bfin_read16(USB_EP5_FIFO)
#define bfin_write_USB_EP5_FIFO(val)		bfin_write16(USB_EP5_FIFO, val)
#define bfin_read_USB_EP6_FIFO()		bfin_read16(USB_EP6_FIFO)
#define bfin_write_USB_EP6_FIFO(val)		bfin_write16(USB_EP6_FIFO, val)
#define bfin_read_USB_EP7_FIFO()		bfin_read16(USB_EP7_FIFO)
#define bfin_write_USB_EP7_FIFO(val)		bfin_write16(USB_EP7_FIFO, val)

/* USB OTG Control Registers */

#define bfin_read_USB_OTG_DEV_CTL()		bfin_read16(USB_OTG_DEV_CTL)
#define bfin_write_USB_OTG_DEV_CTL(val)		bfin_write16(USB_OTG_DEV_CTL, val)
#define bfin_read_USB_OTG_VBUS_IRQ()		bfin_read16(USB_OTG_VBUS_IRQ)
#define bfin_write_USB_OTG_VBUS_IRQ(val)	bfin_write16(USB_OTG_VBUS_IRQ, val)
#define bfin_read_USB_OTG_VBUS_MASK()		bfin_read16(USB_OTG_VBUS_MASK)
#define bfin_write_USB_OTG_VBUS_MASK(val)	bfin_write16(USB_OTG_VBUS_MASK, val)

/* USB Phy Control Registers */

#define bfin_read_USB_LINKINFO()		bfin_read16(USB_LINKINFO)
#define bfin_write_USB_LINKINFO(val)		bfin_write16(USB_LINKINFO, val)
#define bfin_read_USB_VPLEN()			bfin_read16(USB_VPLEN)
#define bfin_write_USB_VPLEN(val)		bfin_write16(USB_VPLEN, val)
#define bfin_read_USB_HS_EOF1()			bfin_read16(USB_HS_EOF1)
#define bfin_write_USB_HS_EOF1(val)		bfin_write16(USB_HS_EOF1, val)
#define bfin_read_USB_FS_EOF1()			bfin_read16(USB_FS_EOF1)
#define bfin_write_USB_FS_EOF1(val)		bfin_write16(USB_FS_EOF1, val)
#define bfin_read_USB_LS_EOF1()			bfin_read16(USB_LS_EOF1)
#define bfin_write_USB_LS_EOF1(val)		bfin_write16(USB_LS_EOF1, val)

/* (APHY_CNTRL is for ADI usage only) */

#define bfin_read_USB_APHY_CNTRL()		bfin_read16(USB_APHY_CNTRL)
#define bfin_write_USB_APHY_CNTRL(val)		bfin_write16(USB_APHY_CNTRL, val)

/* (APHY_CALIB is for ADI usage only) */

#define bfin_read_USB_APHY_CALIB()		bfin_read16(USB_APHY_CALIB)
#define bfin_write_USB_APHY_CALIB(val)		bfin_write16(USB_APHY_CALIB, val)
#define bfin_read_USB_APHY_CNTRL2()		bfin_read16(USB_APHY_CNTRL2)
#define bfin_write_USB_APHY_CNTRL2(val)		bfin_write16(USB_APHY_CNTRL2, val)

/* (PHY_TEST is for ADI usage only) */

#define bfin_read_USB_PHY_TEST()		bfin_read16(USB_PHY_TEST)
#define bfin_write_USB_PHY_TEST(val)		bfin_write16(USB_PHY_TEST, val)
#define bfin_read_USB_PLLOSC_CTRL()		bfin_read16(USB_PLLOSC_CTRL)
#define bfin_write_USB_PLLOSC_CTRL(val)		bfin_write16(USB_PLLOSC_CTRL, val)
#define bfin_read_USB_SRP_CLKDIV()		bfin_read16(USB_SRP_CLKDIV)
#define bfin_write_USB_SRP_CLKDIV(val)		bfin_write16(USB_SRP_CLKDIV, val)

/* USB Endbfin_read_()oint 0 Control Registers */

#define bfin_read_USB_EP_NI0_TXMAXP()		bfin_read16(USB_EP_NI0_TXMAXP)
#define bfin_write_USB_EP_NI0_TXMAXP(val)	bfin_write16(USB_EP_NI0_TXMAXP, val)
#define bfin_read_USB_EP_NI0_TXCSR()		bfin_read16(USB_EP_NI0_TXCSR)
#define bfin_write_USB_EP_NI0_TXCSR(val)	bfin_write16(USB_EP_NI0_TXCSR, val)
#define bfin_read_USB_EP_NI0_RXMAXP()		bfin_read16(USB_EP_NI0_RXMAXP)
#define bfin_write_USB_EP_NI0_RXMAXP(val)	bfin_write16(USB_EP_NI0_RXMAXP, val)
#define bfin_read_USB_EP_NI0_RXCSR()		bfin_read16(USB_EP_NI0_RXCSR)
#define bfin_write_USB_EP_NI0_RXCSR(val)	bfin_write16(USB_EP_NI0_RXCSR, val)
#define bfin_read_USB_EP_NI0_RXCOUNT()		bfin_read16(USB_EP_NI0_RXCOUNT)
#define bfin_write_USB_EP_NI0_RXCOUNT(val)	bfin_write16(USB_EP_NI0_RXCOUNT, val)
#define bfin_read_USB_EP_NI0_TXTYPE()		bfin_read16(USB_EP_NI0_TXTYPE)
#define bfin_write_USB_EP_NI0_TXTYPE(val)	bfin_write16(USB_EP_NI0_TXTYPE, val)
#define bfin_read_USB_EP_NI0_TXINTERVAL()	bfin_read16(USB_EP_NI0_TXINTERVAL)
#define bfin_write_USB_EP_NI0_TXINTERVAL(val)	bfin_write16(USB_EP_NI0_TXINTERVAL, val)
#define bfin_read_USB_EP_NI0_RXTYPE()		bfin_read16(USB_EP_NI0_RXTYPE)
#define bfin_write_USB_EP_NI0_RXTYPE(val)	bfin_write16(USB_EP_NI0_RXTYPE, val)
#define bfin_read_USB_EP_NI0_RXINTERVAL()	bfin_read16(USB_EP_NI0_RXINTERVAL)
#define bfin_write_USB_EP_NI0_RXINTERVAL(val)	bfin_write16(USB_EP_NI0_RXINTERVAL, val)

/* USB Endbfin_read_()oint 1 Control Registers */

#define bfin_read_USB_EP_NI0_TXCOUNT()		bfin_read16(USB_EP_NI0_TXCOUNT)
#define bfin_write_USB_EP_NI0_TXCOUNT(val)	bfin_write16(USB_EP_NI0_TXCOUNT, val)
#define bfin_read_USB_EP_NI1_TXMAXP()		bfin_read16(USB_EP_NI1_TXMAXP)
#define bfin_write_USB_EP_NI1_TXMAXP(val)	bfin_write16(USB_EP_NI1_TXMAXP, val)
#define bfin_read_USB_EP_NI1_TXCSR()		bfin_read16(USB_EP_NI1_TXCSR)
#define bfin_write_USB_EP_NI1_TXCSR(val)	bfin_write16(USB_EP_NI1_TXCSR, val)
#define bfin_read_USB_EP_NI1_RXMAXP()		bfin_read16(USB_EP_NI1_RXMAXP)
#define bfin_write_USB_EP_NI1_RXMAXP(val)	bfin_write16(USB_EP_NI1_RXMAXP, val)
#define bfin_read_USB_EP_NI1_RXCSR()		bfin_read16(USB_EP_NI1_RXCSR)
#define bfin_write_USB_EP_NI1_RXCSR(val)	bfin_write16(USB_EP_NI1_RXCSR, val)
#define bfin_read_USB_EP_NI1_RXCOUNT()		bfin_read16(USB_EP_NI1_RXCOUNT)
#define bfin_write_USB_EP_NI1_RXCOUNT(val)	bfin_write16(USB_EP_NI1_RXCOUNT, val)
#define bfin_read_USB_EP_NI1_TXTYPE()		bfin_read16(USB_EP_NI1_TXTYPE)
#define bfin_write_USB_EP_NI1_TXTYPE(val)	bfin_write16(USB_EP_NI1_TXTYPE, val)
#define bfin_read_USB_EP_NI1_TXINTERVAL()	bfin_read16(USB_EP_NI1_TXINTERVAL)
#define bfin_write_USB_EP_NI1_TXINTERVAL(val)	bfin_write16(USB_EP_NI1_TXINTERVAL, val)
#define bfin_read_USB_EP_NI1_RXTYPE()		bfin_read16(USB_EP_NI1_RXTYPE)
#define bfin_write_USB_EP_NI1_RXTYPE(val)	bfin_write16(USB_EP_NI1_RXTYPE, val)
#define bfin_read_USB_EP_NI1_RXINTERVAL()	bfin_read16(USB_EP_NI1_RXINTERVAL)
#define bfin_write_USB_EP_NI1_RXINTERVAL(val)	bfin_write16(USB_EP_NI1_RXINTERVAL, val)

/* USB Endbfin_read_()oint 2 Control Registers */

#define bfin_read_USB_EP_NI1_TXCOUNT()		bfin_read16(USB_EP_NI1_TXCOUNT)
#define bfin_write_USB_EP_NI1_TXCOUNT(val)	bfin_write16(USB_EP_NI1_TXCOUNT, val)
#define bfin_read_USB_EP_NI2_TXMAXP()		bfin_read16(USB_EP_NI2_TXMAXP)
#define bfin_write_USB_EP_NI2_TXMAXP(val)	bfin_write16(USB_EP_NI2_TXMAXP, val)
#define bfin_read_USB_EP_NI2_TXCSR()		bfin_read16(USB_EP_NI2_TXCSR)
#define bfin_write_USB_EP_NI2_TXCSR(val)	bfin_write16(USB_EP_NI2_TXCSR, val)
#define bfin_read_USB_EP_NI2_RXMAXP()		bfin_read16(USB_EP_NI2_RXMAXP)
#define bfin_write_USB_EP_NI2_RXMAXP(val)	bfin_write16(USB_EP_NI2_RXMAXP, val)
#define bfin_read_USB_EP_NI2_RXCSR()		bfin_read16(USB_EP_NI2_RXCSR)
#define bfin_write_USB_EP_NI2_RXCSR(val)	bfin_write16(USB_EP_NI2_RXCSR, val)
#define bfin_read_USB_EP_NI2_RXCOUNT()		bfin_read16(USB_EP_NI2_RXCOUNT)
#define bfin_write_USB_EP_NI2_RXCOUNT(val)	bfin_write16(USB_EP_NI2_RXCOUNT, val)
#define bfin_read_USB_EP_NI2_TXTYPE()		bfin_read16(USB_EP_NI2_TXTYPE)
#define bfin_write_USB_EP_NI2_TXTYPE(val)	bfin_write16(USB_EP_NI2_TXTYPE, val)
#define bfin_read_USB_EP_NI2_TXINTERVAL()	bfin_read16(USB_EP_NI2_TXINTERVAL)
#define bfin_write_USB_EP_NI2_TXINTERVAL(val)	bfin_write16(USB_EP_NI2_TXINTERVAL, val)
#define bfin_read_USB_EP_NI2_RXTYPE()		bfin_read16(USB_EP_NI2_RXTYPE)
#define bfin_write_USB_EP_NI2_RXTYPE(val)	bfin_write16(USB_EP_NI2_RXTYPE, val)
#define bfin_read_USB_EP_NI2_RXINTERVAL()	bfin_read16(USB_EP_NI2_RXINTERVAL)
#define bfin_write_USB_EP_NI2_RXINTERVAL(val)	bfin_write16(USB_EP_NI2_RXINTERVAL, val)

/* USB Endbfin_read_()oint 3 Control Registers */

#define bfin_read_USB_EP_NI2_TXCOUNT()		bfin_read16(USB_EP_NI2_TXCOUNT)
#define bfin_write_USB_EP_NI2_TXCOUNT(val)	bfin_write16(USB_EP_NI2_TXCOUNT, val)
#define bfin_read_USB_EP_NI3_TXMAXP()		bfin_read16(USB_EP_NI3_TXMAXP)
#define bfin_write_USB_EP_NI3_TXMAXP(val)	bfin_write16(USB_EP_NI3_TXMAXP, val)
#define bfin_read_USB_EP_NI3_TXCSR()		bfin_read16(USB_EP_NI3_TXCSR)
#define bfin_write_USB_EP_NI3_TXCSR(val)	bfin_write16(USB_EP_NI3_TXCSR, val)
#define bfin_read_USB_EP_NI3_RXMAXP()		bfin_read16(USB_EP_NI3_RXMAXP)
#define bfin_write_USB_EP_NI3_RXMAXP(val)	bfin_write16(USB_EP_NI3_RXMAXP, val)
#define bfin_read_USB_EP_NI3_RXCSR()		bfin_read16(USB_EP_NI3_RXCSR)
#define bfin_write_USB_EP_NI3_RXCSR(val)	bfin_write16(USB_EP_NI3_RXCSR, val)
#define bfin_read_USB_EP_NI3_RXCOUNT()		bfin_read16(USB_EP_NI3_RXCOUNT)
#define bfin_write_USB_EP_NI3_RXCOUNT(val)	bfin_write16(USB_EP_NI3_RXCOUNT, val)
#define bfin_read_USB_EP_NI3_TXTYPE()		bfin_read16(USB_EP_NI3_TXTYPE)
#define bfin_write_USB_EP_NI3_TXTYPE(val)	bfin_write16(USB_EP_NI3_TXTYPE, val)
#define bfin_read_USB_EP_NI3_TXINTERVAL()	bfin_read16(USB_EP_NI3_TXINTERVAL)
#define bfin_write_USB_EP_NI3_TXINTERVAL(val)	bfin_write16(USB_EP_NI3_TXINTERVAL, val)
#define bfin_read_USB_EP_NI3_RXTYPE()		bfin_read16(USB_EP_NI3_RXTYPE)
#define bfin_write_USB_EP_NI3_RXTYPE(val)	bfin_write16(USB_EP_NI3_RXTYPE, val)
#define bfin_read_USB_EP_NI3_RXINTERVAL()	bfin_read16(USB_EP_NI3_RXINTERVAL)
#define bfin_write_USB_EP_NI3_RXINTERVAL(val)	bfin_write16(USB_EP_NI3_RXINTERVAL, val)

/* USB Endbfin_read_()oint 4 Control Registers */

#define bfin_read_USB_EP_NI3_TXCOUNT()		bfin_read16(USB_EP_NI3_TXCOUNT)
#define bfin_write_USB_EP_NI3_TXCOUNT(val)	bfin_write16(USB_EP_NI3_TXCOUNT, val)
#define bfin_read_USB_EP_NI4_TXMAXP()		bfin_read16(USB_EP_NI4_TXMAXP)
#define bfin_write_USB_EP_NI4_TXMAXP(val)	bfin_write16(USB_EP_NI4_TXMAXP, val)
#define bfin_read_USB_EP_NI4_TXCSR()		bfin_read16(USB_EP_NI4_TXCSR)
#define bfin_write_USB_EP_NI4_TXCSR(val)	bfin_write16(USB_EP_NI4_TXCSR, val)
#define bfin_read_USB_EP_NI4_RXMAXP()		bfin_read16(USB_EP_NI4_RXMAXP)
#define bfin_write_USB_EP_NI4_RXMAXP(val)	bfin_write16(USB_EP_NI4_RXMAXP, val)
#define bfin_read_USB_EP_NI4_RXCSR()		bfin_read16(USB_EP_NI4_RXCSR)
#define bfin_write_USB_EP_NI4_RXCSR(val)	bfin_write16(USB_EP_NI4_RXCSR, val)
#define bfin_read_USB_EP_NI4_RXCOUNT()		bfin_read16(USB_EP_NI4_RXCOUNT)
#define bfin_write_USB_EP_NI4_RXCOUNT(val)	bfin_write16(USB_EP_NI4_RXCOUNT, val)
#define bfin_read_USB_EP_NI4_TXTYPE()		bfin_read16(USB_EP_NI4_TXTYPE)
#define bfin_write_USB_EP_NI4_TXTYPE(val)	bfin_write16(USB_EP_NI4_TXTYPE, val)
#define bfin_read_USB_EP_NI4_TXINTERVAL()	bfin_read16(USB_EP_NI4_TXINTERVAL)
#define bfin_write_USB_EP_NI4_TXINTERVAL(val)	bfin_write16(USB_EP_NI4_TXINTERVAL, val)
#define bfin_read_USB_EP_NI4_RXTYPE()		bfin_read16(USB_EP_NI4_RXTYPE)
#define bfin_write_USB_EP_NI4_RXTYPE(val)	bfin_write16(USB_EP_NI4_RXTYPE, val)
#define bfin_read_USB_EP_NI4_RXINTERVAL()	bfin_read16(USB_EP_NI4_RXINTERVAL)
#define bfin_write_USB_EP_NI4_RXINTERVAL(val)	bfin_write16(USB_EP_NI4_RXINTERVAL, val)

/* USB Endbfin_read_()oint 5 Control Registers */

#define bfin_read_USB_EP_NI4_TXCOUNT()		bfin_read16(USB_EP_NI4_TXCOUNT)
#define bfin_write_USB_EP_NI4_TXCOUNT(val)	bfin_write16(USB_EP_NI4_TXCOUNT, val)
#define bfin_read_USB_EP_NI5_TXMAXP()		bfin_read16(USB_EP_NI5_TXMAXP)
#define bfin_write_USB_EP_NI5_TXMAXP(val)	bfin_write16(USB_EP_NI5_TXMAXP, val)
#define bfin_read_USB_EP_NI5_TXCSR()		bfin_read16(USB_EP_NI5_TXCSR)
#define bfin_write_USB_EP_NI5_TXCSR(val)	bfin_write16(USB_EP_NI5_TXCSR, val)
#define bfin_read_USB_EP_NI5_RXMAXP()		bfin_read16(USB_EP_NI5_RXMAXP)
#define bfin_write_USB_EP_NI5_RXMAXP(val)	bfin_write16(USB_EP_NI5_RXMAXP, val)
#define bfin_read_USB_EP_NI5_RXCSR()		bfin_read16(USB_EP_NI5_RXCSR)
#define bfin_write_USB_EP_NI5_RXCSR(val)	bfin_write16(USB_EP_NI5_RXCSR, val)
#define bfin_read_USB_EP_NI5_RXCOUNT()		bfin_read16(USB_EP_NI5_RXCOUNT)
#define bfin_write_USB_EP_NI5_RXCOUNT(val)	bfin_write16(USB_EP_NI5_RXCOUNT, val)
#define bfin_read_USB_EP_NI5_TXTYPE()		bfin_read16(USB_EP_NI5_TXTYPE)
#define bfin_write_USB_EP_NI5_TXTYPE(val)	bfin_write16(USB_EP_NI5_TXTYPE, val)
#define bfin_read_USB_EP_NI5_TXINTERVAL()	bfin_read16(USB_EP_NI5_TXINTERVAL)
#define bfin_write_USB_EP_NI5_TXINTERVAL(val)	bfin_write16(USB_EP_NI5_TXINTERVAL, val)
#define bfin_read_USB_EP_NI5_RXTYPE()		bfin_read16(USB_EP_NI5_RXTYPE)
#define bfin_write_USB_EP_NI5_RXTYPE(val)	bfin_write16(USB_EP_NI5_RXTYPE, val)
#define bfin_read_USB_EP_NI5_RXINTERVAL()	bfin_read16(USB_EP_NI5_RXINTERVAL)
#define bfin_write_USB_EP_NI5_RXINTERVAL(val)	bfin_write16(USB_EP_NI5_RXINTERVAL, val)

/* USB Endbfin_read_()oint 6 Control Registers */

#define bfin_read_USB_EP_NI5_TXCOUNT()		bfin_read16(USB_EP_NI5_TXCOUNT)
#define bfin_write_USB_EP_NI5_TXCOUNT(val)	bfin_write16(USB_EP_NI5_TXCOUNT, val)
#define bfin_read_USB_EP_NI6_TXMAXP()		bfin_read16(USB_EP_NI6_TXMAXP)
#define bfin_write_USB_EP_NI6_TXMAXP(val)	bfin_write16(USB_EP_NI6_TXMAXP, val)
#define bfin_read_USB_EP_NI6_TXCSR()		bfin_read16(USB_EP_NI6_TXCSR)
#define bfin_write_USB_EP_NI6_TXCSR(val)	bfin_write16(USB_EP_NI6_TXCSR, val)
#define bfin_read_USB_EP_NI6_RXMAXP()		bfin_read16(USB_EP_NI6_RXMAXP)
#define bfin_write_USB_EP_NI6_RXMAXP(val)	bfin_write16(USB_EP_NI6_RXMAXP, val)
#define bfin_read_USB_EP_NI6_RXCSR()		bfin_read16(USB_EP_NI6_RXCSR)
#define bfin_write_USB_EP_NI6_RXCSR(val)	bfin_write16(USB_EP_NI6_RXCSR, val)
#define bfin_read_USB_EP_NI6_RXCOUNT()		bfin_read16(USB_EP_NI6_RXCOUNT)
#define bfin_write_USB_EP_NI6_RXCOUNT(val)	bfin_write16(USB_EP_NI6_RXCOUNT, val)
#define bfin_read_USB_EP_NI6_TXTYPE()		bfin_read16(USB_EP_NI6_TXTYPE)
#define bfin_write_USB_EP_NI6_TXTYPE(val)	bfin_write16(USB_EP_NI6_TXTYPE, val)
#define bfin_read_USB_EP_NI6_TXINTERVAL()	bfin_read16(USB_EP_NI6_TXINTERVAL)
#define bfin_write_USB_EP_NI6_TXINTERVAL(val)	bfin_write16(USB_EP_NI6_TXINTERVAL, val)
#define bfin_read_USB_EP_NI6_RXTYPE()		bfin_read16(USB_EP_NI6_RXTYPE)
#define bfin_write_USB_EP_NI6_RXTYPE(val)	bfin_write16(USB_EP_NI6_RXTYPE, val)
#define bfin_read_USB_EP_NI6_RXINTERVAL()	bfin_read16(USB_EP_NI6_RXINTERVAL)
#define bfin_write_USB_EP_NI6_RXINTERVAL(val)	bfin_write16(USB_EP_NI6_RXINTERVAL, val)

/* USB Endbfin_read_()oint 7 Control Registers */

#define bfin_read_USB_EP_NI6_TXCOUNT()		bfin_read16(USB_EP_NI6_TXCOUNT)
#define bfin_write_USB_EP_NI6_TXCOUNT(val)	bfin_write16(USB_EP_NI6_TXCOUNT, val)
#define bfin_read_USB_EP_NI7_TXMAXP()		bfin_read16(USB_EP_NI7_TXMAXP)
#define bfin_write_USB_EP_NI7_TXMAXP(val)	bfin_write16(USB_EP_NI7_TXMAXP, val)
#define bfin_read_USB_EP_NI7_TXCSR()		bfin_read16(USB_EP_NI7_TXCSR)
#define bfin_write_USB_EP_NI7_TXCSR(val)	bfin_write16(USB_EP_NI7_TXCSR, val)
#define bfin_read_USB_EP_NI7_RXMAXP()		bfin_read16(USB_EP_NI7_RXMAXP)
#define bfin_write_USB_EP_NI7_RXMAXP(val)	bfin_write16(USB_EP_NI7_RXMAXP, val)
#define bfin_read_USB_EP_NI7_RXCSR()		bfin_read16(USB_EP_NI7_RXCSR)
#define bfin_write_USB_EP_NI7_RXCSR(val)	bfin_write16(USB_EP_NI7_RXCSR, val)
#define bfin_read_USB_EP_NI7_RXCOUNT()		bfin_read16(USB_EP_NI7_RXCOUNT)
#define bfin_write_USB_EP_NI7_RXCOUNT(val)	bfin_write16(USB_EP_NI7_RXCOUNT, val)
#define bfin_read_USB_EP_NI7_TXTYPE()		bfin_read16(USB_EP_NI7_TXTYPE)
#define bfin_write_USB_EP_NI7_TXTYPE(val)	bfin_write16(USB_EP_NI7_TXTYPE, val)
#define bfin_read_USB_EP_NI7_TXINTERVAL()	bfin_read16(USB_EP_NI7_TXINTERVAL)
#define bfin_write_USB_EP_NI7_TXINTERVAL(val)	bfin_write16(USB_EP_NI7_TXINTERVAL, val)
#define bfin_read_USB_EP_NI7_RXTYPE()		bfin_read16(USB_EP_NI7_RXTYPE)
#define bfin_write_USB_EP_NI7_RXTYPE(val)	bfin_write16(USB_EP_NI7_RXTYPE, val)
#define bfin_read_USB_EP_NI7_RXINTERVAL()	bfin_read16(USB_EP_NI7_RXINTERVAL)
#define bfin_write_USB_EP_NI7_RXINTERVAL(val)	bfin_write16(USB_EP_NI7_RXINTERVAL, val)
#define bfin_read_USB_EP_NI7_TXCOUNT()		bfin_read16(USB_EP_NI7_TXCOUNT)
#define bfin_write_USB_EP_NI7_TXCOUNT(val)	bfin_write16(USB_EP_NI7_TXCOUNT, val)
#define bfin_read_USB_DMA_INTERRUPT()		bfin_read16(USB_DMA_INTERRUPT)
#define bfin_write_USB_DMA_INTERRUPT(val)	bfin_write16(USB_DMA_INTERRUPT, val)

/* USB Channel 0 Config Registers */

#define bfin_read_USB_DMA0CONTROL()		bfin_read16(USB_DMA0CONTROL)
#define bfin_write_USB_DMA0CONTROL(val)		bfin_write16(USB_DMA0CONTROL, val)
#define bfin_read_USB_DMA0ADDRLOW()		bfin_read16(USB_DMA0ADDRLOW)
#define bfin_write_USB_DMA0ADDRLOW(val)		bfin_write16(USB_DMA0ADDRLOW, val)
#define bfin_read_USB_DMA0ADDRHIGH()		bfin_read16(USB_DMA0ADDRHIGH)
#define bfin_write_USB_DMA0ADDRHIGH(val)	bfin_write16(USB_DMA0ADDRHIGH, val)
#define bfin_read_USB_DMA0COUNTLOW()		bfin_read16(USB_DMA0COUNTLOW)
#define bfin_write_USB_DMA0COUNTLOW(val)	bfin_write16(USB_DMA0COUNTLOW, val)
#define bfin_read_USB_DMA0COUNTHIGH()		bfin_read16(USB_DMA0COUNTHIGH)
#define bfin_write_USB_DMA0COUNTHIGH(val)	bfin_write16(USB_DMA0COUNTHIGH, val)

/* USB Channel 1 Config Registers */

#define bfin_read_USB_DMA1CONTROL()		bfin_read16(USB_DMA1CONTROL)
#define bfin_write_USB_DMA1CONTROL(val)		bfin_write16(USB_DMA1CONTROL, val)
#define bfin_read_USB_DMA1ADDRLOW()		bfin_read16(USB_DMA1ADDRLOW)
#define bfin_write_USB_DMA1ADDRLOW(val)		bfin_write16(USB_DMA1ADDRLOW, val)
#define bfin_read_USB_DMA1ADDRHIGH()		bfin_read16(USB_DMA1ADDRHIGH)
#define bfin_write_USB_DMA1ADDRHIGH(val)	bfin_write16(USB_DMA1ADDRHIGH, val)
#define bfin_read_USB_DMA1COUNTLOW()		bfin_read16(USB_DMA1COUNTLOW)
#define bfin_write_USB_DMA1COUNTLOW(val)	bfin_write16(USB_DMA1COUNTLOW, val)
#define bfin_read_USB_DMA1COUNTHIGH()		bfin_read16(USB_DMA1COUNTHIGH)
#define bfin_write_USB_DMA1COUNTHIGH(val)	bfin_write16(USB_DMA1COUNTHIGH, val)

/* USB Channel 2 Config Registers */

#define bfin_read_USB_DMA2CONTROL()		bfin_read16(USB_DMA2CONTROL)
#define bfin_write_USB_DMA2CONTROL(val)		bfin_write16(USB_DMA2CONTROL, val)
#define bfin_read_USB_DMA2ADDRLOW()		bfin_read16(USB_DMA2ADDRLOW)
#define bfin_write_USB_DMA2ADDRLOW(val)		bfin_write16(USB_DMA2ADDRLOW, val)
#define bfin_read_USB_DMA2ADDRHIGH()		bfin_read16(USB_DMA2ADDRHIGH)
#define bfin_write_USB_DMA2ADDRHIGH(val)	bfin_write16(USB_DMA2ADDRHIGH, val)
#define bfin_read_USB_DMA2COUNTLOW()		bfin_read16(USB_DMA2COUNTLOW)
#define bfin_write_USB_DMA2COUNTLOW(val)	bfin_write16(USB_DMA2COUNTLOW, val)
#define bfin_read_USB_DMA2COUNTHIGH()		bfin_read16(USB_DMA2COUNTHIGH)
#define bfin_write_USB_DMA2COUNTHIGH(val)	bfin_write16(USB_DMA2COUNTHIGH, val)

/* USB Channel 3 Config Registers */

#define bfin_read_USB_DMA3CONTROL()		bfin_read16(USB_DMA3CONTROL)
#define bfin_write_USB_DMA3CONTROL(val)		bfin_write16(USB_DMA3CONTROL, val)
#define bfin_read_USB_DMA3ADDRLOW()		bfin_read16(USB_DMA3ADDRLOW)
#define bfin_write_USB_DMA3ADDRLOW(val)		bfin_write16(USB_DMA3ADDRLOW, val)
#define bfin_read_USB_DMA3ADDRHIGH()		bfin_read16(USB_DMA3ADDRHIGH)
#define bfin_write_USB_DMA3ADDRHIGH(val)	bfin_write16(USB_DMA3ADDRHIGH, val)
#define bfin_read_USB_DMA3COUNTLOW()		bfin_read16(USB_DMA3COUNTLOW)
#define bfin_write_USB_DMA3COUNTLOW(val)	bfin_write16(USB_DMA3COUNTLOW, val)
#define bfin_read_USB_DMA3COUNTHIGH()		bfin_read16(USB_DMA3COUNTHIGH)
#define bfin_write_USB_DMA3COUNTHIGH(val)	bfin_write16(USB_DMA3COUNTHIGH, val)

/* USB Channel 4 Config Registers */

#define bfin_read_USB_DMA4CONTROL()		bfin_read16(USB_DMA4CONTROL)
#define bfin_write_USB_DMA4CONTROL(val)		bfin_write16(USB_DMA4CONTROL, val)
#define bfin_read_USB_DMA4ADDRLOW()		bfin_read16(USB_DMA4ADDRLOW)
#define bfin_write_USB_DMA4ADDRLOW(val)		bfin_write16(USB_DMA4ADDRLOW, val)
#define bfin_read_USB_DMA4ADDRHIGH()		bfin_read16(USB_DMA4ADDRHIGH)
#define bfin_write_USB_DMA4ADDRHIGH(val)	bfin_write16(USB_DMA4ADDRHIGH, val)
#define bfin_read_USB_DMA4COUNTLOW()		bfin_read16(USB_DMA4COUNTLOW)
#define bfin_write_USB_DMA4COUNTLOW(val)	bfin_write16(USB_DMA4COUNTLOW, val)
#define bfin_read_USB_DMA4COUNTHIGH()		bfin_read16(USB_DMA4COUNTHIGH)
#define bfin_write_USB_DMA4COUNTHIGH(val)	bfin_write16(USB_DMA4COUNTHIGH, val)

/* USB Channel 5 Config Registers */

#define bfin_read_USB_DMA5CONTROL()		bfin_read16(USB_DMA5CONTROL)
#define bfin_write_USB_DMA5CONTROL(val)		bfin_write16(USB_DMA5CONTROL, val)
#define bfin_read_USB_DMA5ADDRLOW()		bfin_read16(USB_DMA5ADDRLOW)
#define bfin_write_USB_DMA5ADDRLOW(val)		bfin_write16(USB_DMA5ADDRLOW, val)
#define bfin_read_USB_DMA5ADDRHIGH()		bfin_read16(USB_DMA5ADDRHIGH)
#define bfin_write_USB_DMA5ADDRHIGH(val)		bfin_write16(USB_DMA5ADDRHIGH, val)
#define bfin_read_USB_DMA5COUNTLOW()		bfin_read16(USB_DMA5COUNTLOW)
#define bfin_write_USB_DMA5COUNTLOW(val)	fin_write16(USB_DMA5COUNTLOW, val)
#define bfin_read_USB_DMA5COUNTHIGH()		bfin_read16(USB_DMA5COUNTHIGH)
#define bfin_write_USB_DMA5COUNTHIGH(val)	bfin_write16(USB_DMA5COUNTHIGH, val)

/* USB Channel 6 Config Registers */

#define bfin_read_USB_DMA6CONTROL()		bfin_read16(USB_DMA6CONTROL)
#define bfin_write_USB_DMA6CONTROL(val)		bfin_write16(USB_DMA6CONTROL, val)
#define bfin_read_USB_DMA6ADDRLOW()		bfin_read16(USB_DMA6ADDRLOW)
#define bfin_write_USB_DMA6ADDRLOW(val)		bfin_write16(USB_DMA6ADDRLOW, val)
#define bfin_read_USB_DMA6ADDRHIGH()		bfin_read16(USB_DMA6ADDRHIGH)
#define bfin_write_USB_DMA6ADDRHIGH(val)	bfin_write16(USB_DMA6ADDRHIGH, val)
#define bfin_read_USB_DMA6COUNTLOW()		bfin_read16(USB_DMA6COUNTLOW)
#define bfin_write_USB_DMA6COUNTLOW(val)	bfin_write16(USB_DMA6COUNTLOW, val)
#define bfin_read_USB_DMA6COUNTHIGH()		bfin_read16(USB_DMA6COUNTHIGH)
#define bfin_write_USB_DMA6COUNTHIGH(val)	bfin_write16(USB_DMA6COUNTHIGH, val)

/* USB Channel 7 Config Registers */

#define bfin_read_USB_DMA7CONTROL()		bfin_read16(USB_DMA7CONTROL)
#define bfin_write_USB_DMA7CONTROL(val)		bfin_write16(USB_DMA7CONTROL, val)
#define bfin_read_USB_DMA7ADDRLOW()		bfin_read16(USB_DMA7ADDRLOW)
#define bfin_write_USB_DMA7ADDRLOW(val)		bfin_write16(USB_DMA7ADDRLOW, val)
#define bfin_read_USB_DMA7ADDRHIGH()		bfin_read16(USB_DMA7ADDRHIGH)
#define bfin_write_USB_DMA7ADDRHIGH(val)	bfin_write16(USB_DMA7ADDRHIGH, val)
#define bfin_read_USB_DMA7COUNTLOW()		bfin_read16(USB_DMA7COUNTLOW)
#define bfin_write_USB_DMA7COUNTLOW(val)	bfin_write16(USB_DMA7COUNTLOW, val)
#define bfin_read_USB_DMA7COUNTHIGH()		bfin_read16(USB_DMA7COUNTHIGH)
#define bfin_write_USB_DMA7COUNTHIGH(val)	bfin_write16(USB_DMA7COUNTHIGH, val)

/* Keybfin_read_()ad Registers */

#define bfin_read_KPAD_CTL()		bfin_read16(KPAD_CTL)
#define bfin_write_KPAD_CTL(val)	bfin_write16(KPAD_CTL, val)
#define bfin_read_KPAD_PRESCALE()	bfin_read16(KPAD_PRESCALE)
#define bfin_write_KPAD_PRESCALE(val)	bfin_write16(KPAD_PRESCALE, val)
#define bfin_read_KPAD_MSEL()		bfin_read16(KPAD_MSEL)
#define bfin_write_KPAD_MSEL(val)	bfin_write16(KPAD_MSEL, val)
#define bfin_read_KPAD_ROWCOL()		bfin_read16(KPAD_ROWCOL)
#define bfin_write_KPAD_ROWCOL(val)	bfin_write16(KPAD_ROWCOL, val)
#define bfin_read_KPAD_STAT()		bfin_read16(KPAD_STAT)
#define bfin_write_KPAD_STAT(val)	bfin_write16(KPAD_STAT, val)
#define bfin_read_KPAD_SOFTEVAL()	bfin_read16(KPAD_SOFTEVAL)
#define bfin_write_KPAD_SOFTEVAL(val)	bfin_write16(KPAD_SOFTEVAL, val)

/* Pixel Combfin_read_()ositor (PIXC) Registers */

#define bfin_read_PIXC_CTL()		bfin_read16(PIXC_CTL)
#define bfin_write_PIXC_CTL(val)	bfin_write16(PIXC_CTL, val)
#define bfin_read_PIXC_PPL()		bfin_read16(PIXC_PPL)
#define bfin_write_PIXC_PPL(val)	bfin_write16(PIXC_PPL, val)
#define bfin_read_PIXC_LPF()		bfin_read16(PIXC_LPF)
#define bfin_write_PIXC_LPF(val)	bfin_write16(PIXC_LPF, val)
#define bfin_read_PIXC_AHSTART()	bfin_read16(PIXC_AHSTART)
#define bfin_write_PIXC_AHSTART(val)	bfin_write16(PIXC_AHSTART, val)
#define bfin_read_PIXC_AHEND()		bfin_read16(PIXC_AHEND)
#define bfin_write_PIXC_AHEND(val)	bfin_write16(PIXC_AHEND, val)
#define bfin_read_PIXC_AVSTART()	bfin_read16(PIXC_AVSTART)
#define bfin_write_PIXC_AVSTART(val)	bfin_write16(PIXC_AVSTART, val)
#define bfin_read_PIXC_AVEND()		bfin_read16(PIXC_AVEND)
#define bfin_write_PIXC_AVEND(val)	bfin_write16(PIXC_AVEND, val)
#define bfin_read_PIXC_ATRANSP()	bfin_read16(PIXC_ATRANSP)
#define bfin_write_PIXC_ATRANSP(val)	bfin_write16(PIXC_ATRANSP, val)
#define bfin_read_PIXC_BHSTART()	bfin_read16(PIXC_BHSTART)
#define bfin_write_PIXC_BHSTART(val)	bfin_write16(PIXC_BHSTART, val)
#define bfin_read_PIXC_BHEND()		bfin_read16(PIXC_BHEND)
#define bfin_write_PIXC_BHEND(val)	bfin_write16(PIXC_BHEND, val)
#define bfin_read_PIXC_BVSTART()	bfin_read16(PIXC_BVSTART)
#define bfin_write_PIXC_BVSTART(val)	bfin_write16(PIXC_BVSTART, val)
#define bfin_read_PIXC_BVEND()		bfin_read16(PIXC_BVEND)
#define bfin_write_PIXC_BVEND(val)	bfin_write16(PIXC_BVEND, val)
#define bfin_read_PIXC_BTRANSP()	bfin_read16(PIXC_BTRANSP)
#define bfin_write_PIXC_BTRANSP(val)	bfin_write16(PIXC_BTRANSP, val)
#define bfin_read_PIXC_INTRSTAT()	bfin_read16(PIXC_INTRSTAT)
#define bfin_write_PIXC_INTRSTAT(val)	bfin_write16(PIXC_INTRSTAT, val)
#define bfin_read_PIXC_RYCON()		bfin_read32(PIXC_RYCON)
#define bfin_write_PIXC_RYCON(val)	bfin_write32(PIXC_RYCON, val)
#define bfin_read_PIXC_GUCON()		bfin_read32(PIXC_GUCON)
#define bfin_write_PIXC_GUCON(val)	bfin_write32(PIXC_GUCON, val)
#define bfin_read_PIXC_BVCON()		bfin_read32(PIXC_BVCON)
#define bfin_write_PIXC_BVCON(val)	bfin_write32(PIXC_BVCON, val)
#define bfin_read_PIXC_CCBIAS()		bfin_read32(PIXC_CCBIAS)
#define bfin_write_PIXC_CCBIAS(val)	bfin_write32(PIXC_CCBIAS, val)
#define bfin_read_PIXC_TC()		bfin_read32(PIXC_TC)
#define bfin_write_PIXC_TC(val)		bfin_write32(PIXC_TC, val)

/* Handshake MDMA 0 Registers */

#define bfin_read_HMDMA0_CONTROL()		bfin_read16(HMDMA0_CONTROL)
#define bfin_write_HMDMA0_CONTROL(val)		bfin_write16(HMDMA0_CONTROL, val)
#define bfin_read_HMDMA0_ECINIT()		bfin_read16(HMDMA0_ECINIT)
#define bfin_write_HMDMA0_ECINIT(val)		bfin_write16(HMDMA0_ECINIT, val)
#define bfin_read_HMDMA0_BCINIT()		bfin_read16(HMDMA0_BCINIT)
#define bfin_write_HMDMA0_BCINIT(val)		bfin_write16(HMDMA0_BCINIT, val)
#define bfin_read_HMDMA0_ECURGENT()		bfin_read16(HMDMA0_ECURGENT)
#define bfin_write_HMDMA0_ECURGENT(val)		bfin_write16(HMDMA0_ECURGENT, val)
#define bfin_read_HMDMA0_ECOVERFLOW()		bfin_read16(HMDMA0_ECOVERFLOW)
#define bfin_write_HMDMA0_ECOVERFLOW(val)	bfin_write16(HMDMA0_ECOVERFLOW, val)
#define bfin_read_HMDMA0_ECOUNT()		bfin_read16(HMDMA0_ECOUNT)
#define bfin_write_HMDMA0_ECOUNT(val)		bfin_write16(HMDMA0_ECOUNT, val)
#define bfin_read_HMDMA0_BCOUNT()		bfin_read16(HMDMA0_BCOUNT)
#define bfin_write_HMDMA0_BCOUNT(val)		bfin_write16(HMDMA0_BCOUNT, val)

/* Handshake MDMA 1 Registers */

#define bfin_read_HMDMA1_CONTROL()		bfin_read16(HMDMA1_CONTROL)
#define bfin_write_HMDMA1_CONTROL(val)		bfin_write16(HMDMA1_CONTROL, val)
#define bfin_read_HMDMA1_ECINIT()		bfin_read16(HMDMA1_ECINIT)
#define bfin_write_HMDMA1_ECINIT(val)		bfin_write16(HMDMA1_ECINIT, val)
#define bfin_read_HMDMA1_BCINIT()		bfin_read16(HMDMA1_BCINIT)
#define bfin_write_HMDMA1_BCINIT(val)		bfin_write16(HMDMA1_BCINIT, val)
#define bfin_read_HMDMA1_ECURGENT()		bfin_read16(HMDMA1_ECURGENT)
#define bfin_write_HMDMA1_ECURGENT(val)		bfin_write16(HMDMA1_ECURGENT, val)
#define bfin_read_HMDMA1_ECOVERFLOW()		bfin_read16(HMDMA1_ECOVERFLOW)
#define bfin_write_HMDMA1_ECOVERFLOW(val)	bfin_write16(HMDMA1_ECOVERFLOW, val)
#define bfin_read_HMDMA1_ECOUNT()		bfin_read16(HMDMA1_ECOUNT)
#define bfin_write_HMDMA1_ECOUNT(val)		bfin_write16(HMDMA1_ECOUNT, val)
#define bfin_read_HMDMA1_BCOUNT()		bfin_read16(HMDMA1_BCOUNT)
#define bfin_write_HMDMA1_BCOUNT(val)		bfin_write16(HMDMA1_BCOUNT, val)

#endif /* _CDEF_BF549_H */
