/*

   term.c

   This stuff is either directly stolen or else adapted from the GNU
   termcap manual, and therefore presumed copyrighted by the FSF.
   See the file `COPYING' for licencing details.

   -svm

  $Id: term.c,v 1.5 1994/05/19 01:24:15 svm Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <termcap.h>

void
fatal (const char *s,...)
{
    va_list l;

    va_start (l, s);
    vfprintf (stderr, s, l);
    va_end (l);

    exit (EXIT_FAILURE);
}

#ifdef __GNUC__
#define term_buffer 0
#else
static char term_buffer[2048];
#endif

void
init_terminal_data ()
{
    char *termtype;
    int success;

    if (!(termtype=getenv("TERM")))
	fatal ("Specify a terminal type with `setenv TERM <yourtype>'.\n");

    success = tgetent (term_buffer, termtype);
    if (success < 0)
	fatal ("Could not access the termcap data base.\n");
    if (success == 0)
	fatal ("Terminal type `%s' is not defined.\n", termtype);
}

char *
my_tgets (char *te)
{
#ifdef __GNUC__
#define BUFFADDR 0
#else
   /* Here we assume that an explicit term_buffer was provided to tgetent. */
    char *buffer = (char *) malloc (strlen (term_buffer));
#define BUFFADDR &buffer
#endif
    char *temp;

   /* Extract information we will use. */
    if ((temp = tgetstr (te, BUFFADDR)) != NULL)
	return temp;
    else
	return "";
}
