/************************************************************************/
/* File Name            : unipowerd.h                                   */
/* Program Name         : unipowerd                   Version: 1.0.0    */
/* Author               : Tom Webster <webster@kaiwan.com>              */
/* Created              : 1994/04/20                                    */
/* Last Modified By     : Tom Webster                 Date: 1995/04/09  */
/*                                                                      */
/* Compiler (created)   : GCC 2.5.8                                     */
/* Compiler (env)       : Linux 1.0.9                                   */
/* ANSI C Compatable    : No                                            */
/* POSIX Compatable     : Yes?                                          */
/*                                                                      */
/* Purpose              : Header file for unipowerd.                    */
/*                      : Contains the configuration information for    */
/*                      : unipowerd.  Edit this file as indicated       */
/*                      : below to activate features and to customize   */
/*                      : unipowerd for your UPS.                       */
/*                                                                      */
/* Copyright            : GNU Copyleft                                  */
/************************************************************************/
 
/* The following are the RS232 control lines      */
/*                                                */
/*                                            D D */
/*                                            T C */
/* Macro           English                    E E */
/* ---------------------------------------------- */
/* TIOCM_DTR       DTR - Data Terminal Ready  --> */
/* TIOCM_RTS       RTS - Ready to send        --> */
/* TIOCM_CTS       CTS - Clear To Send        <-- */
/* TIOCM_CAR       DCD - Data Carrier Detect  <-- */
/* TIOCM_RNG       RI  - Ring Indicator       <-- */
/* TIOCM_DSR       DSR - Data Signal Ready    <-- */
 
#define HIGH 		(1)
#define LOW 		0
#define PWRSTAT         "/etc/powerstatus"
#define UPSSTAT		"/etc/upsstatus"

/* CABLEPOWER is the line which provides power to */
/* the cable for normal monitoring activities.    */
#define CABLEPOWER	TIOCM_RTS

#define POWERBIT 	TIOCM_CTS
#define POWEROK 	LOW

/* Define CABLECHECK as 1 to check for low battery */
/* Define CABLECHECK as 0 value to skip            */
#define CABLECHECK 	0
#define CABLEBIT 	TIOCM_RNG
#define CABLEOK 	LOW

/* Define BATTCHECK as 1 to check for low battery  */
/* Define BATTCHECK as 0 value to skip.            */
#define BATTCHECK 	1
#define BATTBIT 	TIOCM_CAR
#define BATTOK 		LOW
 
/* Define INVERTERKILL as 1 to hndle killing the inverter */
/* Define INVERTERKILL as 0 value to skip.                */
/* INVERTERBIT is the line which will kill the inverter   */
/*    while the UPS is in powerfail mode.                 */
/* INVERTERTIME is the time in seconds to hold the line   */
/*    defiined by INVERTERBIT high to kill the inverter.  */
#define INVERTERKILL	1
#define INVERTERBIT	TIOCM_DTR
#define INVERTERTIME	5

/************************************************************************/
/* End of File unipowerd.h                                              */
/************************************************************************/
