/* $Header: /home/vph/develop/lore/RCS/widgets.cc,v 1.11 1996/10/25 19:47:11 vph Exp vph $*/

/*
 * File:        widgets.cc
 * Description: Widgets for Linux OMEN Reader
 * Author:      Ville Hallivuori, vpg@clinet.fi
 *
 * Copyrights (c) 1995-1996 by Ville Hallivuori
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h>
#include <string.h>
#include <ncurses/curses.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include "lore.h"

extern int CurMsg;
extern char OutText[81];
extern AppMenus *MenuBar;                   //Menubar when reading
extern AppMenus *MMenuBar;                  //Menubar on session selection
extern MsgScreen *Message;                  //UserInterface on reading messages
extern BBSInfo *BInfo;                      //Contains all from SYSTEMxy.BBS
extern Messages *MsgInfo;                   //Contains all from NEWMSGxy.TXT
extern Config *Settings;                    //LORE's configuration
extern MListBox *SesList;                   //SEssion selection
extern FHandler *FileH;                     //Archive handling
extern SkipList *Skip;                      //Skipping
extern boutstream *bout_msg;
extern boutstream *bout_lb;

/*
 * ListBox -widget
 */
ListBox::ListBox(int Xc1, int Yc1, int Xc2, int Yc2, int CI)
{
  X1=Xc1;
  Y1=Yc1;
  X2=Xc2;
  Y2=Yc2;
  CurItem=CI;
  LastItem=-1;
  first_item = NULL;
  OnSrcItem=CI-1; if (OnSrcItem<0) OnSrcItem=0;
}

/*Frees all allocated memory.  */
ListBox::~ListBox(void)
{
  for (int j=LastItem; j>=0; j--)
    {
      delete (get_item (j))->label;
      delete (get_item (j));
    }
}

/*Allocates memory for new item, and adds it to linked list.  */
item_st *ListBox::insert_item (void)
{
  item_st *i = first_item;
  if (i == NULL)
    {
      first_item = new item_st;
      first_item->next = NULL;
      return first_item;
    }
  while (1)
    {
      if (i->next == NULL)
	{
	  i->next =  new item_st;
	  i = i->next;
	  i->next = NULL;
	  return i;
	}
      else i = i->next;
    };
  return (NULL);
};

/*Returns pointer to item number no.  */
item_st *ListBox::get_item (int no)
{
  item_st *i = first_item;
  if ((no > LastItem) || (LastItem < 0 )) return NULL;
  for (int j=0; j < no; j++)
    {
      i = i->next;
    }
  return i;
};

int ListBox::ret_brd_nro(int i)
{
  char sBrdNro[6];
  char *str = (get_item (i))->label;
  sBrdNro[0]=str[0];
  sBrdNro[1]=str[1];
  sBrdNro[2]=str[2];
  sBrdNro[3]=str[3];
  sBrdNro[4]=str[4];
  sBrdNro[5]='\0';
  return (atoi(sBrdNro));
}

void ListBox::AddItem(char *AItem)          //Adds item to listbox
{
  LastItem++;
  item_st *i = insert_item();
  if (i == NULL) exit(2);
  i->label = strdup (AItem);
  i->next = NULL;
}

void ListBox::ModifyItem(char *AItem, int ItemNro)  //Modify listbox-item
{
  item_st *i;
  i = get_item (ItemNro);
  delete i->label;
  i->label = strdup (AItem);
}

void ListBox::Draw(void)                    //Draws all items
{
  int j=OnSrcItem;
  ClrAttrib();
  TextColor(SLstFgColor);
  TextBackColor(SLstBgColor);
  if (LastItem!=-1)                         //Draws all iitem on screen
    {
      while((j<=LastItem)&&((Y1+j-OnSrcItem)<=Y2))
	{
	  DrawItem(j);
	  j++;
	}
    }
  char buffer[256];
  int k;
  for (k=0; k<=X2-X1; k++) buffer[k]=' ';//Draws empty space
  buffer[k]='\0';
  while ((Y1+j-OnSrcItem)<=Y2)
    {
      ClrAttrib();
      TextColor(SLstFgColor);
      TextBackColor(SLstBgColor);
      GotoXY(X1,(Y1+j-OnSrcItem));
      cout<<buffer<<flush;
      j++;
    }
  GotoXY(0,0);
}

void ListBox::DrawItem(int Index)           //Draws one item
{
  int PosY=Y1+Index-OnSrcItem;              //Position of item on screen
  if (Index==CurItem)                       //Colors for selected item
    {
      ClrAttrib();
      TextColor(ASLstFgColor);
      TextBackColor(ASLstBgColor);
    }
  else                                      //Colors for nonselected item 
    {
      ClrAttrib();
      TextColor(SLstFgColor);
      TextBackColor(SLstBgColor);
    }
  GotoXY(X1,PosY); 
  cout<<(get_item(Index))->label<<flush;
}

int ListBox::Handle(void)                   //Takes user's input
{
  int input1;
  do
    {
      do 
        {
	  cout<<flush;
	  GotoXY (0,0);
	  input1=getch();
        }
      while ((input1!=27)&&(input1!=KEY_DOWN)&&(input1!=KEY_UP)&&(input1!=10));
      switch(input1)
       { 
       case KEY_DOWN: if (CurItem<LastItem)
	 {
	   CurItem++;
           if ((Y1+CurItem-OnSrcItem)==(Y2+1))
	     {
	       ScrollDown();
	     }
           else
	     {
	       DrawItem(CurItem-1);
	       DrawItem(CurItem);
	       GotoXY (0,0);
	     }
	 }
         break;
       case KEY_UP: if (CurItem>0)
	 {
           CurItem--;
	   if ((CurItem-OnSrcItem)==-1)
	     {
	       ScrollUp();
	     }
	   else
	     {
	       DrawItem(CurItem+1);
	       DrawItem(CurItem);
	       GotoXY (0,0);
	     }
	 }
	 break;
       case 10: return (CurItem);
	 break;
       case 27: return(-1);
	 break;
       }
    }
  while ((input1!=0)||(input1!=1));         //Loop forever...
  return (-1);
}

void ListBox::ScrollDown(void)              //Scrolls down listbox
{
  OnSrcItem++;
  int j=OnSrcItem;
  while((j<=LastItem)&&((Y1+j-OnSrcItem)<=Y2))
    {
      DrawItem(j);
      j++;
    }
  GotoXY(0,0);
}

void ListBox::ScrollUp(void)                //Scrolls up listboc
{
  OnSrcItem--;
  int j=OnSrcItem;
  while((j<=LastItem)&&((Y1+j-OnSrcItem)<=Y2))
    {
      DrawItem(j);
      j++;
    }
  GotoXY(0,0);
}


/*
 * Message-readin interface
 */
MsgScreen::MsgScreen(int Index)              //Initial values
{
  strcpy(PointerName,Settings->LoreHome);    //File where read messagepointers
  strcat(PointerName,"POINTERS");
  strcat(PointerName,SesList->Items[Index].IDc);
  strcat(PointerName,".");
  strcat(PointerName,SesList->Items[Index].Index);
  ifstream PointersF(PointerName);
  PointersF>>CurMsg;                         //Read number (internal) cu-
  PointersF.close();                         //rent message
  bout_msg=new boutstream(1,2,80,LINES);
}

MsgScreen::~MsgScreen(void)                  //Saves messagepointers
{
  ofstream CPF(PointerName,ios::trunc);      //Open and clears POINTERSxy.zzz
  CPF.close();
  ofstream PointersF(PointerName);
  PointersF<<CurMsg;                         //Saves messagepointers
  PointersF.close();
  delete bout_msg;
}

void MsgScreen::Handle(void)                 //Interface (reads user's input).
{
  update=2;                                  //0=No, 1=draw, 2=reread
  CurMsg--;                                  //This will be undoed by Next-
  msgpos=0;                                  //Message command, whic is re-
  NextMessage(1);                            //guired to get update
  DrawHeader();
  DrawMessage(LINES-1);
  MenuBar->BMenuBar();
  StatusLine();
  int operation=0;                           //-1=Prev 0=This 1=Next message.
  int input1;
  exit=0;
  update=0;
  do                                         //MainLoop
    {
      input1=0;
      do                                     //Read and execute command.
	{
	  GotoXY (0,0);
	  input1=getch();
	}
      while ((input1!=27)&&(input1!=KEY_DOWN)&&(input1!=KEY_UP)
	     &&(input1!=KEY_RIGHT)&&(input1!=KEY_LEFT)&&(input1!=32)
	     &&(input1!=10)&&(input1!='i')&&(input1!='i')&&(input1!='p')
	     &&(input1!='f')&&(input1!='b')&&(input1!='s')&&(input1!='w')
	     &&(input1!='x')&&(input1!='c')&&(input1!='R')&&(input1!='P')
	     &&(input1!='M')&&(input1!='F')&&(input1!='n')&&(input1!='o')
	     &&(input1!='h')&&(input1!='?')&&(input1!='m')&&(input1!='g'));
      update=0;
      switch(input1)
	{
	case 'n':
	case KEY_RIGHT: if (CurMsg<MsgInfo->MaxMsg)
	  {
	    operation=1;
	    update=2;
	  }
	  break;
	case KEY_LEFT: if (CurMsg>0)
	  {
	    operation=-1;
	    update=2;
	  }
	  break;
        case KEY_DOWN: if (MxLine-msgpos>LINES-5)
	  {
	    msgpos++;
	    update=1;
	  }
	  break;
	case KEY_UP: if (msgpos>0)
	  {
	    msgpos--;
	    update=1;
	  }
	  break;
	case 32: if (MxLine-msgpos>LINES-5)
	  {
	    msgpos=msgpos+LINES-6;
	    update=1;
	  }
	  break;
	case 10: if (MxLine-msgpos>LINES-5)
	  {
	    msgpos=msgpos+LINES-6;
	    update=1;
	  }
	  else if (CurMsg<MsgInfo->MaxMsg)
	  {
	    operation=1;
	    update=2;
	  }
	  break;
        case 27: MenuBar->Handle(); update=2; operation=20;
	  break;
	case 'm': MenuBar->Handle(); update=2; operation=20;
	  break;
        case 'i': Index();  update=2; operation=20;
	  break;
	case 'f': ReplyMsg();  update=2; operation=20;
	  break;
	case 'p': PostNewMsg();  update=2; operation=20;
	  break;
	case 'b': Markings();  update=2; operation=20;
	  break;
	case 's': SkipSubject();  update=2; operation=20;
	  break;
	case 'w': SkipName();  update=2; operation=20;
	  break;
	case 'x': ExitMnu();  update=2; operation=20;
	  break;
	case 'c': ReturnMListBox();  update=2; operation=20;
	  break;
	case 'F': FindFirst();  update=2; operation=20;
	  break;
	case 'g': FindNext();  update=2; operation=20;
	  break;
	case 'R': RmMsg();  update=2; operation=20;
	  break;
        case 'P': MkPriv();  update=2; operation=20;
	  break;
	case 'M': MvMsg();  update=2; operation=20;
	  break;
	case 'o': Save2File();  update=2; operation=20;
	  break;
        case 'h': RHelp();  update=2; operation=20;
	  break;
	case '?': RHelp();  update=2; operation=20;
	  break;
	}                                                              
      if ((update==2)&&(exit!=1))            //Full update (reads message)
	{
	  NextMessage(operation);            //Reads nex message ro array
	  operation=0;                       //Do nothing
	  DrawHeader();                      //Draws messageheader
	  DrawMessage(LINES-1);              //Draws messages text
	  StatusLine();                      //Draws statusline
	}
      if (update==1)                         //Scrolls message
	{
	  DrawMessage(LINES-1);              //Draws message's text
	  StatusLine();                      //Draws statusline
	}
    }
  while (exit!=1);
}

void MsgScreen::StatusLine(void)             //Draws Statusline
{
  ClrAttrib();
  TextColor(StatFgColor);
  TextBackColor(StatBgColor);
  resetOT();
  GotoXY(1,LINES);
  cout<<OutText;                             //Prints empty line
  GotoXY(2,LINES);
  cout<<BInfo->SystemName;                   //Sprints name of systen
  GotoXY(64,LINES);
  float LPros;                               //Counts how many prosent of msg
  int LeftPros;                              //is on view at moment
  LPros=msgpos+LINES-5;
  LPros=LPros/MxLine;
  LPros=LPros*100;
  LeftPros=int (LPros);
  if (LeftPros>100) LeftPros=100;
  cout<<LeftPros<<'\%';                      //Prints prosents
  GotoXY(70,LINES);
  cout<<CurMsg+1<<'/'<<MsgInfo->MaxMsg+1;    //Cout messagenumber
}

void MsgScreen::NextMessage(int operation)   //Reads next message to array
{
  unsigned char tmp1;
  int realpos=0;                             //Position in raw-message
  int row=0;
  int col=0;                                 //X-position in array
  MxLine=0;                                  //Y-position in array
  int Found=0;
  if (operation==1)                          //Get next message
    {
      int NextMsg=CurMsg;                       
      while (NextMsg<MsgInfo->MaxMsg)        //Finds next unskipped message
	{
	  NextMsg++;
	  if (Skip->IsSkipped(NextMsg)==0)
	    {
	      Found=1;
	      break;
	    }
	}
      if (Found==1)
	{
	  CurMsg=NextMsg;
          msgpos=0;                         //Position (line) in message.
	}
      else                                  //If not found next unskipped msg
	{
	  Window win_Error(25,10,55,15,"ERRROR");
          win_Error.Draw();
          GotoXY(28,14); cout<<"[ENTER] OK"<<flush;
	  GotoXY(28,12); cout<<"End of unskipped messages."<<flush;
          int input;
	  GotoXY (0,0);
	  do {input=getch();} while (input!=10);
	} 
    }
  if (operation==-1)                         //Get previous message
    {
      int NextMsg=CurMsg;
      while (NextMsg>0)                      //Finds previous unskipped msg
	{
	  NextMsg--;
	  if (Skip->IsSkipped(NextMsg)==0)
	    {
	      Found=1;
	      break;
	    }
	}
      if (Found==1)
	{
	  CurMsg=NextMsg;
          msgpos=0;                          //Position (line) in message.
	}
      else                                   //If not found pevious unskipped m
	{
	  Window win_Error(25,10,55,15,"ERRROR");
          win_Error.Draw();
          GotoXY(28,14); cout<<"[ENTER] OK"<<flush;
	  GotoXY(28,12); cout<<"No earlier unskipped msg."<<flush;
          int input;
	  GotoXY (0,0);
	  do {input=getch();} while (input!=10);
	}
     }
  if (operation!=0)                          //Clears array  
    {
      for (int l=0; l<=1000; l++)
	{
	  for (int c=0; c<=80; c++)
	    {
	      MsgText[l] [c] = '\0';
	    }
	}
    }
  tmp1=MsgInfo->MBase[CurMsg].tpointer[realpos];
  while ((tmp1!=3)&&(row<1000))              //Loops until end of msg
    {
      col=0;
      while ((tmp1!=0x0d)&&(col<79)&&(tmp1!=3))          //Reads line
	{
          tmp1=Convert(tmp1);
	  if (row>1000) cout<<"\n\n\nDEBUG1\n"; /*DEBUG*/
	  if (col>80) cout<<"\n\n\nDEBUG2\n"; /*DEBUG*/
	  MsgText[row] [col]=tmp1;           
	  realpos++;
	  col++;
	  tmp1=MsgInfo->MBase[CurMsg].tpointer[realpos];
	}
      if (MxLine>1000) cout<<"\n\n\nDEBUG3\n"; /*DEBUG*/
      if (col>80) cout<<"\n\n\nDEBUG4\n"; /*DEBUG*/
      MsgText[MxLine][col]='\0';              //Adds null
      realpos++;
      row++;
      MxLine++;
      if (tmp1 != 3) tmp1=MsgInfo->MBase[CurMsg].tpointer[realpos];
      if (tmp1==0x0a)                         //Removes DOS-endline
	{
	  realpos++;
	  tmp1=MsgInfo->MBase[CurMsg].tpointer[realpos];
	}
    }
}

void MsgScreen::DrawMsgLine(int AddLine)      //Draws asked line of message
{
  if (AddLine>1000) AddLine=1000;
  if (MsgText[AddLine][0]!=0)                  //Bolds quotes
    {
      if ((MsgText[AddLine] [0]=='>')||(MsgText[AddLine] [1]=='>')
	||(MsgText[AddLine] [2]=='>')||(MsgText[AddLine] [3]=='>')
	||(MsgText[AddLine] [4]=='>')||(MsgText[AddLine] [5]=='>')
	||(MsgText[AddLine] [0]==':')||((MsgText[AddLine] [0]==' ')
	&&(MsgText[AddLine] [1]==':')))
	{
	  bout_msg->setcolor(1,AddLine+4-msgpos,80,AddLine+4-msgpos,MsgFgColor+100,MsgBgColor);
	}
      resetOT();
      if (strlen(MsgText[AddLine])>79) cout<<"\n\n\nDEBUG5\n"; /*DEBUG*/
      strncpy(OutText,MsgText[AddLine],strlen(MsgText[AddLine]));
      bout_msg->writexy(1,AddLine+4-msgpos,(unsigned char *)"                                                                                ");
      bout_msg->writexy(1,AddLine+4-msgpos,(unsigned char *)OutText);
    }
  if (MsgText[AddLine][0]==0)                 //Print background if string is
    {                                         //empty
      resetOT();
      bout_msg->writexy(1,AddLine+4-msgpos,(unsigned char*)OutText);
    }
}

void MsgScreen::DrawMessage(int DLines)       //Draws one screen of message
{
  bout_msg->setcolor(1,4,80,LINES-1,MsgFgColor,MsgBgColor);
  for (int j=5; j<=DLines; j++)               //Draws ased lines
    {
      resetOT();
      if (MxLine>=j-5)
	{
	  DrawMsgLine(j-5+msgpos);            //Actually draws line
	}
      else bout_msg->writexy(1,j-1,(unsigned char *)OutText);  //If message has ndet draws empty
    }
  bout_msg->draw(1,1,80,LINES-2);
}

void MsgScreen::DrawHeader(void)              //Draws messages header
{
  bout_msg->setcolor(1,1,80,3,HdrFgColor,HdrBgColor);
  resetOT();
  oaddstr("Board:",0); oaddstr(MsgInfo->MBase[CurMsg].BrdName,7);
  oaddstr("Date:",40); oaddstr(MsgInfo->MBase[CurMsg].Date, 46);
  oaddstr("Time:",60); oaddstr(MsgInfo->MBase[CurMsg].Time, 66);
  bout_msg->writexy(1,1,(unsigned char *)OutText);
  resetOT();
  oaddstr("From:",0); oaddstr(MsgInfo->MBase[CurMsg].From,6);
  oaddstr("To:",40); oaddstr(MsgInfo->MBase[CurMsg].To, 44); 
  bout_msg->writexy(1,2,(unsigned char *)OutText);
  resetOT();
  char tmp1[6];
  sprintf(tmp1,"%d",MsgInfo->MBase[CurMsg].MsgNum);
  oaddstr("Subject:",0); oaddstr(MsgInfo->MBase[CurMsg].Subject,9);
  oaddstr("#",60); oaddstr(tmp1, 61);
  bout_msg->writexy(1,3,(unsigned char *)OutText);
}



/*
 * Window -widget
 */
Window::Window(int WX1,int WY1,int WX2,int WY2,char *WCaption)
{
  X1=WX1;                                     //Initial values
  Y1=WY1;
  X2=WX2;
  Y2=WY2;
  Caption=WCaption;
}

void Window::Draw(void)                       //Draws window
{
  int Xj;
  int Yj;
  int CaptBegin;
  int CaptLen=strlen(Caption);                //Length of caption
  char *OutLine;                              //Line to print
  OutLine=new char[X2-X1+2];
  CaptBegin=(X2-X1-CaptLen)/2;                //Begin of caption
  OutLine[0]='+';                             //Left corner
  for (Xj=1; Xj<=CaptBegin-1; Xj++)           //Centers caption in middle
    {
      OutLine[Xj]='=';
    }
  OutLine[Xj]='[';
  OutLine[Xj+1]='\0';
  strcat(OutLine,Caption);
  Xj=Xj+CaptLen+1;
  OutLine[Xj]=']'; Xj++;
  for (Xj=Xj; Xj<=X2-X1-1; Xj++)         
    {
      OutLine[Xj]='=';
    }
  OutLine[Xj]='+';
  OutLine[Xj+1]='\0';                         //Adds null to end
  ClrAttrib();
  TextColor(WinBFgColor);                  
  TextBackColor(WinBBgColor);
  GotoXY(X1,Y1);
  cout<<OutLine;                              //Prints Firs line of window
  for (Xj=0; Xj<X2-X1-1; Xj++)                //Clears OutLine 
    {
      OutLine[Xj]=' ';
    }
  //OutLine[0]='|'; OutLine[Xj]='|';
  OutLine[Xj]='\0';                           //Adds null
  for (Yj=Y1+1; Yj<Y2; Yj++)                  //Prints widow body & bodys frame
    {
      ClrAttrib();
      TextColor(WinFgColor);                  
      TextBackColor(WinBgColor);
      GotoXY(X1+1,Yj);
      cout<<OutLine;
      ClrAttrib();
      TextColor(WinBFgColor);              
      TextBackColor(WinBBgColor);
      GotoXY(X1,Yj);
      cout<<'|';
      GotoXY(X2,Yj);
      cout<<'|';
    }
  for (Xj=1; Xj<X2-X1; Xj++) OutLine[Xj]='='; //Prints bottom-frame of window
  OutLine[0]='+'; OutLine[Xj]='+';
  GotoXY(X1,Y2);
  cout<<OutLine<<flush;
  delete OutLine;
  ClrAttrib();
  TextColor(WinFgColor);               
  TextBackColor(WinBgColor);
}

/*
 * Vertical select -vidget
 */
VSelect::VSelect(int Xc1,int Xc2,int Yc,int MaxItem) //Initial values
{
  X1=Xc1;                                   //Coordinates
  X2=Xc2;
  Y=Yc;
  LastItem=MaxItem;                         //Index of last item;
  Active=0;                                 //Number of active item
}

void VSelect::Draw(int State)               //Draws widget
{
  ClrAttrib();
  if (State==0)                             //Not selected
    {      
      TextColor(VSelectFgColor);
      TextBackColor(VSelectBgColor);
    }
  else                                      //Selected
    {
      TextColor(AVSelectFgColor);
      TextBackColor(AVSelectBgColor);
    }
  GotoXY(X1,Y); cout<<"<-";  
  GotoXY(X2-1,Y); cout<<"->";
  int Size=strlen(Items[Active]); 
  for (int j=X1+3; j<X2-2; j++)
    {
      if (j-X1-3<Size)
	{
	  GotoXY(j,Y);
	  cout<<Items[Active][j-X1-3];
	}
      else cout<<' ';
    }
  cout<<flush;                              //Flushes buffer
}

int VSelect::Handle(void)                   //Interface
{
  Draw(1);                                  //Hilites widget
  int Input1;
  do
    {
      GotoXY (0,0);
      Input1=getch();
      if (Input1==KEY_RIGHT)                //Next item
	{
	  if (Active<LastItem) Active++;
	  else Active=0;
	  Draw(1);
	}
      if (Input1==KEY_LEFT)                 //Previous item
	{
	  if (Active>0) Active--;
	  else Active=LastItem;
	  Draw(1);
	}
    }
  while ((Input1!=27)&&(Input1!=10)&&(Input1!=KEY_UP)&&(Input1!=KEY_DOWN));
  Draw(0);
  switch(Input1)
    {
    case KEY_DOWN: return(1);               //Next widget
    case KEY_UP: return(-1);                //Previous widget
    case 27: return (99);                   //Escape
    case 10: return (0);                    //Enter
    }
  return (99);                              //Compile won't warn (don't needet)
}


/*
 * CheckBox -vidget
 */
CheckBox::CheckBox(int Xc,int Yc,char *Capt, int DefStat=1) //Initial values
{
  X=Xc;
  Y=Yc;
  Caption=Capt;
  Status=DefStat;
}

void CheckBox::Draw(int AState)             //Draws checkbox
{
  ClrAttrib();
  GotoXY(X,Y);
  if (AState==1)                            //If checkbox is active
    {
      TextColor(ACBoxFgColor);
      TextBackColor(ACBoxBgColor);
    }
  else                                      //If checkbox is not active
    {
      TextColor(CBoxFgColor);
      TextBackColor(CBoxBgColor);
    }
  if (Status==0) cout<<"[ ] "<<Caption<<flush;  //If not cheked
  if (Status==1) cout<<"[X] "<<Caption<<flush;  //if cheked
}

int CheckBox::Handle(void)                  //Interface
{
  Draw(1);                                  //This checkbox is active
  int Input1;
  do
    {
      GotoXY (0,0);
      Input1=getch();                  //Reads keyboard
      if (Input1==32)                       //Space togles state
	{
	  if (Status==0)
	    {
	      Status=1;
	    }
	  else
	    {
	      Status=0;
	    }
	  Draw(1);
	}
    }
  while ((Input1!=27)&&(Input1!=10)&&(Input1!=KEY_UP)&&(Input1!=KEY_DOWN));
  Draw(0);
  switch(Input1)                            //Other commands
    {
    case KEY_DOWN: return(1);
    case KEY_UP: return(-1);
    case 27: return (99);
    case 10: return (0);
    }
  return (99);
}

/*
 * TextBox -widget (input-field)
 */
TextBox::TextBox(int Xc1,int Xc2,int Yc,char *PText) //Initial values
{
  X1=Xc1; X2=Xc2; Y=Yc;                     //Sets coordinates
  Text=PText;
  SPos=strlen(Text)-(X2-X1);
  if (SPos<0) SPos=0;
  Status=0;
}

int TextBox::ReadInput(int MaxPos)          //Reads n characters
{
  int input1;
  int XPos;
  Status=1;
  Draw();
  int TLast;
  do
    {
      XPos=(X1+strlen(Text)-SPos);          //Cursors position
      GotoXY(XPos,Y);                       //Cursor to end of field
      cout<<flush;
      input1=getch();                       //Reads input
      TLast=strlen(Text);                   //Character (position) to read
      if  ((isdigit(input1)||(input1=='.')||(input1=='-')||(input1=='/')
	  ||(input1=='_')||(input1=='#')||(isalpha(input1)||(input1==' ')
	  ||(input1=='@')||(input1=='!'))&&(input1!=KEY_UP))
	  &&(input1!=KEY_DOWN)&&(input1!=KEY_LEFT)&&(input1!=KEY_RIGHT)
	  &&(TLast<MaxPos)&&(input1!=330)&&(input1!=127))//Acceptable chars
	{
	  if (XPos<X2)                      //If we dont have to scroll
	    {
	      Text[TLast]=(unsigned char) input1;
              Text[TLast+1]='\0';
	      cout<<(unsigned char)input1;
	      XPos++;
	    }
	  else                              //We will scroll
	    {
	      Text[TLast]=(unsigned char) input1;
	      Text[TLast+1]='\0';
	      SPos++;
	      Draw();
	    }
	}                                   //Erases character
      if (((input1==330)||(input1==127)||(input1==KEY_LEFT))&&(TLast>0))
	{
         if (SPos>0)
	    {
	      SPos--;
	      Text[TLast-1]='\0';
	      Draw();
	    }
	  else
	    {
	      Text[TLast-1]='\0';
	      XPos--; cout<<flush;
	      GotoXY(XPos,Y); cout<<"  "; GotoXY(XPos,Y); cout<<flush;
	    } 
	}
    }
  while ((input1!=27)&&(input1!=10)&&(input1!=KEY_UP)&&(input1!=KEY_DOWN));
  Status=0;
  Draw();
  switch(input1)
    {
    case KEY_DOWN: return(1);
    case KEY_UP: return(-1);
    case 27: return (99);
    case 10: return (0);
    }
  return (99);
}

void TextBox::Draw(void)                    //Draws widget
{
  ClrAttrib();
  if (Status==0)                            //If textbox is inactive
    {      
      TextColor(TextBoxFgColor);
      TextBackColor(TextBoxBgColor);
    }
  else                                      //If it is active
    {
      TextColor(ATextBoxFgColor);
      TextBackColor(ATextBoxBgColor);
    }
  int j;
  for (j=0; ((j<X2-X1)&&(SPos+j<(int)strlen(Text))); j++) //Draws text
    {
      GotoXY(j+X1,Y);
      cout<<Text[j+SPos];
    }
  for (j=j; j<=X2-X1; j++)                  //Draws lempty space
    {
      GotoXY(j+X1,Y);
      cout<<" ";
    }
  cout<<flush;
}

/*
 * MenuBar -vidget
 */
AppMenus::AppMenus(void)                    //Initial values
{
  x1=1; y1=2; x2=80; y2=LINES-2;
  MxMenu=-1;                                //There is no menus yet
  CMenu=0;                                  
}

int AppMenus::MMenuLoop(void)               //UserInterface for root-menus
{
  int tmp1;
  BMenuBar();                               //ReDraws whole menubar (unly 1st line)
  HBMenuBar(CMenu,1);                       //Hilites active menu
  do
    {
      OMenu=CMenu;                          //Store number of curent menu
      do
	{
	  GotoXY (0, 0);
	  tmp1=getch();                //Reads keyboard
	}
      while ((tmp1!=27)&&(tmp1!=KEY_DOWN)&&(tmp1!=KEY_LEFT)&&(tmp1!=KEY_RIGHT)
	     &&(tmp1!=10));
      switch(tmp1)
	{
	case KEY_DOWN: CMenu=SeekMenu(CMenu,CMenu); //Opens submenu
	  break;
        case 10: CMenu=SeekMenu(CMenu,CMenu); //Opens submenu
	  break;
	case KEY_LEFT: CMenu=PrevMMnu();    //Goes previous root-menu
	  break;
        case KEY_RIGHT: CMenu=NextMMnu();   //Goes next root-menu
	  break;
	}
      HBMenuBar(OMenu,0);                   //UnHilites previously selected mnu
      HBMenuBar(CMenu,1);                   //Hilites selected menu
    }
  while ((tmp1!=10)&&(tmp1!=KEY_DOWN)&&(tmp1!=27));
  Update=3;                                 //Full update
  if (tmp1==27) return 1;                   //If user desides close menu
  else return 0;                            //If user open's submenu
}

int AppMenus::NextSMnu(void)                //Returns next submenu
{
  int Mnu=CMenu;
  do                                        //Finds next submenu
    {
      Mnu++;
      if (Mnu>MxMenu) Mnu=0;
    }
  while ((MBase[Mnu].ParentNro!=MBase[CMenu].ParentNro)||(MBase[Mnu].Type!=1));
  return Mnu;                               //Returns index of found menu
}

int AppMenus::PrevSMnu(void)                //Returns previous submenu    
{
  int Mnu=CMenu;
  do                                        //Finds previous submenu
    {
      Mnu--;
      if (Mnu<=MBase[CMenu].ParentNro) Mnu=MxMenu;
    }
  while (MBase[Mnu].ParentNro!=MBase[CMenu].ParentNro||(MBase[Mnu].Type!=1));
  return Mnu;                               //Returnt index of previous submenu
}

int AppMenus::NextMMnu(void)                //Returns next mainmenu
{
  int Mnu=GetRParent(CMenu);
  do                                        //Finds next mainmenu
    {
      Mnu++;
      if (Mnu>MxMenu) Mnu=0;
    }
  while (MBase[Mnu].ParentNro!=-1);
  return Mnu;                               //Returns index of next mainmenu
}

int AppMenus::PrevMMnu(void)                //Return previous mainmenu
{
  int Mnu=GetRParent(CMenu);
  do                                        //Finds previous mainmenu
    {
      Mnu--;
      if (Mnu<0) Mnu=MxMenu;
    }
  while (MBase[Mnu].ParentNro!=-1);
  return (Mnu);                             //Returns index of prev mainmenu
}


int AppMenus::Handle(void)                  //UserInterface
{
  int OCMenu;                               //Previously selected menu
  int tmp1;
  int ExitLoop=0;
  do                                        //Main loop, when user in in menu
    {      
      if (MBase[CMenu].ParentNro==-1)       //If selected menu is root-menu
	{ 
          DrawBackGround(x1,y1,x2,y2);
	  ExitLoop=MMenuLoop();             //Handles Interface for root-mnu
	  if (ExitLoop==0) DrawMenu();      //Draws whole menu-structure
	}
      if (ExitLoop==0){                     //If user dosn't exit from menus
      do
	{
	  GotoXY (0,0);
	  tmp1=getch();                //Reads keyboard
	}
      while ((tmp1!=27)&&(tmp1!=KEY_DOWN)&&(tmp1!=KEY_UP)&&(tmp1!=KEY_RIGHT)
	     &&(tmp1!=KEY_LEFT)&&(tmp1!=10));
      OMenu=CMenu;
      switch(tmp1)
	{
	case KEY_DOWN: CMenu=NextSMnu(); Update=2; //Moves to next submenu
	  break;
	case KEY_UP: CMenu=PrevSMnu(); Update=2; //Moves to prev submenu
	  break;
        case KEY_RIGHT: CMenu=NextMMnu(); CMenu=SeekMenu(CMenu,CMenu);
	  Update=3;                         //Moves to next mainmenu
	  break;
        case KEY_LEFT: CMenu=PrevMMnu();  CMenu=SeekMenu(CMenu,CMenu);
	  Update=3;                         //Moves to previous mainmenu
	  break;
        case 27: CMenu=GetRParent(CMenu);   //Closes submenu
	  break;
	case 10: (*MBase[CMenu].MFunction)(); //Selects item
	  ExitLoop=1;
	}
      DrawMenu();                           //Draws menu
    }}
  while (ExitLoop!=1);                      //Stop looping when exit
  OCMenu=CMenu;
  CMenu=0;
  BMenuBar();                               //Clears menubar (1st line)
  return OCMenu;                            //Returns chosen menu
}

int AppMenus::AddMenu(char MName[30], int PNro, int Type=1, MFP MF=&NYI)
{
  int tmp1=-1;
  MxMenu++;                                 //Increase number of menus
  strcpy(MBase[MxMenu].Name,MName);         //Sets menu's values
  MBase[MxMenu].ParentNro=PNro;
  MBase[MxMenu].Type=Type;
  MBase[MxMenu].PosX=3;
  MBase[MxMenu].PosY=1;
  if (PNro==-1)                              //Counts Y-position of menu
    {
      do
	{
	  tmp1=SeekMenu(-1,tmp1);
	  if (tmp1!=MxMenu) MBase[MxMenu].PosX=MBase[MxMenu].PosX+strlen(MBase[tmp1].Name);
          if (tmp1!=MxMenu) MBase[MxMenu].PosX=MBase[MxMenu].PosX+2;
	}
      while (tmp1!=MxMenu);
      MBase[MxMenu].PosY=1;
    }
  else
    {
      MBase[MxMenu].PosX=MBase[PNro].PosX+1;
      MBase[MxMenu].PosY=3;
      tmp1=-1;
      do
	{
	  tmp1=SeekMenu(PNro,tmp1);
	  if ((tmp1!=-1)&&(tmp1<MxMenu)) MBase[MxMenu].PosY=MBase[MxMenu].PosY+1;
	}
      while ((tmp1!=-1)&&(tmp1<MxMenu));
    }      
  MBase[MxMenu].MFunction=MF;
  return(MxMenu);                            //Returns index of menu
}

int AppMenus::SeekMenu(int PNro, int MenuOH) //Returns next sub-menu
{
  int tmp1;
  int tmp2=-1;
  int found=0;
  for (tmp1=MenuOH+1; ((tmp1<=MxMenu)&&(found!=1)); tmp1++) //Find next s-menu
    {
      if (MBase[tmp1].ParentNro==PNro)
	{
	  found=1;
	  tmp2=tmp1;
	}
    }
  return(tmp2);                              //If not found return -1
}

void AppMenus::BMenuBar(void)                //Draws all rootmenus (1st line)
{
  int MDrawed=-1;                            //No menus draved
  GotoXY(1,1);
  ClrAttrib();                               //ColorAttributes
  TextBackColor(MnuBgColor);
  TextColor(MnuFgColor);
  for (int tmp1=1; tmp1<=80; tmp1++) cout<<' '; //Clears menubar
  MDrawed=SeekMenu(-1,MDrawed);              //Seek next root-menu
  while (MDrawed!=-1)                        //While there is undrawed root-mnu
    {
      GotoXY(MBase[MDrawed].PosX,1);         //Draws menu
      cout<<MBase[MDrawed].Name;
      MDrawed=SeekMenu(-1,MDrawed);
    }
  ClrAttrib(); cout<<flush;                  //Flushs buffers
}

void AppMenus::HBMenuBar(int MnuNro, int Type) //Partial sraw of menubar
{
  if (Type==1)                               //If we are drawing selected menu
    {
      ClrAttrib();
      TextBackColor(AMnuBgColor);
      TextColor(AMnuFgColor);
    }
  else                                       //If we are drawing unselected mnu
    {
      ClrAttrib();
      TextBackColor(MnuBgColor);
      TextColor(MnuFgColor);
    }
  GotoXY(MBase[GetRParent(MnuNro)].PosX-1,1); //Draws menu
  cout<<" "<<MBase[GetRParent(MnuNro)].Name<<" "<<flush; //Flushs buffers
  ClrAttrib();
}

void AppMenus::DrawSep(int SepWidth, int SepNro) //Draws separator
{
  ClrAttrib();
  TextColor(MnuBrdColor);
  TextBackColor(MnuBgColor);
  GotoXY(MBase[SepNro].PosX-1,MBase[SepNro].PosY);
  for (int j=0; j<SepWidth+2; j++) cout<<'-';
}

void AppMenus::DrawSMenu(void)               //Draws submenu          
{
  int RParent=GetRParent(CMenu);             //Real parent of menu
  int MnuWidth=GetMLen(RParent);             //Menu's Width
  int CharPos=MBase[CMenu].PosX;             //Menus text's start position (x)
  int MLine=3;                               //Y-position
  int tmp1=RParent;
  x1=CharPos-3;
  y1=1;
  GotoXY(CharPos-3,2);                       //Goes to upper left corner of mnu
  ClrAttrib();                               //Sets colorattributes
  TextBackColor(MnuBrdBgColor);
  TextColor(MnuBrdColor);
  cout<<'+';                                 //Print 1st line of menu
  for (int j=0; j<=MnuWidth+3;j++) cout<<'=';
  cout<<'+';
  do                                         //Print all items with same parent
    {
      tmp1=SeekMenu(RParent,tmp1);           //Seeks next menu with same parent
      if (tmp1!=-1)                          //If there is next submenu
	{
	  x2=CharPos+MnuWidth+3;
	  GotoXY(CharPos-3,MLine);           //Prints left side of frame
          ClrAttrib();
	  TextColor(MnuBrdColor);
	  TextBackColor(MnuBrdBgColor);
          cout<<"|";
 	  ClrAttrib();                       //Prints menuitem an background
	  TextColor(MnuFgColor);
	  TextBackColor(MnuBgColor);
          cout<<"  ";
          cout<<MBase[tmp1].Name;
	  for (int tmp2=strlen(MBase[tmp1].Name); tmp2<MnuWidth+2;
	       tmp2++) cout<<' ';            //Print menus background
	  ClrAttrib();                       //Prints right side of frame
	  TextColor(MnuBrdColor);
	  TextBackColor(MnuBrdBgColor);
          cout<<'|';
          if (MBase[tmp1].Type==2) DrawSep(MnuWidth,tmp1); //Draws separators
	  MLine++;                           //Increases Y-position
	}    
    }
  while (tmp1!=-1);                          //Stop looping, after last smenu
  GotoXY(CharPos-3,MLine);                   //Draws bottom of menuframe
  cout<<'+';
  for (int j=0; j<=MnuWidth+3;j++) cout<<'=';
  cout<<'+';
  y2=MLine;
  ClrAttrib();
  HSMenu(CMenu,1);
}

void AppMenus::HSMenu(int Menu, int Type)    //(Un)Hilites one menuitem
{
  int RParent=GetRParent(Menu);              //Finds real parent
  int MnuWidth=GetMLen(RParent);             //Gets width of longest menuitem
  GotoXY(MBase[Menu].PosX-1,MBase[Menu].PosY);
  if (Type==1)                               //If menu is selected
    {
      ClrAttrib();
      TextBackColor(AMnuBgColor);
      TextColor(AMnuFgColor); 
    }
  else                                       //If menu is not selected
    {
      ClrAttrib();
      TextBackColor(MnuBgColor);
      TextColor(MnuFgColor);
    }
  cout<<' '<<MBase[Menu].Name;               //Draws menu
  for (int tmp2=strlen(MBase[Menu].Name); tmp2<MnuWidth+1;tmp2++) cout<<' ';
  ClrAttrib();
}

void AppMenus::DrawMenu(void)                //Draws whole menustructure
{
  if (Update==3)                             //Full update
    {
      DrawBackGround(x1,y1,x2,y2);                      //Draws background
      HBMenuBar(OMenu,0);                    //UnHilites old root-menu
      HBMenuBar(CMenu,1);                    //Hilites selected root-menu
      DrawSMenu();                           //Draws submenu
    }
  if (Update==2)
    {
      HSMenu(CMenu,1);                       //Hilites selected menu
    }
  if ((Update==2)&&(OMenu!=CMenu)) HSMenu(OMenu,0); //UnHilites selected menu
}

int AppMenus::GetMLen(int ParentNro)         //Looks for longest item.
{
  int MxLen=0;
  int TMLen;
  int tmp1=-1;                               //Firs menu to check if tmp+1=0
  do                                         //Find next menu with same parent
    {
      tmp1=SeekMenu(ParentNro,tmp1);
      if (tmp1!=-1)                          //While tehere is submenu
	{
	  TMLen=strlen(MBase[tmp1].Name);
	  if (TMLen>MxLen) MxLen=TMLen;      //If this item is longest save
	}     
    }
  while (tmp1!=-1);
  return (MxLen);                            //Retuns lenght of longest smenu
}

int AppMenus::GetRParent(int MnuNro)         //Finds real parent of menu
{
  int RParent;
  if (MBase[MnuNro].ParentNro==-1) RParent=MnuNro; //If menu is parent itself
  else RParent=GetRParent(MBase[MnuNro].ParentNro); //Else...
  return(RParent);                           //Returns real paremt
}

/*
 * Not yet implemented -box 
 */

void NYI(void)                              //Not yet implemented.
{ 
  char WinCaption[]="Not yet implemented";
  Window NYIWin(20,6,59,13,WinCaption);
  NYIWin.Draw();
  char input1;
  GotoXY (0,0);
  input1=getch();
}
