/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.tomcat.jakartaee.bcel.Const;
import org.apache.tomcat.jakartaee.bcel.classfile.ClassFormatException;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantClass;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantDouble;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantDynamic;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantFieldref;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantFloat;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantInteger;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantInvokeDynamic;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantLong;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantMethodHandle;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantMethodType;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantMethodref;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantModule;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantNameAndType;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPackage;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantString;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.jakartaee.bcel.classfile.Node;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;
import org.apache.tomcat.jakartaee.bcel.util.BCELComparator;

public abstract class Constant
implements Cloneable,
Node {
    private static BCELComparator<Constant> bcelComparator = new BCELComparator<Constant>(){

        @Override
        public boolean equals(Constant a, Constant b) {
            return a == b || a != null && b != null && Objects.equals(a.toString(), b.toString());
        }

        @Override
        public int hashCode(Constant o) {
            return o != null ? Objects.hashCode(o.toString()) : 0;
        }
    };
    @Deprecated
    protected byte tag;

    public static BCELComparator<Constant> getComparator() {
        return bcelComparator;
    }

    public static Constant readConstant(DataInput dataInput) throws IOException, ClassFormatException {
        byte b = dataInput.readByte();
        switch (b) {
            case 7: {
                return new ConstantClass(dataInput);
            }
            case 9: {
                return new ConstantFieldref(dataInput);
            }
            case 10: {
                return new ConstantMethodref(dataInput);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInput);
            }
            case 8: {
                return new ConstantString(dataInput);
            }
            case 3: {
                return new ConstantInteger(dataInput);
            }
            case 4: {
                return new ConstantFloat(dataInput);
            }
            case 5: {
                return new ConstantLong(dataInput);
            }
            case 6: {
                return new ConstantDouble(dataInput);
            }
            case 12: {
                return new ConstantNameAndType(dataInput);
            }
            case 1: {
                return ConstantUtf8.getInstance(dataInput);
            }
            case 15: {
                return new ConstantMethodHandle(dataInput);
            }
            case 16: {
                return new ConstantMethodType(dataInput);
            }
            case 17: {
                return new ConstantDynamic(dataInput);
            }
            case 18: {
                return new ConstantInvokeDynamic(dataInput);
            }
            case 19: {
                return new ConstantModule(dataInput);
            }
            case 20: {
                return new ConstantPackage(dataInput);
            }
        }
        throw new ClassFormatException("Invalid byte tag in constant pool: " + b);
    }

    public static void setComparator(BCELComparator<Constant> comparator) {
        bcelComparator = comparator;
    }

    Constant(byte tag) {
        this.tag = tag;
    }

    @Override
    public abstract void accept(Visitor var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Clone Not Supported", e);
        }
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract void dump(DataOutputStream var1) throws IOException;

    public boolean equals(Object obj) {
        return obj instanceof Constant && bcelComparator.equals(this, (Constant)obj);
    }

    public final byte getTag() {
        return this.tag;
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    public String toString() {
        return Const.getConstantName(this.tag) + "[" + this.tag + "]";
    }
}

