/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    public static Node deepClone(Node node, Node node2) {
        Document document = node.getOwnerDocument();
        Node node3 = XmlUtil.cloneNode(document, node2);
        if (node3 != null) {
            XmlUtil.cloneTree(document, node3, node2);
        }
        return node3;
    }

    private static void cloneTree(Document document, Node node, Node node2) {
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = XmlUtil.cloneNode(document, nodeList.item(i));
            if (node3 == null) continue;
            node.appendChild(node3);
            XmlUtil.cloneTree(document, node3, nodeList.item(i));
        }
    }

    private static Node cloneNode(Document document, Node node) {
        Node node2 = null;
        switch (node.getNodeType()) {
            case 3: {
                String string = node.getNodeValue();
                node2 = document.createTextNode(string);
                break;
            }
            case 1: {
                Element element = (Element)node;
                String string = node.getNodeName();
                Element element2 = document.createElement(string);
                NamedNodeMap namedNodeMap = element.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    element2.setAttribute(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
                }
                node2 = element2;
            }
        }
        return node2;
    }

    public static String getNodeInfo(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 1: {
                string = "ELEMENT";
                break;
            }
            case 2: {
                string = "ATTRIBUTE";
                break;
            }
            case 3: {
                string = "TEXT";
                break;
            }
            case 4: {
                string = "CDATA_SECTION";
                break;
            }
            case 5: {
                string = "ENTITY_REFERENCE";
                break;
            }
            case 6: {
                string = "ENTITY";
                break;
            }
            case 7: {
                string = "PROCESSING_INSTRUCTION";
                break;
            }
            case 8: {
                string = "COMMENT";
                break;
            }
            case 9: {
                string = "DOCUMENT";
                break;
            }
            case 10: {
                string = "DOCUMENT_TYPE";
                break;
            }
            case 11: {
                string = "DOCUMENT_FRAGMENT";
                break;
            }
            case 12: {
                string = "NOTATION";
            }
        }
        StringBuffer stringBuffer = new StringBuffer("name=\"");
        stringBuffer.append(node.getNodeName());
        stringBuffer.append("\"  type=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }
}

