/*
 * nsetdinfo -- a working setdinfo for Sony NEWS workstations
 *
 * This knows how to read /etc/disktab for the information, so it is
 * not constrained to some stupid built-in disk types.
 *
 * This is a very simple version, should make this more user friendly etc...
 *
 * Hannu Aronsson <haa@hutcs.hut.fi>
 *
 * Severely hacked by jkp@cs.hut.fi (Jyrki Kuoppala)
 * to be compatible with the Sony setdinfo and put the googols of debug information
 * under the flag -d
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>

#include <sys/ioctl.h>
#include <disktab.h>

#include <newshbdev/diskinfo.h>	/* this has the boot block format in it */
#include <newshbdev/dkio.h> /* the ioctl's for changing the partition info on the fly */

#define USAGE "usage: %s [ -d ] disk | pathname [disktype]\n"

#define SHOWINFO 1
#define WRITEINFO 2

void tostart(), finddesc(), showinfo();

struct disktab *getdiskbyname();

int debug = 0;
int chpart = 0;
char *disk;

main(ac,av)
int ac;
char **av;
{
     char *type, *diskname;
     char op;
     int file, openmode;

     struct firstsector sector;

     if (ac > 1 && strcmp (av[1], "-d") == 0) {
       debug++;
       av++;
       ac--;
     }
     switch (ac) {
     case 2:
	  disk=av[1]; type=""; op=SHOWINFO; openmode=O_RDONLY; 
	  break;
     case 3:
	  disk=av[1]; type=av[2]; op=WRITEINFO; openmode=O_RDWR | O_CREAT;
	  break;
     default:
	  fprintf(stderr,USAGE,av[0]);
	  exit(1);
	  /*NOTREACHED*/
	  break;
     } /*switch(ac)*/

     diskname = (char *) malloc (strlen (disk) + 7);
     if (*disk != '/' && *disk != '.') {
       (void) sprintf (diskname, "/dev/r%sc", disk);
       chpart++;
     }
     else
       (void) strcpy (diskname, disk);
     if ((file = open(diskname, openmode, 0777))== -1) {
  	  perror("cannot open disk file");
	  exit(2);
     }

     tostart(file);
     if (read(file, &sector, sizeof(sector)) != sizeof(sector)) {
	  perror("cannot read sector from file");
	  exit(3);
     }

     if (op == SHOWINFO) {
	  showinfo(disk, &sector);
	  exit(0);
     }				/* else WRITEINFO */
	  
     finddesc(type, &sector);
     if (debug) {
       printf("The created description:\n");
       showinfo(disk, &sector);
     }

     tostart(file);
     if (write(file, &sector, sizeof(sector)) != sizeof(sector)) {
	  perror("write to file failed");
	  exit(6);
     }
     exit(0);
} /* main */

void
tostart(fd)
int fd;
{
     if (lseek(fd, (off_t) 0, L_SET) == -1) {
	  perror("seek to start of file failed");
	  exit(4);
     }
}

void
finddesc(desc, sec)
char *desc;
struct firstsector *sec;
{
     int a,b,c,d,e,f,g,h, cyls, sectors, tracks, fail, i, loc, file;
     char *partname;

     struct disktab *disktab;

     if ((disktab = getdiskbyname (desc)) == NULL) {
       fprintf(stderr, "getdiskbyname() failed for %s\n", desc);
       exit(7);
     }

     for (i = 0; i < 8 ; i++)
       if (disktab->d_partitions[i].p_size == -1)
	 disktab->d_partitions[i].p_size = 0;

     a = disktab->d_partitions[0].p_size;
     b = disktab->d_partitions[1].p_size;
     c = disktab->d_partitions[2].p_size;
     d = disktab->d_partitions[3].p_size;
     e = disktab->d_partitions[4].p_size;
     f = disktab->d_partitions[5].p_size;
     g = disktab->d_partitions[6].p_size;
     h = disktab->d_partitions[7].p_size;

     fail = 0;
     if (d+e+f != g) {
	  fprintf(stderr,"Warning: sizes do not match: of d+e+f != g\n");
	  fail++;
     }
     if (a+b+h+d+e+f != c) {
	  fprintf(stderr,"Warning: sizes do not match: of a+b+h+d+e+f != c\n");
	  fail++;
     }
     if (a+b+h+g != c) {
	  fprintf(stderr,"Warning: sizes do not match: of a+b+h+g != c\n");
	  fail++;
     }
     if (fail && debug)
       fprintf (stderr,"\nThe partitioning which doesn't seem good is:\nabhdef = now %8d\ncccccc = now %8d (whole disk)\n   ggg = now %8d (combined d,e,f partitions)\n(  def = now %8d)\n  (abh+g = now %8d)\n", a+b+h+d+e+f, c, g, d+e+f, a+b+h+g);

     sectors = disktab->d_nsectors;
     cyls = disktab->d_ncylinders;
     tracks = disktab->d_ntracks;

     if (debug) {
       printf("sectors/track = %d\n", sectors);
       printf("cylinders = %d\n", cyls);
       printf("tracks = %d\n", tracks);
     }

     if (sectors == -1 || cyls == -1 || tracks == -1) {
	  fprintf(stderr, "failed in reading cyl/sec/trk\n");
	  exit(14);
     }

     sec->diskinfo.di_magic = DISKINFO_MAGIC;
     sec->diskinfo.di_dkst.dks_ncyl = cyls;
     sec->diskinfo.di_dkst.dks_ntrak = tracks;
     sec->diskinfo.di_dkst.dks_nsect = sectors;
     sec->diskinfo.di_dkst.dks_rps = 60;
                                /* all the world rotates at 3600rpm, right? */

#define ALIGNMENT (sectors*tracks) /* this is 306, perhaps, may not be */
#define align(foo) (foo+(ALIGNMENT-(foo-1)%ALIGNMENT)-1)

/* the foo?bar:0 stuff makes the output cleaner when viewed later. */

/*c, the whole disk*/
     sec->diskinfo.di_part[2].dp_nblocks = c;
     sec->diskinfo.di_part[2].dp_blkoff = 0;

/*a*/
     sec->diskinfo.di_part[0].dp_nblocks = a;
     sec->diskinfo.di_part[0].dp_blkoff = 0;
     loc = a; loc = align(loc);
/*b*/
     sec->diskinfo.di_part[1].dp_nblocks = b;
     sec->diskinfo.di_part[1].dp_blkoff = b?loc:0;
     loc += b; loc = align(loc);
/*h*/
     sec->diskinfo.di_part[7].dp_nblocks = h;
     sec->diskinfo.di_part[7].dp_blkoff = h?loc:0;
     loc += h; loc = align(loc);
/*g, same as d+e+f*/
     sec->diskinfo.di_part[6].dp_nblocks = g;
     sec->diskinfo.di_part[6].dp_blkoff = g?loc:0; /* starts same as d-part */
/*d*/
     sec->diskinfo.di_part[3].dp_nblocks = d;
     sec->diskinfo.di_part[3].dp_blkoff = d?loc:0;
     loc += d; loc = align(loc);
/*e*/
     sec->diskinfo.di_part[4].dp_nblocks = e;
     sec->diskinfo.di_part[4].dp_blkoff = e?loc:0;
     loc += e; loc = align(loc);
/*f*/
     sec->diskinfo.di_part[5].dp_nblocks = f;
     sec->diskinfo.di_part[5].dp_blkoff = f?loc:0;
     if ((loc + f) > c) {
       fprintf(stderr,"Warning: partitions overflow, check the disktab entry\n");
       fprintf(stderr,"and make space for the alignment\n");
     }

				/* Now tell the kernel we have changed partitions */
     if (chpart) {
       partname = (char *) malloc (strlen (disk) + 7);
       for (i = 0; i < 8; i++) {
	 (void) sprintf (partname, "/dev/r%s%c", disk, 'a' + i);
	 if ((file = open(partname, O_RDWR, 0777))== -1) {
	   perror(partname);
	   exit(2);
	 }
	 if (ioctl (file, DKIOCSPART, &sec->diskinfo.di_part[i]) < 0) {
	   perror ("DKIOCSPART");	 
	   (void) fprintf (stderr, "partition: %c\n", 'a' + i);
	 }
       }
     }
} /* finddesc */

void
showinfo(disk, sec)
char *disk;
struct firstsector *sec;
{
     int i;

     if (debug)
       fprintf(stdout,
	     "Disk %s information:\n\
Magic=%lx (right magic is %lx)\n\
Ncyl=%d, Ntrack=%d, Nsect=%d, Nrps=%d\n\
Partitions:\n",
	     disk,
	     sec->diskinfo.di_magic, DISKINFO_MAGIC,
	     sec->diskinfo.di_dkst.dks_ncyl,
	     sec->diskinfo.di_dkst.dks_ntrak,
	     sec->diskinfo.di_dkst.dks_nsect,
	     sec->diskinfo.di_dkst.dks_rps);

     for (i=0; i<8; i++)
	  fprintf(stdout,
		  "%c: size=%8d, off=%8d\n",
		  "abcdefgh"[i],
		  sec->diskinfo.di_part[i].dp_nblocks,
		  sec->diskinfo.di_part[i].dp_blkoff);
} /*showinfo*/
