case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting kit/kitsend (with variable substitutions)"
cat >kitsend <<!GROK!THIS!
$startperl
	eval 'exec perl -S \$0 "\$@"'
		if \$running_under_some_shell;

# $Id: kitsend.SH,v 3.0.1.1 1993/08/19 06:42:15 ram Exp $
#
#  Copyright (c) 1991-1993, Raphael Manfredi
#  
#  You may redistribute only under the terms of the Artistic Licence,
#  as specified in the README file that comes with the distribution.
#  You may reuse parts of this distribution only within the terms of
#  that same Artistic Licence; a copy of which may be found at the root
#  of the source tree for dist 3.0.
#
# Original Author: Harlan Stenn <harlan@mumps.pfcs.com>
#
# $Log: kitsend.SH,v $
# Revision 3.0.1.1  1993/08/19  06:42:15  ram
# patch1: leading config.sh searching was not aborting properly
#
# Revision 3.0  1993/08/18  12:04:25  ram
# Baseline for dist 3.0 netwide release.
#

\$orgname='$orgname';
\$mailer='$mailer';
!GROK!THIS!
cat >>kitsend <<'!NO!SUBS!'

chop($orgname = `cat $orgname`) if $orgname =~ m|^/|;

&readpackage;

while ($_ = shift) {
	if (/^(kit)?[1-9][\d,-]*$/) {
		s/^kit//;
		push(@argv, $_);
	}
	else {
		push(@dest, $_);
	}
}
$dest = join(' ',@dest);
die "Usage: kitsend [kits] dest\n" unless $dest;

@ARGV = @argv;

if (-f "$package.kit10") {
	@filelist = <$package.kit[0-9][0-9]>;
}
else {
	@filelist = <$package.kit[0-9]>;
}
pop(@filelist) =~ /(\d+)$/ && ($maxnum = $1 + 0);

if ($#ARGV < 0) {
	$argv = "1-$maxnum";
	@ARGV = $argv;
}
$argv = do rangeargs(@ARGV);
@ARGV = split(' ',$argv);

$argv =~ s/ $//;

if ($#ARGV < 0) {
	die "No kits specified.\n";
} elsif ($#ARGV) {
	print "Sending $package $baserev kits $argv to $dest...\n";
} else {
	print "Sending $package $baserev kit $argv to $dest...\n";
}

fork && exit;

$opt = '-odq' if $mailer =~ /sendmail/;

until ($#ARGV < 0) {
	$kitnum = shift;
	open(XHEAD,">.xhead$$") || die "kitsend: can't create temp file: $!.\n";
	print XHEAD
"To: $dest
Subject: $package $baserev kit #$kitnum
Organization: $orgname

[There are $maxnum kits for $package version $baserev.]

";
	$kitnum = "0$kitnum" if $kitnum < 10 && $maxnum >= 10;
	open(PATCH,"$package.kit$kitnum") ||
		die "kitsend: can't open $package.kit$kitnum: $!\n";
	while (<PATCH>) {
		print XHEAD;
	}
	close XHEAD;
	system "$mailer $opt $dest <.xhead$$";
}
unlink ".xhead$$";

sub rangeargs {
	local($result) = '';
	local($min,$max,$_);
	while ($#_ >= 0) {
		$_ = shift(@_);
		while (/^\s*\d/) {
			s/^\s*(\d+)//;
			$min = $1;
			if (s/^,//) {
				$max = $min;
			}
			elsif (s/^-(\d*)//) {
				$max = $1;
				if ($max == 0 && $maxnum) {
					$max = $maxnum;
				}
				s/^[^,],?//;
			}
			else {
				$max = $min;
			}
			for ($i = $min; $i <= $max; ++$i) {
				$result .= $i . ' ';
			}
		}
	}
	$result;
}

!NO!SUBS!
$grep -v '^;#' ../pl/package.pl >>kitsend
chmod +x kitsend
$eunicefix kitsend
