case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting mcon/mlint (with variable substitutions)"
cat >mlint <<!GROK!THIS!
$startperl
	eval "exec perl -S \$0 \$*"
		if \$running_under_some_shell;

# $Id: mlint.SH,v 3.0.1.1 1993/08/19 06:42:27 ram Exp $
#
#  Copyright (c) 1991-1993, Raphael Manfredi
#  
#  You may redistribute only under the terms of the Artistic Licence,
#  as specified in the README file that comes with the distribution.
#  You may reuse parts of this distribution only within the terms of
#  that same Artistic Licence; a copy of which may be found at the root
#  of the source tree for dist 3.0.
#
# Original Author: Harlan Stenn <harlan@mumps.pfcs.com>
#
# $Log: mlint.SH,v $
# Revision 3.0.1.1  1993/08/19  06:42:27  ram
# patch1: leading config.sh searching was not aborting properly
#
# Revision 3.0  1993/08/18  12:10:17  ram
# Baseline for dist 3.0 netwide release.
#

# Perload ON

\$MC = '$privlib';
\$version = '$VERSION';
\$patchlevel = '$PATCHLEVEL';
\$grep = '$grep';
!GROK!THIS!

$spitshell >>mlint <<'!NO!SUBS!'
chop($date = `date`);
$MC = &tilda_expand($MC);		# ~name expansion
chop($WD = `pwd`);				# Working directory
chdir $MC || die "Can't chdir to $MC: $!\n";
chop($MC = `pwd`);				# Real metalint lib path (no symbolic links)
chdir $WD || die "Can't chdir back to $WD: $!\n";

require 'getopts.pl';
&usage unless &Getopts("hklV");

if ($opt_V) {
	print STDERR "metalint $version PL$patchlevel\n";
	exit 0;
} elsif ($opt_h) {
	&usage;
}

&init;									# Various initializations
`mkdir .MT 2>&1` unless -d '.MT';		# For private temporary files

&locate_units;				# Fill in @ARGV with a unit list
&extract_dependencies;		# Extract dependencies from units
&sanity_checks;				# Perform sanity checks

if ($opt_k) {
	print "Leaving subdirectory .MT unremoved so you can peruse it.\n"
		unless $opt_s;
} else {
	`rm -rf .MT 2>&1`;
}
print "Done.\n" unless $opt_s;

# General initializations
sub init {
	&init_except;			# Token which have upper-cased letters
	&init_depend;			# The %Depend array records control line handling
}

# Record the exceptions -- all symbols but these are lower case
sub init_except {
	$Except{'Mcc'}++;
	$Except{'Author'}++;
	$Except{'Date'}++;
	$Except{'Header'}++;
	$Except{'Id'}++;
	$Except{'Locker'}++;
	$Except{'Log'}++;
	$Except{'RCSfile'}++;
	$Except{'Revision'}++;
	$Except{'Source'}++;
	$Except{'State'}++;
}

# Print out metalint's usage and exits
sub usage {
	print STDERR <<EOM;
Usage: metalint [-hklsV]
  -h : print this help message and exits.
  -k : keep temporary directory.
  -l : also report problems from library units.
  -s : silent mode.
  -V : print version number and exits.
EOM
	exit 1;
}

!NO!SUBS!
$grep -v '^;#' pl/locate.pl >>mlint 
$grep -v '^;#' pl/lint.pl >>mlint 
$grep -v '^;#' pl/init.pl >>mlint 
$grep -v '^;#' pl/extract.pl >>mlint 
$grep -v '^;#' pl/obsolete.pl >>mlint 
$grep -v '^;#' pl/tsort.pl >>mlint 
$grep -v '^;#' ../pl/tilde.pl >>mlint 
chmod +x mlint
$eunicefix mlint
