/******
  
  texture.c	this is just a temporary routine to map
              an RGB texture to the face. A new routines to 
	      automatically scale a face from video input is now
	      under development.


This "single layer" facial animation model is basically a rewrite of
a old program of Keith Waters which he gave to Carol Wang at Univeristy
of Calgary.

This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/
/** This routine loads an image file for the texture map **/
#include <gl/gl.h>
#include <gl/image.h>
#include <malloc.h>
#include <forms.h>
#include <stdio.h>
#include "standard.h"
#include "proto.h"
#include "lights.h"


/*** load_texture -- loads and defines a texture from a RGB file ***/
void load_texture(int texture_num, char *fname)
{

    IMAGE	*img;
    unsigned long	*txt;
    int		x,y,t_indx;
    long	pixel;
    void	*test;
    char        file[1024];

    unsigned short	r_row[4096];	/* Red value for a whole row */
    unsigned short	b_row[4096];	/* blue values */
    unsigned short	g_row[4096];	/* green values */

    sprintf(file,"%s.texture",fname);
    img	= iopen(file,"r");

    if (img == NULL) {
	printf("Error Opening Image File - %s \n",file);
	exit(-1);
    }

    if (img->zsize!=3) {
	printf("DANGER: This is not an RGB map!!\n");
	printf("Image zsize = %d \n",img->zsize);
    }

   
    /* allocate one 32-bit long for each pixel in the image */
    txt =  (unsigned long *) malloc(img->xsize*img->ysize*
				   sizeof(unsigned long));
    t_indx = 0 ;
    
    
    for (y=0; y<img->ysize; y++) { 	/* thru each row */
	getrow(img,r_row,y,0);		/* SGI libimage routine */
	getrow(img,g_row,y,1);	
	getrow(img,b_row,y,2);	

	for (x=0; x<img->xsize; x++) {
	    txt[t_indx] = r_row[x] + (g_row[x]*256) +(b_row[x] * 65536);
	    t_indx++;
	}
    }


    printf("Image size: %d %d %d \n",img->xsize,img->ysize,
	   img->zsize);

    texdef2d(texture_num,4,img->xsize,img->ysize,txt,0,texprops); 
    texbind(TX_TEXTURE_0,1);/* bind the texture (defined in load_texture)*/
    
    /* ************** */
    tevdef(1,0,tevprops);	/* define the texture mapping environment */
/*    tevdef(1,0,0);	/* define the texture mapping environment */
  }


/*** assign tmap coordinates to face vertices ***/
float *bind_texture_coor(float *psys,char *fname)
{
    
    float	*tcoor;

    char        data_file[1024];
    FILE 	*in_file;
    int 	i,st,nvert;


    sprintf(data_file,"%s.tcoor",fname);
    in_file = fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }
    st = fscanf(in_file,"%d",&nvert);
    if (nvert != psys[0])
      printf("Inconsistent vertex number: %s \n", data_file); 
    tcoor = (float *) malloc(sizeof(float)*psys[0]*2);

    for (i=0;i<nvert*2;i++) { 
	fscanf(in_file,"%f",&tcoor[i]);
    }
    fclose(in_file);
    return tcoor;
  }


    





