/*
     The module that matches Deterministic Finite Automatons.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include "concon.h"
#include "global.h"
#include "dfa.h"
#include "dfa.fdf"
#include "input.fdf"

Inherit proDfa_match( char c, DfaNode *dfa, int index )
    {
    Inherit try;

    if (index == END_ACCEPT) return TRUE;
    if (index == END_REJECT) return FALSE;
    if (c == '\0')
        {
        while (dfa[index].next >= 0) index = dfa[index].next;
        if (index == END_ACCEPT) return TRUE; else return FALSE;
        }

    if (dfa[index].range[0] == '_' &&
    		 dfa[index].range[1] == '_')
    	{
    	if ( (c>='0' && c<='9') || (c>='a' && c<='z') ||
             (c>='A' && c<='Z') ||
             (strrchr( SPECIALS, c ) != NULL && c != '\0') )
    		try = TRUE;
    	else
    		try = FALSE;	 
    	}
    else		            
	    try = (c >= dfa[index].range[0] && c <= dfa[index].range[1])
        	        ? TRUE : FALSE;
    if (try  == TRUE)
        {
        if ((c = proInput_getChar()) == '\0') 
        	return FALSE;  
        else
        	return proDfa_match( c, dfa, dfa[index].accept );
        }
    else 
        return proDfa_match( c, dfa, dfa[index].next );
    }

/* 
    Tokenizing means matching DFA's and executing the action belonging
    to the corresponding DFA.
*/    

Inherit proDfa_tokenize( DfaNode *dfa, TokenRules *rules )
    {
    int     rule = -1;
    char    c;
    
    stateP->token = NOTOKEN;
    if (stateP->endOfFile == TRUE) return TRUE;
    while (rules[++rule].startState >= 0)
        {
       	proInput_undo();       
        if ((c = proInput_getChar()) == '\0') 
        	return FALSE;
        if (proDfa_match( c, dfa, rules[rule].startState ) 
        	== TRUE)
            {
            if (rules[rule].actionFunc() == TRUE)
				{
	            proInput_release();
                return TRUE;
                } 
            else 
            	{
                rule = -1;
            	proInput_release();
            	}
            } 
        }
    printf("ERROR - Token not recognized...line %d\n", 
    			stateP->lineNo );
    proInput_forget();
    return FALSE;
    }

  

